export interface RTCPeerConnectionInformation {
    pc: RTCPeerConnection;
    id: string;
    prev?: any;
    nailUpRef?: any;
    validConnection: boolean;
}
export interface IWatchrtcIdentifiers {
    rtcRoomId: string | undefined;
    rtcPeerId: string | undefined;
    projectId: string | undefined;
}
export interface IWatchRTCConfiguration {
    /** Watchrtc api key */
    rtcApiKey: string;
    /** Identifier for the session */
    rtcRoomId?: string;
    /** Identifier for the current peer */
    rtcPeerId?: string;
    /**
     * ["tag1", "tag2", "tag3"]
     * @deprecated use 'keys' instead
     */
    rtcTags?: string[];
    /** { "key1": "value1", "key2": "value2"} */
    keys?: any;
    /**
     * @deprecated No longer needed. Use "logLevel" instead.
     */
    debug?: boolean;
    rtcToken?: string;
    /**
     * @deprecated No longer needed. Use "proxyUrl" instead.
     */
    wsUrl?: string;
    proxyUrl?: string;
    console?: {
        level: string;
        override: boolean;
    };
    allowBrowserLogCollection?: boolean;
    collectionInterval?: number;
    logGetStats?: boolean;
    /** Logging level of SDK */
    logLevel?: "silent" | "debug" | "info" | "error";
}
export type Rating = 1 | 2 | 3 | 4 | 5;
export type EventType = "global" | "local" | "log";
export interface IEvent {
    name: string;
    /** "global" or "local" or "log" */
    type: EventType;
    parameters?: any;
    pc?: any;
}
export interface IHttpService {
    trace(url: string, projectId?: string, rtcRoomId?: string, rtcPeerId?: string, ...data: any[]): Promise<{
        error?: string;
    }>;
}
export interface IPromiseFuncs {
    resolve: (value: {
        error?: string;
    }) => void;
    reject: () => void;
}
interface ISocketTraceOptions {
    promiseFuncs?: IPromiseFuncs;
}
interface ISocketTraceParams {
    data: any[];
    options?: ISocketTraceOptions;
}
export type ISocketTrace = (params: ISocketTraceParams) => void;
export interface ISocketConnectOptions {
    url: string;
    onData: (data: any) => void;
    onError: (error: any, errorType?: string) => void;
    onOpen?: () => void;
    onClose?: (e: CloseEvent) => void;
    options?: {
        cleanOldTraces?: boolean;
    };
}
export interface ISocketService {
    connection: any | null;
    wasConnected: boolean;
    buffer: any[];
    connect: (params: ISocketConnectOptions) => void;
    trace: ISocketTrace;
    close: (nailUpCallEnd?: boolean) => void;
    disableDataCollection: () => void;
    enableDataCollection: () => void;
    isDisabledDataCollection: () => boolean;
}
export interface IWatchRTCInitServices {
    socketService?: ISocketService;
    httpService?: IHttpService;
}
export interface IStatsCallback {
    (stats: object): void;
}
export interface IStateEvent {
    connectionStatus: "connected" | "disconnected";
}
export type StateListener = (event: IStateEvent) => any;
export {};
