/**
 * @license
 * Copyright 2018 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
// Importing local_storage and indexed_db is necessary for the routers to be
// registered.
import './indexed_db';
import './local_storage';
import { browserFiles } from './browser_files';
import { browserHTTPRequest, http, isHTTPScheme } from './http';
import { concatenateArrayBuffers, decodeWeights, encodeWeights, getModelArtifactsForJSON, getModelArtifactsInfoForJSON } from './io_utils';
import { fromMemory, withSaveHandler } from './passthrough';
import { getLoadHandlers, getSaveHandlers, registerLoadRouter, registerSaveRouter } from './router_registry';
import { loadWeights, weightsLoaderFactory } from './weights_loader';
export { copyModel, listModels, moveModel, removeModel } from './model_management';
export { browserFiles, browserHTTPRequest, concatenateArrayBuffers, decodeWeights, encodeWeights, fromMemory, getLoadHandlers, getModelArtifactsForJSON, getModelArtifactsInfoForJSON, getSaveHandlers, http, isHTTPScheme, loadWeights, registerLoadRouter, registerSaveRouter, weightsLoaderFactory, withSaveHandler };
//# sourceMappingURL=data:application/json;base64,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