/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,a){"object"==typeof exports&&"undefined"!=typeof module?a(exports,require("@tensorflow/tfjs-core"),require("path"),require("fs"),require("worker_threads"),require("perf_hooks"),require("os")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","path","fs","worker_threads","perf_hooks","os"],a):a(((e=e||self).tf=e.tf||{},e.tf.wasm=e.tf.wasm||{}),e.tf,e.path,e.fs,e.worker_threads,e.perf_hooks,e.os)}(this,(function(e,a,n,t,r,u,s){"use strict";var i,o,d;n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r,u=u&&Object.prototype.hasOwnProperty.call(u,"default")?u.default:u,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s,function(e){e[e.float32=0]="float32",e[e.int32=1]="int32",e[e.bool=2]="bool",e[e.string=3]="string",e[e.complex64=4]="complex64"}(i||(i={})),function(e){e[e.linear=0]="linear",e[e.relu=1]="relu",e[e.relu6=2]="relu6",e[e.prelu=3]="prelu",e[e.leakyrelu=4]="leakyrelu",e[e.sigmoid=5]="sigmoid",e[e.elu=6]="elu"}(o||(o={}));var l={kernelName:a._FusedMatMul,backendName:"wasm",setupFunc:function(e){d=e.wasm.cwrap(a._FusedMatMul,null,["number","array","number","number","array","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.backend,r=e.attrs,u=n.a,s=n.b,i=n.bias,l=n.preluActivationWeights;if("float32"!==u.dtype||"float32"!==s.dtype)throw new Error("_FusedMatMul for non non-float32 tensors not yet supported.");var c=r.transposeA,p=r.transposeB,f=r.activation,m=r.leakyreluAlpha,h=t.dataIdMap.get(u.dataId).id,b=t.dataIdMap.get(s.dataId).id,y=0;if(null!=i){var g=t.dataIdMap.get(i.dataId);if(1!==g.shape.length)throw new Error("_FusedMatMul only supports rank-1 bias but got rank "+g.shape.length+".");y=g.id}var _=null==l?0:t.dataIdMap.get(l.dataId).id,v=o[f];if(null==v)throw new Error(f+" activation not yet supported for FusedConv2D in the wasm backend.");var w=c?u.shape[2]:u.shape[1],k=p?s.shape[1]:s.shape[2],I=a.broadcast_util.assertAndGetBroadcastShape(u.shape.slice(0,-2),s.shape.slice(0,-2)),S=t.makeOutput(I.concat([w,k]),u.dtype),M=t.dataIdMap.get(S.dataId).id,A=new Uint8Array(new Int32Array(u.shape).buffer),E=new Uint8Array(new Int32Array(s.shape).buffer);return d(h,A,u.shape.length,b,E,s.shape.length,c,p,v,y,_,m||0,M),S}};function c(e,n){var t;return{kernelName:e,backendName:"wasm",setupFunc:function(a){t=a.wasm.cwrap(e,null,["number","number","number"])},kernelFunc:function(e){var r=e.backend,u=e.inputs.x,s=r.dataIdMap.get(u.dataId).id,o=r.makeOutput(u.shape,n||u.dtype),d=r.dataIdMap.get(o.dataId).id;return 0===a.util.sizeFromShape(o.shape)||t(s,i[u.dtype],d),o}}}var p=c(a.Abs);function f(e,n,t){var r;return{kernelName:e,backendName:"wasm",setupFunc:function(a){r=a.wasm.cwrap(e,null,["number","array","number","number","array","number","number","number"])},kernelFunc:function(e){var n=e.backend,u=e.inputs,s=u.a,o=u.b,d=n.dataIdMap.get(s.dataId).id,l=n.dataIdMap.get(o.dataId).id,c=null!=t?t:s.dtype,p=a.backend_util.assertAndGetBroadcastShape(s.shape,o.shape),f=n.makeOutput(p,c);if(0===a.util.sizeFromShape(p))return f;var m=new Uint8Array(new Int32Array(s.shape).buffer),h=new Uint8Array(new Int32Array(o.shape).buffer),b=n.dataIdMap.get(f.dataId).id;return r(d,m,s.shape.length,l,h,o.shape.length,i[s.dtype],b),f}}}var m,h=f(a.Add);var b={kernelName:a.AddN,backendName:"wasm",setupFunc:function(e){m=e.wasm.cwrap(a.AddN,null,["array","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.backend,r=t.makeOutput(n[0].shape,n[0].dtype);if(0===a.util.sizeFromShape(r.shape))return r;var u=n.map((function(e){return t.dataIdMap.get(e.dataId).id})),s=new Uint8Array(new Int32Array(u).buffer),o=t.dataIdMap.get(r.dataId).id;return m(s,u.length,i[r.dtype],o),r}};function y(e){var a=e.inputs.x,n=e.backend,t=n.makeOutput(a.shape,a.dtype),r=n.typedArrayFromHeap(a);return n.typedArrayFromHeap(t).set(r),t}var g,_={kernelName:a.Identity,backendName:"wasm",kernelFunc:y};function v(e){for(var a=e.inputs,n=e.backend,t=e.attrs,r=function(e,a){for(var n=[],t=[],r=0;r<e.length;++r)1!==e[r]&&n.push(e[r]),1!==e[a[r]]&&t.push(a[r]);for(r=0;r<t.length;++r){for(var u=-1,s=0;s<t.length;++s)t[s]>=r&&(-1===u||t[u]>t[s])&&(u=s);t[u]=r}return[n,t]}(a.x.shape,t.perm),u=r[0],s=r[1],o=!0,d=0;d<s.length;d++)s[d]!==d&&(o=!1);var l=function(e,a){for(var n=new Array(e.length),t=0;t<n.length;t++)n[t]=e[a[t]];return n}(a.x.shape,t.perm),c={dataId:a.x.dataId,shape:u,dtype:a.x.dtype};if(o){var p=y({inputs:a,backend:n});return p.shape=l,p}var f=n.makeOutput(l,c.dtype),m=n.dataIdMap.get(c.dataId).id,h=n.dataIdMap.get(f.dataId).id,b=new Uint8Array(new Int32Array(s).buffer),_=new Uint8Array(new Int32Array(c.shape).buffer);return g(m,_,c.shape.length,i[c.dtype],h,b,s.length),f}var w,k={kernelName:a.Transpose,backendName:"wasm",kernelFunc:v,setupFunc:function(e){g=e.wasm.cwrap(a.Transpose,null,["number","array","number","number","number","array","number"])}};function I(e,n,t){var r=e.shape,u=e.shape.length,s=a.util.parseAxisParam(n,r),i=s,o=a.backend_util.getAxesPermutation(i,u),d=null,l=!1;if(null!=o){for(var c=new Array(u),p=0;p<c.length;p++)c[p]=r[o[p]];i=a.backend_util.getInnerMostAxes(i.length,u),d=v({inputs:{x:e},attrs:{perm:o},backend:t});var f=t.dataIdMap.get(e.dataId).id;t.dataIdMap.get(d.dataId).id!==f&&(l=!0)}return{transposed:d,originalAxes:s,axes:i,inputWasTransposed:l}}var S,M={kernelName:a.All,backendName:"wasm",setupFunc:function(e){w=e.wasm.cwrap(a.All,null,["number, number, number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=r.axis,s=r.keepDims,i=t.x,o=n.dataIdMap.get(i.dataId).id,d=i,l=I(i,u,n),c=l.transposed,p=l.axes,f=l.originalAxes,m=l.inputWasTransposed;m&&(d=c,o=n.dataIdMap.get(c.dataId).id);var h=d.shape.length;a.backend_util.assertAxesAreInnerMostDims("all",p,h);var b=a.backend_util.computeOutAndReduceShapes(d.shape,p),y=b[0],g=b[1],_=a.util.sizeFromShape(g),v=n.makeOutput(y,i.dtype);if(0!==a.util.sizeFromShape(d.shape)){var k=n.dataIdMap.get(v.dataId).id;w(o,_,k)}if(m&&n.disposeData(c.dataId),s){var S=a.backend_util.expandShapeToKeepDim(v.shape,f);v.shape=S}return v}};var A,E={kernelName:a.Any,backendName:"wasm",setupFunc:function(e){S=e.wasm.cwrap(a.Any,null,["number, number, number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=r.axis,s=r.keepDims,i=t.x,o=n.dataIdMap.get(i.dataId).id,d=i,l=I(i,u,n),c=l.transposed,p=l.axes,f=l.originalAxes,m=l.inputWasTransposed;m&&(d=c,o=n.dataIdMap.get(c.dataId).id);var h=d.shape.length;a.backend_util.assertAxesAreInnerMostDims("any",p,h);var b=a.backend_util.computeOutAndReduceShapes(d.shape,p),y=b[0],g=b[1],_=a.util.sizeFromShape(g),v=n.makeOutput(y,i.dtype);if(0!==a.util.sizeFromShape(d.shape)){var w=n.dataIdMap.get(v.dataId).id;S(o,_,w)}if(m&&n.disposeData(c.dataId),s){var k=a.backend_util.expandShapeToKeepDim(v.shape,f);v.shape=k}return v}};var x,N={kernelName:a.ArgMax,backendName:"wasm",kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs.axis,u=t.x,s=n.dataIdMap.get(u.dataId).id,o=s,d=u,l=I(u,r,n),c=l.transposed,p=l.axes,f=l.inputWasTransposed;if(f){var m=n.dataIdMap.get(c.dataId).id;m!==s&&(d=c,o=m)}var h=d.shape.slice(0,-1),b=n.makeOutput(h,"int32"),y=n.dataIdMap.get(b.dataId).id,g=a.util.sizeFromShape(b.shape),_=d.shape[p[0]];return A(o,i[d.dtype],g,_,y),f&&n.disposeData(c.dataId),b},setupFunc:function(e){A=e.wasm.cwrap(a.ArgMax,null,["number","number","number","number","number"])}};var F={kernelName:a.AvgPool,backendName:"wasm",setupFunc:function(e){x=e.wasm.cwrap(a.AvgPool,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.attrs,r=e.backend,u=n.x,s=r.dataIdMap.get(u.dataId).id,i=t.filterSize,o=t.strides,d=t.pad,l=t.dimRoundingMode,c=a.backend_util.computePool2DInfo(u.shape,i,o,1,d,l),p=c.filterHeight,f=c.filterWidth,m=c.padInfo.top,h=c.padInfo.right,b=c.padInfo.bottom,y=c.padInfo.left,g=c.strideHeight,_=c.strideWidth,v=c.inChannels;if("channelsLast"!==c.dataFormat)throw new Error("wasm backend does not support dataFormat:'"+c.dataFormat+"'. Please use 'channelsLast'.");if(1!==c.dilationWidth||1!==c.dilationHeight)throw new Error("was backend only supports average pooling with dilation = [1, 1], got ["+c.dilationHeight+", "+c.dilationWidth+"].");var w=r.makeOutput(c.outShape,"float32"),k=r.dataIdMap.get(w.dataId).id;return x(s,u.shape[0],u.shape[1],u.shape[2],p,f,m,h,b,y,g,_,v,k),w}};function O(e){var n=e.inputs,t=e.attrs,r=n.x,u=t.shape,s=a.util.sizeFromShape(r.shape),i=a.util.inferFromImplicitShape(u,s);return a.util.assert(s===a.util.sizeFromShape(i),(function(){return"new shape: "+i+", old shape: "+r.shape+". New shape and old shape must have the same number of elements."})),e.backend.incRef(r.dataId),{dataId:r.dataId,shape:i,dtype:r.dtype}}var T,R={kernelName:a.Reshape,backendName:"wasm",kernelFunc:O};var C={kernelName:a.BatchMatMul,backendName:"wasm",setupFunc:function(e){T=e.wasm.cwrap(a.BatchMatMul,null,["number","array","number","number","array","number","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.backend,r=e.attrs,u=n.a,s=n.b,i=r.transposeA,o=r.transposeB;if("float32"!==u.dtype||"float32"!==s.dtype)throw new Error("BatchMatMul for non non-float32 tensors not yet supported.");var d=u.shape.length,l=s.shape.length,c=i?u.shape[d-2]:u.shape[d-1],p=o?s.shape[l-1]:s.shape[l-2],f=i?u.shape[d-1]:u.shape[d-2],m=o?s.shape[l-2]:s.shape[l-1],h=u.shape.slice(0,-2),b=s.shape.slice(0,-2),y=a.util.sizeFromShape(h),g=a.util.sizeFromShape(b),_=a.broadcast_util.assertAndGetBroadcastShape(u.shape.slice(0,-2),s.shape.slice(0,-2)).concat([f,m]);a.util.assert(c===p,(function(){return"Error in matMul: inner shapes ("+c+") and ("+p+") of Tensors with shapes "+u.shape+" and "+s.shape+" and transposeA="+i+" and transposeB="+o+" must match."}));var v=o?[g,m,p]:[g,p,m],w=O({inputs:{x:u},backend:t,attrs:{shape:i?[y,c,f]:[y,f,c]}}),k=O({inputs:{x:s},backend:t,attrs:{shape:v}}),I=t.dataIdMap.get(w.dataId).id,S=t.dataIdMap.get(k.dataId).id,M=i?w.shape[2]:w.shape[1],A=o?k.shape[1]:k.shape[2],E=Math.max(y,g),x=t.makeOutput([E,M,A],w.dtype),N=t.dataIdMap.get(x.dataId).id,F=new Uint8Array(new Int32Array(w.shape).buffer),R=new Uint8Array(new Int32Array(k.shape).buffer);return T(I,F,w.shape.length,S,R,k.shape.length,i,o,N),t.disposeData(w.dataId),t.disposeData(k.dataId),x.shape=_,x}};function D(e,n,t,r,u){const s=a.slice_util.isSliceContinous(r,n,t),i=a.util.sizeFromShape(t),o=a.util.computeStrides(r);if(s){const t=a.slice_util.computeFlatOffset(n,o);return"string"===u?e.slice(t,t+i):e.subarray(t,t+i)}const d="string"===u?a.backend_util.fromUint8ToStringArray(e):e,l=a.buffer(r,u,d),c=a.buffer(t,u);for(let e=0;e<c.size;++e){const a=c.indexToLoc(e),t=a.map(((e,a)=>e+n[a]));c.set(l.get(...t),...a)}return"string"===u?a.backend_util.fromStringArrayToUint8(c.values):c.values}function P(e){var n=e.inputs.x,t=e.attrs,r=t.begin,u=t.size,s=e.backend,i=a.slice_util.parseSliceParams(n,r,u),o=i[0],d=i[1],l=a.slice_util.isSliceContinous(n.shape,o,d),c=s.readSync(n.dataId),p=s.makeOutput(d,n.dtype),f=a.util.computeStrides(n.shape),m=s.dataIdMap.get(p.dataId);if(l){var h=a.slice_util.computeFlatOffset(o,f);if("string"===n.dtype)m.stringBytes=c.slice(h,h+a.util.sizeFromShape(d));else s.typedArrayFromHeap(p).set(c.subarray(h,h+a.util.sizeFromShape(d)));return p}if("string"===n.dtype){var b=D(c,o,d,n.shape,n.dtype);return m.stringBytes=b,p}var y=s.typedArrayFromHeap(p),g=n.shape.length;if(2===g)!function(e,a,n,t,r){for(var u=0,s=t[0],i=t[1],o=s+r[0],d=s;d<o;d++){var l=d*a+i;n.set(e.subarray(l,l+r[1]),u),u+=r[1]}}(c,f[0],y,o,d);else if(3===g)!function(e,a,n,t,r,u){for(var s=0,i=r[0],o=r[1],d=r[2],l=i+u[0],c=o+u[1],p=i;p<l;p++)for(var f=o;f<c;f++){var m=p*a+f*n+d;t.set(e.subarray(m,m+u[2]),s),s+=u[2]}}(c,f[0],f[1],y,o,d);else if(4===g)!function(e,a,n,t,r,u,s){for(var i=0,o=u[0],d=u[1],l=u[2],c=o+s[0],p=d+s[1],f=l+s[2],m=u[3],h=o;h<c;h++)for(var b=d;b<p;b++)for(var y=l;y<f;y++){var g=h*a+b*n+y*t+m;r.set(e.subarray(g,g+s[3]),i),i+=s[3]}}(c,f[0],f[1],f[2],y,o,d);else{b=D(c,o,d,n.shape,n.dtype);y.set(b)}return p}var W={kernelName:a.Slice,backendName:"wasm",kernelFunc:P};var L={kernelName:a.BatchToSpaceND,backendName:"wasm",kernelFunc:function(e){var n=e.inputs,t=e.backend,r=e.attrs,u=n.x,s=r.blockShape,i=r.crops,o=s.reduce((function(e,a){return e*a})),d=a.backend_util.getReshaped(u.shape,s,o),l=a.backend_util.getPermuted(d.length,s.length),c=a.backend_util.getReshapedPermuted(u.shape,s,o),p=a.backend_util.getSliceBeginCoords(i,s.length),f=a.backend_util.getSliceSize(c,i,s.length),m=O({inputs:{x:u},backend:t,attrs:{shape:d}}),h=v({inputs:{x:m},backend:t,attrs:{perm:l}}),b=P({inputs:{x:O({inputs:{x:h},backend:t,attrs:{shape:c}})},backend:t,attrs:{begin:p,size:f}});return t.disposeData(m.dataId),t.disposeData(h.dataId),t.disposeData(m.dataId),b}};function H(e){var a=e.inputs.x,n=e.attrs.dtype,t=e.backend,r=t.makeOutput(a.shape,n),u=t.typedArrayFromHeap(a);return t.typedArrayFromHeap(r).set(u),r}var B,U={kernelName:a.Cast,backendName:"wasm",kernelFunc:H},z=c(a.Ceil);var j={kernelName:a.ClipByValue,backendName:"wasm",setupFunc:function(e){B=e.wasm.cwrap(a.ClipByValue,null,["number","number","number","number"])},kernelFunc:function(e){var a=e.inputs,n=e.backend,t=e.attrs,r=a.x,u=t.clipValueMin,s=t.clipValueMax,i=n.dataIdMap.get(r.dataId).id,o=n.makeOutput(r.shape,r.dtype),d=n.dataIdMap.get(o.dataId).id;return B(i,u,s,d),o}};function q(e){var n=e.inputs,t=e.backend,r=a.util.parseAxisParam(e.attrs.axis,n[0].shape)[0],u=a.backend_util.computeOutShape(n.map((function(e){return e.shape})),r),s=n.filter((function(e){return a.util.sizeFromShape(e.shape)>0}));if(1===s.length)return y({inputs:{x:s[0]},backend:t});var i=t.makeOutput(u,n[0].dtype);if(0===a.util.sizeFromShape(u))return i;var o=s.map((function(e){return e.shape}));if(a.backend_util.assertParamsConsistent(o,r),"string"===s[0].dtype){var d=s.map((function(e){var n=a.util.sizeFromShape(e.shape.slice(r));return O({inputs:{x:e},backend:t,attrs:{shape:[-1,n]}})})),l=d.map((function(e){return{vals:t.readSync(e.dataId),shape:e.shape}}));u=a.backend_util.computeOutShape(d.map((function(e){return e.shape})),1);var c=1===d[0].shape[0],p=function(e,n,t,r){const u=a.util.getArrayFromDType(t,a.util.sizeFromShape(n));if(r&&"string"!==t){let n=0;e.forEach((e=>{const t=a.util.sizeFromShape(e.shape);u.set(e.vals,n),n+=t}))}else{let r=0;e.forEach((e=>{const s="string"===t?a.backend_util.fromUint8ToStringArray(e.vals):e.vals;let i=0;for(let a=0;a<e.shape[0];++a){const t=a*n[1]+r;for(let a=0;a<e.shape[1];++a)u[t+a]=s[i++]}r+=e.shape[1]}))}return u}(l,u,n[0].dtype,c),f=a.backend_util.computeOutShape(s.map((function(e){return e.shape})),r);return i.shape=f,t.dataIdMap.get(i.dataId).stringBytes=a.backend_util.fromStringArrayToUint8(p),d.forEach((function(e){return t.disposeData(e.dataId)})),i}for(var m=a.util.sizeFromShape(s[0].shape.slice(0,r)),h=0,b=s.map((function(e){var n=a.util.sizeFromShape(e.shape.slice(r));return h+=n,n})),g=s.map((function(e){return t.typedArrayFromHeap(e)})),_=t.typedArrayFromHeap(i),v=0;v<m;v++)for(var w=v*h,k=0;k<g.length;k++){var I=b[k],S=v*I,M=g[k].subarray(S,S+I);_.set(M,w),w+=I}return i}var V,G={kernelName:a.Concat,backendName:"wasm",kernelFunc:q};var K,X={kernelName:a.Conv2D,backendName:"wasm",setupFunc:function(e){V=e.wasm.cwrap(a.Conv2D,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.attrs,r=e.backend,u=n.x,s=n.filter,i=r.dataIdMap.get(u.dataId).id,o=r.dataIdMap.get(s.dataId).id,d=t.strides,l=t.dilations,c=t.pad,p=t.dimRoundingMode,f=t.dataFormat,m=a.backend_util.convertConv2DDataFormat(f),h=a.backend_util.computeConv2DInfo(u.shape,s.shape,d,l,c,p,!1,m),b=h.filterHeight,y=h.filterWidth,g=h.padInfo.top,_=h.padInfo.right,v=h.padInfo.bottom,w=h.padInfo.left,k=h.dilationHeight,I=h.dilationWidth,S=h.strideHeight,M=h.strideWidth,A=h.inChannels,E=h.outChannels,x="SAME"===h.padInfo.type?1:0;if("channelsLast"!==h.dataFormat)throw new Error("wasm backend Conv2D does not support dataFormat:'"+h.dataFormat+"'. Please use 'channelsLast'.");var N=r.makeOutput(h.outShape,"float32"),F=r.dataIdMap.get(N.dataId).id;return V(i,u.shape[0],u.shape[1],u.shape[2],o,b,y,g,_,v,w,x,k,I,S,M,A,E,F),N}};var Q,Y,Z={kernelName:a.Conv2DBackpropInput,backendName:"wasm",setupFunc:function(e){K=e.wasm.cwrap(a.Conv2DBackpropInput,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=t.dy,s=t.filter,i=r.strides,o=r.pad,d=r.dataFormat,l=r.dimRoundingMode,c=r.inputShape,p=a.backend_util.convertConv2DDataFormat(d),f=a.backend_util.computeConv2DInfo(c,s.shape,i,1,o,l,!1,p),m=f.batchSize,h=f.filterHeight,b=f.filterWidth,y=f.inChannels,g=f.inHeight,_=f.inWidth,v=f.outChannels,w=f.outHeight,k=f.outWidth,I=f.strideHeight,S=f.strideWidth,M=h-1-f.padInfo.top,A=b-1-f.padInfo.left,E="channelsLast"===f.dataFormat,x=a.util.computeStrides(f.inShape),N=a.util.computeStrides(u.shape),F=a.util.computeStrides(s.shape),O=F[0],T=F[1],R=F[2],C=x[0],D=E?x[1]:x[2],P=E?x[2]:1,W=E?1:x[1],L=N[0],H=E?N[1]:N[2],B=E?N[2]:1,U=E?1:N[1],z=n.makeOutput(f.inShape,"float32"),j=n.dataIdMap.get(z.dataId).id,q=n.dataIdMap.get(u.dataId).id,V=n.dataIdMap.get(s.dataId).id;return K(q,V,m,h,b,g,_,y,w,k,v,I,S,M,A,O,T,R,C,D,P,W,L,H,B,U,j),z}},J=c(a.Cos),$=c(a.Cosh);!function(e){e[e.bilinear=0]="bilinear",e[e.nearest=1]="nearest"}(Q||(Q={}));var ee,ae={kernelName:a.CropAndResize,backendName:"wasm",setupFunc:function(e){Y=e.wasm.cwrap(a.CropAndResize,null,["number","number","number","number","array","number","number","number","number","number"])},kernelFunc:function(e){var a,n=e.backend,t=e.inputs,r=e.attrs,u=r.method,s=r.extrapolationValue,i=r.cropSize,o=t.image,d=t.boxes,l=t.boxInd,c=d.shape[0],p=i,f=p[0],m=p[1],h=[c,f,m,o.shape[3]],b=n.dataIdMap.get(o.dataId);"float32"!==o.dtype&&(a=H({backend:n,inputs:{x:o},attrs:{dtype:"float32"}}),b=n.dataIdMap.get(a.dataId));var y=b.id,g=n.dataIdMap.get(d.dataId).id,_=n.dataIdMap.get(l.dataId).id,v=n.makeOutput(h,"float32"),w=n.dataIdMap.get(v.dataId).id,k=new Uint8Array(new Int32Array(o.shape).buffer);return Y(y,g,_,c,k,f,m,Q[u],s,w),null!=a&&n.disposeData(a.dataId),v}};var ne,te={kernelName:a.Cumsum,backendName:"wasm",setupFunc:function(e){ee=e.wasm.cwrap(a.Cumsum,null,["number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.backend,r=e.attrs,u=n.x,s=r.axis,o=r.exclusive,d=r.reverse,l=u.shape.length;a.util.assert("float32"===u.dtype||"int32"===u.dtype,(function(){return"cumsum does not support "+u.dtype+" tensors in the WASM backend"}));var c=a.backend_util.getAxesPermutation([s],l),p=u;null!==c&&(p=v({inputs:{x:u},attrs:{perm:c},backend:t}));var f=a.backend_util.getInnerMostAxes(1,l)[0];a.backend_util.assertAxesAreInnerMostDims("cumsum",[f],l);var m=t.makeOutput(p.shape,p.dtype),h=p.shape[f],b=t.dataIdMap.get(p.dataId).id,y=t.dataIdMap.get(m.dataId).id;ee(b,o?1:0,d?1:0,h,y,i[u.dtype]);var g=m;return null!==c&&(g=v({inputs:{x:m},attrs:{perm:a.backend_util.getUndoAxesPermutation(c)},backend:t}),t.disposeData(p.dataId),t.disposeData(m.dataId)),g}};var re,ue={kernelName:a.DepthToSpace,backendName:"wasm",setupFunc:function(e){ne=e.wasm.cwrap(a.DepthToSpace,null,["number","number","number","array","number","array","array","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=t.x,s=r.blockSize,i=r.dataFormat,o=u.shape[0],d=("NHWC"===i?u.shape[1]:u.shape[2])*s,l=("NHWC"===i?u.shape[2]:u.shape[3])*s,c=("NHWC"===i?u.shape[3]:u.shape[1])/(s*s),p="NHWC"===i?[o,d,l,c]:[o,c,d,l],f=n.makeOutput(p,"float32"),m=n.dataIdMap.get(u.dataId).id,h=new Uint8Array(new Int32Array(a.util.computeStrides(u.shape)).buffer),b=new Uint8Array(new Int32Array(p).buffer),y=new Uint8Array(new Int32Array(a.util.computeStrides(p)).buffer),g=n.dataIdMap.get(f.dataId).id;return ne(m,s,"NHWC"===i?1:0,h,u.shape.length-1,b,y,p.length,g),f}};var se={kernelName:a.DepthwiseConv2dNative,backendName:"wasm",setupFunc:function(e){re=e.wasm.cwrap(a.DepthwiseConv2dNative,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.attrs,r=e.backend,u=n.x,s=n.filter,i=r.dataIdMap.get(u.dataId).id,o=r.dataIdMap.get(s.dataId).id,d=t.strides,l=t.dilations,c=t.pad,p=t.dimRoundingMode,f=null==l?[1,1]:l,m=a.backend_util.computeConv2DInfo(u.shape,s.shape,d,f,c,p,!0),h=m.filterHeight,b=m.filterWidth,y=m.padInfo.top,g=m.padInfo.right,_=m.padInfo.bottom,v=m.padInfo.left,w=m.dilationHeight,k=m.dilationWidth,I=m.strideHeight,S=m.strideWidth,M=m.inChannels,A=m.outChannels,E="SAME"===m.padInfo.type?1:0;if("channelsLast"!==m.dataFormat)throw new Error("wasm backend DepthwiseConv2dNative does not support dataFormat:'"+m.dataFormat+"'. Please use 'channelsLast'.");var x=r.makeOutput(m.outShape,"float32"),N=r.dataIdMap.get(x.dataId).id;return re(i,u.shape[0],u.shape[1],u.shape[2],o,h,b,y,g,_,v,E,w,k,I,S,M,A,N),x}},ie=c(a.Elu),oe=f(a.Equal,0,"bool"),de=c(a.Exp,"float32");function le(e){var n=e.inputs,t=e.attrs,r=e.backend,u=n.input,s=t.dim,i=u.shape.length,o=u.shape.slice(),d=s;return s<0&&(a.util.assert(-(i+1)<=s,(function(){return"Axis must be in the interval ["+-(i+1)+", "+i+"]"})),d=i+s+1),o.splice(d,0,1),O({inputs:{x:u},backend:r,attrs:{shape:o}})}var ce={kernelName:a.ExpandDims,backendName:"wasm",kernelFunc:le};function pe(e){var a=e.attrs,n=a.shape,t=a.value,r=a.dtype,u=e.backend,s=u.makeOutput(n,r);return u.typedArrayFromHeap(s).fill(t),s}var fe,me={kernelName:a.Fill,backendName:"wasm",kernelFunc:pe};var he,be={kernelName:a.FlipLeftRight,backendName:"wasm",kernelFunc:function(e){var a=e.inputs,n=e.backend,t=a.image,r=n.makeOutput(t.shape,t.dtype),u=n.dataIdMap.get(t.dataId).id,s=n.dataIdMap.get(r.dataId).id,i=t.shape,o=i[0],d=i[1],l=i[2],c=i[3];return fe(u,o,d,l,c,s),r},setupFunc:function(e){fe=e.wasm.cwrap(a.FlipLeftRight,null,["number","number","number","number","number","number"])}},ye=c(a.Floor),ge=f(a.FloorDiv);var _e,ve={kernelName:a.FusedBatchNorm,backendName:"wasm",setupFunc:function(e){he=e.wasm.cwrap(a.FusedBatchNorm,null,["number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs.varianceEpsilon,u=t.x,s=t.mean,i=t.variance,o=t.offset,d=t.scale,l=n.dataIdMap.get(u.dataId).id,c=n.dataIdMap.get(s.dataId).id,p=n.dataIdMap.get(i.dataId).id,f=null!=o?n.dataIdMap.get(o.dataId).id:0,m=null!=d?n.dataIdMap.get(d.dataId).id:0,h=n.makeOutput(u.shape,u.dtype);if(0===a.util.sizeFromShape(u.shape))return h;var b=n.dataIdMap.get(h.dataId).id;return he(l,c,p,f,m,r,b),h}};var we,ke={kernelName:a.FusedConv2D,backendName:"wasm",setupFunc:function(e){_e=e.wasm.cwrap(a.FusedConv2D,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.attrs,r=e.backend,u=n.x,s=n.filter,i=n.bias,d=n.preluActivationWeights,l=t.strides,c=t.pad,p=t.dilations,f=t.dataFormat,m=t.dimRoundingMode,h=t.activation,b=t.leakyreluAlpha,y=a.backend_util.computeConv2DInfo(u.shape,s.shape,l,p,c,m),g=o[h];if(null==g)throw new Error(h+" activation not yet supported for FusedConv2D in the wasm backend.");var _=r.dataIdMap.get(u.dataId).id,v=r.dataIdMap.get(s.dataId).id,w=y.outChannels,k=0;if(null!=i){var I=r.dataIdMap.get(i.dataId);if(1!==I.shape.length)throw new Error("FusedConv2D only supports rank-1 bias but got rank "+I.shape.length+".");if(I.shape[0]!==w)throw new Error("FusedConv2D bias shape ("+I.shape+") does not match the number of output channels ("+w+")");k=I.id}var S=y.filterHeight,M=y.filterWidth,A=y.padInfo.top,E=y.padInfo.right,x=y.padInfo.bottom,N=y.padInfo.left,F=y.dilationHeight,O=y.dilationWidth,T=y.strideHeight,R=y.strideWidth,C=y.inChannels,D="SAME"===y.padInfo.type?1:0,P=y.batchSize,W=y.inHeight,L=y.inWidth;if("NHWC"!==f)throw new Error("wasm backend FusedConv2D does not support dataFormat:'"+f+"'. Please use 'NHWC'.");var H=r.makeOutput(y.outShape,"float32"),B=r.dataIdMap.get(H.dataId).id,U=null==d?0:r.dataIdMap.get(d.dataId).id;return _e(_,P,W,L,v,S,M,k,A,E,x,N,D,F,O,T,R,C,w,g,U,b||0,B),H}};var Ie,Se={kernelName:a.FusedDepthwiseConv2D,backendName:"wasm",setupFunc:function(e){we=e.wasm.cwrap(a.FusedDepthwiseConv2D,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.attrs,r=e.backend,u=n.x,s=n.filter,i=n.bias,d=n.preluActivationWeights,l=t.strides,c=t.pad,p=t.dilations,f=t.dataFormat,m=t.dimRoundingMode,h=t.activation,b=t.leakyreluAlpha,y=a.backend_util.computeConv2DInfo(u.shape,s.shape,l,p,c,m,!0),g=o[h];if(null==g)throw new Error(h+" activation not yet supported for FusedDepthwiseConv2D in the wasm backend.");var _=r.dataIdMap.get(u.dataId).id,v=r.dataIdMap.get(s.dataId).id,w=y.outChannels,k=0;if(null!=i){var I=r.dataIdMap.get(i.dataId);if(1!==I.shape.length)throw new Error("FusedDepthwiseConv2D only supports rank-1 bias but got rank "+I.shape.length+".");if(I.shape[0]!==w)throw new Error("FusedDepthwiseConv2D bias shape ("+I.shape+") does not match the number of output channels ("+w+")");k=I.id}var S=y.filterHeight,M=y.filterWidth,A=y.padInfo.top,E=y.padInfo.right,x=y.padInfo.bottom,N=y.padInfo.left,F=y.dilationHeight,O=y.dilationWidth,T=y.strideHeight,R=y.strideWidth,C=y.inChannels,D="SAME"===y.padInfo.type?1:0,P=y.batchSize,W=y.inHeight,L=y.inWidth;if("NHWC"!==f)throw new Error("wasm backend FusedDepthwiseConv2D does not support dataFormat:'"+f+"'. Please use 'NHWC'.");var H=r.makeOutput(y.outShape,"float32"),B=r.dataIdMap.get(H.dataId).id,U=null==d?0:r.dataIdMap.get(d.dataId).id;return we(_,P,W,L,v,S,M,k,A,E,x,N,D,F,O,T,R,C,w,g,U,b||0,B),H}};var Me,Ae={kernelName:a.GatherNd,backendName:"wasm",setupFunc:function(e){Ie=e.wasm.cwrap(a.GatherNd,null,["number","number","number","number","number","number","array","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=t.params,u=t.indices,s=a.gather_util.prepareAndValidate(r,u),o=s[0],d=s[1],l=s[2],c=s[3],p=n.makeOutput(o,r.dtype);if(0===d)return p;var f=u.shape,m=f[f.length-1],h=n.dataIdMap.get(r.dataId).id,b=n.dataIdMap.get(u.dataId).id,y=new Uint8Array(new Int32Array(c).buffer),g=n.dataIdMap.get(p.dataId).id;return Ie(h,i[r.dtype],b,d,m,l,y,g),p}};var Ee,xe={kernelName:a.GatherV2,backendName:"wasm",setupFunc:function(e){Me=e.wasm.cwrap("Gather",null,["number","number","array","number","number","number","array","number"])},kernelFunc:function(e){for(var n=e.backend,t=e.inputs,r=e.attrs,u=t.x,s=t.indices,o=r.axis,d=r.batchDims,l=a.util.parseAxisParam(o,u.shape)[0],c=n.readSync(s.dataId),p=u.shape[l],f=function(e){var n=c[e];a.util.assert(n<=p-1&&n>=0,(function(){return"GatherV2: the index value "+n+" is not in [0, "+(p-1)+"]"}))},m=0;m<c.length;++m)f(m);var h=a.backend_util.segment_util.collectGatherOpShapeInfo(u,s,l,d),b=O({inputs:{x:u},attrs:{shape:[h.batchSize,h.outerSize,h.dimSize,h.sliceSize]},backend:n}),y=a.util.sizeFromShape(s.shape),g=O({inputs:{x:s},attrs:{shape:[h.batchSize,y/h.batchSize]},backend:n}),_=[h.batchSize,h.outerSize,y/h.batchSize,h.sliceSize],v=n.makeOutput(_,u.dtype);if(0===a.util.sizeFromShape(u.shape))return v;var w=b.shape.length-1,k=n.dataIdMap.get(b.dataId).id,I=n.dataIdMap.get(g.dataId).id,S=n.dataIdMap.get(v.dataId).id,M=new Uint8Array(new Int32Array(a.util.computeStrides(b.shape)).buffer),A=new Uint8Array(new Int32Array(a.util.computeStrides(_)).buffer);return Me(k,i[u.dtype],M,w,I,h.batchSize,A,S),n.disposeData(b.dataId),n.disposeData(g.dataId),v.shape=h.outputShape,v}},Ne=f(a.Greater,0,"bool"),Fe=f(a.GreaterEqual,0,"bool");var Oe,Te={kernelName:a.LeakyRelu,backendName:"wasm",setupFunc:function(e){Ee=e.wasm.cwrap(a.LeakyRelu,null,["number","number","number","number"])},kernelFunc:function(e){var n=e.inputs.x,t=e.attrs.alpha,r=e.backend,u=r.dataIdMap.get(n.dataId).id,s=r.makeOutput(n.shape,"float32");if(0!==a.util.sizeFromShape(n.shape)){var o=r.dataIdMap.get(s.dataId).id;Ee(u,i[n.dtype],t,o)}return s}},Re=f(a.Less,0,"bool"),Ce=f(a.LessEqual,0,"bool"),De=c(a.Log),Pe=f(a.LogicalAnd,0,"bool");var We,Le={kernelName:a.Max,backendName:"wasm",setupFunc:function(e){Oe=e.wasm.cwrap(a.Max,null,["number","number","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=r.reductionIndices,s=r.keepDims,o=t.x,d=n.dataIdMap.get(o.dataId).id,l=o,c=I(o,u,n),p=c.transposed,f=c.axes,m=c.originalAxes,h=c.inputWasTransposed;h&&(l=p,d=n.dataIdMap.get(p.dataId).id);var b=l.shape.length;a.backend_util.assertAxesAreInnerMostDims("max",f,b);var y=a.backend_util.computeOutAndReduceShapes(l.shape,f),g=y[0],_=y[1],v=a.util.sizeFromShape(_),w=n.makeOutput(g,o.dtype);if(0!==a.util.sizeFromShape(l.shape)){var k=n.dataIdMap.get(w.dataId).id;Oe(d,i[o.dtype],v,k)}if(h&&n.disposeData(p.dataId),s){var S=a.backend_util.expandShapeToKeepDim(w.shape,m);w.shape=S}return w}},He=f(a.Maximum);var Be,Ue={kernelName:a.MaxPool,backendName:"wasm",setupFunc:function(e){We=e.wasm.cwrap(a.MaxPool,null,["number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.inputs,t=e.attrs,r=e.backend,u=n.x,s=r.dataIdMap.get(u.dataId).id;a.util.assert("float32"===u.dtype,(function(){return"Error in MaxPool: only float32 input is supported. Got "+u.dtype+"."}));var i=t.filterSize,o=t.strides,d=t.pad,l=t.dimRoundingMode,c=a.backend_util.computePool2DInfo(u.shape,i,o,1,d,l),p=c.filterHeight,f=c.filterWidth,m=c.padInfo.top,h=c.padInfo.right,b=c.padInfo.bottom,y=c.padInfo.left,g=c.dilationHeight,_=c.dilationWidth,v=c.strideHeight,w=c.strideWidth,k=c.inChannels,I=c.outChannels;if("channelsLast"!==c.dataFormat)throw new Error("wasm backend does not support dataFormat:'"+c.dataFormat+"'. Please use 'channelsLast'.");var S=r.makeOutput(c.outShape,"float32"),M=r.dataIdMap.get(S.dataId).id;return We(s,u.shape[0],u.shape[1],u.shape[2],p,f,m,h,b,y,g,_,v,w,k,I,M),S}};var ze,je={kernelName:a.Mean,backendName:"wasm",setupFunc:function(e){Be=e.wasm.cwrap(a.Mean,null,["number, number, number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=r.axis,s=r.keepDims,i=t.x,o=n.dataIdMap.get(i.dataId).id,d=o,l=i,c=I(i,u,n),p=c.transposed,f=c.axes,m=c.originalAxes,h=c.inputWasTransposed,b=f;if(h){var y=n.dataIdMap.get(p.dataId).id;y!==o&&(l=p,d=y,b=a.backend_util.getInnerMostAxes(b.length,l.shape.length))}a.backend_util.assertAxesAreInnerMostDims("mean",b,l.shape.length);var g=a.backend_util.computeOutAndReduceShapes(l.shape,b),_=g[0],v=g[1],w=a.util.sizeFromShape(v),k=l;"float32"!==l.dtype&&(k=H({backend:n,inputs:{x:l},attrs:{dtype:"float32"}}),d=n.dataIdMap.get(k.dataId).id);var S=n.makeOutput(_,"float32");if(0!==a.util.sizeFromShape(l.shape)){var M=n.dataIdMap.get(S.dataId).id;Be(d,w,M)}if(h&&n.disposeData(p.dataId),s){var A=a.backend_util.expandShapeToKeepDim(S.shape,m);S.shape=A}return"float32"!==l.dtype&&n.disposeData(k.dataId),S}};var qe,Ve,Ge={kernelName:a.Min,backendName:"wasm",setupFunc:function(e){ze=e.wasm.cwrap(a.Min,null,["number","number","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=r.axis,s=r.keepDims,o=t.x,d=n.dataIdMap.get(o.dataId).id,l=d,c=o,p=I(o,u,n),f=p.transposed,m=p.axes,h=p.originalAxes,b=p.inputWasTransposed;if(b){var y=n.dataIdMap.get(f.dataId).id;y!==d&&(c=f,l=y)}var g=c.shape.length;a.backend_util.assertAxesAreInnerMostDims("min",m,g);var _=a.backend_util.computeOutAndReduceShapes(c.shape,m),v=_[0],w=_[1],k=a.util.sizeFromShape(w),S=n.makeOutput(v,c.dtype);if(0!==a.util.sizeFromShape(c.shape)){var M=n.dataIdMap.get(S.dataId).id;ze(l,i[o.dtype],k,M)}if(b&&n.disposeData(f.dataId),s){var A=a.backend_util.expandShapeToKeepDim(S.shape,h);S.shape=A}return S}},Ke=f(a.Minimum);!function(e){e[e.reflect=0]="reflect",e[e.symmetric=1]="symmetric"}(qe||(qe={}));var Xe,Qe={kernelName:a.MirrorPad,backendName:"wasm",kernelFunc:function(e){var a=e.inputs.x,n=e.backend,t=e.attrs,r=t.paddings,u=t.mode,s=r.map((function(e,n){return e[0]+a.shape[n]+e[1]})),o=n.dataIdMap.get(a.dataId).id,d=n.makeOutput(s,a.dtype),l=n.dataIdMap.get(d.dataId).id,c=new Uint8Array(new Int32Array(a.shape).buffer),p=r.map((function(e){return e[0]})),f=r.map((function(e){return e[1]})),m=new Uint8Array(new Int32Array(p).buffer),h=new Uint8Array(new Int32Array(f).buffer);return Ve(o,c,a.shape.length,i[a.dtype],m,h,qe[u],l),d},setupFunc:function(e){Ve=e.wasm.cwrap(a.MirrorPad,null,["number","array","number","number","array","array","number","number"])}},Ye=f(a.Multiply),Ze=c(a.Neg);function Je(e,a){var n=new Int32Array(e.wasm.HEAPU8.buffer,a,4),t=n[0],r=n[1],u=n[2],s=n[3];return e.wasm._free(a),{pSelectedIndices:t,selectedSize:r,pSelectedScores:u,pValidOutputs:s}}var $e,ea={kernelName:a.NonMaxSuppressionV3,backendName:"wasm",setupFunc:function(e){Xe=e.wasm.cwrap(a.NonMaxSuppressionV3,"number",["number","number","number","number","number"])},kernelFunc:function(e){var a=e.backend,n=e.inputs,t=e.attrs,r=t.iouThreshold,u=t.maxOutputSize,s=t.scoreThreshold,i=n.boxes,o=n.scores,d=a.dataIdMap.get(i.dataId).id,l=a.dataIdMap.get(o.dataId).id,c=Je(a,Xe(d,l,u,r,s)),p=c.pSelectedIndices,f=c.selectedSize,m=c.pSelectedScores,h=c.pValidOutputs;return a.wasm._free(m),a.wasm._free(h),a.makeOutput([f],"int32",p)}};var aa,na={kernelName:a.NonMaxSuppressionV4,backendName:"wasm",setupFunc:function(e){$e=e.wasm.cwrap(a.NonMaxSuppressionV4,"number",["number","number","number","number","number","bool"])},kernelFunc:function(e){var a=e.backend,n=e.inputs,t=e.attrs,r=t.iouThreshold,u=t.maxOutputSize,s=t.scoreThreshold,i=t.padToMaxOutputSize,o=n.boxes,d=n.scores,l=a.dataIdMap.get(o.dataId).id,c=a.dataIdMap.get(d.dataId).id,p=Je(a,$e(l,c,u,r,s,i)),f=p.pSelectedIndices,m=p.selectedSize,h=p.pSelectedScores,b=p.pValidOutputs;return a.wasm._free(h),[a.makeOutput([m],"int32",f),a.makeOutput([],"int32",b)]}};var ta,ra={kernelName:a.NonMaxSuppressionV5,backendName:"wasm",setupFunc:function(e){aa=e.wasm.cwrap(a.NonMaxSuppressionV5,"number",["number","number","number","number","number","number"])},kernelFunc:function(e){var a=e.backend,n=e.inputs,t=e.attrs,r=t.iouThreshold,u=t.maxOutputSize,s=t.scoreThreshold,i=t.softNmsSigma,o=n.boxes,d=n.scores,l=a.dataIdMap.get(o.dataId).id,c=a.dataIdMap.get(d.dataId).id,p=Je(a,aa(l,c,u,r,s,i)),f=p.pSelectedIndices,m=p.selectedSize,h=p.pSelectedScores,b=p.pValidOutputs;return a.wasm._free(b),[a.makeOutput([m],"int32",f),a.makeOutput([m],"float32",h)]}},ua=f(a.NotEqual,0,"bool");var sa={kernelName:a.OneHot,backendName:"wasm",setupFunc:function(e){ta=e.wasm.cwrap(a.OneHot,null,["number","number","number","number","number"])},kernelFunc:function(e){var a=e.inputs,n=e.backend,t=e.attrs,r=a.indices,u=t.depth,s=t.onValue,i=t.offValue,o=n.makeOutput(r.shape.concat([u]),"int32"),d=n.dataIdMap.get(o.dataId).id,l=n.dataIdMap.get(r.dataId).id;return ta(l,u,s,i,d),o}};var ia={kernelName:a.OnesLike,backendName:"wasm",kernelFunc:function(e){var a=e.inputs.x,n=e.backend,t=n.makeOutput(a.shape,a.dtype);return n.typedArrayFromHeap(t).fill(1),t}};var oa,da={kernelName:a.Pack,backendName:"wasm",kernelFunc:function(e){var n=e.inputs,t=e.backend,r=e.attrs.axis;if(1===n.length)return le({inputs:{input:n[0]},backend:t,attrs:{dim:r}});var u=n[0].shape,s=n[0].dtype;n.forEach((function(e){a.util.assertShapesMatch(u,e.shape,"All tensors passed to stack must have matching shapes"),a.util.assert(s===e.dtype,(function(){return"All tensors passed to stack must have matching dtypes"}))}));var i=[],o=q({inputs:n.map((function(e){var a=le({inputs:{input:e},backend:t,attrs:{dim:r}});return i.push(a),a})),backend:t,attrs:{axis:r}});return i.forEach((function(e){return t.disposeData(e.dataId)})),o}};var la,ca={kernelName:a.PadV2,backendName:"wasm",kernelFunc:function(e){var n=e.inputs.x,t=e.backend,r=e.attrs,u=r.paddings,s=r.constantValue,o=u.map((function(e,a){return e[0]+n.shape[a]+e[1]}));if(0===a.util.sizeFromShape(n.shape))return pe({backend:t,attrs:{shape:o,value:s,dtype:n.dtype}});var d=t.dataIdMap.get(n.dataId).id,l=t.makeOutput(o,n.dtype),c=t.dataIdMap.get(l.dataId).id,p=new Uint8Array(new Int32Array(n.shape).buffer),f=u.map((function(e){return e[0]})),m=u.map((function(e){return e[1]})),h=new Uint8Array(new Int32Array(f).buffer),b=new Uint8Array(new Int32Array(m).buffer);return oa(d,p,n.shape.length,i[n.dtype],h,b,s,c),l},setupFunc:function(e){oa=e.wasm.cwrap(a.PadV2,null,["number","array","number","number","array","array","number","number"])}},pa=f(a.Pow);var fa,ma={kernelName:a.Prelu,backendName:"wasm",setupFunc:function(e){la=e.wasm.cwrap(a.Prelu,null,["number","number","number"])},kernelFunc:function(e){var a=e.inputs,n=e.backend,t=a.x,r=a.alpha,u=n.dataIdMap.get(t.dataId).id,s=n.dataIdMap.get(r.dataId).id,i=u,o=t,d=o;"float32"!==o.dtype&&(d=H({backend:n,inputs:{x:t},attrs:{dtype:"float32"}}),i=n.dataIdMap.get(d.dataId).id);var l=n.makeOutput(t.shape,"float32"),c=n.dataIdMap.get(l.dataId).id;return la(i,s,c),"float32"!==o.dtype&&n.disposeData(d.dataId),l}};var ha,ba={kernelName:a.Prod,backendName:"wasm",setupFunc:function(e){fa=e.wasm.cwrap(a.Prod,null,["number","number","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=r.axis,s=r.keepDims,o=t.x,d=n.dataIdMap.get(o.dataId).id,l=d,c=o,p=I(o,u,n),f=p.transposed,m=p.axes,h=p.originalAxes,b=p.inputWasTransposed,y=m;if(b){var g=n.dataIdMap.get(f.dataId).id;g!==d&&(c=f,l=g,y=a.backend_util.getInnerMostAxes(y.length,c.shape.length))}a.backend_util.assertAxesAreInnerMostDims("prod",y,c.shape.length);var _=a.backend_util.computeOutAndReduceShapes(c.shape,y),v=_[0],w=_[1],k=a.util.sizeFromShape(w),S=n.makeOutput(v,c.dtype);if(0!==a.util.sizeFromShape(c.shape)){var M=n.dataIdMap.get(S.dataId).id;fa(l,k,i[S.dtype],M)}if(b&&n.disposeData(f.dataId),s){var A=a.backend_util.expandShapeToKeepDim(S.shape,h);S.shape=A}return S}},ya={kernelName:a.Range,backendName:"wasm",kernelFunc:function(e){var n=e.backend,t=e.attrs,r=t.start,u=t.stop,s=t.step,i=t.dtype,o=function(e,n,t,r){if(e===n||e<n&&t<0||n<e&&t>1)return a.util.makeZerosTypedArray(0,r);const u=Math.abs(Math.ceil((n-e)/t)),s=a.util.makeZerosTypedArray(u,r);n<e&&1===t&&(t=-1),s[0]=e;for(let e=1;e<s.length;e++)s[e]=s[e-1]+t;return s}(r,u,s,i),d=n.makeOutput([o.length],i);return n.typedArrayFromHeap(d).set(o),d}},ga=f(a.RealDiv),_a=c(a.Relu),va=c(a.Relu6);var wa,ka={kernelName:a.ResizeBilinear,backendName:"wasm",setupFunc:function(e){ha=e.wasm.cwrap(a.ResizeBilinear,null,["number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n,t=e.backend,r=e.inputs,u=e.attrs,s=r.images,i=u.alignCorners,o=u.halfPixelCenters,d=u.size,l=d[0],c=d[1],p=s.shape,f=p[0],m=p[1],h=p[2],b=p[3],y=[f,l,c,b],g=t.dataIdMap.get(s.dataId);"float32"!==g.dtype&&(n=H({backend:t,inputs:{x:s},attrs:{dtype:"float32"}}),g=t.dataIdMap.get(n.dataId));var _=g.id,v=t.makeOutput(y,"float32");if(0===a.util.sizeFromShape(s.shape))return v;var w=t.dataIdMap.get(v.dataId).id;return ha(_,f,m,h,b,l,c,i?1:0,o?1:0,w),null!=n&&t.disposeData(n.dataId),v}};var Ia,Sa={kernelName:a.Reverse,backendName:"wasm",kernelFunc:function(e){var n=e.inputs,t=e.backend,r=e.attrs,u=n.x,s=r.dims,i=a.util.parseAxisParam(s,u.shape);if(0===u.shape.length)return y({inputs:{x:u},backend:t});var o=t.makeOutput(u.shape,u.dtype),d=t.dataIdMap.get(u.dataId).id,l=t.dataIdMap.get(o.dataId).id,c=new Uint8Array(new Int32Array(i).buffer),p=new Uint8Array(new Int32Array(u.shape).buffer);wa(d,c,i.length,p,u.shape.length,l);var f=O({inputs:{x:o},attrs:{shape:u.shape},backend:t});return t.disposeData(o.dataId),f},setupFunc:function(e){wa=e.wasm.cwrap(a.Reverse,null,["number","array","number","array","number","number"])}};var Ma,Aa={kernelName:a.RotateWithOffset,backendName:"wasm",kernelFunc:function(e){var n=e.inputs,t=e.backend,r=e.attrs,u=n.image,s=r.radians,i=r.fillValue,o=r.center,d=t.makeOutput(u.shape,u.dtype),l=t.dataIdMap.get(u.dataId).id,c=t.dataIdMap.get(d.dataId).id,p=u.shape,f=p[0],m=p[1],h=p[2],b=p[3],y=a.backend_util.getImageCenter(o,m,h),g=y[0],_=y[1],v="number"==typeof i?[i,i,i,0===i?0:255]:i.concat([255]),w=new Uint8Array(new Int32Array(v).buffer);return Ia(l,f,m,h,b,s,g,_,w,v.length,c),d},setupFunc:function(e){Ia=e.wasm.cwrap(a.RotateWithOffset,null,["number","number","number","number","number","number","number","number","array","number","number"])}},Ea=c(a.Round),xa=c(a.Rsqrt);var Na,Fa={kernelName:a.ScatterNd,backendName:"wasm",setupFunc:function(e){Ma=e.wasm.cwrap(a.ScatterNd,null,["number","number","number","number","number","number","array","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=t.indices,s=t.updates,o=r.shape,d=n.makeOutput(o,s.dtype);if(0===a.util.sizeFromShape(o))return d;var l=a.scatter_util.calculateShapes(s,u,o),c=l.sliceRank,p=l.numUpdates,f=l.sliceSize,m=l.strides,h=l.outputSize,b=n.dataIdMap.get(u.dataId).id,y=n.dataIdMap.get(s.dataId).id,g=new Uint8Array(new Int32Array(m).buffer),_=n.dataIdMap.get(d.dataId).id;return Ma(b,y,i[s.dtype],c,p,f,g,h,_),d}};var Oa,Ta={kernelName:a.Select,backendName:"wasm",kernelFunc:function(e){var n=e.inputs,t=e.backend,r=n.condition,u=n.t,s=n.e,i=t.dataIdMap.get(r.dataId).id,o=t.dataIdMap.get(u.dataId).id,d=t.dataIdMap.get(s.dataId).id,l=t.makeOutput(u.shape,u.dtype),c=t.dataIdMap.get(l.dataId).id,p=r.shape.length,f=u.shape.length,m=0===p||p>1||1===f?1:a.util.sizeFromShape(u.shape.slice(1));return Na(i,o,d,m,c),l},setupFunc:function(e){Na=e.wasm.cwrap("SelectV2",null,["number","number","number","number","number"])}};var Ra,Ca={kernelName:"Sigmoid",backendName:"wasm",setupFunc:function(e){Oa=e.wasm.cwrap(a.Sigmoid,null,["number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs.x,r=n.dataIdMap.get(t.dataId).id,u=n.makeOutput(t.shape,t.dtype),s=n.dataIdMap.get(u.dataId).id;return 0===a.util.sizeFromShape(u.shape)||Oa(r,s),u}},Da=c(a.Sin);var Pa={kernelName:a.Softmax,backendName:"wasm",setupFunc:function(e){Ra=e.wasm.cwrap(a.Softmax,null,["number","number","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs.logits,r=e.attrs.dim,u=n.dataIdMap.get(t.dataId).id,s=n.makeOutput(t.shape,t.dtype),i=n.dataIdMap.get(s.dataId).id,o=t.shape[r],d=a.util.sizeFromShape(t.shape)/o;return 0===a.util.sizeFromShape(s.shape)||Ra(u,i,o,d),s}};var Wa,La={kernelName:a.SpaceToBatchND,backendName:"wasm",kernelFunc:function(e){var n=e.inputs,t=e.backend,r=e.attrs,u=n.x,s=r.blockShape,i=r.paddings,o=a.util.sizeFromShape(s),d=[[0,0]];d.push.apply(d,i);for(var l=1+s.length;l<u.shape.length;++l)d.push([0,0]);var c=ca.kernelFunc({inputs:{x:u},backend:t,attrs:{paddings:d,constantValue:0}}),p=a.backend_util.getReshaped(c.shape,s,o,!1),f=a.backend_util.getPermuted(p.length,s.length,!1),m=a.backend_util.getReshapedPermuted(c.shape,s,o,!1),h=O({inputs:{x:c},backend:t,attrs:{shape:p}}),b=v({inputs:{x:h},backend:t,attrs:{perm:f}}),y=O({inputs:{x:b},backend:t,attrs:{shape:m}});return t.disposeData(c.dataId),t.disposeData(h.dataId),t.disposeData(b.dataId),y}};var Ha,Ba={kernelName:a.SparseFillEmptyRows,backendName:"wasm",setupFunc:function(e){Wa=e.wasm.cwrap("SparseFillEmptyRows","number",["number","number","number","number","number","number","number","number","number","number","number","number"])},kernelFunc:function(e){var n,t=e.backend,r=e.inputs,u=r.indices,s=r.values,o=r.denseShape,d=r.defaultValue,l=u.shape[0],c=u.shape[1],p=t.readSync(o.dataId)[0],f=[l+p,c],m=t.dataIdMap.get(u.dataId).id,h=t.dataIdMap.get(s.dataId).id,b=t.dataIdMap.get(d.dataId).id,y=t.makeOutput(f,u.dtype),g=t.dataIdMap.get(y.dataId).id,_=t.makeOutput(f.slice(0,1),s.dtype),v=t.dataIdMap.get(_.dataId).id,w=t.makeOutput([p],"bool"),k=t.dataIdMap.get(w.dataId).id,I=t.makeOutput([l],u.dtype),S=t.dataIdMap.get(I.dataId).id,M=t.makeOutput([4],"int32"),A=t.dataIdMap.get(M.dataId).id,E=Wa(m,h,i[s.dtype],l,p,c,b,g,v,k,S,A),x=t.readSync(M.dataId);switch(x[0]){case 1:n=a.backend_util.getSparseFillEmptyRowsIndicesDenseShapeMismatch(x[1]);break;case 2:n=a.backend_util.getSparseFillEmptyRowsNegativeIndexErrorMessage(x[1],x[2]);break;case 3:n=a.backend_util.getSparseFillEmptyRowsOutOfRangeIndexErrorMessage(x[1],x[2],x[3]);break;default:n=""}if(t.disposeData(M.dataId),n)throw t.disposeData(y.dataId),t.disposeData(_.dataId),t.disposeData(w.dataId),t.disposeData(I.dataId),new Error(n);var N=y,F=_;return E!==f[0]&&(N=P({inputs:{x:y},attrs:{begin:0,size:[E,c]},backend:t}),F=P({inputs:{x:_},attrs:{begin:0,size:E},backend:t}),t.disposeData(y.dataId),t.disposeData(_.dataId)),[N,F,w,I]}};var Ua,za={kernelName:a.SparseReshape,backendName:"wasm",setupFunc:function(e){Ha=e.wasm.cwrap(a.SparseReshape,null,["number","number","number","number","number","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=t.inputIndices,u=t.inputShape,s=t.newShape;if(2!==r.shape.length)throw new Error("Input indices should be a matrix but received shape\n        "+r.shape);if(1!==u.shape.length)throw new Error("Input shape should be a vector but received shape\n        "+u.shape);if(1!==s.shape.length)throw new Error("Target shape should be a vector but received shape "+s.shape);var i=n.dataIdMap.get(r.dataId).id,o=n.dataIdMap.get(u.dataId).id,d=n.dataIdMap.get(s.dataId).id,l=r.shape[0],c=a.util.sizeFromShape(s.shape),p=n.makeOutput([l,c],r.dtype),f=n.dataIdMap.get(p.dataId).id,m=n.makeOutput([c],s.dtype),h=n.dataIdMap.get(m.dataId).id,b=n.makeOutput([3],"int32"),y=n.dataIdMap.get(b.dataId).id;Ha(i,o,d,l,f,h,y);var g,_=n.readSync(b.dataId);switch(_[0]){case 0:g=a.backend_util.getSparseReshapeMultipleNegativeOneOutputDimErrorMessage(_[1],_[2]);break;case 1:g=a.backend_util.getSparseReshapeNegativeOutputDimErrorMessage(_[1],_[2]);break;case 2:g=a.backend_util.getSparseReshapeEmptyTensorZeroOutputDimErrorMessage();break;case 3:var v=Array.from(n.readSync(u.dataId)),w=Array.from(n.readSync(m.dataId));g=a.backend_util.getSparseReshapeInputOutputMultipleErrorMessage(v,w);break;case 4:v=Array.from(n.readSync(u.dataId)),w=Array.from(n.readSync(m.dataId));g=a.backend_util.getSparseReshapeInputOutputMismatchErrorMessage(v,w);break;default:g=""}if(n.disposeData(b.dataId),g)throw n.disposeData(p.dataId),n.disposeData(m.dataId),new Error(g);return[p,m]}};function ja(e){Ua=e.wasm.cwrap("SparseSegmentReduction",null,["number","number","number","number","number","number","number","number","number"])}function qa(e,n){var t=e.backend,r=e.inputs,u=r.data,s=r.indices,o=r.segmentIds,d=s.shape[0],l=t.readSync(o.dataId,d-1,d)[0],c=d>0?l+1:0;if(c<0)throw new Error(a.backend_util.getSparseSegmentReductionNegativeSegmentIdsErrorMessage());var p=u.shape.slice();p[0]=c;var f=t.dataIdMap.get(u.dataId).id,m=t.dataIdMap.get(s.dataId).id,h=t.dataIdMap.get(o.dataId).id,b=t.makeOutput(p,u.dtype),y=t.dataIdMap.get(b.dataId).id,g=t.makeOutput([4],"int32"),_=t.dataIdMap.get(g.dataId).id;Ua(f,i[u.dtype],u.shape[0],m,h,y,_,n,0);var v,w=t.readSync(g.dataId);switch(w[0]){case 0:v=a.backend_util.getSparseSegmentReductionNegativeSegmentIdsErrorMessage();break;case 1:v=a.backend_util.getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage();break;case 2:v=a.backend_util.getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage(w[1],w[2]);break;case 3:v=a.backend_util.getSparseSegmentReductionIndicesOutOfRangeErrorMessage(w[1],w[2],w[3]);break;default:v=""}if(t.disposeData(g.dataId),v)throw t.disposeData(b.dataId),new Error(v);return b}var Va={kernelName:a.SparseSegmentMean,backendName:"wasm",setupFunc:ja,kernelFunc:function(e){return qa(e,!0)}};var Ga={kernelName:a.SparseSegmentSum,backendName:"wasm",setupFunc:ja,kernelFunc:function(e){return qa(e,!1)}};var Ka,Xa={kernelName:a.SplitV,backendName:"wasm",kernelFunc:function(e){var n=e.inputs,t=e.attrs,r=e.backend,u=n.x,s=t.numOrSizeSplits,i=t.axis,o=a.util.parseAxisParam(i,u.shape)[0],d=a.backend_util.prepareSplitSize(u,s,o),l=new Array(u.shape.length).fill(0),c=u.shape.slice();return d.map((function(e){var a=c.slice();a[o]=e;var n=P({inputs:{x:u},attrs:{begin:l,size:a},backend:r});return l[o]+=e,n}))}},Qa=c(a.Sqrt),Ya=c(a.Square),Za=f(a.SquaredDifference);var Ja,$a={kernelName:a.Step,backendName:"wasm",setupFunc:function(e){Ka=e.wasm.cwrap(a.Step,null,["number","number","number","number"])},kernelFunc:function(e){var a=e.backend,n=e.inputs,t=e.attrs.alpha,r=n.x,u=a.dataIdMap.get(r.dataId).id,s=a.makeOutput(r.shape,r.dtype),o=a.dataIdMap.get(s.dataId).id;return Ka(u,t,i[r.dtype],o),s}};var en,an={kernelName:a.StridedSlice,backendName:"wasm",setupFunc:function(e){Ja=e.wasm.cwrap(a.StridedSlice,null,["number","array","number","array","array","array","array","array","number","number"])},kernelFunc:function(e){var n,t=e.backend,r=e.inputs,u=e.attrs,s=r.x,i=u.begin,o=u.end,d=u.strides,l=u.beginMask,c=u.endMask,p=u.ellipsisMask,f=u.newAxisMask,m=u.shrinkAxisMask,h=a.slice_util.sliceInfo(s.shape,i,o,d,l,c,p,f,m),b=h.finalShapeSparse,y=h.finalShape,g=h.isIdentity,_=h.sliceDim0,v=h.isSimpleSlice,w=h.begin,k=h.end,I=h.strides;if(g)n=O({inputs:{x:s},backend:t,attrs:{shape:y}});else if(_||v){a.util.assert(s.shape.length>=1,(function(){return"Input must have rank at least 1, got: "+s.shape.length}));var S=a.slice_util.computeOutShape(w,k,I),M=P({inputs:{x:s},backend:t,attrs:{begin:w,size:S}});n=O({inputs:{x:M},backend:t,attrs:{shape:y}}),t.disposeData(M.dataId)}else{var A=t.makeOutput(b,"float32"),E=t.dataIdMap.get(s.dataId).id,x=new Uint8Array(new Int32Array(a.util.computeStrides(s.shape)).buffer),N=new Uint8Array(new Int32Array(w).buffer),F=new Uint8Array(new Int32Array(k).buffer),T=new Uint8Array(new Int32Array(I).buffer),R=new Uint8Array(new Int32Array(b).buffer),C=new Uint8Array(new Int32Array(a.util.computeStrides(b)).buffer),D=t.dataIdMap.get(A.dataId).id;Ja(E,x,s.shape.length,N,F,T,R,C,b.length,D),n=O({inputs:{x:A},backend:t,attrs:{shape:y}}),t.disposeData(A.dataId)}return n}},nn=f(a.Sub);var tn,rn={kernelName:a.Sum,backendName:"wasm",setupFunc:function(e){en=e.wasm.cwrap(a.Sum,null,["number","number","number","number"])},kernelFunc:function(e){var n=e.backend,t=e.inputs,r=e.attrs,u=r.axis,s=r.keepDims,o=t.x,d=n.dataIdMap.get(o.dataId).id,l=d,c=o,p=I(o,u,n),f=p.transposed,m=p.axes,h=p.originalAxes,b=p.inputWasTransposed,y=m;if(b){var g=n.dataIdMap.get(f.dataId).id;g!==d&&(c=f,l=g,y=a.backend_util.getInnerMostAxes(y.length,c.shape.length))}a.backend_util.assertAxesAreInnerMostDims("sum",y,c.shape.length);var _=a.backend_util.computeOutAndReduceShapes(c.shape,y),v=_[0],w=_[1],k=a.util.sizeFromShape(w),S=n.makeOutput(v,c.dtype);if(0!==a.util.sizeFromShape(c.shape)){var M=n.dataIdMap.get(S.dataId).id;en(l,k,i[S.dtype],M)}if(b&&n.disposeData(f.dataId),s){var A=a.backend_util.expandShapeToKeepDim(S.shape,h);S.shape=A}return S}},un=c(a.Tan),sn=c(a.Tanh);var on,dn={kernelName:a.Tile,backendName:"wasm",setupFunc:function(e){tn=e.wasm.cwrap(a.Tile,null,["number","array","number","array","number","number"])},kernelFunc:function(e){for(var a=e.inputs,n=e.backend,t=e.attrs,r=a.x,u=n.dataIdMap.get(r.dataId).id,s=t.reps,o=new Array(r.shape.length),d=0;d<o.length;d++)o[d]=r.shape[d]*s[d];var l=new Uint8Array(new Int32Array(r.shape).buffer),c=new Uint8Array(new Int32Array(o).buffer),p=n.makeOutput(o,r.dtype),f=n.dataIdMap.get(p.dataId).id;return tn(u,l,r.shape.length,c,o.length,i[p.dtype],f),p}};var ln,cn={kernelName:a.TopK,backendName:"wasm",setupFunc:function(e){on=e.wasm.cwrap(a.TopK,null,["number","array","number","number","number","bool","number","number"])},kernelFunc:function(e){var a=e.inputs,n=e.backend,t=e.attrs,r=a.x,u=t.k,s=t.sorted,o=n.dataIdMap.get(r.dataId).id,d=new Uint8Array(new Int32Array(r.shape).buffer),l=r.shape.slice();l[l.length-1]=u;var c=n.makeOutput(l,r.dtype),p=n.dataIdMap.get(c.dataId).id,f=n.makeOutput(l,"int32"),m=n.dataIdMap.get(f.dataId).id;return on(o,d,r.shape.length,i[r.dtype],u,s,p,m),[c,f]}};var pn={kernelName:a.Transform,backendName:"wasm",setupFunc:function(e){ln=e.wasm.cwrap(a.Transform,null,["number","number","bool","number","number","number","number","number","number","array","number","number","number","number","number"])},kernelFunc:function(e){var n,t=e.backend,r=e.inputs,u=e.attrs,s=r.image,i=r.transforms,o=u.interpolation,d=u.fillMode,l=u.fillValue,c=u.outputShape,p=s.shape,f=p[0],m=p[1],h=p[2],b=p[3],y=null!=c?c:[m,h],g=y[0],_=y[1],v=[f,g,_,b],w=new Uint8Array(new Int32Array(a.util.computeStrides(s.shape)).buffer),k=t.makeOutput(v,s.dtype),I=t.dataIdMap.get(k.dataId).id,S=t.dataIdMap.get(s.dataId).id,M=t.dataIdMap.get(i.dataId).id,A="nearest"===o?1:2;switch(d){case"constant":n=1;break;case"reflect":n=2;break;case"wrap":n=3;break;case"nearest":n=4;break;default:n=1}return ln(S,M,i.shape[0]>1,f,g,_,b,h,m,w,s.shape.length-1,A,n,l,I),k}};var fn={kernelName:a.Unpack,backendName:"wasm",kernelFunc:function(e){var a=e.inputs,n=e.backend,t=e.attrs,r=a.value,u=t.axis;u<0&&(u+=r.shape.length);for(var s=r.shape[u],i=r.shape.length,o=new Array(i-1),d=0,l=0;l<i;l++)l!==u&&(o[d++]=r.shape[l]);var c=new Array(s),p=new Array(i).fill(0),f=r.shape.slice();for(f[u]=1,l=0;l<c.length;l++)p[u]=l,c[l]=P({inputs:{x:r},attrs:{begin:p,size:f},backend:n});return c.map((function(e){return{dataId:e.dataId,dtype:e.dtype,shape:o}}))}};for(var mn={kernelName:a.ZerosLike,backendName:"wasm",kernelFunc:function(e){var a=e.inputs.x,n=e.backend,t=n.makeOutput(a.shape,a.dtype);return n.typedArrayFromHeap(t).fill(0),t}},hn=0,bn=[l,p,h,b,M,E,N,F,C,L,U,z,j,G,X,Z,J,$,ae,te,ue,se,ie,oe,de,ce,me,be,ye,ge,ve,ke,Se,Ae,xe,Ne,Fe,_,Te,Re,Ce,De,Pe,Le,He,Ue,je,Ge,Ke,Qe,Ye,Ze,ea,na,ra,ua,sa,ia,da,ca,pa,ma,ba,ya,ga,_a,va,R,ka,Sa,Aa,Ea,xa,Fa,Ta,Ca,Da,W,Pa,La,Ba,za,Va,Ga,Xa,Qa,Ya,Za,$a,an,nn,rn,un,sn,dn,cn,pn,k,fn,mn];hn<bn.length;hn++){var yn=bn[hn];a.registerKernel(yn)}var gn=function(e,a){return(gn=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,a){e.__proto__=a}||function(e,a){for(var n in a)a.hasOwnProperty(n)&&(e[n]=a[n])})(e,a)};function _n(e,a,n,t){return new(n||(n=Promise))((function(r,u){function s(e){try{o(t.next(e))}catch(e){u(e)}}function i(e){try{o(t.throw(e))}catch(e){u(e)}}function o(e){var a;e.done?r(e.value):(a=e.value,a instanceof n?a:new n((function(e){e(a)}))).then(s,i)}o((t=t.apply(e,a||[])).next())}))}function vn(e,a){var n,t,r,u,s={label:0,sent:function(){if(1&r[0])throw r[1];return r[1]},trys:[],ops:[]};return u={next:i(0),throw:i(1),return:i(2)},"function"==typeof Symbol&&(u[Symbol.iterator]=function(){return this}),u;function i(u){return function(i){return function(u){if(n)throw new TypeError("Generator is already executing.");for(;s;)try{if(n=1,t&&(r=2&u[0]?t.return:u[0]?t.throw||((r=t.return)&&r.call(t),0):t.next)&&!(r=r.call(t,u[1])).done)return r;switch(t=0,r&&(u=[2&u[0],r.value]),u[0]){case 0:case 1:r=u;break;case 4:return s.label++,{value:u[1],done:!1};case 5:s.label++,t=u[1],u=[0];continue;case 7:u=s.ops.pop(),s.trys.pop();continue;default:if(!(r=s.trys,(r=r.length>0&&r[r.length-1])||6!==u[0]&&2!==u[0])){s=0;continue}if(3===u[0]&&(!r||u[1]>r[0]&&u[1]<r[3])){s.label=u[1];break}if(6===u[0]&&s.label<r[1]){s.label=r[1],r=u;break}if(r&&s.label<r[2]){s.label=r[2],s.ops.push(u);break}r[2]&&s.ops.pop(),s.trys.pop();continue}u=a.call(e,s)}catch(e){u=[6,e],t=0}finally{n=r=0}if(5&u[0])throw u[1];return{value:u[0]?u[1]:void 0,done:!0}}([u,i])}}}var wn=void 0,kn=a.env();kn.registerFlag("WASM_HAS_SIMD_SUPPORT",(function(){return _n(wn,void 0,void 0,(function(){return vn(this,(function(e){return[2,WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,10,9,1,7,0,65,0,253,15,26,11]))]}))}))})),kn.registerFlag("WASM_HAS_MULTITHREAD_SUPPORT",(function(){return _n(wn,void 0,void 0,(function(){return vn(this,(function(e){if(kn.get("IS_NODE"))return[2,!1];try{return(new MessageChannel).port1.postMessage(new SharedArrayBuffer(1)),[2,WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,5,4,1,3,1,1,10,11,1,9,0,65,0,254,16,2,0,26,11]))]}catch(e){return[2,!1]}return[2]}))}))}));var In="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function Sn(e,a){return e(a={exports:{}},a.exports),a.exports}var Mn=Sn((function(e,a){var i,o=(i="undefined"!=typeof document&&document.currentScript?document.currentScript.src:void 0,"undefined"!=typeof __filename&&(i=i||__filename),function(e){function a(){return P.buffer!=H&&te(P.buffer),B}function o(){return P.buffer!=H&&te(P.buffer),U}function d(){return P.buffer!=H&&te(P.buffer),z}function l(){return P.buffer!=H&&te(P.buffer),j}function c(){return P.buffer!=H&&te(P.buffer),q}var p,f,m,h="undefined"!=typeof(e=e||{})?e:{};h.ready=new Promise((function(e,a){p=e,f=a})),"undefined"!=typeof process&&process.listeners&&(m={uncaughtException:process.listeners("uncaughtException"),unhandledRejection:process.listeners("unhandledRejection")});var b,y={};for(b in h)h.hasOwnProperty(b)&&(y[b]=h[b]);var g=function(e,a){throw a},_=!1,v=!1,w=!1,k=!1;_="object"==typeof window,v="function"==typeof importScripts,w="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node,k=!_&&!w&&!v;var I=h.ENVIRONMENT_IS_PTHREAD||!1;I&&(H=h.buffer);var S,M,A,E,x,N="";function F(e){return h.locateFile?h.locateFile(e,N):N+e}if(w){var O;N=v?n.dirname(N)+"/":__dirname+"/",S=function(e,a){return E||(E=t),x||(x=n),e=x.normalize(e),E.readFileSync(e,a?null:"utf8")},A=function(e){var a=S(e,!0);return a.buffer||(a=new Uint8Array(a)),G(a.buffer),a},process.argv.length>1&&process.argv[1].replace(/\\/g,"/"),process.argv.slice(2),process.on("uncaughtException",(function(e){if(!(e instanceof yn))throw e})),process.on("unhandledRejection",ve),g=function(e){process.exit(e)},h.inspect=function(){return"[Emscripten Module object]"};try{O=r}catch(e){throw console.error('The "worker_threads" module is not supported in this node.js build - perhaps a newer version is needed?'),e}In.Worker=O.Worker}else k?("undefined"!=typeof read&&(S=function(e){return read(e)}),A=function(e){var a;return"function"==typeof readbuffer?new Uint8Array(readbuffer(e)):(G("object"==typeof(a=read(e,"binary"))),a)},"undefined"!=typeof scriptArgs&&scriptArgs,"function"==typeof quit&&(g=function(e){quit(e)}),"undefined"!=typeof print&&("undefined"==typeof console&&(console={}),console.log=print,console.warn=console.error="undefined"!=typeof printErr?printErr:print)):(_||v)&&(v?N=self.location.href:"undefined"!=typeof document&&document.currentScript&&(N=document.currentScript.src),"undefined"!=typeof i&&i&&(N=i),N=0!==N.indexOf("blob:")?N.substr(0,N.lastIndexOf("/")+1):"",w?(S=function(e,a){return E||(E=t),x||(x=n),e=x.normalize(e),E.readFileSync(e,a?null:"utf8")},A=function(e){var a=S(e,!0);return a.buffer||(a=new Uint8Array(a)),G(a.buffer),a}):(S=function(e){var a=new XMLHttpRequest;return a.open("GET",e,!1),a.send(null),a.responseText},v&&(A=function(e){var a=new XMLHttpRequest;return a.open("GET",e,!1),a.responseType="arraybuffer",a.send(null),new Uint8Array(a.response)}),M=function(e,a,n){var t=new XMLHttpRequest;t.open("GET",e,!0),t.responseType="arraybuffer",t.onload=function(){200==t.status||0==t.status&&t.response?a(t.response):n()},t.onerror=n,t.send(null)}));w&&"undefined"==typeof performance&&(In.performance=u.performance);var T,R=h.print||console.log.bind(console),C=h.printErr||console.warn.bind(console);for(b in y)y.hasOwnProperty(b)&&(h[b]=y[b]);function D(e){D.shown||(D.shown={}),D.shown[e]||(D.shown[e]=1,C(e))}y=null,h.arguments&&h.arguments,h.thisProgram&&h.thisProgram,h.quit&&(g=h.quit),h.wasmBinary&&(T=h.wasmBinary);var P,W,L=h.noExitRuntime||!0;"object"!=typeof WebAssembly&&ve("no native wasm support detected");var H,B,U,z,j,q,V=!1;function G(e,a){e||ve("Assertion failed: "+a)}function K(e){var a=h["_"+e];return G(a,"Cannot call unknown function "+e+", make sure it is exported"),a}function X(e,a,n,t,r){var u={string:function(e){var a=0;if(null!=e&&0!==e){var n=1+(e.length<<2);$(e,a=pn(n),n)}return a},array:function(e){var a=pn(e.length);return ae(e,a),a}},s=K(e),i=[],o=0;if(t)for(var d=0;d<t.length;d++){var l=u[n[d]];l?(0===o&&(o=ln()),i[d]=l(t[d])):i[d]=t[d]}var c=s.apply(null,i);return c=function(e){return"string"===a?Z(e):"boolean"===a?Boolean(e):e}(c),0!==o&&cn(o),c}function Q(e,a,n,t){var r=(n=n||[]).every((function(e){return"number"===e}));return"string"!==a&&r&&!t?K(e):function(){return X(e,a,n,arguments)}}function Y(e,a,n){for(var t=a+n,r="";!(a>=t);){var u=e[a++];if(!u)return r;if(128&u){var s=63&e[a++];if(192!=(224&u)){var i=63&e[a++];if((u=224==(240&u)?(15&u)<<12|s<<6|i:(7&u)<<18|s<<12|i<<6|63&e[a++])<65536)r+=String.fromCharCode(u);else{var o=u-65536;r+=String.fromCharCode(55296|o>>10,56320|1023&o)}}else r+=String.fromCharCode((31&u)<<6|s)}else r+=String.fromCharCode(u)}return r}function Z(e,a){return e?Y(o(),e,a):""}function J(e,a,n,t){if(!(t>0))return 0;for(var r=n,u=n+t-1,s=0;s<e.length;++s){var i=e.charCodeAt(s);if(i>=55296&&i<=57343&&(i=65536+((1023&i)<<10)|1023&e.charCodeAt(++s)),i<=127){if(n>=u)break;a[n++]=i}else if(i<=2047){if(n+1>=u)break;a[n++]=192|i>>6,a[n++]=128|63&i}else if(i<=65535){if(n+2>=u)break;a[n++]=224|i>>12,a[n++]=128|i>>6&63,a[n++]=128|63&i}else{if(n+3>=u)break;a[n++]=240|i>>18,a[n++]=128|i>>12&63,a[n++]=128|i>>6&63,a[n++]=128|63&i}}return a[n]=0,n-r}function $(e,a,n){return J(e,o(),a,n)}function ee(e){for(var a=0,n=0;n<e.length;++n){var t=e.charCodeAt(n);t>=55296&&t<=57343&&(t=65536+((1023&t)<<10)|1023&e.charCodeAt(++n)),t<=127?++a:a+=t<=2047?2:t<=65535?3:4}return a}function ae(e,n){a().set(e,n)}function ne(e,a){return e%a>0&&(e+=a-e%a),e}function te(e){H=e,h.HEAP8=B=new Int8Array(e),h.HEAP16=new Int16Array(e),h.HEAP32=z=new Int32Array(e),h.HEAPU8=U=new Uint8Array(e),h.HEAPU16=new Uint16Array(e),h.HEAPU32=j=new Uint32Array(e),h.HEAPF32=new Float32Array(e),h.HEAPF64=q=new Float64Array(e)}var re,ue=h.INITIAL_MEMORY||16777216;if(I)P=h.wasmMemory,H=h.buffer;else if(h.wasmMemory)P=h.wasmMemory;else if(!((P=new WebAssembly.Memory({initial:ue/65536,maximum:32768,shared:!0})).buffer instanceof SharedArrayBuffer))throw C("requested a shared WebAssembly.Memory but the returned buffer is not a SharedArrayBuffer, indicating that while the browser has SharedArrayBuffer it does not have WebAssembly threads support - you may need to set a flag"),w&&console.log("(on node you may need: --experimental-wasm-threads --experimental-wasm-bulk-memory and also use a recent version)"),Error("bad memory");P&&(H=P.buffer),ue=H.byteLength,te(H);var se=[],ie=[],oe=[],de=[];function le(){if(!I){if(h.preRun)for("function"==typeof h.preRun&&(h.preRun=[h.preRun]);h.preRun.length;)me(h.preRun.shift());Te(se)}}function ce(){I||Te(ie)}function pe(){I||Te(oe)}function fe(){if(!I){if(h.postRun)for("function"==typeof h.postRun&&(h.postRun=[h.postRun]);h.postRun.length;)he(h.postRun.shift());Te(de)}}function me(e){se.unshift(e)}function he(e){de.unshift(e)}I||ie.push({func:function(){Xa()}});var be=0,ye=null;function ge(e){G(!I,"addRunDependency cannot be used in a pthread worker"),be++,h.monitorRunDependencies&&h.monitorRunDependencies(be)}function _e(e){if(be--,h.monitorRunDependencies&&h.monitorRunDependencies(be),0==be&&ye){var a=ye;ye=null,a()}}function ve(e){h.onAbort&&h.onAbort(e),I&&console.error("Pthread aborting at "+(new Error).stack),C(e+=""),V=!0,e="abort("+e+"). Build with -s ASSERTIONS=1 for more info.";var a=new WebAssembly.RuntimeError(e);throw f(a),a}function we(e,a){return String.prototype.startsWith?e.startsWith(a):0===e.indexOf(a)}h.preloadedImages={},h.preloadedAudios={};var ke="data:application/octet-stream;base64,";function Ie(e){return we(e,ke)}var Se="file://";function Me(e){return we(e,Se)}var Ae="tfjs-backend-wasm-threaded-simd.wasm";function Ee(e){try{if(e==Ae&&T)return new Uint8Array(T);if(A)return A(e);throw"both async and sync fetching of the wasm failed"}catch(e){ve(e)}}function xe(){if(!T&&(_||v)){if("function"==typeof fetch&&!Me(Ae))return fetch(Ae,{credentials:"same-origin"}).then((function(e){if(!e.ok)throw"failed to load wasm binary file at '"+Ae+"'";return e.arrayBuffer()})).catch((function(){return Ee(Ae)}));if(M)return new Promise((function(e,a){M(Ae,(function(a){e(new Uint8Array(a))}),a)}))}return Promise.resolve().then((function(){return Ee(Ae)}))}function Ne(){var e={a:Ka};function a(e,a){var n=e.exports;if(h.asm=n,re=h.asm.I,W=a,!I){var t=He.unusedWorkers.length;He.unusedWorkers.forEach((function(e){He.loadWasmModuleToWorker(e,(function(){--t||_e()}))}))}}function n(e){a(e.instance,e.module)}function t(a){return xe().then((function(a){return WebAssembly.instantiate(a,e)})).then(a,(function(e){C("failed to asynchronously prepare wasm: "+e),ve(e)}))}if(I||ge(),h.instantiateWasm)try{return h.instantiateWasm(e,a)}catch(e){return C("Module.instantiateWasm callback failed with error: "+e),!1}return(T||"function"!=typeof WebAssembly.instantiateStreaming||Ie(Ae)||Me(Ae)||"function"!=typeof fetch?t(n):fetch(Ae,{credentials:"same-origin"}).then((function(a){return WebAssembly.instantiateStreaming(a,e).then(n,(function(e){return C("wasm streaming compile failed: "+e),C("falling back to ArrayBuffer instantiation"),t(n)}))}))).catch(f),{}}Ie(Ae)||(Ae=F(Ae));var Fe={10664:function(){throw"Canceled!"},10682:function(e,a){setTimeout((function(){rn(e,a)}),0)}};function Oe(){He.initRuntime()}function Te(e){for(;e.length>0;){var a=e.shift();if("function"!=typeof a){var n=a.func;"number"==typeof n?void 0===a.arg?re.get(n)():re.get(n)(a.arg):n(void 0===a.arg?null:a.arg)}else a(h)}}var Re={EPERM:63,ENOENT:44,ESRCH:71,EINTR:27,EIO:29,ENXIO:60,E2BIG:1,ENOEXEC:45,EBADF:8,ECHILD:12,EAGAIN:6,EWOULDBLOCK:6,ENOMEM:48,EACCES:2,EFAULT:21,ENOTBLK:105,EBUSY:10,EEXIST:20,EXDEV:75,ENODEV:43,ENOTDIR:54,EISDIR:31,EINVAL:28,ENFILE:41,EMFILE:33,ENOTTY:59,ETXTBSY:74,EFBIG:22,ENOSPC:51,ESPIPE:70,EROFS:69,EMLINK:34,EPIPE:64,EDOM:18,ERANGE:68,ENOMSG:49,EIDRM:24,ECHRNG:106,EL2NSYNC:156,EL3HLT:107,EL3RST:108,ELNRNG:109,EUNATCH:110,ENOCSI:111,EL2HLT:112,EDEADLK:16,ENOLCK:46,EBADE:113,EBADR:114,EXFULL:115,ENOANO:104,EBADRQC:103,EBADSLT:102,EDEADLOCK:16,EBFONT:101,ENOSTR:100,ENODATA:116,ETIME:117,ENOSR:118,ENONET:119,ENOPKG:120,EREMOTE:121,ENOLINK:47,EADV:122,ESRMNT:123,ECOMM:124,EPROTO:65,EMULTIHOP:36,EDOTDOT:125,EBADMSG:9,ENOTUNIQ:126,EBADFD:127,EREMCHG:128,ELIBACC:129,ELIBBAD:130,ELIBSCN:131,ELIBMAX:132,ELIBEXEC:133,ENOSYS:52,ENOTEMPTY:55,ENAMETOOLONG:37,ELOOP:32,EOPNOTSUPP:138,EPFNOSUPPORT:139,ECONNRESET:15,ENOBUFS:42,EAFNOSUPPORT:5,EPROTOTYPE:67,ENOTSOCK:57,ENOPROTOOPT:50,ESHUTDOWN:140,ECONNREFUSED:14,EADDRINUSE:3,ECONNABORTED:13,ENETUNREACH:40,ENETDOWN:38,ETIMEDOUT:73,EHOSTDOWN:142,EHOSTUNREACH:23,EINPROGRESS:26,EALREADY:7,EDESTADDRREQ:17,EMSGSIZE:35,EPROTONOSUPPORT:66,ESOCKTNOSUPPORT:137,EADDRNOTAVAIL:4,ENETRESET:39,EISCONN:30,ENOTCONN:53,ETOOMANYREFS:141,EUSERS:136,EDQUOT:19,ESTALE:72,ENOTSUP:138,ENOMEDIUM:148,EILSEQ:25,EOVERFLOW:61,ECANCELED:11,ENOTRECOVERABLE:56,EOWNERDEAD:62,ESTRPIPE:135};function Ce(e,n){if(e<=0||e>a().length||!0&e||n<0)return-28;if(0==n)return 0;n>=2147483647&&(n=1/0);var t=Atomics.load(d(),bn>>2),r=0;if(t==e&&Atomics.compareExchange(d(),bn>>2,t,0)==t&&(r=1,--n<=0))return 1;var u=Atomics.notify(d(),e>>2,n);if(u>=0)return u+r;throw"Atomics.notify returned an unexpected value "+u}function De(e){if(I)throw"Internal Error! killThread() can only ever be called from main application thread!";if(!e)throw"Internal Error! Null pthread_ptr in killThread!";d()[e+12>>2]=0;var a=He.pthreads[e];a.worker.terminate(),He.freeThreadData(a),He.runningWorkers.splice(He.runningWorkers.indexOf(a.worker),1),a.worker.pthread=void 0}function Pe(e){if(I)throw"Internal Error! cancelThread() can only ever be called from main application thread!";if(!e)throw"Internal Error! Null pthread_ptr in cancelThread!";He.pthreads[e].worker.postMessage({cmd:"cancel"})}function We(e){if(I)throw"Internal Error! cleanupThread() can only ever be called from main application thread!";if(!e)throw"Internal Error! Null pthread_ptr in cleanupThread!";var a=He.pthreads[e];if(a){d()[e+12>>2]=0;var n=a.worker;He.returnWorkerToPool(n)}}h._emscripten_futex_wake=Ce;var Le,He={unusedWorkers:[],runningWorkers:[],initMainThreadBlock:function(){for(var e=0;e<8;++e)He.allocateUnusedWorker()},initRuntime:function(){for(var e=Qa(228),a=0;a<57;++a)l()[e/4+a]=0;d()[e+12>>2]=e;var n=e+152;d()[n>>2]=n;var t=Qa(512);for(a=0;a<128;++a)l()[t/4+a]=0;Atomics.store(l(),e+100>>2,t),Atomics.store(l(),e+40>>2,e),dn(e,!v,1),nn(e)},initWorker:function(){},pthreads:{},threadExitHandlers:[],setThreadStatus:function(){},runExitHandlers:function(){for(;He.threadExitHandlers.length>0;)He.threadExitHandlers.pop()();I&&$a()&&en()},runExitHandlersAndDeinitThread:function(e,a){Atomics.store(l(),e+56>>2,1),Atomics.store(l(),e+60>>2,0),He.runExitHandlers(),Atomics.store(l(),e+4>>2,a),Atomics.store(l(),e+0>>2,1),Ce(e+0,2147483647),dn(0,0,0)},threadExit:function(e){var a=$a();a&&(He.runExitHandlersAndDeinitThread(a,e),I&&postMessage({cmd:"exit"}))},threadCancel:function(){He.runExitHandlersAndDeinitThread($a(),-1),postMessage({cmd:"cancelDone"})},terminateAllThreads:function(){for(var e in He.pthreads)(t=He.pthreads[e])&&t.worker&&He.returnWorkerToPool(t.worker);He.pthreads={};for(var a=0;a<He.unusedWorkers.length;++a)(n=He.unusedWorkers[a]).terminate();for(He.unusedWorkers=[],a=0;a<He.runningWorkers.length;++a){var n,t=(n=He.runningWorkers[a]).pthread;He.freeThreadData(t),n.terminate()}He.runningWorkers=[]},freeThreadData:function(e){if(e){if(e.threadInfoStruct){var a=d()[e.threadInfoStruct+100>>2];d()[e.threadInfoStruct+100>>2]=0,Ya(a),Ya(e.threadInfoStruct)}e.threadInfoStruct=0,e.allocatedOwnStack&&e.stackBase&&Ya(e.stackBase),e.stackBase=0,e.worker&&(e.worker.pthread=null)}},returnWorkerToPool:function(e){He.runWithoutMainThreadQueuedCalls((function(){delete He.pthreads[e.pthread.threadInfoStruct],He.unusedWorkers.push(e),He.runningWorkers.splice(He.runningWorkers.indexOf(e),1),He.freeThreadData(e.pthread),e.pthread=void 0}))},runWithoutMainThreadQueuedCalls:function(e){d()[hn>>2]=0;try{e()}finally{d()[hn>>2]=1}},receiveObjectTransfer:function(e){},loadWasmModuleToWorker:function(e,a){e.onmessage=function(n){var t=n.data,r=t.cmd;if(e.pthread&&(He.currentProxiedOperationCallerThread=e.pthread.threadInfoStruct),t.targetThread&&t.targetThread!=$a()){var u=He.pthreads[t.targetThread];return u?u.worker.postMessage(n.data,t.transferList):console.error('Internal error! Worker sent a message "'+r+'" to target pthread '+t.targetThread+", but that thread no longer exists!"),void(He.currentProxiedOperationCallerThread=void 0)}if("processQueuedMainThreadWork"===r)an();else if("spawnThread"===r)Pa(n.data);else if("cleanupThread"===r)We(t.thread);else if("killThread"===r)De(t.thread);else if("cancelThread"===r)Pe(t.thread);else if("loaded"===r)e.loaded=!0,a&&a(e),e.runPthread&&(e.runPthread(),delete e.runPthread);else if("print"===r)R("Thread "+t.threadId+": "+t.text);else if("printErr"===r)C("Thread "+t.threadId+": "+t.text);else if("alert"===r)alert("Thread "+t.threadId+": "+t.text);else if("exit"===r)e.pthread&&Atomics.load(l(),e.pthread.threadInfoStruct+64>>2)&&He.returnWorkerToPool(e);else if("exitProcess"===r)try{_n(t.returnCode)}catch(n){if(n instanceof yn)return;throw n}else"cancelDone"===r?He.returnWorkerToPool(e):"objectTransfer"===r?He.receiveObjectTransfer(n.data):"setimmediate"===n.data.target?e.postMessage(n.data):C("worker sent an unknown command "+r);He.currentProxiedOperationCallerThread=void 0},e.onerror=function(e){C("pthread sent an error! "+e.filename+":"+e.lineno+": "+e.message)},w&&(e.on("message",(function(a){e.onmessage({data:a})})),e.on("error",(function(a){e.onerror(a)})),e.on("exit",(function(e){}))),e.postMessage({cmd:"load",urlOrBlob:h.mainScriptUrlOrBlob||i,wasmMemory:P,wasmModule:W})},allocateUnusedWorker:function(){var e=F("tfjs-backend-wasm-threaded-simd.worker.js");He.unusedWorkers.push(new Worker(e))},getNewWorker:function(){return 0==He.unusedWorkers.length&&(He.allocateUnusedWorker(),He.loadWasmModuleToWorker(He.unusedWorkers[0])),He.unusedWorkers.length>0?He.unusedWorkers.pop():null},busySpinWait:function(e){for(var a=performance.now()+e;performance.now()<a;);}};function Be(e,a){fn(e,a),cn(e)}function Ue(){return L}function ze(e,a){return re.get(e)(a)}function je(e,a,n,t){ve("Assertion failed: "+Z(e)+", at: "+[a?Z(a):"unknown filename",n,t?Z(t):"unknown function"])}function qe(e,a){_main(e,a)}function Ve(e){return d()[Za()>>2]=e,e}function Ge(e,a){if(I)return ea(1,1,e,a)}function Ke(e,a){if(e==a)postMessage({cmd:"processQueuedMainThreadWork"});else if(I)postMessage({targetThread:e,cmd:"processThreadQueue"});else{var n=He.pthreads[e],t=n&&n.worker;if(!t)return;t.postMessage({cmd:"processThreadQueue"})}return 1}function Xe(){ve()}function Qe(e,a,n){var t=ta(a,n);return Fe[e].apply(null,t)}function Ye(e,a){}function Ze(e,n,t){if(e<=0||e>a().length||!0&e)return-28;if(_){if(Atomics.load(d(),e>>2)!=n)return-6;var r=performance.now(),u=r+t;for(Atomics.exchange(d(),bn>>2,e);;){if((r=performance.now())>u)return Atomics.exchange(d(),bn>>2,0),-73;if(0==Atomics.exchange(d(),bn>>2,0))break;if(an(),Atomics.load(d(),e>>2)!=n)return-6;Atomics.exchange(d(),bn>>2,e)}return 0}var s=Atomics.wait(d(),e>>2,n,t);if("timed-out"===s)return-73;if("not-equal"===s)return-6;if("ok"===s)return 0;throw"Atomics.wait returned an unexpected value "+s}function Je(e,a,n){o().copyWithin(e,a,a+n)}function $e(){return w?s.cpus().length:navigator.hardwareConcurrency}function ea(e,a){for(var n=arguments.length-2,t=ln(),r=n,u=pn(8*r),s=u>>3,i=0;i<n;i++){var o=arguments[2+i];c()[s+i]=o}var d=sn(e,r,u,a);return cn(t),d}h.establishStackSpace=Be,h.getNoExitRuntime=Ue,h.invokeEntryPoint=ze,Le=w?function(){var e=process.hrtime();return 1e3*e[0]+e[1]/1e6}:I?function(){return performance.now()-h.__performance_now_clock_drift}:"undefined"!=typeof dateNow?dateNow:function(){return performance.now()};var aa=[],na=[];function ta(e,a){var n;for(na.length=0,a>>=2;n=o()[e++];){var t=n<105;t&&1&a&&a++,na.push(t?c()[a++>>1]:d()[a]),++a}return na}function ra(e,a,n){aa.length=a;for(var t=n>>3,r=0;r<a;r++)aa[r]=c()[t+r];return(e<0?Fe[-e-1]:Ga[e]).apply(null,aa)}function ua(){return o().length}function sa(e){try{return P.grow(e-H.byteLength+65535>>>16),te(P.buffer),1}catch(e){}}function ia(e){var a=ua();if(e<=a)return!1;var n=2147483648;if(e>n)return!1;for(var t=1;t<=4;t*=2){var r=a*(1+.2/t);if(r=Math.min(r,e+100663296),sa(Math.min(n,ne(Math.max(e,r),65536))))return!0}return!1}var oa={inEventHandler:0,removeAllEventListeners:function(){for(var e=oa.eventHandlers.length-1;e>=0;--e)oa._removeHandler(e);oa.eventHandlers=[],oa.deferredCalls=[]},registerRemoveEventListeners:function(){oa.removeEventListenersRegistered||(oa.removeEventListenersRegistered=!0)},deferredCalls:[],deferCall:function(e,a,n){function t(e,a){if(e.length!=a.length)return!1;for(var n in e)if(e[n]!=a[n])return!1;return!0}for(var r in oa.deferredCalls){var u=oa.deferredCalls[r];if(u.targetFunction==e&&t(u.argsList,n))return}oa.deferredCalls.push({targetFunction:e,precedence:a,argsList:n}),oa.deferredCalls.sort((function(e,a){return e.precedence<a.precedence}))},removeDeferredCalls:function(e){for(var a=0;a<oa.deferredCalls.length;++a)oa.deferredCalls[a].targetFunction==e&&(oa.deferredCalls.splice(a,1),--a)},canPerformEventHandlerRequests:function(){return oa.inEventHandler&&oa.currentEventHandler.allowsDeferredCalls},runDeferredCalls:function(){if(oa.canPerformEventHandlerRequests())for(var e=0;e<oa.deferredCalls.length;++e){var a=oa.deferredCalls[e];oa.deferredCalls.splice(e,1),--e,a.targetFunction.apply(null,a.argsList)}},eventHandlers:[],removeAllHandlersOnTarget:function(e,a){for(var n=0;n<oa.eventHandlers.length;++n)oa.eventHandlers[n].target!=e||a&&a!=oa.eventHandlers[n].eventTypeString||oa._removeHandler(n--)},_removeHandler:function(e){var a=oa.eventHandlers[e];a.target.removeEventListener(a.eventTypeString,a.eventListenerFunc,a.useCapture),oa.eventHandlers.splice(e,1)},registerOrRemoveHandler:function(e){var a=function(a){++oa.inEventHandler,oa.currentEventHandler=e,oa.runDeferredCalls(),e.handlerFunc(a),oa.runDeferredCalls(),--oa.inEventHandler};if(e.callbackfunc)e.eventListenerFunc=a,e.target.addEventListener(e.eventTypeString,a,e.useCapture),oa.eventHandlers.push(e),oa.registerRemoveEventListeners();else for(var n=0;n<oa.eventHandlers.length;++n)oa.eventHandlers[n].target==e.target&&oa.eventHandlers[n].eventTypeString==e.eventTypeString&&oa._removeHandler(n--)},queueEventHandlerOnThread_iiii:function(e,a,n,t,r){var u=ln(),s=pn(12);d()[s>>2]=n,d()[s+4>>2]=t,d()[s+8>>2]=r,on(0,e,637534208,a,t,s),cn(u)},getTargetThreadForEventCallback:function(e){switch(e){case 1:return 0;case 2:return He.currentProxiedOperationCallerThread;default:return e}},getNodeNameForTarget:function(e){return e?e==window?"#window":e==screen?"#screen":e&&e.nodeName?e.nodeName:"":""},fullscreenEnabled:function(){return document.fullscreenEnabled||document.webkitFullscreenEnabled}};function da(e){var a=ee(e)+1,n=Qa(a);return $(e,n,a),n}function la(e,a,n,t){var r=ln(),u=pn(12),s=0;a&&(s=da(a)),d()[u>>2]=s,d()[u+4>>2]=n,d()[u+8>>2]=t,on(0,e,657457152,0,s,u),cn(r)}function ca(e,a,n,t){la(e,a=a?Z(a):"",n,t)}function pa(e){return e>2?Z(e):e}var fa=[0,"undefined"!=typeof document?document:0,"undefined"!=typeof window?window:0];function ma(e){return e=pa(e),fa[e]||("undefined"!=typeof document?document.querySelector(e):void 0)}function ha(e){return ma(e)}function ba(e,a,n){var t=ha(e);if(!t)return-4;if(t.canvasSharedPtr&&(d()[t.canvasSharedPtr>>2]=a,d()[t.canvasSharedPtr+4>>2]=n),!t.offscreenCanvas&&t.controlTransferredOffscreen)return t.canvasSharedPtr?(ca(d()[t.canvasSharedPtr+8>>2],e,a,n),1):-4;t.offscreenCanvas&&(t=t.offscreenCanvas);var r=!1;if(t.GLctxObject&&t.GLctxObject.GLctx){var u=t.GLctxObject.GLctx.getParameter(2978);r=0===u[0]&&0===u[1]&&u[2]===t.width&&u[3]===t.height}return t.width=a,t.height=n,r&&t.GLctxObject.GLctx.viewport(0,0,a,n),0}function ya(e,a,n){return I?ea(2,1,e,a,n):ba(e,a,n)}function ga(e,a,n){return ha(e)?ba(e,a,n):ya(e,a,n)}function _a(e){}function va(e,a){}function wa(e){var a=e.getExtension("ANGLE_instanced_arrays");if(a)return e.vertexAttribDivisor=function(e,n){a.vertexAttribDivisorANGLE(e,n)},e.drawArraysInstanced=function(e,n,t,r){a.drawArraysInstancedANGLE(e,n,t,r)},e.drawElementsInstanced=function(e,n,t,r,u){a.drawElementsInstancedANGLE(e,n,t,r,u)},1}function ka(e){var a=e.getExtension("OES_vertex_array_object");if(a)return e.createVertexArray=function(){return a.createVertexArrayOES()},e.deleteVertexArray=function(e){a.deleteVertexArrayOES(e)},e.bindVertexArray=function(e){a.bindVertexArrayOES(e)},e.isVertexArray=function(e){return a.isVertexArrayOES(e)},1}function Ia(e){var a=e.getExtension("WEBGL_draw_buffers");if(a)return e.drawBuffers=function(e,n){a.drawBuffersWEBGL(e,n)},1}function Sa(e){return!!(e.multiDrawWebgl=e.getExtension("WEBGL_multi_draw"))}var Ma={counter:1,buffers:[],programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],vaos:[],contexts:{},offscreenCanvases:{},timerQueriesEXT:[],programInfos:{},stringCache:{},unpackAlignment:4,recordError:function(e){Ma.lastError||(Ma.lastError=e)},getNewId:function(e){for(var a=Ma.counter++,n=e.length;n<a;n++)e[n]=null;return a},getSource:function(e,a,n,t){for(var r="",u=0;u<a;++u){var s=t?d()[t+4*u>>2]:-1;r+=Z(d()[n+4*u>>2],s<0?void 0:s)}return r},createContext:function(e,a){var n=e.getContext("webgl",a);return n?Ma.registerContext(n,a):0},registerContext:function(e,a){var n=Qa(8);d()[n+4>>2]=$a();var t={handle:n,attributes:a,version:a.majorVersion,GLctx:e};return e.canvas&&(e.canvas.GLctxObject=t),Ma.contexts[n]=t,("undefined"==typeof a.enableExtensionsByDefault||a.enableExtensionsByDefault)&&Ma.initExtensions(t),n},makeContextCurrent:function(e){return Ma.currentContext=Ma.contexts[e],h.ctx=Na=Ma.currentContext&&Ma.currentContext.GLctx,!(e&&!Na)},getContext:function(e){return Ma.contexts[e]},deleteContext:function(e){Ma.currentContext===Ma.contexts[e]&&(Ma.currentContext=null),"object"==typeof oa&&oa.removeAllHandlersOnTarget(Ma.contexts[e].GLctx.canvas),Ma.contexts[e]&&Ma.contexts[e].GLctx.canvas&&(Ma.contexts[e].GLctx.canvas.GLctxObject=void 0),Ya(Ma.contexts[e].handle),Ma.contexts[e]=null},initExtensions:function(e){if(e||(e=Ma.currentContext),!e.initExtensionsDone){e.initExtensionsDone=!0;var a=e.GLctx;wa(a),ka(a),Ia(a),a.disjointTimerQueryExt=a.getExtension("EXT_disjoint_timer_query"),Sa(a),(a.getSupportedExtensions()||[]).forEach((function(e){e.indexOf("lose_context")<0&&e.indexOf("debug")<0&&a.getExtension(e)}))}},populateUniformTable:function(e){for(var a=Ma.programs[e],n=Ma.programInfos[e]={uniforms:{},maxUniformLength:0,maxAttributeLength:-1,maxUniformBlockNameLength:-1},t=n.uniforms,r=Na.getProgramParameter(a,35718),u=0;u<r;++u){var s=Na.getActiveUniform(a,u),i=s.name;n.maxUniformLength=Math.max(n.maxUniformLength,i.length+1),"]"==i.slice(-1)&&(i=i.slice(0,i.lastIndexOf("[")));var o=Na.getUniformLocation(a,i);if(o){var d=Ma.getNewId(Ma.uniforms);t[i]=[s.size,d],Ma.uniforms[d]=o;for(var l=1;l<s.size;++l){var c=i+"["+l+"]";o=Na.getUniformLocation(a,c),d=Ma.getNewId(Ma.uniforms),Ma.uniforms[d]=o}}}}},Aa=["default","low-power","high-performance"];function Ea(e,a){var n=a>>2,t=d()[n+6],r={alpha:!!d()[n+0],depth:!!d()[n+1],stencil:!!d()[n+2],antialias:!!d()[n+3],premultipliedAlpha:!!d()[n+4],preserveDrawingBuffer:!!d()[n+5],powerPreference:Aa[t],failIfMajorPerformanceCaveat:!!d()[n+7],majorVersion:d()[n+8],minorVersion:d()[n+9],enableExtensionsByDefault:d()[n+10],explicitSwapControl:d()[n+11],proxyContextToMainThread:d()[n+12],renderViaOffscreenBackBuffer:d()[n+13]},u=ha(e);return u?r.explicitSwapControl?0:Ma.createContext(u,r):0}function xa(e,a){return Ea(e,a)}var Na,Fa={mappings:{},buffers:[null,[],[]],printChar:function(e,a){var n=Fa.buffers[e];0===a||10===a?((1===e?R:C)(Y(n,0)),n.length=0):n.push(a)},varargs:void 0,get:function(){return Fa.varargs+=4,d()[Fa.varargs-4>>2]},getStr:function(e){return Z(e)},get64:function(e,a){return e}};function Oa(e){return I?ea(3,1,e):0}function Ta(e,a,n,t,r){if(I)return ea(4,1,e,a,n,t,r)}function Ra(e,a,n,t){if(I)return ea(5,1,e,a,n,t);for(var r=0,u=0;u<n;u++){for(var s=d()[a+8*u>>2],i=d()[a+(8*u+4)>>2],l=0;l<i;l++)Fa.printChar(e,o()[s+l]);r+=i}return d()[t>>2]=r,0}function Ca(e){var a=He.threadExitHandlers.pop();e&&a()}function Da(e,a){He.threadExitHandlers.push((function(){re.get(e)(a)}))}function Pa(e){if(I)throw"Internal Error! spawnThread() can only ever be called from main application thread!";var a=He.getNewWorker();if(void 0!==a.pthread)throw"Internal error!";if(!e.pthread_ptr)throw"Internal error, no pthread ptr!";He.runningWorkers.push(a);for(var n=Qa(512),t=0;t<128;++t)d()[n+4*t>>2]=0;var r=e.stackBase+e.stackSize,u=He.pthreads[e.pthread_ptr]={worker:a,stackBase:e.stackBase,stackSize:e.stackSize,allocatedOwnStack:e.allocatedOwnStack,threadInfoStruct:e.pthread_ptr},s=u.threadInfoStruct>>2;Atomics.store(l(),s+16,e.detached),Atomics.store(l(),s+25,n),Atomics.store(l(),s+10,u.threadInfoStruct),Atomics.store(l(),s+20,e.stackSize),Atomics.store(l(),s+19,r),Atomics.store(l(),s+26,e.stackSize),Atomics.store(l(),s+28,r),Atomics.store(l(),s+29,e.detached);var i=Ja()+40;Atomics.store(l(),s+43,i),a.pthread=u;var o={cmd:"run",start_routine:e.startRoutine,arg:e.arg,threadInfoStruct:e.pthread_ptr,stackBase:e.stackBase,stackSize:e.stackSize};a.runPthread=function(){o.time=performance.now(),a.postMessage(o,e.transferList)},a.loaded&&(a.runPthread(),delete a.runPthread)}function Wa(e,a,n,t){if("undefined"==typeof SharedArrayBuffer)return C("Current environment does not support SharedArrayBuffer, pthreads are not available!"),6;if(!e)return C("pthread_create called with a null thread pointer!"),28;var r=[];if(I&&0===r.length)return un(687865856,e,a,n,t);var u=0,s=0,i=0;a&&-1!=a?(u=d()[a>>2],u+=81920,s=d()[a+8>>2],i=0!==d()[a+12>>2]):u=2097152;var o=0==s;o?s=mn(16,u):G((s-=u)>0);for(var c=Qa(228),p=0;p<57;++p)l()[(c>>2)+p]=0;d()[e>>2]=c,d()[c+12>>2]=c;var f=c+152;d()[f>>2]=f;var m={stackBase:s,stackSize:u,allocatedOwnStack:o,detached:i,startRoutine:n,pthread_ptr:c,arg:t,transferList:r};return I?(m.cmd="spawnThread",postMessage(m,r)):Pa(m),0}function La(){if(I){var e=$a();if(e&&!Atomics.load(l(),e+56>>2)&&2==Atomics.load(l(),e+0>>2))throw"Canceled!"}}function Ha(){w||v||D("Blocking on the main thread is very dangerous, see https://emscripten.org/docs/porting/pthreads.html#blocking-on-the-main-browser-thread")}function Ba(e,a,n){if(!e)return C("pthread_join attempted on a null thread pointer!"),Re.ESRCH;if(I&&$a()==e)return C("PThread "+e+" is attempting to join to itself!"),Re.EDEADLK;if(!I&&tn()==e)return C("Main thread "+e+" is attempting to join to itself!"),Re.EDEADLK;if(d()[e+12>>2]!==e)return C("pthread_join attempted on thread "+e+", which does not point to a valid thread, or does not exist anymore!"),Re.ESRCH;if(Atomics.load(l(),e+64>>2))return C("Attempted to join thread "+e+", which was already detached!"),Re.EINVAL;for(n&&Ha();;){var t=Atomics.load(l(),e+0>>2);if(1==t){var r=Atomics.load(l(),e+4>>2);return a&&(d()[a>>2]=r),Atomics.store(l(),e+64>>2,1),I?postMessage({cmd:"cleanupThread",thread:e}):We(e),0}if(!n)return Re.EBUSY;La(),I||an(),Ze(e+0,t,I?100:1)}}function Ua(e,a){return Ba(e,a,!0)}function za(e){if(I)return ea(6,1,e);switch(e){case 30:return 16384;case 85:return 131072;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:case 80:case 81:case 79:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:return"object"==typeof navigator&&navigator.hardwareConcurrency||1}return Ve(28),-1}I||He.initMainThreadBlock();var ja,qa,Va,Ga=[null,Ge,ya,Oa,Ta,Ra,za],Ka={e:je,r:qe,x:Ke,b:Xe,y:Qe,j:Ye,d:Ze,c:Ce,f:Le,p:Je,A:$e,u:ra,q:ia,v:ga,i:_a,s:va,w:xa,l:Oa,n:Ta,g:Ra,o:Oe,a:P||h.wasmMemory,z:Ca,k:Da,h:Wa,m:Ua,t:za},Xa=(Ne(),h.___wasm_call_ctors=function(){return(Xa=h.___wasm_call_ctors=h.asm.B).apply(null,arguments)}),Qa=(h._init=function(){return(h._init=h.asm.C).apply(null,arguments)},h._init_with_threads_count=function(){return(h._init_with_threads_count=h.asm.D).apply(null,arguments)},h._get_threads_count=function(){return(h._get_threads_count=h.asm.E).apply(null,arguments)},h._register_tensor=function(){return(h._register_tensor=h.asm.F).apply(null,arguments)},h._dispose_data=function(){return(h._dispose_data=h.asm.G).apply(null,arguments)},h._dispose=function(){return(h._dispose=h.asm.H).apply(null,arguments)},h._Abs=function(){return(h._Abs=h.asm.J).apply(null,arguments)},h._Add=function(){return(h._Add=h.asm.K).apply(null,arguments)},h._AddN=function(){return(h._AddN=h.asm.L).apply(null,arguments)},h._All=function(){return(h._All=h.asm.M).apply(null,arguments)},h._Any=function(){return(h._Any=h.asm.N).apply(null,arguments)},h._ArgMax=function(){return(h._ArgMax=h.asm.O).apply(null,arguments)},h._AvgPool=function(){return(h._AvgPool=h.asm.P).apply(null,arguments)},h._BatchMatMul=function(){return(h._BatchMatMul=h.asm.Q).apply(null,arguments)},h._Ceil=function(){return(h._Ceil=h.asm.R).apply(null,arguments)},h._ClipByValue=function(){return(h._ClipByValue=h.asm.S).apply(null,arguments)},h._Conv2D=function(){return(h._Conv2D=h.asm.T).apply(null,arguments)},h._Conv2DBackpropInput=function(){return(h._Conv2DBackpropInput=h.asm.U).apply(null,arguments)},h._Cos=function(){return(h._Cos=h.asm.V).apply(null,arguments)},h._Cosh=function(){return(h._Cosh=h.asm.W).apply(null,arguments)},h._CropAndResize=function(){return(h._CropAndResize=h.asm.X).apply(null,arguments)},h._Cumsum=function(){return(h._Cumsum=h.asm.Y).apply(null,arguments)},h._DepthToSpace=function(){return(h._DepthToSpace=h.asm.Z).apply(null,arguments)},h._DepthwiseConv2dNative=function(){return(h._DepthwiseConv2dNative=h.asm._).apply(null,arguments)},h._Elu=function(){return(h._Elu=h.asm.$).apply(null,arguments)},h._Equal=function(){return(h._Equal=h.asm.aa).apply(null,arguments)},h._Exp=function(){return(h._Exp=h.asm.ba).apply(null,arguments)},h._FlipLeftRight=function(){return(h._FlipLeftRight=h.asm.ca).apply(null,arguments)},h._Floor=function(){return(h._Floor=h.asm.da).apply(null,arguments)},h._FloorDiv=function(){return(h._FloorDiv=h.asm.ea).apply(null,arguments)},h._FusedBatchNorm=function(){return(h._FusedBatchNorm=h.asm.fa).apply(null,arguments)},h._FusedConv2D=function(){return(h._FusedConv2D=h.asm.ga).apply(null,arguments)},h._FusedDepthwiseConv2D=function(){return(h._FusedDepthwiseConv2D=h.asm.ha).apply(null,arguments)},h._Gather=function(){return(h._Gather=h.asm.ia).apply(null,arguments)},h._GatherNd=function(){return(h._GatherNd=h.asm.ja).apply(null,arguments)},h._Greater=function(){return(h._Greater=h.asm.ka).apply(null,arguments)},h._GreaterEqual=function(){return(h._GreaterEqual=h.asm.la).apply(null,arguments)},h._LeakyRelu=function(){return(h._LeakyRelu=h.asm.ma).apply(null,arguments)},h._Less=function(){return(h._Less=h.asm.na).apply(null,arguments)},h._LessEqual=function(){return(h._LessEqual=h.asm.oa).apply(null,arguments)},h._Log=function(){return(h._Log=h.asm.pa).apply(null,arguments)},h._LogicalAnd=function(){return(h._LogicalAnd=h.asm.qa).apply(null,arguments)},h._Max=function(){return(h._Max=h.asm.ra).apply(null,arguments)},h._MaxPool=function(){return(h._MaxPool=h.asm.sa).apply(null,arguments)},h._Maximum=function(){return(h._Maximum=h.asm.ta).apply(null,arguments)},h._Mean=function(){return(h._Mean=h.asm.ua).apply(null,arguments)},h._Min=function(){return(h._Min=h.asm.va).apply(null,arguments)},h._Minimum=function(){return(h._Minimum=h.asm.wa).apply(null,arguments)},h._MirrorPad=function(){return(h._MirrorPad=h.asm.xa).apply(null,arguments)},h._Multiply=function(){return(h._Multiply=h.asm.ya).apply(null,arguments)},h._Neg=function(){return(h._Neg=h.asm.za).apply(null,arguments)},h._NonMaxSuppressionV3=function(){return(h._NonMaxSuppressionV3=h.asm.Aa).apply(null,arguments)},h._NonMaxSuppressionV4=function(){return(h._NonMaxSuppressionV4=h.asm.Ba).apply(null,arguments)},h._NonMaxSuppressionV5=function(){return(h._NonMaxSuppressionV5=h.asm.Ca).apply(null,arguments)},h._NotEqual=function(){return(h._NotEqual=h.asm.Da).apply(null,arguments)},h._OneHot=function(){return(h._OneHot=h.asm.Ea).apply(null,arguments)},h._PadV2=function(){return(h._PadV2=h.asm.Fa).apply(null,arguments)},h._Pow=function(){return(h._Pow=h.asm.Ga).apply(null,arguments)},h._Prelu=function(){return(h._Prelu=h.asm.Ha).apply(null,arguments)},h._Prod=function(){return(h._Prod=h.asm.Ia).apply(null,arguments)},h._RealDiv=function(){return(h._RealDiv=h.asm.Ja).apply(null,arguments)},h._Relu=function(){return(h._Relu=h.asm.Ka).apply(null,arguments)},h._Relu6=function(){return(h._Relu6=h.asm.La).apply(null,arguments)},h._ResizeBilinear=function(){return(h._ResizeBilinear=h.asm.Ma).apply(null,arguments)},h._Reverse=function(){return(h._Reverse=h.asm.Na).apply(null,arguments)},h._RotateWithOffset=function(){return(h._RotateWithOffset=h.asm.Oa).apply(null,arguments)},h._Round=function(){return(h._Round=h.asm.Pa).apply(null,arguments)},h._Rsqrt=function(){return(h._Rsqrt=h.asm.Qa).apply(null,arguments)},h._ScatterNd=function(){return(h._ScatterNd=h.asm.Ra).apply(null,arguments)},h._SelectV2=function(){return(h._SelectV2=h.asm.Sa).apply(null,arguments)},h._Sigmoid=function(){return(h._Sigmoid=h.asm.Ta).apply(null,arguments)},h._Sin=function(){return(h._Sin=h.asm.Ua).apply(null,arguments)},h._Softmax=function(){return(h._Softmax=h.asm.Va).apply(null,arguments)},h._SparseFillEmptyRows=function(){return(h._SparseFillEmptyRows=h.asm.Wa).apply(null,arguments)},h._SparseReshape=function(){return(h._SparseReshape=h.asm.Xa).apply(null,arguments)},h._SparseSegmentReduction=function(){return(h._SparseSegmentReduction=h.asm.Ya).apply(null,arguments)},h._Sqrt=function(){return(h._Sqrt=h.asm.Za).apply(null,arguments)},h._Square=function(){return(h._Square=h.asm._a).apply(null,arguments)},h._SquaredDifference=function(){return(h._SquaredDifference=h.asm.$a).apply(null,arguments)},h._Step=function(){return(h._Step=h.asm.ab).apply(null,arguments)},h._StridedSlice=function(){return(h._StridedSlice=h.asm.bb).apply(null,arguments)},h._Sub=function(){return(h._Sub=h.asm.cb).apply(null,arguments)},h._Sum=function(){return(h._Sum=h.asm.db).apply(null,arguments)},h._Tan=function(){return(h._Tan=h.asm.eb).apply(null,arguments)},h._Tanh=function(){return(h._Tanh=h.asm.fb).apply(null,arguments)},h._Tile=function(){return(h._Tile=h.asm.gb).apply(null,arguments)},h._TopK=function(){return(h._TopK=h.asm.hb).apply(null,arguments)},h._Transform=function(){return(h._Transform=h.asm.ib).apply(null,arguments)},h._Transpose=function(){return(h._Transpose=h.asm.jb).apply(null,arguments)},h.__FusedMatMul=function(){return(h.__FusedMatMul=h.asm.kb).apply(null,arguments)},h._malloc=function(){return(Qa=h._malloc=h.asm.lb).apply(null,arguments)}),Ya=h._free=function(){return(Ya=h._free=h.asm.mb).apply(null,arguments)},Za=h.___errno_location=function(){return(Za=h.___errno_location=h.asm.nb).apply(null,arguments)},Ja=h._emscripten_get_global_libc=function(){return(Ja=h._emscripten_get_global_libc=h.asm.ob).apply(null,arguments)},$a=h._pthread_self=function(){return($a=h._pthread_self=h.asm.pb).apply(null,arguments)},en=h.___pthread_tsd_run_dtors=function(){return(en=h.___pthread_tsd_run_dtors=h.asm.qb).apply(null,arguments)},an=h._emscripten_main_thread_process_queued_calls=function(){return(an=h._emscripten_main_thread_process_queued_calls=h.asm.rb).apply(null,arguments)},nn=(h._emscripten_current_thread_process_queued_calls=function(){return(h._emscripten_current_thread_process_queued_calls=h.asm.sb).apply(null,arguments)},h._emscripten_register_main_browser_thread_id=function(){return(nn=h._emscripten_register_main_browser_thread_id=h.asm.tb).apply(null,arguments)}),tn=h._emscripten_main_browser_thread_id=function(){return(tn=h._emscripten_main_browser_thread_id=h.asm.ub).apply(null,arguments)},rn=h.__emscripten_do_dispatch_to_thread=function(){return(rn=h.__emscripten_do_dispatch_to_thread=h.asm.vb).apply(null,arguments)},un=h._emscripten_sync_run_in_main_thread_4=function(){return(un=h._emscripten_sync_run_in_main_thread_4=h.asm.wb).apply(null,arguments)},sn=h._emscripten_run_in_main_runtime_thread_js=function(){return(sn=h._emscripten_run_in_main_runtime_thread_js=h.asm.xb).apply(null,arguments)},on=h.__emscripten_call_on_thread=function(){return(on=h.__emscripten_call_on_thread=h.asm.yb).apply(null,arguments)},dn=(h._emscripten_tls_init=function(){return(h._emscripten_tls_init=h.asm.zb).apply(null,arguments)},h.__emscripten_thread_init=function(){return(dn=h.__emscripten_thread_init=h.asm.Ab).apply(null,arguments)}),ln=h.stackSave=function(){return(ln=h.stackSave=h.asm.Bb).apply(null,arguments)},cn=h.stackRestore=function(){return(cn=h.stackRestore=h.asm.Cb).apply(null,arguments)},pn=h.stackAlloc=function(){return(pn=h.stackAlloc=h.asm.Db).apply(null,arguments)},fn=h._emscripten_stack_set_limits=function(){return(fn=h._emscripten_stack_set_limits=h.asm.Eb).apply(null,arguments)},mn=h._memalign=function(){return(mn=h._memalign=h.asm.Fb).apply(null,arguments)},hn=h.__emscripten_allow_main_runtime_queued_calls=10656,bn=h.__emscripten_main_thread_futex=12292;function yn(e){this.name="ExitStatus",this.message="Program terminated with exit("+e+")",this.status=e}function gn(e){if(!(be>0)){if(I)return p(h),ce(),void postMessage({cmd:"loaded"});le(),be>0||(h.setStatus?(h.setStatus("Running..."),setTimeout((function(){setTimeout((function(){h.setStatus("")}),1),a()}),1)):a())}function a(){ja||(ja=!0,h.calledRun=!0,V||(ce(),pe(),p(h),h.onRuntimeInitialized&&h.onRuntimeInitialized(),fe()))}}function _n(e,a){if(!a||!L||0!==e){if(!a&&I)throw postMessage({cmd:"exitProcess",returnCode:e}),new yn(e);L||(He.terminateAllThreads(),h.onExit&&h.onExit(e),V=!0),g(e,new yn(e))}}if(h.cwrap=Q,h.PThread=He,h.PThread=He,h.wasmMemory=P,h.ExitStatus=yn,ye=function e(){ja||gn(),ja||(ye=e)},h.run=gn,h.preInit)for("function"==typeof h.preInit&&(h.preInit=[h.preInit]);h.preInit.length>0;)h.preInit.pop()();if(I&&(L=!1,He.initWorker()),gn(),m&&(qa={uncaughtException:process.listeners("uncaughtException").filter((function(e){return!m.uncaughtException.indexOf(e)>-1})),unhandledRejection:process.listeners("unhandledRejection").filter((function(e){return!m.unhandledRejection.indexOf(e)>-1}))}),"undefined"!=typeof WasmBackendModule)Va=WasmBackendModule;else{if("undefined"==typeof e)throw new Error("Could not find wasm module in post.js");Va=e}if(qa){var vn=Va._dispose;Va._dispose=function(){vn(),qa.uncaughtException.forEach((function(e){process.removeListener("uncaughtException",e)})),qa.unhandledRejection.forEach((function(e){process.removeListener("unhandledRejection",e)}))}}return e.ready});e.exports=o}));var An=Sn((function(e,a){var r,u=(r="undefined"!=typeof document&&document.currentScript?document.currentScript.src:void 0,"undefined"!=typeof __filename&&(r=r||__filename),function(e){var a,u,s,i="undefined"!=typeof(e=e||{})?e:{};i.ready=new Promise((function(e,n){a=e,u=n})),"undefined"!=typeof process&&process.listeners&&(s={uncaughtException:process.listeners("uncaughtException"),unhandledRejection:process.listeners("unhandledRejection")});var o,d={};for(o in i)i.hasOwnProperty(o)&&(d[o]=i[o]);var l=!1,c=!1,p=!1,f=!1;l="object"==typeof window,c="function"==typeof importScripts,p="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node,f=!l&&!p&&!c;var m,h,b,y,g,_="";function v(e){return i.locateFile?i.locateFile(e,_):_+e}p?(_=c?n.dirname(_)+"/":__dirname+"/",m=function(e,a){return y||(y=t),g||(g=n),e=g.normalize(e),y.readFileSync(e,a?null:"utf8")},b=function(e){var a=m(e,!0);return a.buffer||(a=new Uint8Array(a)),A(a.buffer),a},process.argv.length>1&&process.argv[1].replace(/\\/g,"/"),process.argv.slice(2),process.on("uncaughtException",(function(e){if(!(e instanceof Pe))throw e})),process.on("unhandledRejection",te),i.inspect=function(){return"[Emscripten Module object]"}):f?("undefined"!=typeof read&&(m=function(e){return read(e)}),b=function(e){var a;return"function"==typeof readbuffer?new Uint8Array(readbuffer(e)):(A("object"==typeof(a=read(e,"binary"))),a)},"undefined"!=typeof scriptArgs&&scriptArgs,"undefined"!=typeof print&&("undefined"==typeof console&&(console={}),console.log=print,console.warn=console.error="undefined"!=typeof printErr?printErr:print)):(l||c)&&(c?_=self.location.href:"undefined"!=typeof document&&document.currentScript&&(_=document.currentScript.src),r&&(_=r),_=0!==_.indexOf("blob:")?_.substr(0,_.lastIndexOf("/")+1):"",m=function(e){var a=new XMLHttpRequest;return a.open("GET",e,!1),a.send(null),a.responseText},c&&(b=function(e){var a=new XMLHttpRequest;return a.open("GET",e,!1),a.responseType="arraybuffer",a.send(null),new Uint8Array(a.response)}),h=function(e,a,n){var t=new XMLHttpRequest;t.open("GET",e,!0),t.responseType="arraybuffer",t.onload=function(){200==t.status||0==t.status&&t.response?a(t.response):n()},t.onerror=n,t.send(null)});var w,k,I=i.print||console.log.bind(console),S=i.printErr||console.warn.bind(console);for(o in d)d.hasOwnProperty(o)&&(i[o]=d[o]);d=null,i.arguments&&i.arguments,i.thisProgram&&i.thisProgram,i.quit&&i.quit,i.wasmBinary&&(w=i.wasmBinary),i.noExitRuntime,"object"!=typeof WebAssembly&&te("no native wasm support detected");var M=!1;function A(e,a){e||te("Assertion failed: "+a)}function E(e){var a=i["_"+e];return A(a,"Cannot call unknown function "+e+", make sure it is exported"),a}function x(e,a,n,t,r){var u={string:function(e){var a=0;if(null!=e&&0!==e){var n=1+(e.length<<2);L(e,a=De(n),n)}return a},array:function(e){var a=De(e.length);return H(e,a),a}},s=E(e),i=[],o=0;if(t)for(var d=0;d<t.length;d++){var l=u[n[d]];l?(0===o&&(o=Re()),i[d]=l(t[d])):i[d]=t[d]}var c=s.apply(null,i);return c=function(e){return"string"===a?P(e):"boolean"===a?Boolean(e):e}(c),0!==o&&Ce(o),c}function N(e,a,n,t){var r=(n=n||[]).every((function(e){return"number"===e}));return"string"!==a&&r&&!t?E(e):function(){return x(e,a,n,arguments)}}var F,O,T,R,C="undefined"!=typeof TextDecoder?new TextDecoder("utf8"):void 0;function D(e,a,n){for(var t=a+n,r=a;e[r]&&!(r>=t);)++r;if(r-a>16&&e.subarray&&C)return C.decode(e.subarray(a,r));for(var u="";a<r;){var s=e[a++];if(128&s){var i=63&e[a++];if(192!=(224&s)){var o=63&e[a++];if((s=224==(240&s)?(15&s)<<12|i<<6|o:(7&s)<<18|i<<12|o<<6|63&e[a++])<65536)u+=String.fromCharCode(s);else{var d=s-65536;u+=String.fromCharCode(55296|d>>10,56320|1023&d)}}else u+=String.fromCharCode((31&s)<<6|i)}else u+=String.fromCharCode(s)}return u}function P(e,a){return e?D(T,e,a):""}function W(e,a,n,t){if(!(t>0))return 0;for(var r=n,u=n+t-1,s=0;s<e.length;++s){var i=e.charCodeAt(s);if(i>=55296&&i<=57343&&(i=65536+((1023&i)<<10)|1023&e.charCodeAt(++s)),i<=127){if(n>=u)break;a[n++]=i}else if(i<=2047){if(n+1>=u)break;a[n++]=192|i>>6,a[n++]=128|63&i}else if(i<=65535){if(n+2>=u)break;a[n++]=224|i>>12,a[n++]=128|i>>6&63,a[n++]=128|63&i}else{if(n+3>=u)break;a[n++]=240|i>>18,a[n++]=128|i>>12&63,a[n++]=128|i>>6&63,a[n++]=128|63&i}}return a[n]=0,n-r}function L(e,a,n){return W(e,T,a,n)}function H(e,a){O.set(e,a)}function B(e,a){return e%a>0&&(e+=a-e%a),e}function U(e){F=e,i.HEAP8=O=new Int8Array(e),i.HEAP16=new Int16Array(e),i.HEAP32=R=new Int32Array(e),i.HEAPU8=T=new Uint8Array(e),i.HEAPU16=new Uint16Array(e),i.HEAPU32=new Uint32Array(e),i.HEAPF32=new Float32Array(e),i.HEAPF64=new Float64Array(e)}i.INITIAL_MEMORY;var z,j=[],q=[],V=[],G=[];function K(){if(i.preRun)for("function"==typeof i.preRun&&(i.preRun=[i.preRun]);i.preRun.length;)Z(i.preRun.shift());fe(j)}function X(){fe(q)}function Q(){fe(V)}function Y(){if(i.postRun)for("function"==typeof i.postRun&&(i.postRun=[i.postRun]);i.postRun.length;)J(i.postRun.shift());fe(G)}function Z(e){j.unshift(e)}function J(e){G.unshift(e)}q.push({func:function(){Oe()}});var $=0,ee=null;function ae(e){$++,i.monitorRunDependencies&&i.monitorRunDependencies($)}function ne(e){if($--,i.monitorRunDependencies&&i.monitorRunDependencies($),0==$&&ee){var a=ee;ee=null,a()}}function te(e){i.onAbort&&i.onAbort(e),S(e+=""),M=!0,e="abort("+e+"). Build with -s ASSERTIONS=1 for more info.";var a=new WebAssembly.RuntimeError(e);throw u(a),a}function re(e,a){return String.prototype.startsWith?e.startsWith(a):0===e.indexOf(a)}i.preloadedImages={},i.preloadedAudios={};var ue="data:application/octet-stream;base64,";function se(e){return re(e,ue)}var ie="file://";function oe(e){return re(e,ie)}var de="tfjs-backend-wasm.wasm";function le(e){try{if(e==de&&w)return new Uint8Array(w);if(b)return b(e);throw"both async and sync fetching of the wasm failed"}catch(e){te(e)}}function ce(){if(!w&&(l||c)){if("function"==typeof fetch&&!oe(de))return fetch(de,{credentials:"same-origin"}).then((function(e){if(!e.ok)throw"failed to load wasm binary file at '"+de+"'";return e.arrayBuffer()})).catch((function(){return le(de)}));if(h)return new Promise((function(e,a){h(de,(function(a){e(new Uint8Array(a))}),a)}))}return Promise.resolve().then((function(){return le(de)}))}function pe(){var e={a:Fe};function a(e,a){var n=e.exports;i.asm=n,U((k=i.asm.j).buffer),z=i.asm.r,ne()}function n(e){a(e.instance)}function t(a){return ce().then((function(a){return WebAssembly.instantiate(a,e)})).then(a,(function(e){S("failed to asynchronously prepare wasm: "+e),te(e)}))}if(ae(),i.instantiateWasm)try{return i.instantiateWasm(e,a)}catch(e){return S("Module.instantiateWasm callback failed with error: "+e),!1}return(w||"function"!=typeof WebAssembly.instantiateStreaming||se(de)||oe(de)||"function"!=typeof fetch?t(n):fetch(de,{credentials:"same-origin"}).then((function(a){return WebAssembly.instantiateStreaming(a,e).then(n,(function(e){return S("wasm streaming compile failed: "+e),S("falling back to ArrayBuffer instantiation"),t(n)}))}))).catch(u),{}}function fe(e){for(;e.length>0;){var a=e.shift();if("function"!=typeof a){var n=a.func;"number"==typeof n?void 0===a.arg?z.get(n)():z.get(n)(a.arg):n(void 0===a.arg?null:a.arg)}else a(i)}}function me(){te()}function he(e,a,n){T.copyWithin(e,a,a+n)}function be(){return T.length}function ye(e){try{return k.grow(e-F.byteLength+65535>>>16),U(k.buffer),1}catch(e){}}function ge(e){var a=be(),n=2147483648;if(e>n)return!1;for(var t=1;t<=4;t*=2){var r=a*(1+.2/t);if(r=Math.min(r,e+100663296),ye(Math.min(n,B(Math.max(e,r),65536))))return!0}return!1}se(de)||(de=v(de));var _e={mappings:{},buffers:[null,[],[]],printChar:function(e,a){var n=_e.buffers[e];0===a||10===a?((1===e?I:S)(D(n,0)),n.length=0):n.push(a)},varargs:void 0,get:function(){return _e.varargs+=4,R[_e.varargs-4>>2]},getStr:function(e){return P(e)},get64:function(e,a){return e}};function ve(e){return 0}function we(e,a,n,t,r){}function ke(e,a,n,t){for(var r=0,u=0;u<n;u++){for(var s=R[a+8*u>>2],i=R[a+(8*u+4)>>2],o=0;o<i;o++)_e.printChar(e,T[s+o]);r+=i}return R[t>>2]=r,0}function Ie(){return 6}function Se(){return 28}function Me(e){return R[Te()>>2]=e,e}function Ae(e){switch(e){case 30:return 16384;case 85:return 131072;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:case 80:case 81:case 79:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:return"object"==typeof navigator&&navigator.hardwareConcurrency||1}return Me(28),-1}var Ee,xe,Ne,Fe={a:me,d:he,e:ge,f:ve,c:we,b:ke,h:Ie,g:Se,i:Ae},Oe=(pe(),i.___wasm_call_ctors=function(){return(Oe=i.___wasm_call_ctors=i.asm.k).apply(null,arguments)}),Te=(i._init=function(){return(i._init=i.asm.l).apply(null,arguments)},i._init_with_threads_count=function(){return(i._init_with_threads_count=i.asm.m).apply(null,arguments)},i._get_threads_count=function(){return(i._get_threads_count=i.asm.n).apply(null,arguments)},i._register_tensor=function(){return(i._register_tensor=i.asm.o).apply(null,arguments)},i._dispose_data=function(){return(i._dispose_data=i.asm.p).apply(null,arguments)},i._dispose=function(){return(i._dispose=i.asm.q).apply(null,arguments)},i._Abs=function(){return(i._Abs=i.asm.s).apply(null,arguments)},i._Add=function(){return(i._Add=i.asm.t).apply(null,arguments)},i._AddN=function(){return(i._AddN=i.asm.u).apply(null,arguments)},i._All=function(){return(i._All=i.asm.v).apply(null,arguments)},i._Any=function(){return(i._Any=i.asm.w).apply(null,arguments)},i._ArgMax=function(){return(i._ArgMax=i.asm.x).apply(null,arguments)},i._AvgPool=function(){return(i._AvgPool=i.asm.y).apply(null,arguments)},i._BatchMatMul=function(){return(i._BatchMatMul=i.asm.z).apply(null,arguments)},i._Ceil=function(){return(i._Ceil=i.asm.A).apply(null,arguments)},i._ClipByValue=function(){return(i._ClipByValue=i.asm.B).apply(null,arguments)},i._Conv2D=function(){return(i._Conv2D=i.asm.C).apply(null,arguments)},i._Conv2DBackpropInput=function(){return(i._Conv2DBackpropInput=i.asm.D).apply(null,arguments)},i._Cos=function(){return(i._Cos=i.asm.E).apply(null,arguments)},i._Cosh=function(){return(i._Cosh=i.asm.F).apply(null,arguments)},i._CropAndResize=function(){return(i._CropAndResize=i.asm.G).apply(null,arguments)},i._Cumsum=function(){return(i._Cumsum=i.asm.H).apply(null,arguments)},i._DepthToSpace=function(){return(i._DepthToSpace=i.asm.I).apply(null,arguments)},i._DepthwiseConv2dNative=function(){return(i._DepthwiseConv2dNative=i.asm.J).apply(null,arguments)},i._Elu=function(){return(i._Elu=i.asm.K).apply(null,arguments)},i._Equal=function(){return(i._Equal=i.asm.L).apply(null,arguments)},i._Exp=function(){return(i._Exp=i.asm.M).apply(null,arguments)},i._FlipLeftRight=function(){return(i._FlipLeftRight=i.asm.N).apply(null,arguments)},i._Floor=function(){return(i._Floor=i.asm.O).apply(null,arguments)},i._FloorDiv=function(){return(i._FloorDiv=i.asm.P).apply(null,arguments)},i._FusedBatchNorm=function(){return(i._FusedBatchNorm=i.asm.Q).apply(null,arguments)},i._FusedConv2D=function(){return(i._FusedConv2D=i.asm.R).apply(null,arguments)},i._FusedDepthwiseConv2D=function(){return(i._FusedDepthwiseConv2D=i.asm.S).apply(null,arguments)},i._Gather=function(){return(i._Gather=i.asm.T).apply(null,arguments)},i._GatherNd=function(){return(i._GatherNd=i.asm.U).apply(null,arguments)},i._Greater=function(){return(i._Greater=i.asm.V).apply(null,arguments)},i._GreaterEqual=function(){return(i._GreaterEqual=i.asm.W).apply(null,arguments)},i._LeakyRelu=function(){return(i._LeakyRelu=i.asm.X).apply(null,arguments)},i._Less=function(){return(i._Less=i.asm.Y).apply(null,arguments)},i._LessEqual=function(){return(i._LessEqual=i.asm.Z).apply(null,arguments)},i._Log=function(){return(i._Log=i.asm._).apply(null,arguments)},i._LogicalAnd=function(){return(i._LogicalAnd=i.asm.$).apply(null,arguments)},i._Max=function(){return(i._Max=i.asm.aa).apply(null,arguments)},i._MaxPool=function(){return(i._MaxPool=i.asm.ba).apply(null,arguments)},i._Maximum=function(){return(i._Maximum=i.asm.ca).apply(null,arguments)},i._Mean=function(){return(i._Mean=i.asm.da).apply(null,arguments)},i._Min=function(){return(i._Min=i.asm.ea).apply(null,arguments)},i._Minimum=function(){return(i._Minimum=i.asm.fa).apply(null,arguments)},i._MirrorPad=function(){return(i._MirrorPad=i.asm.ga).apply(null,arguments)},i._Multiply=function(){return(i._Multiply=i.asm.ha).apply(null,arguments)},i._Neg=function(){return(i._Neg=i.asm.ia).apply(null,arguments)},i._NonMaxSuppressionV3=function(){return(i._NonMaxSuppressionV3=i.asm.ja).apply(null,arguments)},i._NonMaxSuppressionV4=function(){return(i._NonMaxSuppressionV4=i.asm.ka).apply(null,arguments)},i._NonMaxSuppressionV5=function(){return(i._NonMaxSuppressionV5=i.asm.la).apply(null,arguments)},i._NotEqual=function(){return(i._NotEqual=i.asm.ma).apply(null,arguments)},i._OneHot=function(){return(i._OneHot=i.asm.na).apply(null,arguments)},i._PadV2=function(){return(i._PadV2=i.asm.oa).apply(null,arguments)},i._Pow=function(){return(i._Pow=i.asm.pa).apply(null,arguments)},i._Prelu=function(){return(i._Prelu=i.asm.qa).apply(null,arguments)},i._Prod=function(){return(i._Prod=i.asm.ra).apply(null,arguments)},i._RealDiv=function(){return(i._RealDiv=i.asm.sa).apply(null,arguments)},i._Relu=function(){return(i._Relu=i.asm.ta).apply(null,arguments)},i._Relu6=function(){return(i._Relu6=i.asm.ua).apply(null,arguments)},i._ResizeBilinear=function(){return(i._ResizeBilinear=i.asm.va).apply(null,arguments)},i._Reverse=function(){return(i._Reverse=i.asm.wa).apply(null,arguments)},i._RotateWithOffset=function(){return(i._RotateWithOffset=i.asm.xa).apply(null,arguments)},i._Round=function(){return(i._Round=i.asm.ya).apply(null,arguments)},i._Rsqrt=function(){return(i._Rsqrt=i.asm.za).apply(null,arguments)},i._ScatterNd=function(){return(i._ScatterNd=i.asm.Aa).apply(null,arguments)},i._SelectV2=function(){return(i._SelectV2=i.asm.Ba).apply(null,arguments)},i._Sigmoid=function(){return(i._Sigmoid=i.asm.Ca).apply(null,arguments)},i._Sin=function(){return(i._Sin=i.asm.Da).apply(null,arguments)},i._Softmax=function(){return(i._Softmax=i.asm.Ea).apply(null,arguments)},i._SparseFillEmptyRows=function(){return(i._SparseFillEmptyRows=i.asm.Fa).apply(null,arguments)},i._SparseReshape=function(){return(i._SparseReshape=i.asm.Ga).apply(null,arguments)},i._SparseSegmentReduction=function(){return(i._SparseSegmentReduction=i.asm.Ha).apply(null,arguments)},i._Sqrt=function(){return(i._Sqrt=i.asm.Ia).apply(null,arguments)},i._Square=function(){return(i._Square=i.asm.Ja).apply(null,arguments)},i._SquaredDifference=function(){return(i._SquaredDifference=i.asm.Ka).apply(null,arguments)},i._Step=function(){return(i._Step=i.asm.La).apply(null,arguments)},i._StridedSlice=function(){return(i._StridedSlice=i.asm.Ma).apply(null,arguments)},i._Sub=function(){return(i._Sub=i.asm.Na).apply(null,arguments)},i._Sum=function(){return(i._Sum=i.asm.Oa).apply(null,arguments)},i._Tan=function(){return(i._Tan=i.asm.Pa).apply(null,arguments)},i._Tanh=function(){return(i._Tanh=i.asm.Qa).apply(null,arguments)},i._Tile=function(){return(i._Tile=i.asm.Ra).apply(null,arguments)},i._TopK=function(){return(i._TopK=i.asm.Sa).apply(null,arguments)},i._Transform=function(){return(i._Transform=i.asm.Ta).apply(null,arguments)},i._Transpose=function(){return(i._Transpose=i.asm.Ua).apply(null,arguments)},i.__FusedMatMul=function(){return(i.__FusedMatMul=i.asm.Va).apply(null,arguments)},i._malloc=function(){return(i._malloc=i.asm.Wa).apply(null,arguments)},i._free=function(){return(i._free=i.asm.Xa).apply(null,arguments)},i.___errno_location=function(){return(Te=i.___errno_location=i.asm.Ya).apply(null,arguments)}),Re=i.stackSave=function(){return(Re=i.stackSave=i.asm.Za).apply(null,arguments)},Ce=i.stackRestore=function(){return(Ce=i.stackRestore=i.asm._a).apply(null,arguments)},De=i.stackAlloc=function(){return(De=i.stackAlloc=i.asm.$a).apply(null,arguments)};function Pe(e){this.name="ExitStatus",this.message="Program terminated with exit("+e+")",this.status=e}function We(e){function n(){Ee||(Ee=!0,i.calledRun=!0,M||(X(),Q(),a(i),i.onRuntimeInitialized&&i.onRuntimeInitialized(),Y()))}$>0||(K(),$>0||(i.setStatus?(i.setStatus("Running..."),setTimeout((function(){setTimeout((function(){i.setStatus("")}),1),n()}),1)):n()))}if(i.cwrap=N,ee=function e(){Ee||We(),Ee||(ee=e)},i.run=We,i.preInit)for("function"==typeof i.preInit&&(i.preInit=[i.preInit]);i.preInit.length>0;)i.preInit.pop()();if(We(),s&&(xe={uncaughtException:process.listeners("uncaughtException").filter((function(e){return!s.uncaughtException.indexOf(e)>-1})),unhandledRejection:process.listeners("unhandledRejection").filter((function(e){return!s.unhandledRejection.indexOf(e)>-1}))}),"undefined"!=typeof e)Ne=e;else{if("undefined"==typeof WasmBackendModuleThreadedSimd)throw new Error("Could not find wasm module in post.js");Ne=WasmBackendModuleThreadedSimd}if(xe){var Le=Ne._dispose;Ne._dispose=function(){Le(),xe.uncaughtException.forEach((function(e){process.removeListener("uncaughtException",e)})),xe.unhandledRejection.forEach((function(e){process.removeListener("unhandledRejection",e)}))}}return e.ready});e.exports=u})),En=function(e){function n(n){var t=e.call(this)||this;return t.wasm=n,t.dataIdNextNumber=1,t.wasm.tfjs.initWithThreadsCount(Pn),Wn=t.wasm.tfjs.getThreadsCount(),t.dataIdMap=new a.DataStorage(t,a.engine()),t}return function(e,a){function n(){this.constructor=e}gn(e,a),e.prototype=null===a?Object.create(a):(n.prototype=a.prototype,new n)}(n,e),n.prototype.write=function(e,a,n){var t={id:this.dataIdNextNumber++};return this.move(t,e,a,n,1),t},n.prototype.numDataIds=function(){return this.dataIdMap.numDataIds()},n.prototype.time=function(e){return _n(this,void 0,void 0,(function(){var n;return vn(this,(function(t){return n=a.util.now(),e(),[2,{kernelMs:a.util.now()-n}]}))}))},n.prototype.move=function(e,n,t,r,u){var s=this.dataIdNextNumber++;if("string"!==r){var i=a.util.sizeFromShape(t),o=i*a.util.bytesPerElement(r),d=this.wasm._malloc(o);this.dataIdMap.set(e,{id:s,memoryOffset:d,shape:t,dtype:r,refCount:u}),this.wasm.tfjs.registerTensor(s,i,d),null!=n&&this.wasm.HEAPU8.set(new Uint8Array(n.buffer,n.byteOffset,o),d)}else{var l=n;this.dataIdMap.set(e,{id:s,stringBytes:l,shape:t,dtype:r,memoryOffset:null,refCount:u})}},n.prototype.read=function(e){return _n(this,void 0,void 0,(function(){return vn(this,(function(a){return[2,this.readSync(e)]}))}))},n.prototype.readSync=function(e,n,t){var r=this.dataIdMap.get(e),u=r.memoryOffset,s=r.dtype,i=r.shape,o=r.stringBytes;if("string"===s)return null!=n&&0!==n||!(null==t||t>=o.length)?o.slice(n,t):o;n=n||0,t=t||a.util.sizeFromShape(i);var d=a.util.bytesPerElement(s);return function(e,a){switch(a){case"float32":return new Float32Array(e);case"int32":return new Int32Array(e);case"bool":return new Uint8Array(e);default:throw new Error("Unknown dtype "+a)}}(this.wasm.HEAPU8.slice(u+n*d,u+t*d).buffer,s)},n.prototype.disposeData=function(e,a){if(void 0===a&&(a=!1),this.dataIdMap.has(e)){var n=this.dataIdMap.get(e);if(n.refCount--,!a&&n.refCount>0)return!1;this.wasm._free(n.memoryOffset),this.wasm.tfjs.disposeData(n.id),this.dataIdMap.delete(e)}return!0},n.prototype.refCount=function(e){return this.dataIdMap.has(e)?this.dataIdMap.get(e).refCount:0},n.prototype.incRef=function(e){var a=this.dataIdMap.get(e);null!=a&&a.refCount++},n.prototype.floatPrecision=function(){return 32},n.prototype.getMemoryOffset=function(e){return this.dataIdMap.get(e).memoryOffset},n.prototype.dispose=function(){this.wasm.tfjs.dispose(),"PThread"in this.wasm&&this.wasm.PThread.terminateAllThreads(),this.wasm=null},n.prototype.memory=function(){return{unreliable:!1}},n.prototype.makeOutput=function(e,n,t){var r;if(null==t)r=this.write(null,e,n);else{var u=this.dataIdNextNumber++;r={id:u},this.dataIdMap.set(r,{id:u,memoryOffset:t,shape:e,dtype:n,refCount:1});var s=a.util.sizeFromShape(e);this.wasm.tfjs.registerTensor(u,s,t)}return{dataId:r,shape:e,dtype:n}},n.prototype.typedArrayFromHeap=function(e){var n=e.shape,t=e.dtype,r=e.dataId,u=this.wasm.HEAPU8.buffer,s=this.dataIdMap.get(r).memoryOffset,i=a.util.sizeFromShape(n);switch(t){case"float32":return new Float32Array(u,s,i);case"int32":return new Int32Array(u,s,i);case"bool":return new Uint8Array(u,s,i);default:throw new Error("Unknown dtype "+t)}},n}(a.KernelBackend);function xn(e,a,n){if(null!=On)return On;var t="tfjs-backend-wasm.wasm";return e&&a?t="tfjs-backend-wasm-threaded-simd.wasm":e&&(t="tfjs-backend-wasm-simd.wasm"),null!=Rn&&null!=Rn[t]?Rn[t]:n+t}function Nn(){return _n(this,void 0,void 0,(function(){var e,n,t;return vn(this,(function(r){switch(r.label){case 0:return[4,Promise.all([a.env().getAsync("WASM_HAS_SIMD_SUPPORT"),a.env().getAsync("WASM_HAS_MULTITHREAD_SUPPORT")])];case 1:return e=r.sent(),n=e[0],t=e[1],[2,new Promise((function(e,r){var u={locateFile:function(e,a){if(e.endsWith(".worker.js")){var r=new Blob(['var Module={};function threadPrintErr(){var text=Array.prototype.slice.call(arguments).join(" ");console.error(text)}function threadAlert(){var text=Array.prototype.slice.call(arguments).join(" ");postMessage({cmd:"alert",text:text,threadId:Module["_pthread_self"]()})}var err=threadPrintErr;this.alert=threadAlert;Module["instantiateWasm"]=function(info,receiveInstance){var instance=new WebAssembly.Instance(Module["wasmModule"],info);Module["wasmModule"]=null;receiveInstance(instance);return instance.exports};function moduleLoaded(){}this.onmessage=function(e){try{if(e.data.cmd==="load"){Module["wasmModule"]=e.data.wasmModule;Module["wasmMemory"]=e.data.wasmMemory;Module["buffer"]=Module["wasmMemory"].buffer;Module["ENVIRONMENT_IS_PTHREAD"]=true;if(typeof e.data.urlOrBlob==="string"){importScripts(e.data.urlOrBlob)}else{var objectUrl=URL.createObjectURL(e.data.urlOrBlob);importScripts(objectUrl);URL.revokeObjectURL(objectUrl)}WasmBackendModuleThreadedSimd(Module).then(function(instance){Module=instance;moduleLoaded()})}else if(e.data.cmd==="objectTransfer"){Module["PThread"].receiveObjectTransfer(e.data)}else if(e.data.cmd==="run"){Module["__performance_now_clock_drift"]=performance.now()-e.data.time;Module["__emscripten_thread_init"](e.data.threadInfoStruct,0,0);var max=e.data.stackBase;var top=e.data.stackBase+e.data.stackSize;Module["establishStackSpace"](top,max);Module["_emscripten_tls_init"]();Module["PThread"].receiveObjectTransfer(e.data);Module["PThread"].setThreadStatus(Module["_pthread_self"](),1);try{var result=Module["invokeEntryPoint"](e.data.start_routine,e.data.arg);if(!Module["getNoExitRuntime"]())Module["PThread"].threadExit(result)}catch(ex){if(ex==="Canceled!"){Module["PThread"].threadCancel()}else if(ex!="unwind"){if(ex instanceof Module["ExitStatus"]){if(Module["getNoExitRuntime"]()){}else{Module["PThread"].threadExit(ex.status)}}else{Module["PThread"].threadExit(-2);throw ex}}}}else if(e.data.cmd==="cancel"){if(Module["_pthread_self"]()){Module["PThread"].threadCancel()}}else if(e.data.target==="setimmediate"){}else if(e.data.cmd==="processThreadQueue"){if(Module["_pthread_self"]()){Module["_emscripten_current_thread_process_queued_calls"]()}}else{err("worker.js received unknown command "+e.data.cmd);err(e.data)}}catch(ex){err("worker.js onmessage() captured an uncaught exception: "+ex);if(ex&&ex.stack)err(ex.stack);throw ex}};if(typeof process==="object"&&typeof process.versions==="object"&&typeof process.versions.node==="string"){self={location:{href:__filename}};var onmessage=this.onmessage;var nodeWorkerThreads=require("worker_threads");global.Worker=nodeWorkerThreads.Worker;var parentPort=nodeWorkerThreads.parentPort;parentPort.on("message",function(data){onmessage({data:data})});var nodeFS=require("fs");var nodeRead=function(filename){return nodeFS.readFileSync(filename,"utf8")};function globalEval(x){global.require=require;global.Module=Module;eval.call(null,x)}importScripts=function(f){globalEval(nodeRead(f))};postMessage=function(msg){parentPort.postMessage(msg)};if(typeof performance==="undefined"){performance={now:function(){return Date.now()}}}}'],{type:"application/javascript"});return URL.createObjectURL(r)}return e.endsWith(".wasm")?xn(n,t,null!=Tn?Tn:a):a+e}};Dn&&(u.instantiateWasm=function(e){return function(n,t){return a.util.fetch(e,{credentials:"same-origin"}).then((function(a){a.ok||n.env.a("failed to load wasm binary file at '"+e+"'"),a.arrayBuffer().then((function(e){WebAssembly.instantiate(e,n).then((function(e){t(e.instance,e.module)}))}))})),{}}}(xn(n,t,null!=Tn?Tn:"")));var s,i=!1;u.onAbort=function(){if(!i&&!Cn){Cn=!0;r({message:"Make sure the server can serve the `.wasm` file relative to the bundled js file. For more details see https://github.com/tensorflow/tfjs/blob/master/tfjs-backend-wasm/README.md#using-bundlers"})}},t&&n&&null==On?(u.mainScriptUrlOrBlob=new Blob(["var WasmBackendModuleThreadedSimd = "+Mn.toString()],{type:"text/javascript"}),s=Mn(u)):s=An(u),s.then((function(a){i=!0,Cn=!1;a.tfjs={init:a.cwrap("init",null,[]),initWithThreadsCount:a.cwrap("init_with_threads_count",null,["number"]),getThreadsCount:a.cwrap("get_threads_count","number",[]),registerTensor:a.cwrap("register_tensor",null,["number","number","number"]),disposeData:a.cwrap("dispose_data",null,["number"]),dispose:a.cwrap("dispose",null,[])},e({wasm:a})}))}))]}}))}))}var Fn=["tfjs-backend-wasm.wasm","tfjs-backend-wasm-simd.wasm","tfjs-backend-wasm-threaded-simd.wasm"],On=null,Tn=null,Rn={},Cn=!1,Dn=!1;var Pn=-1,Wn=-1;a.registerBackend("wasm",(function(){return _n(undefined,void 0,void 0,(function(){var e;return vn(this,(function(a){switch(a.label){case 0:return[4,Nn()];case 1:return e=a.sent().wasm,[2,new En(e)]}}))}))}),2),e.BackendWasm=En,e.getThreadsCount=function(){if(-1===Wn)throw new Error("WASM backend not initialized.");return Wn},e.setThreadsCount=function(e){Pn=e},e.setWasmPath=function(e,n){if(void 0===n&&(n=!1),a.deprecationWarn("setWasmPath has been deprecated in favor of setWasmPaths and will be removed in a future release."),Cn)throw new Error("The WASM backend was already initialized. Make sure you call `setWasmPath()` before you call `tf.setBackend()` or `tf.ready()`");On=e,Dn=n},e.setWasmPaths=function(e,a){if(void 0===a&&(a=!1),Cn)throw new Error("The WASM backend was already initialized. Make sure you call `setWasmPaths()` before you call `tf.setBackend()` or `tf.ready()`");if("string"==typeof e)Tn=e;else{Rn=e;var n=Fn.filter((function(e){return null==Rn[e]}));if(n.length>0)throw new Error("There were no entries found for the following binaries: "+n.join(",")+". Please either call setWasmPaths with a map providing a path for each binary, or with a string indicating the directory where all the binaries can be found.")}Dn=a},e.version_wasm="3.13.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-wasm.min.js.map
