function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useEffect } from 'react';
import { NativeModules, Platform, DeviceEventEmitter, StyleSheet } from 'react-native';
import { RNGoogleSigninButton } from './RNGoogleSiginButton';
const RNGoogleSignin = NativeModules.RNGoogleSignin;
export const GoogleSigninButton = _ref => {
  let {
    onPress,
    style,
    ...rest
  } = _ref;
  useEffect(() => {
    if (Platform.OS === 'ios') {
      return;
    }
    const clickListener = DeviceEventEmitter.addListener('RNGoogleSigninButtonClicked', () => {
      onPress === null || onPress === void 0 ? void 0 : onPress();
    });
    return () => {
      clickListener.remove();
    };
  }, [onPress]);
  const recommendedSize = (() => {
    switch (rest.size) {
      case RNGoogleSignin.BUTTON_SIZE_ICON:
        return styles.iconSize;
      case RNGoogleSignin.BUTTON_SIZE_WIDE:
        return styles.wideSize;
      default:
        return styles.standardSize;
    }
  })();

  // @ts-ignore style prop incompatible
  return /*#__PURE__*/React.createElement(RNGoogleSigninButton, _extends({}, rest, {
    onPress: onPress,
    style: [recommendedSize, style]
  }));
};
GoogleSigninButton.Size = {
  Icon: RNGoogleSignin.BUTTON_SIZE_ICON,
  Standard: RNGoogleSignin.BUTTON_SIZE_STANDARD,
  Wide: RNGoogleSignin.BUTTON_SIZE_WIDE
};
GoogleSigninButton.Color = {
  Dark: RNGoogleSignin.BUTTON_COLOR_DARK,
  Light: RNGoogleSignin.BUTTON_COLOR_LIGHT
};

// sizes according to https://developers.google.com/identity/sign-in/ios/reference/Classes/GIDSignInButton
const styles = StyleSheet.create({
  iconSize: {
    width: 48,
    height: 48
  },
  standardSize: {
    width: 230,
    height: 48
  },
  wideSize: {
    width: 312,
    height: 48
  }
});
//# sourceMappingURL=GoogleSigninButton.js.map