import _extends from "@babel/runtime/helpers/esm/extends";
import { moveHighlight, listReducer, ListActionTypes } from '../useList';
import { SelectActionTypes } from './useSelect.types';
export default function selectReducer(state, action) {
  const {
    open
  } = state;
  const {
    context: {
      selectionMode
    }
  } = action;
  switch (action.type) {
    case SelectActionTypes.buttonClick:
      {
        const itemToHighlight = state.selectedValues[0] ?? moveHighlight(null, 'start', action.context);
        return _extends({}, state, {
          open: !open,
          highlightedValue: !open ? itemToHighlight : null
        });
      }
    case SelectActionTypes.buttonArrowKeyDown:
      if (action.key === 'ArrowDown') {
        const itemToHighlight = state.selectedValues[0] ?? moveHighlight(null, 'start', action.context);
        return _extends({}, state, {
          open: true,
          highlightedValue: itemToHighlight
        });
      }
      if (action.key === 'ArrowUp') {
        const itemToHighlight = state.selectedValues[0] ?? moveHighlight(null, 'end', action.context);
        return _extends({}, state, {
          open: true,
          highlightedValue: itemToHighlight
        });
      }
      break;
    default:
      break;
  }
  const newState = listReducer(state, action);
  switch (action.type) {
    case ListActionTypes.keyDown:
      if (selectionMode === 'single' && (action.event.key === 'Enter' || action.event.key === ' ' || action.event.key === 'Escape')) {
        return _extends({}, newState, {
          open: false
        });
      }
      break;
    case ListActionTypes.itemClick:
      if (selectionMode === 'single') {
        return _extends({}, newState, {
          open: false
        });
      }
      break;
    case ListActionTypes.blur:
      return _extends({}, newState, {
        open: false
      });
    default:
      return newState;
  }
  return newState;
}