export const mode: string;
export namespace output {
    const libraryTarget: string;
    const filename: string;
    const publicPath: string;
}
export namespace resolve {
    const extensions: string[];
}
export namespace module {
    const rules: ({
        test: RegExp;
        exclude: RegExp;
        use: (string | {
            loader: string;
            options?: undefined;
        } | {
            loader: string;
            options: {
                postcssOptions: {
                    plugins: any[];
                };
            };
        })[];
        type?: undefined;
    } | {
        test: RegExp;
        exclude: RegExp;
        use: ({
            loader: string;
            options: {
                transpileOnly: boolean;
                configFile: string;
                presets?: undefined;
                plugins?: undefined;
            };
        } | {
            loader: string;
            options: {
                presets: (string | (string | {
                    runtime: string;
                })[])[];
                plugins: string[];
                transpileOnly?: undefined;
                configFile?: undefined;
            };
        })[];
        type?: undefined;
    } | {
        test: RegExp;
        type: string;
        exclude?: undefined;
        use?: undefined;
    })[];
}
export namespace optimization {
    const minimize: boolean;
    const minimizer: any[];
    namespace splitChunks {
        const chunks: string;
        namespace cacheGroups {
            namespace vendors {
                const test: RegExp;
                const name: string;
            }
        }
    }
}
export const plugins: any[];
export const externals: {
    react: {
        root: string;
        commonjs2: string;
        commonjs: string;
        amd: string;
    };
    "react-dom": {
        root: string;
        commonjs2: string;
        commonjs: string;
        amd: string;
    };
};
