import React from "react";
import { AppState } from "../types";
import { ActionManager } from "../actions/manager";
import { NonDeletedExcalidrawElement } from "../element/types";
declare type MobileMenuProps = {
    appState: AppState;
    actionManager: ActionManager;
    renderJSONExportDialog: () => React.ReactNode;
    renderImageExportDialog: () => React.ReactNode;
    setAppState: React.Component<any, AppState>["setState"];
    elements: readonly NonDeletedExcalidrawElement[];
    libraryMenu: JSX.Element | null;
    onCollabButtonClick?: () => void;
    onLockToggle: () => void;
    onPenModeToggle: () => void;
    canvas: HTMLCanvasElement | null;
    allowedShapes: Array<String>;
    disableAlignItems?: boolean;
    disableGrouping?: boolean;
    disableHints?: boolean;
    disableLink?: boolean;
    disableShortcuts?: boolean;
    disableVerticalAlignOptions?: boolean;
    fontSizeOptions?: Array<String>;
    isCollaborating: boolean;
    hideArrowHeadsOptions?: boolean;
    hideClearCanvas?: boolean;
    hideColorInput?: boolean;
    hideFontFamily?: boolean;
    hideIOActions?: boolean;
    hideLayers?: boolean;
    hideLibraries?: boolean;
    hideLockButton?: boolean;
    hideOpacityInput?: boolean;
    hideSharpness?: boolean;
    hideStrokeStyle?: boolean;
    hideTextAlign?: boolean;
    hideThemeControls?: boolean;
    hideUserList?: boolean;
    renderCustomFooter?: (isMobile: boolean, appState: AppState) => JSX.Element | null;
    showThemeBtn: boolean;
    onImageAction: (data: {
        insertOnCanvasDirectly: boolean;
    }) => void;
    renderTopRightUI?: (isMobile: boolean, appState: AppState) => JSX.Element | null;
    renderStats: () => JSX.Element | null;
};
export declare const MobileMenu: ({ appState, elements, libraryMenu, actionManager, renderJSONExportDialog, renderImageExportDialog, setAppState, onCollabButtonClick, onLockToggle, onPenModeToggle, canvas, allowedShapes, disableAlignItems, disableGrouping, disableHints, disableLink, disableShortcuts, disableVerticalAlignOptions, hideArrowHeadsOptions, fontSizeOptions, isCollaborating, hideClearCanvas, hideColorInput, hideFontFamily, hideIOActions, hideLayers, hideLibraries, hideLockButton, hideOpacityInput, hideSharpness, hideStrokeStyle, hideTextAlign, hideThemeControls, hideUserList, renderCustomFooter, showThemeBtn, onImageAction, renderTopRightUI, renderStats, }: MobileMenuProps) => JSX.Element;
export {};
