import React from "react";
import { ExcalidrawElement } from "../element/types";
import { AppClassProperties, AppState, ExcalidrawProps, BinaryFiles } from "../types";
export declare type ActionSource = "ui" | "keyboard" | "contextMenu" | "api";
/** if false, the action should be prevented */
export declare type ActionResult = {
    elements?: readonly ExcalidrawElement[] | null;
    appState?: MarkOptional<AppState, "offsetTop" | "offsetLeft" | "width" | "height"> | null;
    files?: BinaryFiles | null;
    commitToHistory: boolean;
    syncHistory?: boolean;
    replaceFiles?: boolean;
} | false;
declare type ActionFn = (elements: readonly ExcalidrawElement[], appState: Readonly<AppState>, formData: any, app: AppClassProperties) => ActionResult | Promise<ActionResult>;
export declare type UpdaterFn = (res: ActionResult) => void;
export declare type ActionFilterFn = (action: Action) => void;
export declare type ActionName = "copy" | "cut" | "paste" | "copyAsPng" | "copyAsSvg" | "copyText" | "sendBackward" | "bringForward" | "sendToBack" | "bringToFront" | "copyStyles" | "selectAll" | "pasteStyles" | "gridMode" | "zenMode" | "stats" | "changeStrokeColor" | "changeBackgroundColor" | "changeFillStyle" | "changeStrokeWidth" | "changeStrokeShape" | "changeSloppiness" | "changeStrokeStyle" | "changeArrowhead" | "changeOpacity" | "changeFontSize" | "toggleCanvasMenu" | "toggleEditMenu" | "undo" | "redo" | "finalize" | "changeProjectName" | "changeExportBackground" | "changeExportEmbedScene" | "changeExportScale" | "saveToActiveFile" | "saveFileToDisk" | "loadScene" | "duplicateSelection" | "deleteSelectedElements" | "changeViewBackgroundColor" | "clearCanvas" | "zoomIn" | "zoomOut" | "resetZoom" | "zoomToFit" | "zoomToSelection" | "changeFontFamily" | "changeTextAlign" | "changeVerticalAlign" | "toggleFullScreen" | "toggleShortcuts" | "group" | "ungroup" | "goToCollaborator" | "addToLibrary" | "changeSharpness" | "alignTop" | "alignBottom" | "alignLeft" | "alignRight" | "alignVerticallyCentered" | "alignHorizontallyCentered" | "distributeHorizontally" | "distributeVertically" | "flipHorizontal" | "flipVertical" | "viewMode" | "exportWithDarkMode" | "toggleTheme" | "increaseFontSize" | "decreaseFontSize" | "unbindText" | "hyperlink" | "eraser" | "bindText" | "toggleLock";
export declare type PanelComponentProps = {
    elements: readonly ExcalidrawElement[];
    appState: AppState;
    updateData: (formData?: any) => void;
    appProps: ExcalidrawProps;
    data?: Record<string, any>;
};
export interface Action {
    name: ActionName;
    PanelComponent?: React.FC<PanelComponentProps>;
    perform: ActionFn;
    keyPriority?: number;
    keyTest?: (event: React.KeyboardEvent | KeyboardEvent, appState: AppState, elements: readonly ExcalidrawElement[]) => boolean;
    contextItemLabel?: string | ((elements: readonly ExcalidrawElement[], appState: Readonly<AppState>) => string);
    contextItemPredicate?: (elements: readonly ExcalidrawElement[], appState: AppState) => boolean;
    checked?: (appState: Readonly<AppState>) => boolean;
    trackEvent: false | {
        category: "toolbar" | "element" | "canvas" | "export" | "history" | "menu" | "collab" | "hyperlink";
        action?: string;
        predicate?: (appState: Readonly<AppState>, elements: readonly ExcalidrawElement[], value: any) => boolean;
    };
}
export {};
