import { processColor } from 'react-native';
import type { IndicatorStyle, KeyboardAppearance } from './misc';
import type { GiphyThemePreset } from './giphyThemePreset';
type NativeColorValue = ReturnType<typeof processColor>;
type ColorValue = Exclude<NativeColorValue, null> | string;
export interface NativeGiphyTheme {
    preset?: GiphyThemePreset;
    handleBarColor?: NativeColorValue;
    emojiDrawerGradientBottomColor?: NativeColorValue;
    emojiDrawerGradientTopColor?: NativeColorValue;
    emojiDrawerScrollIndicatorStyle?: IndicatorStyle;
    emojiDrawerSeparatorColor?: NativeColorValue;
    searchBackButtonColor?: NativeColorValue;
    searchBarBackgroundColor?: NativeColorValue;
    searchBarCornerRadius?: number;
    searchBarPadding?: number;
    searchPlaceholderTextColor?: NativeColorValue;
    searchTextColor?: NativeColorValue;
    showSuggestionsBar?: boolean;
    suggestionCellBackgroundColor?: NativeColorValue;
    suggestionCellTextColor?: NativeColorValue;
    tabBarBackgroundAlpha?: number;
    tabBarSwitchDefaultColor?: NativeColorValue;
    tabBarSwitchSelectedColor?: NativeColorValue;
    avatarPlaceholderColor?: NativeColorValue;
    confirmationBackButtonColor?: NativeColorValue;
    confirmationSelectButtonColor?: NativeColorValue;
    confirmationSelectButtonTextColor?: NativeColorValue;
    confirmationViewOnGiphyColor?: NativeColorValue;
    usernameColor?: NativeColorValue;
    backgroundColorForLoadingCells?: NativeColorValue;
    cellCornerRadius?: number;
    fixedSizeCells?: boolean;
    stickerBackgroundColor?: NativeColorValue;
    keyboardAppearance?: KeyboardAppearance;
    backgroundColor?: NativeColorValue;
    defaultTextColor?: NativeColorValue;
    dialogOverlayBackgroundColor?: NativeColorValue;
    retryButtonBackgroundColor?: NativeColorValue;
    retryButtonTextColor?: NativeColorValue;
}
declare const THEME_COLOR_FIELDS: ("handleBarColor" | "emojiDrawerGradientBottomColor" | "emojiDrawerGradientTopColor" | "emojiDrawerSeparatorColor" | "searchBackButtonColor" | "searchBarBackgroundColor" | "searchPlaceholderTextColor" | "searchTextColor" | "suggestionCellBackgroundColor" | "suggestionCellTextColor" | "tabBarSwitchDefaultColor" | "tabBarSwitchSelectedColor" | "avatarPlaceholderColor" | "confirmationBackButtonColor" | "confirmationSelectButtonColor" | "confirmationSelectButtonTextColor" | "confirmationViewOnGiphyColor" | "usernameColor" | "backgroundColorForLoadingCells" | "stickerBackgroundColor" | "backgroundColor" | "defaultTextColor" | "dialogOverlayBackgroundColor" | "retryButtonBackgroundColor" | "retryButtonTextColor")[];
type ChangeThemeColorType<T> = {
    [P in keyof T]: P extends (typeof THEME_COLOR_FIELDS)[number] ? ColorValue : T[P];
};
export type GiphyTheme = ChangeThemeColorType<NativeGiphyTheme>;
export declare function serializeTheme(theme: GiphyTheme | GiphyThemePreset): NativeGiphyTheme;
export {};
//# sourceMappingURL=giphyTheme.d.ts.map