import React from 'react';
import type { ViewProps } from 'react-native';
import type { DirectEventHandler } from 'react-native/Libraries/Types/CodegenTypes';
import { type GiphyMedia } from './dto/giphyMedia';
import { type GiphyTheme } from './dto/giphyTheme';
import type { GiphyClipsRendition, GiphyRendition } from './dto/giphyRendition';
import type { GiphyContentRequest } from './dto/giphyContentRequest';
import type { GiphyDirection } from './dto/misc';
import type { GiphyThemePreset } from './dto/giphyThemePreset';
import { type GiphyGridViewContentUpdateEvent, type GiphyGridViewMediaScrollEvent } from './specs/GiphyGridViewNativeComponent';
export interface GiphyGridViewMediaSelectEvent {
    media: GiphyMedia;
}
export interface GiphyGridViewProps extends ViewProps {
    cellPadding?: number;
    clipsPreviewRenditionType?: GiphyClipsRendition;
    content?: GiphyContentRequest;
    disableEmojiVariations?: boolean;
    fixedSizeCells?: boolean;
    onContentUpdate?: DirectEventHandler<GiphyGridViewContentUpdateEvent>;
    onMediaSelect?: DirectEventHandler<GiphyGridViewMediaSelectEvent>;
    onScroll?: DirectEventHandler<GiphyGridViewMediaScrollEvent>;
    orientation?: GiphyDirection;
    renditionType?: GiphyRendition;
    showCheckeredBackground?: boolean;
    spanCount?: number;
    theme?: GiphyTheme | GiphyThemePreset;
}
export declare class GiphyGridView extends React.Component<GiphyGridViewProps, {}> {
    mediaSelectHandler: (e: any) => void | Promise<void>;
    render(): React.JSX.Element;
}
//# sourceMappingURL=GiphyGridView.d.ts.map