import { type EmitterSubscription } from 'react-native';
import type { GiphyClipsRendition, GiphyRendition } from './dto/giphyRendition';
import type { GiphyContentType } from './dto/giphyContentType';
import type { GiphyFileExtension } from './dto/giphyFileExtension';
import type { GiphyRating } from './dto/giphyRating';
import type { GiphyStickersColumnCount } from './dto/misc';
import { type GiphyMedia } from './dto/giphyMedia';
import { type GiphyTheme } from './dto/giphyTheme';
import { type GiphyThemePreset } from './dto/giphyThemePreset';
export declare const GiphyDialogEvent: {
    readonly MediaSelected: "onMediaSelect";
    readonly Dismissed: "onDismiss";
};
export type GiphyDialogEvent = (typeof GiphyDialogEvent)[keyof typeof GiphyDialogEvent];
export type GiphyDialogMediaSelectEventHandler = (e: {
    media: GiphyMedia;
}) => void;
export type GiphyDialogDismissEventHandler = (e: {}) => void;
export interface GiphyDialogConfig {
    clipsPreviewRenditionType?: GiphyClipsRendition;
    confirmationRenditionType?: GiphyRendition;
    enableDynamicText?: boolean;
    fileType?: GiphyFileExtension;
    mediaTypeConfig?: GiphyContentType[];
    rating?: GiphyRating;
    renditionType?: GiphyRendition;
    selectedContentType?: GiphyContentType;
    shouldLocalizeSearch?: boolean;
    showCheckeredBackground?: boolean;
    showConfirmationScreen?: boolean;
    showSuggestionsBar?: boolean;
    stickerColumnCount?: GiphyStickersColumnCount;
    theme?: GiphyTheme | GiphyThemePreset;
    trayHeightMultiplier?: number;
    enableEdgeToEdge?: boolean;
}
export declare const GiphyDialog: {
    addListener(eventType: GiphyDialogEvent, listener: (...args: any[]) => any, ...rest: any[]): EmitterSubscription;
    configure(config: GiphyDialogConfig): void;
    show(): void;
    hide(): void;
    removeAllListeners(eventType: string): void;
    listenerCount(eventType: string): number;
    emit(eventType: string, ...params: any[]): void;
};
//# sourceMappingURL=GiphyDialog.d.ts.map