import { GiphyMediaType } from './dto/giphyMediaType';
import { type GiphyContentRequest } from './dto/giphyContentRequest';
import { type GiphyRating } from './dto/giphyRating';
type GiphyContentRating = {
    rating?: GiphyRating;
};
export type GiphyContentSearchOptions = GiphyContentRating & {
    searchQuery: string;
    mediaType?: GiphyMediaType;
};
export type GiphyContentTrendingOptions = GiphyContentRating & {
    mediaType?: GiphyMediaType;
};
export type GiphyContentTrendingGIFsOptions = GiphyContentRating;
export type GiphyContentTrendingStickersOptions = GiphyContentRating;
export type GiphyContentTrendingTextOptions = GiphyContentRating;
export type GiphyContentRecentsOptions = GiphyContentRating;
export type GiphyContentEmojiOptions = GiphyContentRating;
export type GiphyContentAnimateOptions = GiphyContentRating & {
    searchQuery: string;
};
export declare class GiphyContent {
    static search(options: GiphyContentSearchOptions): GiphyContentRequest;
    static trending(options: GiphyContentTrendingOptions): GiphyContentRequest;
    static trendingGifs(options?: GiphyContentTrendingGIFsOptions): GiphyContentRequest;
    static trendingStickers(options?: GiphyContentTrendingStickersOptions): GiphyContentRequest;
    static trendingText(options?: GiphyContentTrendingTextOptions): GiphyContentRequest;
    static recents(options?: GiphyContentRecentsOptions): GiphyContentRequest;
    static emoji(options?: GiphyContentEmojiOptions): GiphyContentRequest;
    static animate(options: GiphyContentAnimateOptions): GiphyContentRequest;
}
export {};
//# sourceMappingURL=GiphyContent.d.ts.map