function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from 'react';
import { deserializeGiphyMedia } from './dto/giphyMedia';
import { serializeTheme } from './dto/giphyTheme';
import NativeGiphyGridView from './specs/GiphyGridViewNativeComponent';
export class GiphyGridView extends React.Component {
  mediaSelectHandler = e => {
    const {
      onMediaSelect
    } = this.props;
    if (!onMediaSelect) {
      return;
    }
    const media = JSON.parse(e.nativeEvent.media ?? '{}') || {};
    e.nativeEvent.media = deserializeGiphyMedia(media);
    return onMediaSelect(e);
  };
  render() {
    const {
      cellPadding = 0,
      clipsPreviewRenditionType = 'fixed_width',
      content,
      disableEmojiVariations = false,
      fixedSizeCells = false,
      onMediaSelect,
      orientation = 'vertical',
      renditionType = 'fixed_width',
      showCheckeredBackground = false,
      theme = 'light',
      ...other
    } = this.props;
    return /*#__PURE__*/React.createElement(NativeGiphyGridView, _extends({
      cellPadding: cellPadding,
      clipsPreviewRenditionType: clipsPreviewRenditionType,
      content: content ? JSON.stringify(content) : '',
      disableEmojiVariations: disableEmojiVariations,
      fixedSizeCells: fixedSizeCells,
      onMediaSelect: onMediaSelect ? this.mediaSelectHandler : undefined,
      orientation: orientation,
      renditionType: renditionType,
      showCheckeredBackground: showCheckeredBackground,
      theme: JSON.stringify(serializeTheme(theme))
    }, other));
  }
}
//# sourceMappingURL=GiphyGridView.js.map