"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GiphyDialogEvent = exports.GiphyDialog = void 0;
var _reactNative = require("react-native");
var _NativeGiphyDialog = _interopRequireDefault(require("./specs/NativeGiphyDialog"));
var _giphyMedia = require("./dto/giphyMedia");
var _GiphyVideoManager = require("./GiphyVideoManager");
var _noop = require("./utils/noop");
var _giphyTheme = require("./dto/giphyTheme");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const GiphyDialogEvent = {
  MediaSelected: 'onMediaSelect',
  Dismissed: 'onDismiss'
};
exports.GiphyDialogEvent = GiphyDialogEvent;
function wrapMediaSelectedListener(listener) {
  return e => {
    e.media = (0, _giphyMedia.deserializeGiphyMedia)(e.media ?? {});
    return listener(e);
  };
}
const GiphyDialog = new class GiphyDialog extends _reactNative.NativeEventEmitter {
  constructor() {
    super(_NativeGiphyDialog.default);
    // listener stubs
    this.addListener('onMediaSelect', _noop.noop);
    this.addListener('onDismiss', _noop.noop);
  }
  addListener(eventType, listener) {
    for (var _len = arguments.length, rest = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      rest[_key - 2] = arguments[_key];
    }
    if (eventType === 'onMediaSelect') {
      return super.addListener(eventType, wrapMediaSelectedListener(listener), ...rest);
    }
    return super.addListener(eventType, listener, ...rest);
  }
  configure(config) {
    _NativeGiphyDialog.default.configure({
      ...config,
      theme: (0, _giphyTheme.serializeTheme)(config.theme ?? 'light')
    });
  }
  show() {
    _GiphyVideoManager.GiphyVideoManager.pauseAll();
    _NativeGiphyDialog.default.show();
  }
  hide() {
    _NativeGiphyDialog.default.hide();
  }
}();
exports.GiphyDialog = GiphyDialog;
//# sourceMappingURL=GiphyDialog.js.map