"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GiphyContent = void 0;
var _giphyMediaType = require("./dto/giphyMediaType");
var _giphyContentRequest = require("./dto/giphyContentRequest");
function makeGiphyContentRequest(options) {
  return {
    searchQuery: '',
    mediaType: _giphyMediaType.GiphyMediaType.Gif,
    ...options
  };
}
class GiphyContent {
  static search(options) {
    return makeGiphyContentRequest({
      ...options,
      requestType: _giphyContentRequest.GiphyContentRequestType.Search
    });
  }
  static trending(options) {
    return makeGiphyContentRequest({
      ...options,
      requestType: _giphyContentRequest.GiphyContentRequestType.Trending
    });
  }
  static trendingGifs(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: _giphyMediaType.GiphyMediaType.Gif,
      requestType: _giphyContentRequest.GiphyContentRequestType.Trending
    });
  }
  static trendingStickers(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: _giphyMediaType.GiphyMediaType.Sticker,
      requestType: _giphyContentRequest.GiphyContentRequestType.Trending
    });
  }
  static trendingText(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: _giphyMediaType.GiphyMediaType.Text,
      requestType: _giphyContentRequest.GiphyContentRequestType.Trending
    });
  }
  static recents(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: _giphyMediaType.GiphyMediaType.Gif,
      requestType: _giphyContentRequest.GiphyContentRequestType.Recents
    });
  }
  static emoji(options) {
    return makeGiphyContentRequest({
      ...options,
      mediaType: _giphyMediaType.GiphyMediaType.Sticker,
      requestType: _giphyContentRequest.GiphyContentRequestType.Emoji
    });
  }
  static animate(options) {
    return makeGiphyContentRequest({
      ...options,
      requestType: _giphyContentRequest.GiphyContentRequestType.Animate
    });
  }
}
exports.GiphyContent = GiphyContent;
//# sourceMappingURL=GiphyContent.js.map