var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { pingback } from '@giphy/js-analytics';
import { getClientRect } from '@giphy/js-util';
var firePingback = function (actionType) { return function (gif, userId, target, attributes) {
    if (attributes === void 0) { attributes = {}; }
    if (!gif.analytics_response_payload) {
        return;
    }
    pingback({
        analyticsResponsePayload: gif.analytics_response_payload,
        userId: userId,
        actionType: actionType,
        attributes: __assign({ position: JSON.stringify(getClientRect(target)) }, attributes),
    });
}; };
// no target on this one
export var onGifSeen = function (gif, userId, position, attributes) {
    if (attributes === void 0) { attributes = {}; }
    if (!gif.analytics_response_payload) {
        return;
    }
    pingback({
        analyticsResponsePayload: gif.analytics_response_payload,
        userId: userId,
        actionType: 'SEEN',
        attributes: __assign({ position: JSON.stringify(position) }, attributes),
    });
};
export var onGifClick = firePingback('CLICK');
export var onGifHover = firePingback('HOVER');
//# sourceMappingURL=pingback.js.map