import 'intersection-observer';
import React, { useEffect, useRef } from 'react';
var Observer = function (_a) {
    var children = _a.children, className = _a.className, onVisibleChange = _a.onVisibleChange, config = _a.config;
    var container = useRef(null);
    useEffect(function () {
        var io;
        if (container.current) {
            io = new IntersectionObserver(function (_a) {
                var entry = _a[0];
                if (onVisibleChange)
                    onVisibleChange(entry.isIntersecting);
            }, config);
            io.observe(container.current);
        }
        return function () { return io === null || io === void 0 ? void 0 : io.disconnect(); };
    }, [onVisibleChange, container, config]);
    return (React.createElement("div", { ref: container, className: className }, children));
};
export default Observer;
//# sourceMappingURL=observer.js.map