var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import styled from '@emotion/styled';
import { getGifHeight, Logger } from '@giphy/js-util';
import React, { useCallback, useEffect, useState } from 'react';
import useTimeoutFn from 'react-use/lib/useTimeoutFn';
import Attribution from './attribution';
import { VolumeOffIcon, VolumeOnIcon } from './controls/volume';
import ProgressBar from './progress-bar';
import Video from './video';
var Container = styled.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    position: relative;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    background: black;\n    font-family: interface, helvetica, arial;\n    -webkit-font-smoothing: antialiased;\n"], ["\n    position: relative;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    background: black;\n    font-family: interface, helvetica, arial;\n    -webkit-font-smoothing: antialiased;\n"])));
var Volume = styled.div(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    position: relative;\n    cursor: pointer;\n"], ["\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    position: relative;\n    cursor: pointer;\n"])));
var Controls = styled.div(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n    position: absolute;\n    top: 10px;\n    right: 10px;\n    left: 10px;\n    bottom: 0;\n    display: flex;\n    justify-content: space-between;\n    opacity: ", ";\n    transition: opacity ease-out 250ms;\n    align-items: flex-start;\n"], ["\n    position: absolute;\n    top: 10px;\n    right: 10px;\n    left: 10px;\n    bottom: 0;\n    display: flex;\n    justify-content: space-between;\n    opacity: ", ";\n    transition: opacity ease-out 250ms;\n    align-items: flex-start;\n"])), function (props) { return (props.isHovered ? 1 : 0); });
var Title = styled.div(templateObject_4 || (templateObject_4 = __makeTemplateObject(["\n    font-size: 22px;\n    color: white;\n    margin-bottom: 5px;\n    font-weight: bold;\n    text-overflow: ellipsis;\n    overflow: hidden;\n    white-space: nowrap;\n    user-select: none;\n    cursor: pointer;\n"], ["\n    font-size: 22px;\n    color: white;\n    margin-bottom: 5px;\n    font-weight: bold;\n    text-overflow: ellipsis;\n    overflow: hidden;\n    white-space: nowrap;\n    user-select: none;\n    cursor: pointer;\n"])));
var TitleContainer = styled.div(templateObject_5 || (templateObject_5 = __makeTemplateObject(["\n    position: relative;\n    min-width: 0;\n"], ["\n    position: relative;\n    min-width: 0;\n"])));
var Gradient = styled.div(templateObject_6 || (templateObject_6 = __makeTemplateObject(["\n    &:before {\n        background: linear-gradient(rgba(18, 18, 18, 0.6), rgba(0, 0, 0, 0));\n        content: '';\n        height: ", "px;\n        left: 0;\n        pointer-events: none;\n        position: absolute;\n        top: 0;\n        width: 100%;\n    }\n    &:after {\n        background: linear-gradient(rgba(0, 0, 0, 0), rgba(18, 18, 18, 0.6));\n        content: '';\n        height: ", "px;\n        left: 0;\n        pointer-events: none;\n        position: absolute;\n        bottom: 0;\n        width: 100%;\n    }\n"], ["\n    &:before {\n        background: linear-gradient(rgba(18, 18, 18, 0.6), rgba(0, 0, 0, 0));\n        content: '';\n        height: ", "px;\n        left: 0;\n        pointer-events: none;\n        position: absolute;\n        top: 0;\n        width: 100%;\n    }\n    &:after {\n        background: linear-gradient(rgba(0, 0, 0, 0), rgba(18, 18, 18, 0.6));\n        content: '';\n        height: ", "px;\n        left: 0;\n        pointer-events: none;\n        position: absolute;\n        bottom: 0;\n        width: 100%;\n    }\n"])), function (props) { return (props.isLargePlayer ? 125 : 75); }, function (props) { return (props.isLargePlayer ? 125 : 75); });
var LARGE_PLAYER_HEIGHT = 300;
var AUTO_HIDE_TIMEOUT = 4000;
var VideoPlayer = function (props) {
    var width = props.width, hideMute = props.hideMute, hideAttribution = props.hideAttribution, hideProgressBar = props.hideProgressBar, className = props.className, persistentControls = props.persistentControls, gif = props.gif, Overlay = props.overlay;
    var _a = useState(false), isHovered = _a[0], setIsHovered = _a[1];
    var _b = useState(null), videoEl = _b[0], _setVideoEl = _b[1];
    var _c = useState(props.muted), muted = _c[0], setMuted = _c[1];
    var _d = useState(false), mutedByBrowser = _d[0], setMutedByBrowser = _d[1];
    var setVideoEl = props.setVideoEl, onMuted = props.onMuted, onUserMuted = props.onUserMuted;
    var height = props.height || getGifHeight(gif, width);
    var _e = useTimeoutFn(function () {
        setIsHovered(false);
    }, AUTO_HIDE_TIMEOUT), cancelHideTimeout = _e[1], resetHideTimeout = _e[2];
    var combinedOnMuted = useCallback(function (args) {
        onMuted === null || onMuted === void 0 ? void 0 : onMuted(args);
        setMutedByBrowser(args);
    }, [setMutedByBrowser, onMuted]);
    var combinedSetVideoEl = useCallback(function (args) {
        setVideoEl === null || setVideoEl === void 0 ? void 0 : setVideoEl(args);
        _setVideoEl(args);
    }, [setVideoEl, _setVideoEl]);
    var toggleMute = function () {
        if (mutedByBrowser) {
            setMutedByBrowser(false);
            setMuted(false);
        }
        else {
            setMuted(!muted);
        }
    };
    useEffect(function () {
        setMuted(props.muted);
    }, [props.muted]);
    var showControls = persistentControls || isHovered;
    var isLargePlayer = height >= LARGE_PLAYER_HEIGHT;
    // Manage auto hide controls
    useEffect(function () {
        if (showControls) {
            resetHideTimeout();
        }
        else {
            cancelHideTimeout();
        }
        return function () { return cancelHideTimeout(); };
    }, [showControls, cancelHideTimeout, resetHideTimeout]);
    return (React.createElement(Container, { className: className, style: { width: width, height: height }, onMouseOver: function () { return setIsHovered(true); }, onMouseLeave: function () { return setIsHovered(false); }, onMouseMove: function () {
            setIsHovered(true);
            resetHideTimeout();
        }, onClick: function (e) {
            // TODO on mobile, maybe here we'd want to not mute if
            // controls are hidden, mute and show controls are the same action
            // which could be annoying
            onUserMuted === null || onUserMuted === void 0 ? void 0 : onUserMuted(!(muted || mutedByBrowser));
            // adding this, it may save us if the browser blocks autoplay
            videoEl === null || videoEl === void 0 ? void 0 : videoEl.play();
            e.preventDefault();
            toggleMute();
        } },
        React.createElement(Video, __assign({}, props, { onMuted: combinedOnMuted, setVideoEl: combinedSetVideoEl, muted: muted })),
        showControls && React.createElement(Gradient, { isLargePlayer: isLargePlayer }),
        React.createElement(Controls, { isHovered: showControls },
            React.createElement(TitleContainer, null,
                isLargePlayer && (React.createElement(Title, { onClick: function (e) {
                        e.preventDefault();
                        e.stopPropagation();
                        window.open(gif.url, '_blank');
                    } }, gif.title)),
                videoEl && !hideAttribution ? React.createElement(Attribution, { gif: gif }) : null),
            !hideMute && React.createElement(Volume, null, muted || mutedByBrowser ? React.createElement(VolumeOffIcon, null) : React.createElement(VolumeOnIcon, null))),
        showControls && !hideProgressBar && videoEl ? React.createElement(ProgressBar, { videoEl: videoEl }) : null,
        Overlay && React.createElement(Overlay, { gif: gif, isHovered: isHovered, width: width, height: height })));
};
var VideoWrapper = function (props) {
    if (props.overlay && !props.controls) {
        console.warn("".concat(Logger.PREFIX, ": Overlays only work when controls are enabled"));
    }
    return props.controls ? React.createElement(VideoPlayer, __assign({}, props)) : React.createElement(Video, __assign({}, props));
};
export default VideoWrapper;
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6;
//# sourceMappingURL=index.js.map