var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
import { css } from '@emotion/react';
import styled from '@emotion/styled';
import { giphyBlack, giphyCharcoal, giphyIndigo, giphyLightGrey, giphyWhite } from '@giphy/js-brand';
import React, { useContext, useEffect, useRef, useState } from 'react';
import useDebounce from 'react-use/lib/useDebounce';
import CancelIcon from './cancel-icon';
import { SearchContext, _SearchContext } from './context';
import SearchBarChannel from './search-bar-channel';
import SearchButton from './search-button';
import { getSize } from './theme';
function usePrevious(value) {
    var ref = useRef(value);
    useEffect(function () {
        ref.current = value;
    });
    return ref.current;
}
var SEARCH_DEBOUNCE = 500;
var Container = styled.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    display: flex;\n    background: white;\n    align-items: center;\n    border-radius: 4px;\n    ", "\n"], ["\n    display: flex;\n    background: white;\n    align-items: center;\n    border-radius: 4px;\n    ", "\n"])), function (props) { return getSize(props.theme); });
var Input = styled.input(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n    background: ", ";\n    box-sizing: border-box;\n    border: 0;\n    appearance: none;\n    font-weight: normal;\n    font-family: interface, Helvetica Neue, helvetica, sans-serif;\n    outline: 0;\n    font-size: 15px;\n    padding: 0 10px;\n    border-radius: 0;\n    text-overflow: ellipsis;\n    color: ", ";\n    &::placeholder {\n        color: ", ";\n    }\n    min-width: 150px;\n    flex: 1;\n    ", "\n"], ["\n    background: ", ";\n    box-sizing: border-box;\n    border: 0;\n    appearance: none;\n    font-weight: normal;\n    font-family: interface, Helvetica Neue, helvetica, sans-serif;\n    outline: 0;\n    font-size: 15px;\n    padding: 0 10px;\n    border-radius: 0;\n    text-overflow: ellipsis;\n    color: ", ";\n    &::placeholder {\n        color: ", ";\n    }\n    min-width: 150px;\n    flex: 1;\n    ", "\n"])), function (props) { return (props.theme.mode === 'dark' ? giphyCharcoal : giphyWhite); }, function (props) { return (props.theme.mode === 'dark' ? giphyWhite : giphyBlack); }, function (props) { return (props.theme.mode === 'dark' ? giphyLightGrey : giphyLightGrey); }, function (props) {
    return props.isUsernameSearch && css(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n            color: ", ";\n        "], ["\n            color: ", ";\n        "])), giphyIndigo);
});
var SearchBar = function (_a) {
    var className = _a.className, _b = _a.placeholder, placeholder = _b === void 0 ? "Search GIPHY" : _b, _c = _a.clear, clear = _c === void 0 ? false : _c, autoFocus = _a.autoFocus, _d = _a.searchDebounce, searchDebounce = _d === void 0 ? SEARCH_DEBOUNCE : _d, onEnter = _a.onEnter;
    var _e = useContext(SearchContext), activeChannel = _e.activeChannel, setActiveChannel = _e.setActiveChannel, term = _e.term, setChannels = _e.setChannels;
    var _f = useContext(_SearchContext), setIsFocused = _f.setIsFocused, _inputValOverride = _f._inputValOverride, _setSearch = _f._setSearch;
    // the input val
    var _g = useState(term), val = _g[0], setVal = _g[1];
    // set the term when it changes after searchDebounce
    useDebounce(function () { return _setSearch(val); }, searchDebounce, [val]);
    // used only to focus the input
    var inputRef = useRef(null);
    // we'll use this to see when we went from no channel to channel
    var previousActiveChannel = usePrevious(activeChannel);
    var _h = useState(clear), isCleared = _h[0], setCleared = _h[1];
    useEffect(function () {
        var _a;
        if (autoFocus) {
            (_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [autoFocus]);
    useEffect(function () {
        var _a;
        // if we know have a channel, focus and clear the input
        // so the user can search the channel
        if (activeChannel && !previousActiveChannel) {
            (_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
            if (val === ' ') {
                // this doesn't come from a keystroke
                setVal('');
            }
            else {
                setVal(val.replace(/@?\w*\s?/, ''));
            }
        }
    }, [val, activeChannel, previousActiveChannel]);
    useEffect(function () {
        setCleared(clear);
    }, [clear]);
    // something is setting the input value
    useEffect(function () {
        setVal(_inputValOverride);
    }, [_inputValOverride, setVal]);
    // key ups to clear the active channel
    var onKeyUp = function (e) {
        var key = e.keyCode || e.key;
        switch (key) {
            case 27: // esc
            case "Escape": // esc
                setActiveChannel(undefined);
                setChannels([]);
                break;
            case 13: // esc
            case "Enter": // esc
                onEnter === null || onEnter === void 0 ? void 0 : onEnter(val);
                break;
            default:
                break;
        }
    };
    var onKeyDown = function (e) {
        var key = e.keyCode || e.key;
        switch (key) {
            case 8: // backspace
            case 'Backspace':
                if (val === '') {
                    setActiveChannel(undefined);
                    setChannels([]);
                }
                break;
            default:
                break;
        }
    };
    return (React.createElement(Container, { className: [SearchBar.className, className].join(' ') },
        React.createElement(SearchBarChannel, null),
        React.createElement(Input, { isUsernameSearch: term.indexOf('@') === 0, onChange: function (_a) {
                var value = _a.target.value;
                if (!isCleared || value !== '') {
                    setCleared(false);
                    setVal(value);
                }
            }, onFocus: function () {
                setIsFocused(true);
            }, onBlur: function () {
                setIsFocused(false);
            }, value: isCleared ? '' : val, placeholder: activeChannel ? "Search ".concat(activeChannel.display_name) : placeholder, autoCapitalize: "off", autoCorrect: "off", autoComplete: "off", ref: inputRef, onKeyUp: onKeyUp, onKeyDown: onKeyDown }),
        React.createElement(CancelIcon, { setCleared: function () { return setVal(''); } }),
        React.createElement(SearchButton, null)));
};
SearchBar.className = 'giphy-search-bar';
export default SearchBar;
var templateObject_1, templateObject_2, templateObject_3;
//# sourceMappingURL=index.js.map