import { IGif, IUser } from '@giphy/js-types';
import 'intersection-observer';
import React, { ElementType, SyntheticEvent } from 'react';
import { GifOverlayProps } from './types';
export declare const GRID_COLORS: string[];
export declare const getColor: () => string;
export type EventProps = {
    onGifVisible?: (gif: IGif, e?: SyntheticEvent<HTMLElement, Event>) => void;
    onGifSeen?: (gif: IGif, boundingClientRect: ClientRect | DOMRect) => void;
    onGifClick?: (gif: IGif, e: SyntheticEvent<HTMLElement, Event>) => void;
    onGifRightClick?: (gif: IGif, e: SyntheticEvent<HTMLElement, Event>) => void;
    onGifKeyPress?: (gif: IGif, e: SyntheticEvent<HTMLElement, Event>) => void;
};
type GifProps = {
    gif: IGif;
    width: number;
    height?: number;
    backgroundColor?: string;
    className?: string;
    user?: Partial<IUser>;
    overlay?: ElementType<GifOverlayProps>;
    hideAttribution?: boolean;
    noLink?: boolean;
    borderRadius?: number;
    tabIndex?: number;
    style?: any;
};
type Props = GifProps & EventProps;
declare const Gif: {
    ({ gif, width, height: forcedHeight, onGifRightClick, className, onGifClick, onGifKeyPress, onGifSeen, onGifVisible, user, backgroundColor, overlay, hideAttribution, noLink, borderRadius, style, tabIndex, }: Props): React.JSX.Element;
    className: string;
    imgClassName: string;
    imgLoadedClassName: string;
};
export default Gif;
