var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useEffect } from 'react';
import styled from '@emotion/styled';
import useAsyncFn from 'react-use/lib/useAsyncFn';
import useLatest from 'react-use/lib/useLatest';
import { giphyDarkGrey, giphyCharcoal } from '@giphy/js-brand';
import { getGifWidth } from '@giphy/js-util';
import FetchError from './fetch-error';
import Gif from './gif';
var DEFAULT_BG_COLOR = giphyDarkGrey;
var DEFAULT_DIVIDER_COLOR = giphyCharcoal;
var DIVIDER_RELATIVE_HEIGHT = 0.75;
var Root = styled.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    align-items: center;\n    background-color: ", ";\n    border-radius: 16px;\n    display: flex;\n    max-width: fit-content;\n    overflow: hidden;\n    padding: 4px 5px 5px 6px;\n"], ["\n    align-items: center;\n    background-color: ", ";\n    border-radius: 16px;\n    display: flex;\n    max-width: fit-content;\n    overflow: hidden;\n    padding: 4px 5px 5px 6px;\n"])), function (_a) {
    var backgroundColor = _a.backgroundColor;
    return backgroundColor;
});
var VariationsViewport = styled.div(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n    overflow-x: auto;\n    overflow-y: hidden;\n    position: relative;\n    -webkit-overflow-scrolling: touch;\n"], ["\n    overflow-x: auto;\n    overflow-y: hidden;\n    position: relative;\n    -webkit-overflow-scrolling: touch;\n"])));
var VariationsContainer = styled.div(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n    display: inline-flex;\n    justify-content: space-between;\n    overflow: hidden;\n    white-space: nowrap;\n    width: ", ";\n"], ["\n    display: inline-flex;\n    justify-content: space-between;\n    overflow: hidden;\n    white-space: nowrap;\n    width: ", ";\n"])), function (_a) {
    var width = _a.width;
    return "".concat(width, "px");
});
var Divider = styled.div(templateObject_4 || (templateObject_4 = __makeTemplateObject(["\n    background-color: ", ";\n    box-sizing: border-box;\n    height: ", ";\n    margin: ", ";\n    width: 2px;\n"], ["\n    background-color: ", ";\n    box-sizing: border-box;\n    height: ", ";\n    margin: ", ";\n    width: 2px;\n"])), function (_a) {
    var color = _a.color;
    return color;
}, function (_a) {
    var gifHeight = _a.gifHeight;
    return "".concat(Math.round(gifHeight * DIVIDER_RELATIVE_HEIGHT), "px");
}, function (_a) {
    var gutter = _a.gutter;
    return "0 ".concat(gutter, "px");
});
var Emoji = styled(Gif)(templateObject_5 || (templateObject_5 = __makeTemplateObject(["\n    display: inline-block;\n    flex-shrink: 0;\n    list-style: none;\n    /* make sure gifs are fully visible with a scrollbar */\n    margin-bottom: 1px;\n    position: relative;\n\n    .", " {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n"], ["\n    display: inline-block;\n    flex-shrink: 0;\n    list-style: none;\n    /* make sure gifs are fully visible with a scrollbar */\n    margin-bottom: 1px;\n    position: relative;\n\n    .", " {\n        position: absolute;\n        top: 0;\n        left: 0;\n    }\n"])), Gif.imgClassName);
export function EmojiVariationsList(props) {
    var _this = this;
    var _a;
    var _b = props.backgroundColor, backgroundColor = _b === void 0 ? DEFAULT_BG_COLOR : _b, className = props.className, _c = props.dividerColor, dividerColor = _c === void 0 ? DEFAULT_DIVIDER_COLOR : _c, fetchVariations = props.fetchVariations, gif = props.gif, gifHeight = props.gifHeight, _d = props.GifProps, GifProps = _d === void 0 ? {} : _d, gifWidthProp = props.gifWidth, _e = props.gutter, gutter = _e === void 0 ? 6 : _e, hideAttribution = props.hideAttribution, LoaderComponent = props.loader, noLink = props.noLink, onGifClick = props.onGifClick, onGifKeyPress = props.onGifKeyPress, onGifRightClick = props.onGifRightClick, onGifSeen = props.onGifSeen, onGifVisible = props.onGifVisible, onVariationsFetched = props.onVariationsFetched, overlay = props.overlay, _f = props.tabIndex, tabIndex = _f === void 0 ? 0 : _f, user = props.user, other = __rest(props, ["backgroundColor", "className", "dividerColor", "fetchVariations", "gif", "gifHeight", "GifProps", "gifWidth", "gutter", "hideAttribution", "loader", "noLink", "onGifClick", "onGifKeyPress", "onGifRightClick", "onGifSeen", "onGifVisible", "onVariationsFetched", "overlay", "tabIndex", "user"]);
    var variationCount = (_a = gif.variation_count) !== null && _a !== void 0 ? _a : 0;
    var gifWidth = gifWidthProp || getGifWidth(gif, gifHeight);
    var variationsContainerWidth = variationCount * gifWidth + Math.max(0, variationCount - 1) * gutter;
    var fetchVariationsRef = useLatest(fetchVariations);
    var onVariationsFetchedRef = useLatest(onVariationsFetched);
    var _g = useAsyncFn(function () { return __awaiter(_this, void 0, void 0, function () {
        var result, variations;
        var _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, fetchVariationsRef.current(gif.id)];
                case 1:
                    result = _b.sent();
                    variations = ((_a = result === null || result === void 0 ? void 0 : result.data) !== null && _a !== void 0 ? _a : []);
                    if (onVariationsFetchedRef.current) {
                        onVariationsFetchedRef.current(variations);
                    }
                    return [2 /*return*/, variations];
            }
        });
    }); }, [gif], { loading: true, value: [] }), variationsState = _g[0], syncVariations = _g[1];
    useEffect(function () {
        // noinspection JSIgnoredPromiseFromCall
        syncVariations();
    }, [syncVariations]);
    var emojiCommonProps = __assign({ backgroundColor: 'transparent', height: gifHeight, hideAttribution: hideAttribution, noLink: noLink, onGifClick: onGifClick, onGifKeyPress: onGifKeyPress, onGifRightClick: onGifRightClick, onGifSeen: onGifSeen, onGifVisible: onGifVisible, overlay: overlay, tabIndex: tabIndex, user: user, width: gifWidth }, GifProps);
    var getVariationsContent = function () {
        var _a;
        if (variationsState.loading) {
            return LoaderComponent ? React.createElement(LoaderComponent, { className: EmojiVariationsList.loaderClassName }) : null;
        }
        if (variationsState.error) {
            return React.createElement(FetchError, { onClick: syncVariations });
        }
        return (React.createElement(React.Fragment, null, ((_a = variationsState.value) !== null && _a !== void 0 ? _a : []).map(function (gif) { return (React.createElement(Emoji, __assign({}, emojiCommonProps, { key: gif.id, gif: gif }))); })));
    };
    return (React.createElement(Root, __assign({ backgroundColor: backgroundColor, className: [EmojiVariationsList.className, className].join(' ') }, other),
        React.createElement(Emoji, __assign({}, emojiCommonProps, { gif: gif })),
        variationCount ? (React.createElement(Divider, { className: EmojiVariationsList.dividerClassName, color: dividerColor, gifHeight: gifHeight, gutter: gutter })) : null,
        React.createElement(VariationsViewport, { className: EmojiVariationsList.variationsViewportClassName },
            React.createElement(VariationsContainer, { className: EmojiVariationsList.variationsContainerClassName, width: variationsContainerWidth }, getVariationsContent()))));
}
EmojiVariationsList.className = 'giphy-emoji-variations-list';
EmojiVariationsList.dividerClassName = 'giphy-emoji-variations-divider';
EmojiVariationsList.loaderClassName = 'giphy-emoji-variations-loader';
EmojiVariationsList.variationsViewportClassName = 'giphy-emoji-variations-viewport';
EmojiVariationsList.variationsContainerClassName = 'giphy-emoji-variations-container';
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5;
//# sourceMappingURL=emoji-variations-list.js.map