"use strict";
var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("@emotion/react");
var styled_1 = __importDefault(require("@emotion/styled"));
var js_brand_1 = require("@giphy/js-brand");
var react_2 = __importStar(require("react"));
var useDebounce_1 = __importDefault(require("react-use/lib/useDebounce"));
var cancel_icon_1 = __importDefault(require("./cancel-icon"));
var context_1 = require("./context");
var search_bar_channel_1 = __importDefault(require("./search-bar-channel"));
var search_button_1 = __importDefault(require("./search-button"));
var theme_1 = require("./theme");
function usePrevious(value) {
    var ref = (0, react_2.useRef)(value);
    (0, react_2.useEffect)(function () {
        ref.current = value;
    });
    return ref.current;
}
var SEARCH_DEBOUNCE = 500;
var Container = styled_1.default.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    display: flex;\n    background: white;\n    align-items: center;\n    border-radius: 4px;\n    ", "\n"], ["\n    display: flex;\n    background: white;\n    align-items: center;\n    border-radius: 4px;\n    ", "\n"])), function (props) { return (0, theme_1.getSize)(props.theme); });
var Input = styled_1.default.input(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n    background: ", ";\n    box-sizing: border-box;\n    border: 0;\n    appearance: none;\n    font-weight: normal;\n    font-family: interface, Helvetica Neue, helvetica, sans-serif;\n    outline: 0;\n    font-size: 15px;\n    padding: 0 10px;\n    border-radius: 0;\n    text-overflow: ellipsis;\n    color: ", ";\n    &::placeholder {\n        color: ", ";\n    }\n    min-width: 150px;\n    flex: 1;\n    ", "\n"], ["\n    background: ", ";\n    box-sizing: border-box;\n    border: 0;\n    appearance: none;\n    font-weight: normal;\n    font-family: interface, Helvetica Neue, helvetica, sans-serif;\n    outline: 0;\n    font-size: 15px;\n    padding: 0 10px;\n    border-radius: 0;\n    text-overflow: ellipsis;\n    color: ", ";\n    &::placeholder {\n        color: ", ";\n    }\n    min-width: 150px;\n    flex: 1;\n    ", "\n"])), function (props) { return (props.theme.mode === 'dark' ? js_brand_1.giphyCharcoal : js_brand_1.giphyWhite); }, function (props) { return (props.theme.mode === 'dark' ? js_brand_1.giphyWhite : js_brand_1.giphyBlack); }, function (props) { return (props.theme.mode === 'dark' ? js_brand_1.giphyLightGrey : js_brand_1.giphyLightGrey); }, function (props) {
    return props.isUsernameSearch && (0, react_1.css)(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n            color: ", ";\n        "], ["\n            color: ", ";\n        "])), js_brand_1.giphyIndigo);
});
var SearchBar = function (_a) {
    var className = _a.className, _b = _a.placeholder, placeholder = _b === void 0 ? "Search GIPHY" : _b, _c = _a.clear, clear = _c === void 0 ? false : _c, autoFocus = _a.autoFocus, _d = _a.searchDebounce, searchDebounce = _d === void 0 ? SEARCH_DEBOUNCE : _d, onEnter = _a.onEnter;
    var _e = (0, react_2.useContext)(context_1.SearchContext), activeChannel = _e.activeChannel, setActiveChannel = _e.setActiveChannel, term = _e.term, setChannels = _e.setChannels;
    var _f = (0, react_2.useContext)(context_1._SearchContext), setIsFocused = _f.setIsFocused, _inputValOverride = _f._inputValOverride, _setSearch = _f._setSearch;
    // the input val
    var _g = (0, react_2.useState)(term), val = _g[0], setVal = _g[1];
    // set the term when it changes after searchDebounce
    (0, useDebounce_1.default)(function () { return _setSearch(val); }, searchDebounce, [val]);
    // used only to focus the input
    var inputRef = (0, react_2.useRef)(null);
    // we'll use this to see when we went from no channel to channel
    var previousActiveChannel = usePrevious(activeChannel);
    var _h = (0, react_2.useState)(clear), isCleared = _h[0], setCleared = _h[1];
    (0, react_2.useEffect)(function () {
        var _a;
        if (autoFocus) {
            (_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [autoFocus]);
    (0, react_2.useEffect)(function () {
        var _a;
        // if we know have a channel, focus and clear the input
        // so the user can search the channel
        if (activeChannel && !previousActiveChannel) {
            (_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
            if (val === ' ') {
                // this doesn't come from a keystroke
                setVal('');
            }
            else {
                setVal(val.replace(/@?\w*\s?/, ''));
            }
        }
    }, [val, activeChannel, previousActiveChannel]);
    (0, react_2.useEffect)(function () {
        setCleared(clear);
    }, [clear]);
    // something is setting the input value
    (0, react_2.useEffect)(function () {
        setVal(_inputValOverride);
    }, [_inputValOverride, setVal]);
    // key ups to clear the active channel
    var onKeyUp = function (e) {
        var key = e.keyCode || e.key;
        switch (key) {
            case 27: // esc
            case "Escape": // esc
                setActiveChannel(undefined);
                setChannels([]);
                break;
            case 13: // esc
            case "Enter": // esc
                onEnter === null || onEnter === void 0 ? void 0 : onEnter(val);
                break;
            default:
                break;
        }
    };
    var onKeyDown = function (e) {
        var key = e.keyCode || e.key;
        switch (key) {
            case 8: // backspace
            case 'Backspace':
                if (val === '') {
                    setActiveChannel(undefined);
                    setChannels([]);
                }
                break;
            default:
                break;
        }
    };
    return (react_2.default.createElement(Container, { className: [SearchBar.className, className].join(' ') },
        react_2.default.createElement(search_bar_channel_1.default, null),
        react_2.default.createElement(Input, { isUsernameSearch: term.indexOf('@') === 0, onChange: function (_a) {
                var value = _a.target.value;
                if (!isCleared || value !== '') {
                    setCleared(false);
                    setVal(value);
                }
            }, onFocus: function () {
                setIsFocused(true);
            }, onBlur: function () {
                setIsFocused(false);
            }, value: isCleared ? '' : val, placeholder: activeChannel ? "Search ".concat(activeChannel.display_name) : placeholder, autoCapitalize: "off", autoCorrect: "off", autoComplete: "off", ref: inputRef, onKeyUp: onKeyUp, onKeyDown: onKeyDown }),
        react_2.default.createElement(cancel_icon_1.default, { setCleared: function () { return setVal(''); } }),
        react_2.default.createElement(search_button_1.default, null)));
};
SearchBar.className = 'giphy-search-bar';
exports.default = SearchBar;
var templateObject_1, templateObject_2, templateObject_3;
//# sourceMappingURL=index.js.map