"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports._SearchContext = exports.SearchContext = void 0;
var react_1 = require("@emotion/react");
var js_fetch_api_1 = require("@giphy/js-fetch-api");
var js_util_1 = require("@giphy/js-util");
var react_2 = __importStar(require("react"));
var pingback_context_manager_1 = __importDefault(require("../pingback-context-manager"));
var theme_1 = require("./theme");
exports.SearchContext = (0, react_2.createContext)({});
// for internal components
exports._SearchContext = (0, react_2.createContext)({});
var emptyChannels = [];
var emptyGifsResult = {
    data: [],
    pagination: { total_count: 0, count: 0, offset: 0 },
    meta: { status: 200, msg: 'OK', response_id: '' },
};
var SearchContextManager = function (_a) {
    var _b, _c;
    var children = _a.children, _d = _a.options, options = _d === void 0 ? {} : _d, apiKey = _a.apiKey, theme = _a.theme, _e = _a.initialTerm, initialTerm = _e === void 0 ? '' : _e, initialChannel = _a.initialChannel, _f = _a.shouldDefaultToTrending, shouldDefaultToTrending = _f === void 0 ? true : _f, _g = _a.shouldFetchChannels, shouldFetchChannels = _g === void 0 ? true : _g;
    var gf = (0, react_2.useMemo)(function () { return new js_fetch_api_1.GiphyFetch(apiKey); }, [apiKey]);
    var _h = (0, react_2.useState)([]), currentChannels = _h[0], setChannels = _h[1];
    // the input value
    var _j = (0, react_2.useState)(initialTerm), term = _j[0], _setSearch = _j[1];
    // will replace the current input value with this value
    // until the user types again.
    // there needs to be a second state otherwise
    // with the input value being debounced, there seems to be a race condition that
    // manifests in Cypress tests
    var _k = (0, react_2.useState)(initialTerm), _inputValOverride = _k[0], setSearch = _k[1];
    var _l = (0, react_2.useState)(false), isFetching = _l[0], setIsFetching = _l[1];
    // active channel we're searching and displaying in the search bar
    var _m = (0, react_2.useState)(initialChannel), activeChannel = _m[0], _setActiveChannel = _m[1];
    var setActiveChannel = (0, react_2.useCallback)(function (activeChannel) {
        _setSearch('');
        _setActiveChannel(activeChannel);
    }, []);
    // fetched list of trending search terms
    var _o = (0, react_2.useState)([]), trendingSearches = _o[0], setTrendingSearches = _o[1];
    var _p = (0, react_2.useState)(false), isFocused = _p[0], setIsFocused = _p[1];
    var searchKey = [term, options.type, ((_b = activeChannel === null || activeChannel === void 0 ? void 0 : activeChannel.user) === null || _b === void 0 ? void 0 : _b.username) || ''].filter(function (val) { return !!val; }).join(' / ');
    // search fetch
    var fetchGifs = (0, react_2.useCallback)(function (offset) { return __awaiter(void 0, void 0, void 0, function () {
        var result;
        var _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    setIsFetching(true);
                    result = emptyGifsResult;
                    if (!term) return [3 /*break*/, 2];
                    return [4 /*yield*/, gf.search(term, __assign(__assign({}, options), { offset: offset, channel: (_a = activeChannel === null || activeChannel === void 0 ? void 0 : activeChannel.user) === null || _a === void 0 ? void 0 : _a.username }))];
                case 1:
                    result = _b.sent();
                    return [3 /*break*/, 4];
                case 2:
                    if (!shouldDefaultToTrending) return [3 /*break*/, 4];
                    return [4 /*yield*/, gf.trending(__assign(__assign({}, options), { offset: offset }))];
                case 3:
                    result = _b.sent();
                    _b.label = 4;
                case 4:
                    setIsFetching(false);
                    return [2 /*return*/, result];
            }
        });
    }); }, [(_c = activeChannel === null || activeChannel === void 0 ? void 0 : activeChannel.user) === null || _c === void 0 ? void 0 : _c.username, gf, options, term, shouldDefaultToTrending]);
    var fetchAnimatedText = (0, react_2.useCallback)(function (offset) { return __awaiter(void 0, void 0, void 0, function () {
        var limit, result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    limit = options.limit || 50;
                    return [4 /*yield*/, gf.animate(term, { offset: offset, limit: limit })];
                case 1:
                    result = _a.sent();
                    if (!result.pagination) {
                        result.pagination = { count: limit, total_count: limit, offset: offset };
                    }
                    return [2 /*return*/, result];
            }
        });
    }); }, [gf, options.limit, term]);
    var fetchChannelSearch = (0, react_2.useCallback)(function (offset) { return __awaiter(void 0, void 0, void 0, function () {
        var search, result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    search = term.indexOf('@') === 0 ? term.split(' ')[0] : term;
                    return [4 /*yield*/, gf.channels(search, { offset: offset })];
                case 1:
                    result = _a.sent();
                    return [2 /*return*/, result.data];
            }
        });
    }); }, [gf, term]);
    (0, react_2.useEffect)(function () {
        var fetchTrendingSearches = function () { return __awaiter(void 0, void 0, void 0, function () {
            var searches, _a, data, error_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        searches = [];
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, (0, js_fetch_api_1.request)("trending/searches?api_key=".concat(apiKey))];
                    case 2:
                        _a = (_b.sent()).data, data = _a === void 0 ? [] : _a;
                        searches = data;
                        return [3 /*break*/, 4];
                    case 3:
                        error_1 = _b.sent();
                        js_util_1.Logger.warn("Trending searches request failed: ".concat(error_1));
                        return [3 /*break*/, 4];
                    case 4:
                        setTrendingSearches(searches);
                        return [2 /*return*/];
                }
            });
        }); };
        fetchTrendingSearches();
    }, [apiKey]);
    // set active channel based on search
    (0, react_2.useEffect)(function () {
        var foundChannel = currentChannels.find(function (_a) {
            var slug = _a.slug;
            return term.indexOf("@".concat(slug, " ")) === 0;
        });
        if (foundChannel) {
            _setActiveChannel(foundChannel);
        }
    }, [term, currentChannels, _setActiveChannel]);
    // fetch when term changes
    (0, react_2.useEffect)(function () {
        if (shouldFetchChannels) {
            var fetchChannels = function () { return __awaiter(void 0, void 0, void 0, function () {
                var channels;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4 /*yield*/, fetchChannelSearch(0)];
                        case 1:
                            channels = _a.sent();
                            setChannels(channels || emptyChannels);
                            return [2 /*return*/];
                    }
                });
            }); };
            if (!activeChannel && term.replace('@', '')) {
                fetchChannels();
            }
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [term, activeChannel]);
    return (react_2.default.createElement(exports.SearchContext.Provider, { value: {
            activeChannel: activeChannel,
            setChannels: setChannels,
            currentChannels: currentChannels,
            setActiveChannel: setActiveChannel,
            fetchChannelSearch: fetchChannelSearch,
            term: term,
            trendingSearches: trendingSearches,
            setSearch: setSearch,
            fetchGifs: fetchGifs,
            fetchAnimatedText: fetchAnimatedText,
            searchKey: searchKey,
            isFetching: isFetching,
            isFocused: isFocused,
        } },
        react_2.default.createElement(exports._SearchContext.Provider, { value: { setIsFocused: setIsFocused, _setSearch: _setSearch, _inputValOverride: _inputValOverride } },
            react_2.default.createElement(react_1.ThemeProvider, { theme: (0, theme_1.initTheme)(theme) },
                react_2.default.createElement(pingback_context_manager_1.default, { attributes: { layout_type: 'SEARCH' } }, children)))));
};
exports.default = SearchContextManager;
//# sourceMappingURL=context.js.map