import { GifsResult } from '@giphy/js-fetch-api';
import { IGif, IUser } from '@giphy/js-types';
import React, { ElementType, GetDerivedStateFromProps, PureComponent } from 'react';
import { debounce } from 'throttle-debounce';
import { EventProps } from './gif';
import type { GifOverlayProps } from './types';
type Props = {
    className?: string;
    width: number;
    user: Partial<IUser>;
    columns: number;
    gutter: number;
    layoutType?: 'GRID' | 'MIXED';
    fetchGifs: (offset: number) => Promise<GifsResult>;
    onGifsFetched?: (gifs: IGif[]) => void;
    onGifsFetchError?: (e: Error) => void;
    overlay?: ElementType<GifOverlayProps>;
    hideAttribution?: boolean;
    noLink?: boolean;
    noResultsMessage?: string | JSX.Element;
    initialGifs?: IGif[];
    useTransform?: boolean;
    columnOffsets?: number[];
    backgroundColor?: string;
    borderRadius?: number;
    tabIndex?: number;
    loaderConfig?: IntersectionObserverInit;
    loader?: ElementType;
} & EventProps;
type State = {
    gifWidth: number;
    isFetching: boolean;
    isError: boolean;
    gifs: IGif[];
    isLoaderVisible: boolean;
    isDoneFetching: boolean;
};
declare class Grid extends PureComponent<Props, State> {
    static className: string;
    static loaderClassName: string;
    static fetchDebounce: number;
    static readonly defaultProps: Readonly<{
        gutter: 6;
        user: {};
        initialGifs: never[];
    }>;
    readonly state: {
        gifs: IGif[];
        isFetching: false;
        isError: false;
        gifWidth: 0;
        isLoaderVisible: false;
        isDoneFetching: false;
    };
    bricks?: any;
    el?: HTMLDivElement | null;
    unmounted: boolean;
    paginator: () => Promise<IGif[]>;
    static getDerivedStateFromProps: GetDerivedStateFromProps<Props, State>;
    componentDidMount(): void;
    componentWillUnmount(): void;
    onLoaderVisible: (isVisible: boolean) => void;
    fetchGifs: debounce<(prefetchCount: any) => Promise<void>>;
    onFetch: () => Promise<void>;
    render(): React.JSX.Element;
}
export default Grid;
