"use strict";
var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getColor = exports.GRID_COLORS = void 0;
var react_1 = require("@emotion/react");
var styled_1 = __importDefault(require("@emotion/styled"));
var js_brand_1 = require("@giphy/js-brand");
var js_util_1 = require("@giphy/js-util");
require("intersection-observer");
var react_2 = __importStar(require("react"));
var pingback = __importStar(require("../util/pingback"));
var overlay_1 = __importDefault(require("./attribution/overlay"));
var verified_badge_1 = __importDefault(require("./attribution/verified-badge"));
var pingback_context_manager_1 = require("./pingback-context-manager");
var GifContainer = styled_1.default.div(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n    display: block;\n    &:focus {\n        outline: unset;\n    }\n    ", "\n    img {\n        display: block;\n    }\n    .", " {\n        g {\n            fill: white;\n        }\n    }\n    .", " {\n        opacity: 0;\n    }\n"], ["\n    display: block;\n    &:focus {\n        outline: unset;\n    }\n    ", "\n    img {\n        display: block;\n    }\n    .", " {\n        g {\n            fill: white;\n        }\n    }\n    .", " {\n        opacity: 0;\n    }\n"])), function (props) {
    return props.borderRadius && (0, react_1.css)(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n            border-radius: ", "px;\n            overflow: hidden;\n        "], ["\n            border-radius: ", "px;\n            overflow: hidden;\n        "])), props.borderRadius);
}, verified_badge_1.default.className, verified_badge_1.default.checkMarkClassName);
exports.GRID_COLORS = [js_brand_1.giphyBlue, js_brand_1.giphyGreen, js_brand_1.giphyPurple, js_brand_1.giphyRed, js_brand_1.giphyYellow];
var getColor = function () { return exports.GRID_COLORS[Math.round(Math.random() * (exports.GRID_COLORS.length - 1))]; };
exports.getColor = getColor;
var hoverTimeoutDelay = 200;
var Container = function (props) { return (react_2.default.createElement(GifContainer, __assign({ as: props.href ? 'a' : 'div' }, props))); };
var placeholder = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
// used to detect if we're on the server or client
var canUseDOM = !!(typeof window !== 'undefined' && window.document && window.document.createElement);
var noop = function () { };
var RenderOnClient = function (_a) {
    var children = _a.children;
    var _b = (0, react_2.useState)(false), render = _b[0], setRender = _b[1];
    (0, react_2.useEffect)(function () {
        setRender(true);
    }, []);
    return render ? react_2.default.createElement(react_2.default.Fragment, null, children) : null;
};
var Gif = function (_a) {
    var gif = _a.gif, width = _a.width, forcedHeight = _a.height, _b = _a.onGifRightClick, onGifRightClick = _b === void 0 ? noop : _b, _c = _a.className, className = _c === void 0 ? '' : _c, _d = _a.onGifClick, onGifClick = _d === void 0 ? noop : _d, _e = _a.onGifKeyPress, onGifKeyPress = _e === void 0 ? noop : _e, _f = _a.onGifSeen, onGifSeen = _f === void 0 ? noop : _f, _g = _a.onGifVisible, onGifVisible = _g === void 0 ? noop : _g, _h = _a.user, user = _h === void 0 ? {} : _h, backgroundColor = _a.backgroundColor, overlay = _a.overlay, _j = _a.hideAttribution, hideAttribution = _j === void 0 ? false : _j, _k = _a.noLink, noLink = _k === void 0 ? false : _k, _l = _a.borderRadius, borderRadius = _l === void 0 ? 4 : _l, style = _a.style, tabIndex = _a.tabIndex;
    // only fire seen once per gif id
    var _m = (0, react_2.useState)(false), hasFiredSeen = _m[0], setHasFiredSeen = _m[1];
    // hovered is for the gif overlay
    var _o = (0, react_2.useState)(false), isHovered = _o[0], setHovered = _o[1];
    // only show the gif if it's on the screen
    // if we can't use the dom (SSR), then we show the gif by default
    var _p = (0, react_2.useState)(!canUseDOM), shouldShowMedia = _p[0], setShouldShowMedia = _p[1];
    // classname to target animations on image load
    var _q = (0, react_2.useState)(''), loadedClassname = _q[0], setLoadedClassName = _q[1];
    // the background color shouldn't change unless it comes from a prop or we have a sticker
    var defaultBgColor = (0, react_2.useRef)((0, exports.getColor)());
    // the a tag the media is rendered into
    var container = (0, react_2.useRef)(null);
    // to play it safe when using SSR, we check image.complete after mount
    var image = (0, react_2.useRef)(null);
    // intersection observer with no threshold
    var showGifObserver = (0, react_2.useRef)();
    // intersection observer with a threshold of 1 (full element is on screen)
    var fullGifObserver = (0, react_2.useRef)();
    // fire hover pingback after this timeout
    var hoverTimeout = (0, react_2.useRef)();
    // fire onseen ref (changes per gif, so need a ref)
    var sendOnSeen = (0, react_2.useRef)(noop);
    // custom pingback
    var attributes = (0, react_2.useContext)(pingback_context_manager_1.PingbackContext).attributes;
    // user's overlay
    var Overlay = overlay;
    if (!Overlay && !hideAttribution) {
        // no user overlay, and no force hide of the attribution
        Overlay = overlay_1.default;
    }
    var onMouseOver = function (e) {
        clearTimeout(hoverTimeout.current);
        e.persist();
        setHovered(true);
        hoverTimeout.current = window.setTimeout(function () {
            pingback.onGifHover(gif, user === null || user === void 0 ? void 0 : user.id, e.target, attributes);
        }, hoverTimeoutDelay);
    };
    var onMouseLeave = function () {
        clearTimeout(hoverTimeout.current);
        setHovered(false);
    };
    var onClick = function (e) {
        // fire pingback
        pingback.onGifClick(gif, user === null || user === void 0 ? void 0 : user.id, e.target, attributes);
        onGifClick(gif, e);
    };
    var onKeyPress = function (e) {
        onGifKeyPress(gif, e);
    };
    // using a ref in case `gif` changes
    sendOnSeen.current = function (entry) {
        // flag so we don't observe any more
        setHasFiredSeen(true);
        js_util_1.Logger.debug("GIF ".concat(gif.id, " seen. ").concat(gif.title));
        // fire pingback
        pingback.onGifSeen(gif, user === null || user === void 0 ? void 0 : user.id, entry.boundingClientRect, attributes);
        // fire custom onGifSeen
        onGifSeen === null || onGifSeen === void 0 ? void 0 : onGifSeen(gif, entry.boundingClientRect);
        // disconnect
        if (fullGifObserver.current) {
            fullGifObserver.current.disconnect();
        }
    };
    var watchGif = function () {
        if (!fullGifObserver.current) {
            fullGifObserver.current = new IntersectionObserver(function (_a) {
                var entry = _a[0];
                if (entry.isIntersecting) {
                    sendOnSeen.current(entry);
                }
            }, { threshold: [0.99] });
        }
        if (!hasFiredSeen && container.current && fullGifObserver.current) {
            // observe img for full gif view
            fullGifObserver.current.observe(container.current);
        }
    };
    var onImageLoad = function (e) {
        watchGif();
        onGifVisible(gif, e); // gif is visible, perhaps just partially
        setLoadedClassName(Gif.imgLoadedClassName);
    };
    (0, react_2.useEffect)(function () {
        var _a, _b;
        // the id has changed, maybe the image has loaded
        if ((_a = image.current) === null || _a === void 0 ? void 0 : _a.complete) {
            watchGif();
            onGifVisible(gif); // gif is visible, perhaps just partially
        }
        (_b = fullGifObserver.current) === null || _b === void 0 ? void 0 : _b.disconnect();
        setHasFiredSeen(false);
        // We only want to fire this when gif id changes
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [gif.id]);
    (0, react_2.useEffect)(function () {
        showGifObserver.current = new IntersectionObserver(function (_a) {
            var entry = _a[0];
            var isIntersecting = entry.isIntersecting;
            // show the gif if the container is on the screen
            setShouldShowMedia(isIntersecting);
            // remove the fullGifObserver if we go off the screen
            // we may have already disconnected if the hasFiredSeen happened
            if (!isIntersecting && fullGifObserver.current) {
                fullGifObserver.current.disconnect();
            }
        });
        showGifObserver.current.observe(container.current);
        return function () {
            if (showGifObserver.current)
                showGifObserver.current.disconnect();
            if (fullGifObserver.current)
                fullGifObserver.current.disconnect();
            if (hoverTimeout.current)
                clearTimeout(hoverTimeout.current);
        };
    }, []);
    var height = forcedHeight || (0, js_util_1.getGifHeight)(gif, width);
    var bestRendition = (0, js_util_1.getBestRendition)(gif.images, width, height);
    var rendition = gif.images[bestRendition.renditionName];
    var background = backgroundColor || // <- specified background prop
        // sticker has black if no backgroundColor is specified
        (gif.is_sticker
            ? "url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADgAAAA4AQMAAACSSKldAAAABlBMVEUhIiIWFhYoSqvJAAAAGElEQVQY02MAAv7///8PWxqIPwDZw5UGABtgwz2xhFKxAAAAAElFTkSuQmCC') 0 0"
            : defaultBgColor.current);
    return (react_2.default.createElement(Container, { href: noLink ? undefined : gif.url, "data-giphy-id": gif.id, "data-giphy-is-sticker": gif.is_sticker, style: __assign({ width: width, height: height }, style), borderRadius: borderRadius, className: [Gif.className, className].join(' '), onMouseOver: onMouseOver, onMouseLeave: onMouseLeave, onClick: onClick, onContextMenu: function (e) { return onGifRightClick(gif, e); }, onKeyPress: onKeyPress, tabIndex: tabIndex },
        react_2.default.createElement("div", { style: { width: width, height: height, position: 'relative' }, ref: container },
            react_2.default.createElement("picture", null,
                react_2.default.createElement("source", { type: "image/webp", srcSet: shouldShowMedia ? rendition.webp : placeholder, suppressHydrationWarning: true }),
                react_2.default.createElement("img", { ref: image, suppressHydrationWarning: true, className: [Gif.imgClassName, loadedClassname].join(' '), src: shouldShowMedia ? rendition.url : placeholder, style: { background: background }, width: width, height: height, alt: (0, js_util_1.getAltText)(gif), onLoad: shouldShowMedia ? onImageLoad : function () { } })),
            Overlay && (
            // only render the overlay on the client since it depends on shouldShowMedia
            react_2.default.createElement(RenderOnClient, null, shouldShowMedia && react_2.default.createElement(Overlay, { gif: gif, isHovered: isHovered, width: width, height: height }))))));
};
Gif.className = 'giphy-gif';
Gif.imgClassName = 'giphy-gif-img';
Gif.imgLoadedClassName = 'giphy-img-loaded';
exports.default = Gif;
var templateObject_1, templateObject_2;
//# sourceMappingURL=gif.js.map