import React, { ElementType } from 'react';
import type { GifID, IGif, IUser } from '@giphy/js-types';
import type { NonPaginatedGifsResult } from '@giphy/js-fetch-api';
import Gif, { EventProps } from './gif';
import type { GifOverlayProps } from './types';
export type EmojiVariationsListProps = {
    backgroundColor?: string;
    dividerColor?: string;
    fetchVariations: (gifId: GifID) => Promise<NonPaginatedGifsResult>;
    gif: IGif;
    gifHeight: number;
    GifProps?: Partial<React.ComponentProps<typeof Gif>>;
    gifWidth?: number;
    gutter?: number;
    hideAttribution?: boolean;
    loader?: ElementType;
    noLink?: boolean;
    onVariationsFetched?: (gifs: IGif[]) => void;
    overlay?: ElementType<GifOverlayProps>;
    tabIndex?: number;
    user?: Partial<IUser>;
} & EventProps & React.ComponentProps<'div'>;
export declare function EmojiVariationsList(props: EmojiVariationsListProps): React.JSX.Element;
export declare namespace EmojiVariationsList {
    var className: string;
    var dividerClassName: string;
    var loaderClassName: string;
    var variationsViewportClassName: string;
    var variationsContainerClassName: string;
}
