"use strict";
var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var styled_1 = __importDefault(require("@emotion/styled"));
var react_1 = __importDefault(require("react"));
var avatar_1 = __importDefault(require("./avatar"));
var user_1 = __importDefault(require("./user"));
var Container = styled_1.default.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    display: flex;\n    align-items: center;\n    font-family: interface, helvetica, arial;\n"], ["\n    display: flex;\n    align-items: center;\n    font-family: interface, helvetica, arial;\n"])));
var Avatar = (0, styled_1.default)(avatar_1.default)(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n    flex-shrink: 0;\n"], ["\n    flex-shrink: 0;\n"])));
var Attribution = function (_a) {
    var gif = _a.gif, className = _a.className, onClick = _a.onClick;
    var user = gif.user;
    if (!(user === null || user === void 0 ? void 0 : user.username) && !(user === null || user === void 0 ? void 0 : user.display_name)) {
        return null;
    }
    return (react_1.default.createElement(Container, { className: [Attribution.className, className].join(' '), onClick: function (e) {
            e.preventDefault();
            e.stopPropagation();
            if (onClick) {
                onClick(gif);
            }
            else {
                var url = user.profile_url;
                if (url)
                    window.open(url, '_blank');
            }
        } },
        react_1.default.createElement(Avatar, { user: user }),
        react_1.default.createElement(user_1.default, { user: gif.user })));
};
Attribution.className = 'giphy-attribution';
exports.default = Attribution;
var templateObject_1, templateObject_2;
//# sourceMappingURL=index.js.map