var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import { serverUrl } from './constants';
import FetchError from './fetch-error';
export var ERROR_PREFIX = "@giphy/js-fetch-api: ";
export var DEFAULT_ERROR = 'Error fetching';
var identity = function (i) { return i; };
var requestMap = {};
var maxLife = 60000; // clear memory cache every minute
var errorMaxLife = 6000; // clear error memory cache after a second
var purgeCache = function () {
    var now = Date.now();
    Object.keys(requestMap).forEach(function (key) {
        var ttl = requestMap[key].isError ? errorMaxLife : maxLife;
        if (now - requestMap[key].ts >= ttl) {
            delete requestMap[key];
        }
    });
};
function request(url, options) {
    var _this = this;
    if (options === void 0) { options = {}; }
    var _a = options.apiVersion, apiVersion = _a === void 0 ? 1 : _a, _b = options.noCache, noCache = _b === void 0 ? false : _b, _c = options.normalizer, normalizer = _c === void 0 ? identity : _c;
    var serverUrl_ = serverUrl.replace(/\/v\d+\/$/, "/v".concat(apiVersion, "/"));
    purgeCache();
    if (!requestMap[url] || noCache) {
        var fullUrl_1 = "".concat(serverUrl_).concat(url);
        var makeRequest = function () { return __awaiter(_this, void 0, void 0, function () {
            var fetchError, response, result, message, result, _1, unexpectedError_1;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 9, , 10]);
                        return [4 /*yield*/, fetch(fullUrl_1, {
                                method: 'get',
                            })];
                    case 1:
                        response = _b.sent();
                        if (!response.ok) return [3 /*break*/, 3];
                        return [4 /*yield*/, response.json()];
                    case 2:
                        result = (_b.sent());
                        // no response id is an indiication of a synthetic response
                        if (!((_a = result.meta) === null || _a === void 0 ? void 0 : _a.response_id)) {
                            throw { message: "synthetic response" };
                        }
                        else {
                            // if everything is successful, we return here, otherwise an error will be thrown
                            return [2 /*return*/, normalizer(result)];
                        }
                        return [3 /*break*/, 8];
                    case 3:
                        message = DEFAULT_ERROR;
                        _b.label = 4;
                    case 4:
                        _b.trys.push([4, 6, , 7]);
                        return [4 /*yield*/, response.json()];
                    case 5:
                        result = (_b.sent());
                        if (result.message)
                            message = result.message;
                        return [3 /*break*/, 7];
                    case 6:
                        _1 = _b.sent();
                        return [3 /*break*/, 7];
                    case 7:
                        if (requestMap[url]) {
                            // we got a specific error,
                            // normally, you'd want to not fetch this again,
                            // but the api goes down and sends 400s, so allow a refetch after errorMaxLife
                            requestMap[url].isError = true;
                        }
                        // we got an error response, throw with the message in the response body json
                        fetchError = new FetchError("".concat(ERROR_PREFIX).concat(message), fullUrl_1, response.status, response.statusText);
                        _b.label = 8;
                    case 8: return [3 /*break*/, 10];
                    case 9:
                        unexpectedError_1 = _b.sent();
                        fetchError = new FetchError(unexpectedError_1.message, fullUrl_1);
                        // if the request fails with an unspecfied error,
                        // the user can request again after the error timeout
                        if (requestMap[url]) {
                            requestMap[url].isError = true;
                        }
                        return [3 /*break*/, 10];
                    case 10: throw fetchError;
                }
            });
        }); };
        requestMap[url] = { request: makeRequest(), ts: Date.now() };
    }
    return requestMap[url].request;
}
export default request;
//# sourceMappingURL=request.js.map