import { CategoriesOptions, PaginationOptions, RandomOptions, RelatedOptions, SearchOptions, SubcategoriesOptions, TrendingOptions } from './option-types';
import { GifID } from '@giphy/js-types';
import { CategoriesResult, ChannelsResult, GifResult, GifsResult, NonPaginatedGifsResult } from './result-types';
/**
 * @class GiphyFetch
 * @param {string} apiKey
 */
export declare class GiphyFetch {
    constructor(apiKey: string);
    /**
     * @hidden
     */
    private apiKey;
    /**
     * @hidden
     */
    private getQS;
    /**
     * A list of categories
     *
     * @param {CategoriesOptions} [options]
     * @returns {Promise<CategoriesResult>}
     */
    categories(options?: CategoriesOptions): Promise<CategoriesResult>;
    /**
     * Get a single gif by a id
     * @param {string} id
     * @returns {Promise<GifsResult>}
     **/
    gif(id: string): Promise<GifResult>;
    /**
     *
     * @function
     * Get gifs by an array of ids
     * @param {string[]} ids
     *
     * @function
     * Get gifs by category and subcategory
     * @param {string} category
     * @param {string} subcategory
     * @returns {Promise<GifsResult>}
     **/
    gifs(ids: string[]): Promise<GifsResult>;
    gifs(category: string, subcategory: string): Promise<GifsResult>;
    emoji(options?: PaginationOptions): Promise<GifsResult>;
    /**
     * Returns a list of all the default emoji variations
     *
     * @param {PaginationOptions} options
     * @returns {Promise<GifsResult>}
     **/
    emojiDefaultVariations(options?: PaginationOptions): Promise<GifsResult>;
    /**
     * Returns a list of gifs representing all the variations for the emoji
     *
     * @param {string} id
     * @returns {Promise<NonPaginatedGifsResult>}
     **/
    emojiVariations(id: GifID): Promise<NonPaginatedGifsResult>;
    animate(text: string, options?: PaginationOptions): Promise<GifsResult>;
    /**
     * @param term: string The term you're searching for
     * @param options: SearchOptions
     * @returns {Promise<GifsResult>}
     **/
    search(term: string, options?: SearchOptions): Promise<GifsResult>;
    /**
     * Get a list of subcategories
     * @param {string} category
     * @param {SubcategoriesOptions} options
     * @returns {Promise<CategoriesResult>}
     */
    subcategories(category: string, options?: SubcategoriesOptions): Promise<CategoriesResult>;
    /**
     * Get trending gifs
     *
     * @param {TrendingOptions} options
     * @returns {Promise<GifsResult>}
     */
    trending(options?: TrendingOptions): Promise<GifsResult>;
    /**
     * Get a random gif
     * @param {RandomOptions} options
     * @returns {Promise<GifResult>}
     **/
    random(options?: RandomOptions): Promise<GifResult>;
    /**
     * Get related gifs by a id
     * @param {string} id
     * @param {SubcategoriesOptions} options
     * @returns {Promise<GifsResult>}
     **/
    related(id: string, options?: RelatedOptions): Promise<GifsResult>;
    /**
     * Search for channels based on a term
     * @param {string} term
     * @param options: SearchOptions
     * @returns {Promise<ChannelsResult>}
     **/
    channels(term: string, options?: SearchOptions): Promise<ChannelsResult>;
}
export default GiphyFetch;
