"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendPingback = void 0;
var js_util_1 = require("@giphy/js-util");
var global_1 = __importDefault(require("./global"));
// TODO remove api key
var environment = (global_1.default === null || global_1.default === void 0 ? void 0 : global_1.default.GIPHY_PINGBACK_URL) || 'https://pingback.giphy.com';
var pingBackUrl = "".concat(environment, "/v2/pingback?apikey=l0HlIwPWyBBUDAUgM");
var sendPingback = function (events) {
    var headers = (0, js_util_1.getGiphySDKRequestHeaders)();
    /* istanbul ignore next */
    headers === null || headers === void 0 ? void 0 : headers.set('Content-Type', 'application/json');
    js_util_1.Logger.debug("Pingback session", events);
    if (!events.length) {
        return new Promise(function (resolve) { return resolve(); });
    }
    return fetch(pingBackUrl, {
        method: 'POST',
        body: JSON.stringify({ events: events }),
        headers: headers,
    }).catch(function (error) {
        // Call failed, probably due to adblock.
        js_util_1.Logger.warn("pingbacks failing to post ".concat(error));
    });
};
exports.sendPingback = sendPingback;
//# sourceMappingURL=send-pingback.js.map