"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
var js_util_1 = require("@giphy/js-util");
var throttle_debounce_1 = require("throttle-debounce");
var global_1 = __importDefault(require("./global"));
var send_pingback_1 = require("./send-pingback");
var queuedPingbackEvents = [];
global_1.default.giphyRandomId = (0, js_util_1.getPingbackId)();
var loggedInUserId = '';
function sendPingbacks() {
    var sendEvents = __spreadArray([], queuedPingbackEvents, true);
    queuedPingbackEvents = [];
    (0, send_pingback_1.sendPingback)(sendEvents);
}
var debouncedPingbackEvent = (0, throttle_debounce_1.debounce)(1000, sendPingbacks);
(_a = global_1.default.addEventListener) === null || _a === void 0 ? void 0 : _a.call(global_1.default, 'beforeunload', sendPingbacks);
var pingback = function (_a) {
    var userId = _a.userId, eventType = _a.eventType, actionType = _a.actionType, attributes = _a.attributes, _b = _a.queueEvents, queueEvents = _b === void 0 ? true : _b, analyticsResponsePayload = _a.analyticsResponsePayload;
    // save the user id for whenever create session is invoked
    loggedInUserId = userId ? String(userId) : loggedInUserId;
    var newEvent = {
        ts: Date.now(),
        attributes: attributes,
        action_type: actionType,
        user_id: (0, js_util_1.getPingbackId)(),
        analytics_response_payload: analyticsResponsePayload,
    };
    if (loggedInUserId) {
        newEvent.logged_in_user_id = loggedInUserId;
    }
    // add verification mode
    if (newEvent.analytics_response_payload) {
        newEvent.analytics_response_payload = "".concat(newEvent.analytics_response_payload).concat(js_util_1.Logger.ENABLED ? '&mode=verification' : '');
    }
    if (eventType) {
        newEvent.event_type = eventType;
    }
    queuedPingbackEvents.push(newEvent);
    queueEvents ? debouncedPingbackEvent() : sendPingbacks();
};
exports.default = pingback;
//# sourceMappingURL=pingback.js.map