export interface NetworkTrackingOptions {
    /**
     * Suppresses tracking Amplitude requests from network capture.
     * @defaultValue `true`
     */
    ignoreAmplitudeRequests?: boolean;
    /**
     * Hosts to ignore for network capture. Supports wildcard.
     * @defaultValue `[]`
     */
    ignoreHosts?: string[];
    /**
     * Rules to determine which network requests should be captured.
     *
     * Performs matching on array in reverse order.
     */
    captureRules?: NetworkCaptureRule[];
}
export interface NetworkCaptureRule {
    /**
     * Hosts to allow for network capture. Supports wildcard.
     * @defaultValue `["*"]` all hosts (except amplitude)
     */
    hosts?: string[];
    /**
     * Range list that defines the status codes to be captured.
     * @defaultValue `500-599`
     */
    statusCodeRange?: string;
}
//# sourceMappingURL=network-tracking.d.ts.map