import { __awaiter, __generator, __read, __spreadArray, __values } from "tslib";
/* eslint-disable no-restricted-globals */
import { DEFAULT_DATA_ATTRIBUTE_PREFIX, DEFAULT_RAGE_CLICK_ALLOWLIST, DEFAULT_DEAD_CLICK_ALLOWLIST, } from '@amplitude/analytics-core';
import * as constants from './constants';
import { fromEvent, map, Observable, share } from 'rxjs';
import { addAdditionalEventProperties, createShouldTrackEvent, getEventProperties, } from './helpers';
import { trackDeadClick } from './autocapture/track-dead-click';
import { trackRageClicks } from './autocapture/track-rage-click';
import { ObservablesEnum } from './autocapture-plugin';
import { createClickObservable, createMutationObservable } from './observables';
export var frustrationPlugin = function (options) {
    var _a, _b, _c, _d, _e;
    var name = constants.FRUSTRATION_PLUGIN_NAME;
    var type = 'enrichment';
    var subscriptions = [];
    var rageCssSelectors = (_b = (_a = options.rageClicks) === null || _a === void 0 ? void 0 : _a.cssSelectorAllowlist) !== null && _b !== void 0 ? _b : DEFAULT_RAGE_CLICK_ALLOWLIST;
    var deadCssSelectors = (_d = (_c = options.deadClicks) === null || _c === void 0 ? void 0 : _c.cssSelectorAllowlist) !== null && _d !== void 0 ? _d : DEFAULT_DEAD_CLICK_ALLOWLIST;
    var dataAttributePrefix = (_e = options.dataAttributePrefix) !== null && _e !== void 0 ? _e : DEFAULT_DATA_ATTRIBUTE_PREFIX;
    // combine the two selector lists to determine which clicked elements should be filtered
    var combinedCssSelectors = __spreadArray([], __read(new Set(__spreadArray(__spreadArray([], __read(rageCssSelectors), false), __read(deadCssSelectors), false))), false);
    // Create observables on events on the window
    var createObservables = function () {
        var _a;
        // Create Observables from direct user events
        var clickObservable = createClickObservable().pipe(map(function (click) {
            return addAdditionalEventProperties(click, 'click', combinedCssSelectors, dataAttributePrefix, true);
        }), share());
        // Create observable for URL changes
        var navigateObservable;
        /* istanbul ignore next */
        if (window.navigation) {
            navigateObservable = fromEvent(window.navigation, 'navigate').pipe(map(function (navigate) {
                return addAdditionalEventProperties(navigate, 'navigate', combinedCssSelectors, dataAttributePrefix);
            }), share());
        }
        // Track DOM Mutations
        var enrichedMutationObservable = createMutationObservable().pipe(map(function (mutation) { return addAdditionalEventProperties(mutation, 'mutation', combinedCssSelectors, dataAttributePrefix); }), share());
        return _a = {},
            _a[ObservablesEnum.ClickObservable] = clickObservable,
            _a[ObservablesEnum.ChangeObservable] = new Observable(),
            _a[ObservablesEnum.NavigateObservable] = navigateObservable,
            _a[ObservablesEnum.MutationObservable] = enrichedMutationObservable,
            _a;
    };
    var setup = function (config, amplitude) { return __awaiter(void 0, void 0, void 0, function () {
        var shouldTrackRageClick, shouldTrackDeadClick, allObservables, rageClickSubscription, deadClickSubscription;
        var _a;
        return __generator(this, function (_b) {
            /* istanbul ignore if */
            if (typeof document === 'undefined') {
                return [2 /*return*/];
            }
            shouldTrackRageClick = createShouldTrackEvent(options, rageCssSelectors, true);
            shouldTrackDeadClick = createShouldTrackEvent(options, deadCssSelectors, true);
            allObservables = createObservables();
            rageClickSubscription = trackRageClicks({
                allObservables: allObservables,
                amplitude: amplitude,
                shouldTrackRageClick: shouldTrackRageClick,
            });
            subscriptions.push(rageClickSubscription);
            deadClickSubscription = trackDeadClick({
                amplitude: amplitude,
                allObservables: allObservables,
                getEventProperties: function (actionType, element) { return getEventProperties(actionType, element, dataAttributePrefix); },
                shouldTrackDeadClick: shouldTrackDeadClick,
            });
            subscriptions.push(deadClickSubscription);
            /* istanbul ignore next */
            (_a = config === null || config === void 0 ? void 0 : config.loggerProvider) === null || _a === void 0 ? void 0 : _a.log("".concat(name, " has been successfully added."));
            return [2 /*return*/];
        });
    }); };
    var execute = function (event) { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2 /*return*/, event];
        });
    }); };
    var teardown = function () { return __awaiter(void 0, void 0, void 0, function () {
        var subscriptions_1, subscriptions_1_1, subscription;
        var e_1, _a;
        return __generator(this, function (_b) {
            try {
                for (subscriptions_1 = __values(subscriptions), subscriptions_1_1 = subscriptions_1.next(); !subscriptions_1_1.done; subscriptions_1_1 = subscriptions_1.next()) {
                    subscription = subscriptions_1_1.value;
                    subscription.unsubscribe();
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (subscriptions_1_1 && !subscriptions_1_1.done && (_a = subscriptions_1.return)) _a.call(subscriptions_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return [2 /*return*/];
        });
    }); };
    return {
        name: name,
        type: type,
        setup: setup,
        execute: execute,
        teardown: teardown,
    };
};
//# sourceMappingURL=frustration-plugin.js.map