"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.frustrationPlugin = void 0;
var tslib_1 = require("tslib");
/* eslint-disable no-restricted-globals */
var analytics_core_1 = require("@amplitude/analytics-core");
var constants = tslib_1.__importStar(require("./constants"));
var rxjs_1 = require("rxjs");
var helpers_1 = require("./helpers");
var track_dead_click_1 = require("./autocapture/track-dead-click");
var track_rage_click_1 = require("./autocapture/track-rage-click");
var autocapture_plugin_1 = require("./autocapture-plugin");
var observables_1 = require("./observables");
var frustrationPlugin = function (options) {
    var _a, _b, _c, _d, _e;
    var name = constants.FRUSTRATION_PLUGIN_NAME;
    var type = 'enrichment';
    var subscriptions = [];
    var rageCssSelectors = (_b = (_a = options.rageClicks) === null || _a === void 0 ? void 0 : _a.cssSelectorAllowlist) !== null && _b !== void 0 ? _b : analytics_core_1.DEFAULT_RAGE_CLICK_ALLOWLIST;
    var deadCssSelectors = (_d = (_c = options.deadClicks) === null || _c === void 0 ? void 0 : _c.cssSelectorAllowlist) !== null && _d !== void 0 ? _d : analytics_core_1.DEFAULT_DEAD_CLICK_ALLOWLIST;
    var dataAttributePrefix = (_e = options.dataAttributePrefix) !== null && _e !== void 0 ? _e : analytics_core_1.DEFAULT_DATA_ATTRIBUTE_PREFIX;
    // combine the two selector lists to determine which clicked elements should be filtered
    var combinedCssSelectors = tslib_1.__spreadArray([], tslib_1.__read(new Set(tslib_1.__spreadArray(tslib_1.__spreadArray([], tslib_1.__read(rageCssSelectors), false), tslib_1.__read(deadCssSelectors), false))), false);
    // Create observables on events on the window
    var createObservables = function () {
        var _a;
        // Create Observables from direct user events
        var clickObservable = (0, observables_1.createClickObservable)().pipe((0, rxjs_1.map)(function (click) {
            return (0, helpers_1.addAdditionalEventProperties)(click, 'click', combinedCssSelectors, dataAttributePrefix, true);
        }), (0, rxjs_1.share)());
        // Create observable for URL changes
        var navigateObservable;
        /* istanbul ignore next */
        if (window.navigation) {
            navigateObservable = (0, rxjs_1.fromEvent)(window.navigation, 'navigate').pipe((0, rxjs_1.map)(function (navigate) {
                return (0, helpers_1.addAdditionalEventProperties)(navigate, 'navigate', combinedCssSelectors, dataAttributePrefix);
            }), (0, rxjs_1.share)());
        }
        // Track DOM Mutations
        var enrichedMutationObservable = (0, observables_1.createMutationObservable)().pipe((0, rxjs_1.map)(function (mutation) { return (0, helpers_1.addAdditionalEventProperties)(mutation, 'mutation', combinedCssSelectors, dataAttributePrefix); }), (0, rxjs_1.share)());
        return _a = {},
            _a[autocapture_plugin_1.ObservablesEnum.ClickObservable] = clickObservable,
            _a[autocapture_plugin_1.ObservablesEnum.ChangeObservable] = new rxjs_1.Observable(),
            _a[autocapture_plugin_1.ObservablesEnum.NavigateObservable] = navigateObservable,
            _a[autocapture_plugin_1.ObservablesEnum.MutationObservable] = enrichedMutationObservable,
            _a;
    };
    var setup = function (config, amplitude) { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
        var shouldTrackRageClick, shouldTrackDeadClick, allObservables, rageClickSubscription, deadClickSubscription;
        var _a;
        return tslib_1.__generator(this, function (_b) {
            /* istanbul ignore if */
            if (typeof document === 'undefined') {
                return [2 /*return*/];
            }
            shouldTrackRageClick = (0, helpers_1.createShouldTrackEvent)(options, rageCssSelectors, true);
            shouldTrackDeadClick = (0, helpers_1.createShouldTrackEvent)(options, deadCssSelectors, true);
            allObservables = createObservables();
            rageClickSubscription = (0, track_rage_click_1.trackRageClicks)({
                allObservables: allObservables,
                amplitude: amplitude,
                shouldTrackRageClick: shouldTrackRageClick,
            });
            subscriptions.push(rageClickSubscription);
            deadClickSubscription = (0, track_dead_click_1.trackDeadClick)({
                amplitude: amplitude,
                allObservables: allObservables,
                getEventProperties: function (actionType, element) { return (0, helpers_1.getEventProperties)(actionType, element, dataAttributePrefix); },
                shouldTrackDeadClick: shouldTrackDeadClick,
            });
            subscriptions.push(deadClickSubscription);
            /* istanbul ignore next */
            (_a = config === null || config === void 0 ? void 0 : config.loggerProvider) === null || _a === void 0 ? void 0 : _a.log("".concat(name, " has been successfully added."));
            return [2 /*return*/];
        });
    }); };
    var execute = function (event) { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
        return tslib_1.__generator(this, function (_a) {
            return [2 /*return*/, event];
        });
    }); };
    var teardown = function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
        var subscriptions_1, subscriptions_1_1, subscription;
        var e_1, _a;
        return tslib_1.__generator(this, function (_b) {
            try {
                for (subscriptions_1 = tslib_1.__values(subscriptions), subscriptions_1_1 = subscriptions_1.next(); !subscriptions_1_1.done; subscriptions_1_1 = subscriptions_1.next()) {
                    subscription = subscriptions_1_1.value;
                    subscription.unsubscribe();
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (subscriptions_1_1 && !subscriptions_1_1.done && (_a = subscriptions_1.return)) _a.call(subscriptions_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return [2 /*return*/];
        });
    }); };
    return {
        name: name,
        type: type,
        setup: setup,
        execute: execute,
        teardown: teardown,
    };
};
exports.frustrationPlugin = frustrationPlugin;
//# sourceMappingURL=frustration-plugin.js.map