"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.trackRageClicks = exports._overrideRageClickConfig = void 0;
var tslib_1 = require("tslib");
var rxjs_1 = require("rxjs");
var helpers_1 = require("../helpers");
var constants_1 = require("../constants");
var analytics_core_1 = require("@amplitude/analytics-core");
var RAGE_CLICK_THRESHOLD = analytics_core_1.DEFAULT_RAGE_CLICK_THRESHOLD;
var RAGE_CLICK_WINDOW_MS = analytics_core_1.DEFAULT_RAGE_CLICK_WINDOW_MS;
// allow override of rage click config for testing only
function _overrideRageClickConfig(rageClickThreshold, rageClickWindowMs) {
    RAGE_CLICK_THRESHOLD = rageClickThreshold;
    RAGE_CLICK_WINDOW_MS = rageClickWindowMs;
}
exports._overrideRageClickConfig = _overrideRageClickConfig;
function trackRageClicks(_a) {
    var amplitude = _a.amplitude, allObservables = _a.allObservables, shouldTrackRageClick = _a.shouldTrackRageClick;
    var clickObservable = allObservables.clickObservable;
    // Buffer clicks within a RAGE_CLICK_WINDOW_MS window and filter for rage clicks
    var rageClickObservable = clickObservable.pipe((0, rxjs_1.filter)(helpers_1.filterOutNonTrackableEvents), (0, rxjs_1.filter)(function (click) {
        return shouldTrackRageClick('click', click.closestTrackedAncestor);
    }), (0, rxjs_1.bufferTime)(RAGE_CLICK_WINDOW_MS), (0, rxjs_1.filter)(function (clicks) {
        // filter if not enough clicks to be a rage click
        if (clicks.length < RAGE_CLICK_THRESHOLD) {
            return false;
        }
        // filter if the last RAGE_CLICK_THRESHOLD clicks were not all on the same element
        var trailingIndex = clicks.length - 1;
        var lastClickTarget = clicks[trailingIndex].event.target;
        while (--trailingIndex >= clicks.length - RAGE_CLICK_THRESHOLD) {
            if (clicks[trailingIndex].event.target !== lastClickTarget) {
                return false;
            }
        }
        // if we reach here that means the last RAGE_CLICK_THRESHOLD clicks were all on the same element
        // and thus we have a rage click
        return true;
    }), (0, rxjs_1.map)(function (clicks) {
        var firstClick = clicks[0];
        var lastClick = clicks[clicks.length - 1];
        var rageClickEvent = tslib_1.__assign({ '[Amplitude] Begin Time': new Date(firstClick.timestamp).toISOString(), '[Amplitude] End Time': new Date(lastClick.timestamp).toISOString(), '[Amplitude] Duration': lastClick.timestamp - firstClick.timestamp, '[Amplitude] Clicks': clicks.map(function (click) { return ({
                X: click.event.clientX,
                Y: click.event.clientY,
                Time: click.timestamp,
            }); }), '[Amplitude] Click Count': clicks.length }, firstClick.targetElementProperties);
        return { rageClickEvent: rageClickEvent, time: firstClick.timestamp };
    }));
    return rageClickObservable.subscribe(function (_a) {
        var rageClickEvent = _a.rageClickEvent, time = _a.time;
        amplitude.track(constants_1.AMPLITUDE_ELEMENT_RAGE_CLICKED_EVENT, rageClickEvent, { time: time });
    });
}
exports.trackRageClicks = trackRageClicks;
//# sourceMappingURL=track-rage-click.js.map