import { Event } from '../event';
import { IngestionMetadata } from '../ingestion-metadata';
import { Plan } from '../plan';
import { ServerZone } from '../server-zone';
import { Storage } from '../storage';
import { Transport } from '../transport';
import { Logger, LogLevel } from '../logger';
export interface Config {
    apiKey: string;
    flushIntervalMillis: number;
    flushMaxRetries: number;
    flushQueueSize: number;
    instanceName?: string;
    logLevel: LogLevel;
    loggerProvider: Logger;
    minIdLength?: number;
    optOut: boolean;
    plan?: Plan;
    ingestionMetadata?: IngestionMetadata;
    serverUrl?: string;
    serverZone?: keyof typeof ServerZone;
    storageProvider?: Storage<Event[]>;
    transportProvider: Transport;
    useBatch: boolean;
}
export interface Options extends Partial<Config> {
    apiKey: string;
    transportProvider: Transport;
}
//# sourceMappingURL=core.d.ts.map