import { Event, ReactNativeOptions, ReactNativeConfig as IReactNativeConfig, Storage, ReactNativeTrackingOptions, UserSession } from '@amplitude/analytics-types';
import { Config, MemoryStorage } from '@amplitude/analytics-core';
import { FetchTransport } from '@amplitude/analytics-client-common';
export declare const getDefaultConfig: () => {
    cookieExpiration: number;
    cookieSameSite: string;
    cookieSecure: boolean;
    cookieStorage: MemoryStorage<UserSession>;
    cookieUpgrade: boolean;
    disableCookies: boolean;
    domain: string;
    sessionTimeout: number;
    storageProvider: MemoryStorage<Event[]>;
    trackingSessionEvents: boolean;
    trackingOptions: Required<ReactNativeTrackingOptions>;
    transportProvider: FetchTransport;
};
export declare class ReactNativeConfig extends Config implements IReactNativeConfig {
    appVersion?: string;
    cookieExpiration: number;
    cookieSameSite: string;
    cookieSecure: boolean;
    cookieStorage: Storage<UserSession>;
    cookieUpgrade: boolean;
    disableCookies: boolean;
    domain: string;
    partnerId?: string;
    sessionTimeout: number;
    trackingSessionEvents: boolean;
    trackingOptions: ReactNativeTrackingOptions;
    protected _deviceId?: string;
    protected _lastEventId?: number;
    protected _lastEventTime?: number;
    protected _optOut: boolean;
    protected _sessionId?: number;
    protected _userId?: string;
    constructor(apiKey: string, options?: ReactNativeOptions);
    get deviceId(): string | undefined;
    set deviceId(deviceId: string | undefined);
    get userId(): string | undefined;
    set userId(userId: string | undefined);
    get sessionId(): number | undefined;
    set sessionId(sessionId: number | undefined);
    get optOut(): boolean;
    set optOut(optOut: boolean);
    get lastEventTime(): number | undefined;
    set lastEventTime(lastEventTime: number | undefined);
    get lastEventId(): number | undefined;
    set lastEventId(lastEventId: number | undefined);
    private updateStorage;
}
export declare const useReactNativeConfig: (apiKey: string, options?: ReactNativeOptions) => Promise<IReactNativeConfig>;
export declare const createCookieStorage: <T>(overrides?: ReactNativeOptions, baseConfig?: {
    cookieExpiration: number;
    cookieSameSite: string;
    cookieSecure: boolean;
    cookieStorage: MemoryStorage<UserSession>;
    cookieUpgrade: boolean;
    disableCookies: boolean;
    domain: string;
    sessionTimeout: number;
    storageProvider: MemoryStorage<Event[]>;
    trackingSessionEvents: boolean;
    trackingOptions: Required<ReactNativeTrackingOptions>;
    transportProvider: FetchTransport;
}) => Promise<Storage<T>>;
export declare const createEventsStorage: (overrides?: ReactNativeOptions) => Promise<Storage<Event[]> | undefined>;
export declare const getTopLevelDomain: (url?: string) => Promise<string>;
//# sourceMappingURL=config.d.ts.map