"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNative = require("react-native");
var _analyticsCore = require("@amplitude/analytics-core");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
class RemnantDataMigration {
  constructor(apiKey, instanceName, storage, firstRunSinceUpgrade, logger) {
    this.apiKey = apiKey;
    this.instanceName = instanceName;
    this.storage = storage;
    this.firstRunSinceUpgrade = firstRunSinceUpgrade;
    this.logger = logger;
    _defineProperty(this, "eventsStorageKey", void 0);
    _defineProperty(this, "nativeModule", void 0);
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    this.eventsStorageKey = `${_analyticsCore.STORAGE_PREFIX}_${this.apiKey.substring(0, 10)}`;
    this.nativeModule = _reactNative.NativeModules.AmplitudeReactNative;
  }
  async execute() {
    if (!this.nativeModule) {
      return {};
    }
    if (this.firstRunSinceUpgrade) {
      await this.moveIdentifies();
      await this.moveInterceptedIdentifies();
    }
    await this.moveEvents();
    const sessionData = await this.callNativeFunction(() => this.nativeModule.getLegacySessionData(this.instanceName));
    return sessionData ?? {};
  }
  async moveEvents() {
    await this.moveLegacyEvents('event');
  }
  async moveIdentifies() {
    await this.moveLegacyEvents('identify');
  }
  async moveInterceptedIdentifies() {
    await this.moveLegacyEvents('interceptedIdentify');
  }
  async callNativeFunction(action) {
    try {
      return await action();
    } catch (e) {
      var _this$logger;
      (_this$logger = this.logger) === null || _this$logger === void 0 ? void 0 : _this$logger.error(`can't call native function: ${String(e)}`);
      return undefined;
    }
  }
  callNativeAction(action) {
    try {
      action();
    } catch (e) {
      var _this$logger2;
      (_this$logger2 = this.logger) === null || _this$logger2 === void 0 ? void 0 : _this$logger2.error(`can't call native function: ${String(e)}`);
    }
  }
  async moveLegacyEvents(eventKind) {
    const legacyJsonEvents = await this.callNativeFunction(() => this.nativeModule.getLegacyEvents(this.instanceName, eventKind));
    if (!this.storage || !legacyJsonEvents || legacyJsonEvents.length === 0) {
      return;
    }
    const events = (await this.storage.get(this.eventsStorageKey)) ?? [];
    const eventIds = [];
    legacyJsonEvents.forEach(jsonEvent => {
      const event = this.convertLegacyEvent(jsonEvent);
      if (event) {
        events.push(event);
        if (event.event_id !== undefined) {
          eventIds.push(event.event_id);
        }
      }
    });
    await this.storage.set(this.eventsStorageKey, events);
    eventIds.forEach(eventId => this.callNativeAction(() => this.nativeModule.removeLegacyEvent(this.instanceName, eventKind, eventId)));
  }

  /* eslint-disable @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-member-access */
  convertLegacyEvent(legacyJsonEvent) {
    try {
      const event = JSON.parse(legacyJsonEvent);
      const {
        library,
        timestamp,
        uuid,
        api_properties
      } = event;
      if (library !== undefined) {
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        event.library = `${library.name}/${library.version}`;
      }
      if (timestamp !== undefined) {
        event.time = timestamp;
      }
      if (uuid !== undefined) {
        event.insert_id = uuid;
      }
      if (api_properties) {
        const {
          androidADID,
          android_app_set_id,
          ios_idfa,
          ios_idfv,
          productId,
          quantity,
          price,
          location
        } = api_properties;
        if (androidADID !== undefined) {
          event.adid = androidADID;
        }
        if (android_app_set_id !== undefined) {
          event.android_app_set_id = android_app_set_id;
        }
        if (ios_idfa !== undefined) {
          event.idfa = ios_idfa;
        }
        if (ios_idfv !== undefined) {
          event.idfv = ios_idfv;
        }
        if (productId !== undefined) {
          event.productId = productId;
        }
        if (quantity !== undefined) {
          event.quantity = quantity;
        }
        if (price !== undefined) {
          event.price = price;
        }
        if (location !== undefined) {
          const {
            lat,
            lng
          } = location;
          event.location_lat = lat;
          event.location_lng = lng;
        }
      }
      const {
        $productId: productId,
        $quantity: quantity,
        $price: price,
        $revenueType: revenueType
      } = event;
      if (productId !== undefined) {
        event.productId = productId;
      }
      if (quantity !== undefined) {
        event.quantity = quantity;
      }
      if (price !== undefined) {
        event.price = price;
      }
      if (revenueType !== undefined) {
        event.revenueType = revenueType;
      }
      return event;
    } catch {
      // skip invalid events
      return null;
    }
  }
  // eslint-enable @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-member-access
}
exports.default = RemnantDataMigration;
//# sourceMappingURL=remnant-data-migration.js.map