import { Event, Config as IConfig, Logger as ILogger, LogLevel, Storage, Transport, Plan, IngestionMetadata, ServerZone, Options } from '@amplitude/analytics-types';
import { Logger } from './logger';
export declare const getDefaultConfig: () => {
    flushMaxRetries: number;
    flushQueueSize: number;
    flushIntervalMillis: number;
    instanceName: string;
    logLevel: LogLevel;
    loggerProvider: Logger;
    optOut: boolean;
    serverUrl: string;
    serverZone: ServerZone;
    useBatch: boolean;
};
export declare class Config implements IConfig {
    apiKey: string;
    flushIntervalMillis: number;
    flushMaxRetries: number;
    flushQueueSize: number;
    instanceName?: string;
    loggerProvider: ILogger;
    logLevel: LogLevel;
    minIdLength?: number;
    plan?: Plan;
    ingestionMetadata?: IngestionMetadata;
    serverUrl: string | undefined;
    serverZone?: keyof typeof ServerZone;
    transportProvider: Transport;
    storageProvider?: Storage<Event[]>;
    useBatch: boolean;
    protected _optOut: boolean;
    get optOut(): boolean;
    set optOut(optOut: boolean);
    constructor(options: Options);
}
export declare const getServerUrl: (serverZone: keyof typeof ServerZone, useBatch: boolean) => "https://api2.amplitude.com/2/httpapi" | "https://api.eu.amplitude.com/2/httpapi" | "https://api2.amplitude.com/batch" | "https://api.eu.amplitude.com/batch";
export declare const createServerConfig: (serverUrl?: string, serverZone?: keyof typeof ServerZone, useBatch?: boolean) => {
    serverUrl: string;
    serverZone: undefined;
} | {
    serverZone: ServerZone | "US" | "EU" | "STAGING";
    serverUrl: string;
};
//# sourceMappingURL=config.d.ts.map