export var isFileDownloadTrackingEnabled = function (defaultTracking) {
    if (typeof defaultTracking === 'boolean') {
        return defaultTracking;
    }
    if (defaultTracking === null || defaultTracking === void 0 ? void 0 : defaultTracking.fileDownloads) {
        return true;
    }
    return false;
};
export var isFormInteractionTrackingEnabled = function (defaultTracking) {
    if (typeof defaultTracking === 'boolean') {
        return defaultTracking;
    }
    if (defaultTracking === null || defaultTracking === void 0 ? void 0 : defaultTracking.formInteractions) {
        return true;
    }
    return false;
};
export var isPageViewTrackingEnabled = function (defaultTracking) {
    if (typeof defaultTracking === 'boolean') {
        return defaultTracking;
    }
    if ((defaultTracking === null || defaultTracking === void 0 ? void 0 : defaultTracking.pageViews) === true ||
        ((defaultTracking === null || defaultTracking === void 0 ? void 0 : defaultTracking.pageViews) && typeof defaultTracking.pageViews === 'object')) {
        return true;
    }
    return false;
};
export var isSessionTrackingEnabled = function (defaultTracking) {
    if (typeof defaultTracking === 'boolean') {
        return defaultTracking;
    }
    if (defaultTracking === null || defaultTracking === void 0 ? void 0 : defaultTracking.sessions) {
        return true;
    }
    return false;
};
/**
 * Returns page view tracking config
 *
 * if config.attribution.trackPageViews and config.defaultTracking.pageViews are both TRUE
 * then always track page views
 *
 * if config.attribution.trackPageViews is TRUE and config.defaultTracking.pageViews is FALSE
 * then only track page views on attribution
 *
 * if config.attribution.trackPageViews is FALSE and config.defaultTracking.pageViews is TRUE
 * then always track page views
 *
 * if config.attribution.trackPageViews and config.defaultTracking.pageViews are both FALSE
 * then never track page views
 */
export var getPageViewTrackingConfig = function (config) {
    var _a;
    var trackOn = ((_a = config.attribution) === null || _a === void 0 ? void 0 : _a.trackPageViews) ? 'attribution' : function () { return false; };
    var trackHistoryChanges = undefined;
    var eventType = 'Page View';
    var isDefaultPageViewTrackingEnabled = isPageViewTrackingEnabled(config.defaultTracking);
    if (isDefaultPageViewTrackingEnabled) {
        trackOn = undefined;
        eventType = undefined;
        if (config.defaultTracking &&
            typeof config.defaultTracking === 'object' &&
            config.defaultTracking.pageViews &&
            typeof config.defaultTracking.pageViews === 'object') {
            if ('trackOn' in config.defaultTracking.pageViews) {
                trackOn = config.defaultTracking.pageViews.trackOn;
            }
            if ('trackHistoryChanges' in config.defaultTracking.pageViews) {
                trackHistoryChanges = config.defaultTracking.pageViews.trackHistoryChanges;
            }
            if ('eventType' in config.defaultTracking.pageViews && config.defaultTracking.pageViews.eventType) {
                eventType = config.defaultTracking.pageViews.eventType;
            }
        }
    }
    return {
        trackOn: trackOn,
        trackHistoryChanges: trackHistoryChanges,
        eventType: eventType,
    };
};
//# sourceMappingURL=default-tracking.js.map