"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBrowserJoinedConfigGenerator = exports.BrowserJoinedConfigGenerator = void 0;
var tslib_1 = require("tslib");
var analytics_remote_config_1 = require("@amplitude/analytics-remote-config");
var analytics_core_1 = require("@amplitude/analytics-core");
var BrowserJoinedConfigGenerator = /** @class */ (function () {
    function BrowserJoinedConfigGenerator(localConfig) {
        this.config = localConfig;
        this.config.loggerProvider.debug('Local configuration before merging with remote config', JSON.stringify(this.config, null, 2));
    }
    BrowserJoinedConfigGenerator.prototype.initialize = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _a;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this;
                        return [4 /*yield*/, (0, analytics_remote_config_1.createRemoteConfigFetch)({
                                localConfig: this.config,
                                configKeys: ['analyticsSDK'],
                            })];
                    case 1:
                        _a.remoteConfigFetch = _b.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    BrowserJoinedConfigGenerator.prototype.generateJoinedConfig = function () {
        var _a, _b, _c, _d, _e;
        var _f;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var remoteConfig, _g, transformedAutocaptureRemoteConfig, transformedRcElementInteractions, exactAllowList, regexList, _h, _j, pattern, combinedPageUrlAllowlist, e_1;
            var e_2, _k;
            return tslib_1.__generator(this, function (_l) {
                switch (_l.label) {
                    case 0:
                        _l.trys.push([0, 3, , 4]);
                        _g = this.remoteConfigFetch;
                        if (!_g) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.remoteConfigFetch.getRemoteConfig('analyticsSDK', 'browserSDK', this.config.sessionId)];
                    case 1:
                        _g = (_l.sent());
                        _l.label = 2;
                    case 2:
                        remoteConfig = _g;
                        this.config.loggerProvider.debug('Remote configuration:', JSON.stringify(remoteConfig, null, 2));
                        // merge remoteConfig.autocapture and this.config.autocapture
                        // if a field is in remoteConfig.autocapture, use that value
                        // if a field is not in remoteConfig.autocapture, use the value from this.config.autocapture
                        if (remoteConfig && 'autocapture' in remoteConfig) {
                            if (typeof remoteConfig.autocapture === 'boolean') {
                                this.config.autocapture = remoteConfig.autocapture;
                            }
                            if (typeof remoteConfig.autocapture === 'object') {
                                transformedAutocaptureRemoteConfig = tslib_1.__assign({}, remoteConfig.autocapture);
                                if (this.config.autocapture === undefined) {
                                    this.config.autocapture = remoteConfig.autocapture;
                                }
                                // Handle Element Interactions config initialization
                                if (typeof remoteConfig.autocapture.elementInteractions === 'object' &&
                                    ((_a = remoteConfig.autocapture.elementInteractions.pageUrlAllowlistRegex) === null || _a === void 0 ? void 0 : _a.length)) {
                                    transformedAutocaptureRemoteConfig.elementInteractions = tslib_1.__assign({}, remoteConfig.autocapture.elementInteractions);
                                    transformedRcElementInteractions = transformedAutocaptureRemoteConfig.elementInteractions;
                                    exactAllowList = (_b = transformedRcElementInteractions.pageUrlAllowlist) !== null && _b !== void 0 ? _b : [];
                                    regexList = [];
                                    try {
                                        for (_h = tslib_1.__values(remoteConfig.autocapture.elementInteractions.pageUrlAllowlistRegex), _j = _h.next(); !_j.done; _j = _h.next()) {
                                            pattern = _j.value;
                                            try {
                                                regexList.push(new RegExp(pattern));
                                            }
                                            catch (regexError) {
                                                this.config.loggerProvider.warn("Invalid regex pattern: ".concat(pattern), regexError);
                                            }
                                        }
                                    }
                                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                                    finally {
                                        try {
                                            if (_j && !_j.done && (_k = _h.return)) _k.call(_h);
                                        }
                                        finally { if (e_2) throw e_2.error; }
                                    }
                                    combinedPageUrlAllowlist = exactAllowList.concat(regexList);
                                    transformedRcElementInteractions.pageUrlAllowlist = combinedPageUrlAllowlist;
                                    delete transformedRcElementInteractions.pageUrlAllowlistRegex;
                                }
                                if (typeof this.config.autocapture === 'boolean') {
                                    this.config.autocapture = tslib_1.__assign({ attribution: this.config.autocapture, fileDownloads: this.config.autocapture, formInteractions: this.config.autocapture, pageViews: this.config.autocapture, sessions: this.config.autocapture, elementInteractions: this.config.autocapture }, transformedAutocaptureRemoteConfig);
                                }
                                if (typeof this.config.autocapture === 'object') {
                                    this.config.autocapture = tslib_1.__assign(tslib_1.__assign({}, this.config.autocapture), transformedAutocaptureRemoteConfig);
                                }
                            }
                            // Override default tracking options if autocapture is updated by remote config
                            this.config.defaultTracking = this.config.autocapture;
                        }
                        this.config.loggerProvider.debug('Joined configuration: ', JSON.stringify(this.config, null, 2));
                        (_c = (_f = this.config).requestMetadata) !== null && _c !== void 0 ? _c : (_f.requestMetadata = new analytics_core_1.RequestMetadata());
                        if ((_d = this.remoteConfigFetch) === null || _d === void 0 ? void 0 : _d.metrics.fetchTimeAPISuccess) {
                            this.config.requestMetadata.recordHistogram('remote_config_fetch_time_API_success', this.remoteConfigFetch.metrics.fetchTimeAPISuccess);
                        }
                        if ((_e = this.remoteConfigFetch) === null || _e === void 0 ? void 0 : _e.metrics.fetchTimeAPIFail) {
                            this.config.requestMetadata.recordHistogram('remote_config_fetch_time_API_fail', this.remoteConfigFetch.metrics.fetchTimeAPIFail);
                        }
                        return [3 /*break*/, 4];
                    case 3:
                        e_1 = _l.sent();
                        this.config.loggerProvider.error('Failed to fetch remote configuration because of error: ', e_1);
                        return [3 /*break*/, 4];
                    case 4: return [2 /*return*/, this.config];
                }
            });
        });
    };
    return BrowserJoinedConfigGenerator;
}());
exports.BrowserJoinedConfigGenerator = BrowserJoinedConfigGenerator;
var createBrowserJoinedConfigGenerator = function (localConfig) { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
    var joinedConfigGenerator;
    return tslib_1.__generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                joinedConfigGenerator = new BrowserJoinedConfigGenerator(localConfig);
                return [4 /*yield*/, joinedConfigGenerator.initialize()];
            case 1:
                _a.sent();
                return [2 /*return*/, joinedConfigGenerator];
        }
    });
}); };
exports.createBrowserJoinedConfigGenerator = createBrowserJoinedConfigGenerator;
//# sourceMappingURL=joined-config.js.map