"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createInstance = void 0;
var analytics_core_1 = require("@amplitude/analytics-core");
var browser_client_1 = require("./browser-client");
var createInstance = function () {
    var client = new browser_client_1.AmplitudeBrowser();
    return {
        init: (0, analytics_core_1.debugWrapper)(client.init.bind(client), 'init', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config'])),
        add: (0, analytics_core_1.debugWrapper)(client.add.bind(client), 'add', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config.apiKey', 'timeline.plugins'])),
        remove: (0, analytics_core_1.debugWrapper)(client.remove.bind(client), 'remove', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config.apiKey', 'timeline.plugins'])),
        track: (0, analytics_core_1.debugWrapper)(client.track.bind(client), 'track', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config.apiKey', 'timeline.queue.length'])),
        logEvent: (0, analytics_core_1.debugWrapper)(client.logEvent.bind(client), 'logEvent', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config.apiKey', 'timeline.queue.length'])),
        identify: (0, analytics_core_1.debugWrapper)(client.identify.bind(client), 'identify', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config.apiKey', 'timeline.queue.length'])),
        groupIdentify: (0, analytics_core_1.debugWrapper)(client.groupIdentify.bind(client), 'groupIdentify', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config.apiKey', 'timeline.queue.length'])),
        setGroup: (0, analytics_core_1.debugWrapper)(client.setGroup.bind(client), 'setGroup', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config.apiKey', 'timeline.queue.length'])),
        revenue: (0, analytics_core_1.debugWrapper)(client.revenue.bind(client), 'revenue', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config.apiKey', 'timeline.queue.length'])),
        flush: (0, analytics_core_1.debugWrapper)(client.flush.bind(client), 'flush', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config.apiKey', 'timeline.queue.length'])),
        getUserId: (0, analytics_core_1.debugWrapper)(client.getUserId.bind(client), 'getUserId', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config', 'config.userId'])),
        setUserId: (0, analytics_core_1.debugWrapper)(client.setUserId.bind(client), 'setUserId', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config', 'config.userId'])),
        getDeviceId: (0, analytics_core_1.debugWrapper)(client.getDeviceId.bind(client), 'getDeviceId', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config', 'config.deviceId'])),
        setDeviceId: (0, analytics_core_1.debugWrapper)(client.setDeviceId.bind(client), 'setDeviceId', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config', 'config.deviceId'])),
        reset: (0, analytics_core_1.debugWrapper)(client.reset.bind(client), 'reset', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config', 'config.userId', 'config.deviceId'])),
        getSessionId: (0, analytics_core_1.debugWrapper)(client.getSessionId.bind(client), 'getSessionId', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config'])),
        setSessionId: (0, analytics_core_1.debugWrapper)(client.setSessionId.bind(client), 'setSessionId', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config'])),
        extendSession: (0, analytics_core_1.debugWrapper)(client.extendSession.bind(client), 'extendSession', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config'])),
        setOptOut: (0, analytics_core_1.debugWrapper)(client.setOptOut.bind(client), 'setOptOut', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config'])),
        setTransport: (0, analytics_core_1.debugWrapper)(client.setTransport.bind(client), 'setTransport', (0, analytics_core_1.getClientLogConfig)(client), (0, analytics_core_1.getClientStates)(client, ['config'])),
    };
};
exports.createInstance = createInstance;
exports.default = (0, exports.createInstance)();
//# sourceMappingURL=browser-client-factory.js.map