import { IEvent, ISocketTrace, IWatchRTCConfiguration, IWatchrtcIdentifiers, Rating, RTCPeerConnectionInformation } from "./interfaces";
type ConfigLogLevel = Required<IWatchRTCConfiguration>["logLevel"];
type LogLevel = Exclude<ConfigLogLevel, "silent">;
export declare const logPrefix: (level?: LogLevel) => string[];
export declare const getSdkLogger: (getLogLevel: () => ConfigLogLevel) => (level: LogLevel, message: string, object?: Object) => void;
export declare const getSdkLogWithoutTrace: (getLogLevel: () => ConfigLogLevel) => (level: LogLevel, message: string, object?: Object) => void;
export declare const deltaCompression: (oldStats: any, newStats: any) => any;
export declare const mangleChromeStats: (pc: any, response: any) => any;
export declare const map2obj: (m: any) => any;
export declare const dumpStream: (stream: any) => {
    id: any;
    tracks: any;
};
export declare const getConnectionData: (type: "ws" | "http", key: string, proxyURL?: string) => {
    url: string;
    key: string;
};
export declare const validateConfig: (config: IWatchRTCConfiguration) => boolean;
export declare const countOfValidConnections: (openChannels: {
    [id: string]: RTCPeerConnectionInformation;
}) => number;
export declare const isRoomIdOrPeerIdChanged: (watchrtcIdentifiers: IWatchrtcIdentifiers, watchrtcConfig: IWatchRTCConfiguration) => boolean;
export declare const validateRating: (rating: Rating) => boolean;
export declare const validateEvent: (event: IEvent, channels: any) => boolean;
export declare const getHardwareInfo: () => Promise<any>;
export declare const setConsoleLevel: (level: string, trace: ISocketTrace) => void;
export declare const restoreOriginalConsoleMethods: () => void;
export declare const exposeApplicationStatsForPC: (id: string, previous: any, current: any, mappedTradk: any) => {
    peer: any;
    streams: any;
};
export declare const applyPatchForRTT: (oldStats: any, newStats: any) => any;
export declare const subtractNailUpReferenceStats: (referenceStats: any, newStats: any) => any;
export declare const generateID: () => string;
export {};
