import "./types";
import { IEvent, IStatsCallback, IWatchRTCConfiguration, IWatchRTCInitServices, Rating, StateListener } from "./interfaces";
/**
 * Initialize SDK. Can be called multiple times but it will be initialized only at the first time.
 * Use 'setConfig' function after if you don't have rtcRoomId and rtcPeerId yet.
 * @param watchrtc
 * @param prefixesToWrap
 * @param services
 */
export declare const init: (watchrtcConfig?: IWatchRTCConfiguration, services?: IWatchRTCInitServices) => void;
/**
 * You also can use watchRTC.setConfig function to set watchRTC configuration after calling init()
 * and before the creation of RTCPeerConnection objects
 */
export declare const setConfig: (watchrtcConfig: IWatchRTCConfiguration) => void;
/**
 * @deprecated Tags no longer supported. Use addKeys instead
 * Add tags for peer session
 * @param rtcTags[]
 */
export declare const addTags: (_rtcTags: string[]) => void;
/**
 * Set user rating and/or comment for peer session
 * @param rating number from 1 to 5
 * @param comment string
 */
export declare const setUserRating: (rating: Rating, comment?: string) => void;
/**
 * Add keys for peer session
 * @param keys
 */
export declare const addKeys: (keys: any) => void;
/**
 * Disables data collection
 */
export declare const disableDataCollection: () => void;
/**
 * Enables data collection
 */
export declare const enableDataCollection: () => void;
export declare const addEvent: (event: IEvent) => void;
/**
 * Map an incoming stream with a human-readable name
 * @param id The identifier of the stream (streamIdentifier attribute)
 * @param name The human-readable name
 * @deprecated
 */
export declare const mapStream: (id: string, name: string) => void;
/**
 * Map an incoming track with a human-readable name
 * @param id The identifier of the track (trackIdentifier attribute)
 * @param name The human-readable name
 */
export declare const mapTrack: (id: string, name: string) => void;
export declare const connect: () => void;
export declare const disconnect: () => void;
export declare const addStatsListener: (listener: IStatsCallback | null) => void;
export declare const persistentEnd: (nailUpCallEnd?: boolean) => void;
export declare const persistentStart: (roomId: string, peerId: string) => void;
export declare const addStateListener: (listener: StateListener | null) => void;
declare const _default: {
    /**
     * Initialize SDK. Can be called multiple times but it will be initialized only at the first time.
     * Use 'setConfig' function after if you don't have rtcRoomId and rtcPeerId yet.
     * @param watchrtc
     * @param prefixesToWrap
     */
    init: (watchrtcConfig?: IWatchRTCConfiguration | undefined, services?: IWatchRTCInitServices | undefined) => void;
    /**
     * @deprecated Tags no longer supported. Use addKeys instead
     * Add tags for peer session
     * @param rtcTags[]
     */
    addTags: (_rtcTags: string[]) => void;
    /**
     * Set user rating and/or comment for peer session
     * @param rating number from 1 to 5
     * @param comment string
     */
    setUserRating: (rating: Rating, comment?: string | undefined) => void;
    /**
     * Add keys for peer session
     * @param keys
     */
    addKeys: (keys: any) => void;
    /**
     * You also can use watchRTC.setConfig function to set watchRTC configuration after calling init()
     * and before the creation of RTCPeerConnection objects
     */
    setConfig: (watchrtcConfig: IWatchRTCConfiguration) => void;
    /**
     * Disables data collection
     */
    disableDataCollection: () => void;
    /**
     * Enables data collection
     */
    enableDataCollection: () => void;
    addEvent: (event: IEvent) => void;
    /**
     * Map an incoming stream with a human-readable name
     * @param id The identifier of the stream (streamIdentifier attribute)
     * @param name The human-readable name
     * @deprecated
     */
    mapStream: (id: string, name: string) => void;
    /**
     * Map an incoming track with a human-readable name
     * @param id The identifier of the track (trackIdentifier attribute)
     * @param name The human-readable name
     */
    mapTrack: (id: string, name: string) => void;
    connect: () => void;
    disconnect: () => void;
    addStatsListener: (listener: IStatsCallback | null) => void;
    persistentEnd: (nailUpCallEnd?: boolean | undefined) => void;
    persistentStart: (roomId: string, peerId: string) => void;
    addStateListener: (listener: StateListener | null) => void;
    qualityrtc: {
        run: ({ options, progressCallback, }: {
            options?: Record<string, any> | undefined;
            progressCallback: (progress: number) => void;
        }) => Promise<any>;
        stop: () => void;
    };
};
export default _default;
