/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import e from"crypto";class t{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}}class n{refCount(e){return r("refCount")}incRef(e){return r("incRef")}timerAvailable(){return!0}time(e){return r("time")}read(e){return r("read")}readSync(e){return r("readSync")}readToGPU(e,t){return r("readToGPU")}numDataIds(){return r("numDataIds")}disposeData(e,t){return r("disposeData")}write(e,t,n){return r("write")}move(e,t,n,s,o){return r("move")}memory(){return r("memory")}floatPrecision(){return r("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return r("dispose")}}function r(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function s(e){let t=e.length,n=0;for(;t>0;)n=Math.random()*t|0,t--,a(e,t,n)}function o(e,t,n){return Math.max(e,Math.min(t,n))}function a(e,t,n){const r=e[t];e[t]=e[n],e[n]=r}function i(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function l(e,t,n=""){i(d(e,t),(()=>n+` Shapes ${e} and ${t} must match`))}function u(e){i(null!=e,(()=>"The input to the tensor constructor must be a non-null value."))}function c(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||v(e)&&!n)for(let r=0;r<e.length;++r)c(e[r],t,n);else t.push(e);return t}function h(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function d(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function f(e){return e%1==0}function p(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function g(e,t){const n=t.length;return i((e=null==e?t.map(((e,t)=>t)):[].concat(e)).every((e=>e>=-n&&e<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`)),i(e.every((e=>f(e))),(()=>`All values in axis param must be integers but got axis ${e}`)),e.map((e=>e<0?n+e:e))}function m(e,t){const n=[],r=[],s=null!=t&&Array.isArray(t)&&0===t.length,o=null==t||s?null:g(t,e).sort();let a=0;for(let t=0;t<e.length;++t){if(null!=o){if(o[a]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==o[a]||o[a]>t)&&1===e[t]&&(n.push(e[t]),r.push(t)),o[a]<=t&&a++}1!==e[t]&&(n.push(e[t]),r.push(t))}return{newShape:n,keptDims:r}}function b(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error(`Unknown data type ${e}`);n=new Uint8Array(t)}return n}function y(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error(`Unknown data type ${e}`);n=new Array(t)}return n}function w(e,t){for(let n=0;n<e.length;n++){const r=e[n];if(isNaN(r)||!isFinite(r))throw Error(`A tensor of type ${t} being uploaded contains ${r}.`)}}function k(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function v(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray}function x(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error(`Unknown dtype ${e}`)}function E(e){if(null==e)return 0;let t=0;return e.forEach((e=>t+=e.length)),t}function S(e){return"string"==typeof e||e instanceof String}function $(e){return"boolean"==typeof e}function A(e){return"number"==typeof e}function _(e){return Array.isArray(e)?_(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray?"int32":A(e)?"float32":S(e)?"string":$(e)?"bool":"float32"}function I(e){return!!(e&&e.constructor&&e.call&&e.apply)}function M(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function N(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let r=t-3;r>=0;--r)n[r]=n[r+1]*e[r+1];return n}function T(e,t,n,r=!1){const s=new Array;if(1===t.length){const o=t[0]*(r?2:1);for(let t=0;t<o;t++)s[t]=n[e+t]}else{const o=t[0],a=t.slice(1),i=a.reduce(((e,t)=>e*t))*(r?2:1);for(let t=0;t<o;t++)s[t]=T(e+t*i,a,n,r)}return s}function D(e,t,n=!1){if(0===e.length)return t[0];const r=e.reduce(((e,t)=>e*t))*(n?2:1);if(0===r)return[];if(r!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}${n?" for a complex tensor":""}.`);return T(0,e,t,n)}function R(e,t){const n=F(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function F(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error(`Unknown data type ${t}`)}function B(e){e.forEach((t=>{i(Number.isInteger(t)&&t>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`))}))}function C(e){return e&&e.then&&"function"==typeof e.then}class P{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=O,this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&(L().getBool("IS_TEST")||L().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`)),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];L().getBool("IS_TEST")||L().getBool("PROD")||console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(C(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const e=this.getQueryParams(this.global.location.search);if("tfjsflags"in e){e.tfjsflags.split(",").forEach((e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)}))}}}function O(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("=")))),t}function L(){return W}let z,W=null;function K(){if(null==z){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}z=e}return z}function U(e,t){const n=function(){const e=K();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const r=t();return n.set(e,r),n.get(e)}}const q="Abs",G="Acos",H="Acosh",V="Add",j="AddN",J="All",Z="Any",Y="ArgMax",X="ArgMin",Q="Asin",ee="Asinh",te="Atan",ne="Atanh",re="Atan2",se="AvgPool",oe="AvgPoolGrad",ae="AvgPool3D",ie="AvgPool3DGrad",le="BatchMatMul",ue="BatchToSpaceND",ce="Bincount",he="BroadcastTo",de="BroadcastArgs",fe="Cast",pe="Ceil",ge="ClipByValue",me="Complex",be="ComplexAbs",ye="Concat",we="Conv2D",ke="Conv2DBackpropFilter",ve="Conv2DBackpropInput",xe="Conv3D",Ee="Conv3DBackpropFilterV2",Se="Conv3DBackpropInputV2",$e="Cos",Ae="Cosh",_e="Cumsum",Ie="CropAndResize",Me="DenseBincount",Ne="DepthToSpace",Te="DepthwiseConv2dNative",De="DepthwiseConv2dNativeBackpropFilter",Re="DepthwiseConv2dNativeBackpropInput",Fe="Diag",Be="Dilation2D",Ce="Dilation2DBackpropInput",Pe="Dilation2DBackpropFilter",Oe="RealDiv",Le="Einsum",ze="Elu",We="EluGrad",Ke="Erf",Ue="Equal",qe="Exp",Ge="ExpandDims",He="Expm1",Ve="FFT",je="Fill",Je="FlipLeftRight",Ze="Floor",Ye="FloorDiv",Xe="FusedBatchNorm",Qe="GatherV2",et="GatherNd",tt="Greater",nt="GreaterEqual",rt="Identity",st="IFFT",ot="Imag",at="IsFinite",it="IsInf",lt="IsNan",ut="LeakyRelu",ct="Less",ht="LessEqual",dt="LinSpace",ft="Log",pt="Log1p",gt="LogicalAnd",mt="LogicalNot",bt="LogicalOr",yt="LogSoftmax",wt="LRN",kt="LRNGrad",vt="Max",xt="Maximum",Et="MaxPool",St="MaxPoolGrad",$t="MaxPool3D",At="MaxPool3DGrad",_t="MaxPoolWithArgmax",It="Mean",Mt="Min",Nt="Minimum",Tt="MirrorPad",Dt="Mod",Rt="Multinomial",Ft="Multiply",Bt="Neg",Ct="NotEqual",Pt="NonMaxSuppressionV3",Ot="NonMaxSuppressionV4",Lt="NonMaxSuppressionV5",zt="OnesLike",Wt="OneHot",Kt="Pack",Ut="PadV2",qt="Pool",Gt="Pow",Ht="Prelu",Vt="Prod",jt="Range",Jt="Real",Zt="Reciprocal",Yt="Relu",Xt="Reshape",Qt="ResizeNearestNeighbor",en="ResizeNearestNeighborGrad",tn="ResizeBilinear",nn="ResizeBilinearGrad",rn="Relu6",sn="Reverse",on="Round",an="Rsqrt",ln="ScatterNd",un="Select",cn="Selu",hn="Slice",dn="Sin",fn="Sinh",pn="Sign",gn="Sigmoid",mn="Softplus",bn="Sqrt",yn="Sum",wn="SpaceToBatchND",kn="SplitV",vn="Softmax",xn="SparseFillEmptyRows",En="SparseReshape",Sn="SparseSegmentMean",$n="SparseSegmentSum",An="SparseToDense",_n="SquaredDifference",In="Square",Mn="StridedSlice",Nn="StringNGrams",Tn="StringSplit",Dn="StringToHashBucketFast",Rn="Sub",Fn="Tan",Bn="Tanh",Cn="Tile",Pn="TopK",On="Transform",Ln="Transpose",zn="Unique",Wn="Unpack",Kn="UnsortedSegmentSum",Un="ZerosLike",qn="Step",Gn="FromPixels",Hn="RotateWithOffset",Vn="_FusedMatMul",jn="FusedConv2D",Jn="FusedDepthwiseConv2D";function Zn(...e){L().getBool("IS_TEST")||L().getBool("PROD")||console.warn(...e)}const Yn=U("kernelRegistry",(()=>new Map)),Xn=U("gradRegistry",(()=>new Map));function Qn(e,t){const n=ir(e,t);return Yn.get(n)}function er(e){return Xn.get(e)}function tr(e){const t=Yn.entries(),n=[];for(;;){const{done:r,value:s}=t.next();if(r)break;const[o,a]=s,[i]=o.split("_");i===e&&n.push(a)}return n}function nr(e){const{kernelName:t,backendName:n}=e,r=ir(t,n);Yn.has(r)&&Zn(`The kernel '${t}' for backend '${n}' is already registered`),Yn.set(r,e)}function rr(e){const{kernelName:t}=e;Xn.has(t)&&L().getBool("DEBUG")&&Zn(`Overriding the gradient for '${t}'`),Xn.set(t,e)}function sr(e,t){const n=ir(e,t);if(!Yn.has(n))throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);Yn.delete(n)}function or(e){if(!Xn.has(e))throw new Error(`The gradient '${e}' for backend is not registered`);Xn.delete(e)}function ar(e,t){tr(e).forEach((e=>{nr(Object.assign({},e,{backendName:t}))}))}function ir(e,t){return`${t}_${e}`}var lr=cr,ur=null;try{ur=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(e){}function cr(e,t,n){this.low=0|e,this.high=0|t,this.unsigned=!!n}function hr(e){return!0===(e&&e.__isLong__)}cr.prototype.__isLong__,Object.defineProperty(cr.prototype,"__isLong__",{value:!0}),cr.isLong=hr;var dr={},fr={};function pr(e,t){var n,r,s;return t?(s=0<=(e>>>=0)&&e<256)&&(r=fr[e])?r:(n=mr(e,(0|e)<0?-1:0,!0),s&&(fr[e]=n),n):(s=-128<=(e|=0)&&e<128)&&(r=dr[e])?r:(n=mr(e,e<0?-1:0,!1),s&&(dr[e]=n),n)}function gr(e,t){if(isNaN(e))return t?$r:Sr;if(t){if(e<0)return $r;if(e>=vr)return Nr}else{if(e<=-xr)return Tr;if(e+1>=xr)return Mr}return e<0?gr(-e,t).neg():mr(e%kr|0,e/kr|0,t)}function mr(e,t,n){return new cr(e,t,n)}cr.fromInt=pr,cr.fromNumber=gr,cr.fromBits=mr;var br=Math.pow;function yr(e,t,n){if(0===e.length)throw Error("empty string");if("NaN"===e||"Infinity"===e||"+Infinity"===e||"-Infinity"===e)return Sr;if("number"==typeof t?(n=t,t=!1):t=!!t,(n=n||10)<2||36<n)throw RangeError("radix");var r;if((r=e.indexOf("-"))>0)throw Error("interior hyphen");if(0===r)return yr(e.substring(1),t,n).neg();for(var s=gr(br(n,8)),o=Sr,a=0;a<e.length;a+=8){var i=Math.min(8,e.length-a),l=parseInt(e.substring(a,a+i),n);if(i<8){var u=gr(br(n,i));o=o.mul(u).add(gr(l))}else o=(o=o.mul(s)).add(gr(l))}return o.unsigned=t,o}function wr(e,t){return"number"==typeof e?gr(e,t):"string"==typeof e?yr(e,t):mr(e.low,e.high,"boolean"==typeof t?t:e.unsigned)}cr.fromString=yr,cr.fromValue=wr;var kr=4294967296,vr=kr*kr,xr=vr/2,Er=pr(1<<24),Sr=pr(0);cr.ZERO=Sr;var $r=pr(0,!0);cr.UZERO=$r;var Ar=pr(1);cr.ONE=Ar;var _r=pr(1,!0);cr.UONE=_r;var Ir=pr(-1);cr.NEG_ONE=Ir;var Mr=mr(-1,2147483647,!1);cr.MAX_VALUE=Mr;var Nr=mr(-1,-1,!0);cr.MAX_UNSIGNED_VALUE=Nr;var Tr=mr(0,-2147483648,!1);cr.MIN_VALUE=Tr;var Dr=cr.prototype;Dr.toInt=function(){return this.unsigned?this.low>>>0:this.low},Dr.toNumber=function(){return this.unsigned?(this.high>>>0)*kr+(this.low>>>0):this.high*kr+(this.low>>>0)},Dr.toString=function(e){if((e=e||10)<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(Tr)){var t=gr(e),n=this.div(t),r=n.mul(t).sub(this);return n.toString(e)+r.toInt().toString(e)}return"-"+this.neg().toString(e)}for(var s=gr(br(e,6),this.unsigned),o=this,a="";;){var i=o.div(s),l=(o.sub(i.mul(s)).toInt()>>>0).toString(e);if((o=i).isZero())return l+a;for(;l.length<6;)l="0"+l;a=""+l+a}},Dr.getHighBits=function(){return this.high},Dr.getHighBitsUnsigned=function(){return this.high>>>0},Dr.getLowBits=function(){return this.low},Dr.getLowBitsUnsigned=function(){return this.low>>>0},Dr.getNumBitsAbs=function(){if(this.isNegative())return this.eq(Tr)?64:this.neg().getNumBitsAbs();for(var e=0!=this.high?this.high:this.low,t=31;t>0&&0==(e&1<<t);t--);return 0!=this.high?t+33:t+1},Dr.isZero=function(){return 0===this.high&&0===this.low},Dr.eqz=Dr.isZero,Dr.isNegative=function(){return!this.unsigned&&this.high<0},Dr.isPositive=function(){return this.unsigned||this.high>=0},Dr.isOdd=function(){return 1==(1&this.low)},Dr.isEven=function(){return 0==(1&this.low)},Dr.equals=function(e){return hr(e)||(e=wr(e)),(this.unsigned===e.unsigned||this.high>>>31!=1||e.high>>>31!=1)&&(this.high===e.high&&this.low===e.low)},Dr.eq=Dr.equals,Dr.notEquals=function(e){return!this.eq(e)},Dr.neq=Dr.notEquals,Dr.ne=Dr.notEquals,Dr.lessThan=function(e){return this.comp(e)<0},Dr.lt=Dr.lessThan,Dr.lessThanOrEqual=function(e){return this.comp(e)<=0},Dr.lte=Dr.lessThanOrEqual,Dr.le=Dr.lessThanOrEqual,Dr.greaterThan=function(e){return this.comp(e)>0},Dr.gt=Dr.greaterThan,Dr.greaterThanOrEqual=function(e){return this.comp(e)>=0},Dr.gte=Dr.greaterThanOrEqual,Dr.ge=Dr.greaterThanOrEqual,Dr.compare=function(e){if(hr(e)||(e=wr(e)),this.eq(e))return 0;var t=this.isNegative(),n=e.isNegative();return t&&!n?-1:!t&&n?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1},Dr.comp=Dr.compare,Dr.negate=function(){return!this.unsigned&&this.eq(Tr)?Tr:this.not().add(Ar)},Dr.neg=Dr.negate,Dr.add=function(e){hr(e)||(e=wr(e));var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,o=e.high>>>16,a=65535&e.high,i=e.low>>>16,l=0,u=0,c=0,h=0;return c+=(h+=s+(65535&e.low))>>>16,u+=(c+=r+i)>>>16,l+=(u+=n+a)>>>16,l+=t+o,mr((c&=65535)<<16|(h&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},Dr.subtract=function(e){return hr(e)||(e=wr(e)),this.add(e.neg())},Dr.sub=Dr.subtract,Dr.multiply=function(e){if(this.isZero())return Sr;if(hr(e)||(e=wr(e)),ur)return mr(ur.mul(this.low,this.high,e.low,e.high),ur.get_high(),this.unsigned);if(e.isZero())return Sr;if(this.eq(Tr))return e.isOdd()?Tr:Sr;if(e.eq(Tr))return this.isOdd()?Tr:Sr;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(Er)&&e.lt(Er))return gr(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,o=e.high>>>16,a=65535&e.high,i=e.low>>>16,l=65535&e.low,u=0,c=0,h=0,d=0;return h+=(d+=s*l)>>>16,c+=(h+=r*l)>>>16,h&=65535,c+=(h+=s*i)>>>16,u+=(c+=n*l)>>>16,c&=65535,u+=(c+=r*i)>>>16,c&=65535,u+=(c+=s*a)>>>16,u+=t*l+n*i+r*a+s*o,mr((h&=65535)<<16|(d&=65535),(u&=65535)<<16|(c&=65535),this.unsigned)},Dr.mul=Dr.multiply,Dr.divide=function(e){if(hr(e)||(e=wr(e)),e.isZero())throw Error("division by zero");var t,n,r;if(ur)return this.unsigned||-2147483648!==this.high||-1!==e.low||-1!==e.high?mr((this.unsigned?ur.div_u:ur.div_s)(this.low,this.high,e.low,e.high),ur.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?$r:Sr;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return $r;if(e.gt(this.shru(1)))return _r;r=$r}else{if(this.eq(Tr))return e.eq(Ar)||e.eq(Ir)?Tr:e.eq(Tr)?Ar:(t=this.shr(1).div(e).shl(1)).eq(Sr)?e.isNegative()?Ar:Ir:(n=this.sub(e.mul(t)),r=t.add(n.div(e)));if(e.eq(Tr))return this.unsigned?$r:Sr;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();r=Sr}for(n=this;n.gte(e);){t=Math.max(1,Math.floor(n.toNumber()/e.toNumber()));for(var s=Math.ceil(Math.log(t)/Math.LN2),o=s<=48?1:br(2,s-48),a=gr(t),i=a.mul(e);i.isNegative()||i.gt(n);)i=(a=gr(t-=o,this.unsigned)).mul(e);a.isZero()&&(a=Ar),r=r.add(a),n=n.sub(i)}return r},Dr.div=Dr.divide,Dr.modulo=function(e){return hr(e)||(e=wr(e)),ur?mr((this.unsigned?ur.rem_u:ur.rem_s)(this.low,this.high,e.low,e.high),ur.get_high(),this.unsigned):this.sub(this.div(e).mul(e))},Dr.mod=Dr.modulo,Dr.rem=Dr.modulo,Dr.not=function(){return mr(~this.low,~this.high,this.unsigned)},Dr.and=function(e){return hr(e)||(e=wr(e)),mr(this.low&e.low,this.high&e.high,this.unsigned)},Dr.or=function(e){return hr(e)||(e=wr(e)),mr(this.low|e.low,this.high|e.high,this.unsigned)},Dr.xor=function(e){return hr(e)||(e=wr(e)),mr(this.low^e.low,this.high^e.high,this.unsigned)},Dr.shiftLeft=function(e){return hr(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?mr(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):mr(0,this.low<<e-32,this.unsigned)},Dr.shl=Dr.shiftLeft,Dr.shiftRight=function(e){return hr(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?mr(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):mr(this.high>>e-32,this.high>=0?0:-1,this.unsigned)},Dr.shr=Dr.shiftRight,Dr.shiftRightUnsigned=function(e){if(hr(e)&&(e=e.toInt()),0===(e&=63))return this;var t=this.high;return e<32?mr(this.low>>>e|t<<32-e,t>>>e,this.unsigned):mr(32===e?t:t>>>e-32,0,this.unsigned)},Dr.shru=Dr.shiftRightUnsigned,Dr.shr_u=Dr.shiftRightUnsigned,Dr.toSigned=function(){return this.unsigned?mr(this.low,this.high,!1):this},Dr.toUnsigned=function(){return this.unsigned?this:mr(this.low,this.high,!0)},Dr.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()},Dr.toBytesLE=function(){var e=this.high,t=this.low;return[255&t,t>>>8&255,t>>>16&255,t>>>24,255&e,e>>>8&255,e>>>16&255,e>>>24]},Dr.toBytesBE=function(){var e=this.high,t=this.low;return[e>>>24,e>>>16&255,e>>>8&255,255&e,t>>>24,t>>>16&255,t>>>8&255,255&t]},cr.fromBytes=function(e,t,n){return n?cr.fromBytesLE(e,t):cr.fromBytesBE(e,t)},cr.fromBytesLE=function(e,t){return new cr(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,t)},cr.fromBytesBE=function(e,t){return new cr(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],t)};const Rr=lr||Object.assign(Object.create(null),lr,{default:lr});function Fr(e){return Rr.fromString(e,!0,16)}const Br=Fr("c3a5c85c97cb3127"),Cr=Fr("b492b66fbe98f273"),Pr=Fr("9ae16a3b2f90404f");function Or(e){return e.xor(e.shru(47))}function Lr(e,t,n){const r=e.slice(t,t+n);return Rr.fromBytes(Array.from(r),!0,!0)}function zr(e,t){return Lr(e,t,8)}function Wr(e,t){return Lr(e,t,4)}function Kr(e,t){return 0===t?e:e.shru(t).or(e.shl(64-t))}function Ur(e,t,n=Fr("9ddfea08eb382d69")){let r=e.xor(t).mul(n);r=r.xor(r.shru(47));let s=t.xor(r).mul(n);return s=s.xor(s.shru(47)),s=s.mul(n),s}function qr(e,t,n,r){return function(e,t,n,r,s,o){s=s.add(e),o=Kr(o.add(s).add(r),21);const a=s;return s=(s=s.add(t)).add(n),o=o.add(Kr(s,44)),[s.add(r),o.add(a)]}(zr(e,t),zr(e,t+8),zr(e,t+16),zr(e,t+24),n,r)}function Gr(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=c(e)),L().getBool("DEBUG")&&w(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error(`Unknown data type ${t}`)}function Hr(){return L().platform.now()}function Vr(e,t="utf-8"){return t=t||"utf-8",L().platform.encode(e,t)}function jr(e,t="utf-8"){return t=t||"utf-8",L().platform.decode(e,t)}var Jr={__proto__:null,createScalarValue:function(e,t){return"string"===t?Vr(e):Gr([e],t)},toTypedArray:Gr,now:Hr,fetch:function(e,t){return L().platform.fetch(e,t)},encodeString:Vr,decodeString:jr,shuffle:s,shuffleCombo:function(e,t){if(e.length!==t.length)throw new Error(`Array sizes must match to be shuffled together First array length was ${e.length}Second array length was ${t.length}`);let n=e.length,r=0;for(;n>0;)r=Math.random()*n|0,n--,a(e,n,r),a(t,n,r)},clamp:o,nearestLargerEven:function(e){return e%2==0?e:e+1},swap:a,sum:function(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t},randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},distSquared:function(e,t){let n=0;for(let r=0;r<e.length;r++){const s=Number(e[r])-Number(t[r]);n+=s*s}return n},assert:i,assertShapesMatch:l,assertNonNull:u,flatten:c,sizeFromShape:h,isScalarShape:function(e){return 0===e.length},arraysEqual:d,isInt:f,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},sizeToSquarishShape:function(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]},createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return s(t),t},rightPad:p,repeatedTry:function(e,t=(e=>0),n){return new Promise(((r,s)=>{let o=0;const a=()=>{if(e())return void r();o++;const i=t(o);null!=n&&o>=n?s():setTimeout(a,i)};a()}))},inferFromImplicitShape:function(e,t){let n=1,r=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==r)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${r} and dim ${t}`);r=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===r){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const s=e.slice();return s[r]=t/n,s},parseAxisParam:g,squeezeShape:m,getTypedArrayFromDType:b,getArrayFromDType:y,checkConversionForErrors:w,isValidDtype:k,hasEncodingLoss:function(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))},isTypedArray:v,bytesPerElement:x,bytesFromStringArray:E,isString:S,isBoolean:$,isNumber:A,inferDtype:_,isFunction:I,nearestDivisor:M,computeStrides:N,toNestedArray:D,makeOnesTypedArray:R,makeZerosTypedArray:F,makeZerosNestedTypedArray:function(e,t){const n=e.reduce(((e,t)=>e*t),1);if(null==t||"float32"===t)return D(e,new Float32Array(n));if("int32"===t)return D(e,new Int32Array(n));if("bool"===t)return D(e,new Uint8Array(n));throw new Error(`Unknown data type ${t}`)},assertNonNegativeIntegerDimensions:B,locToIndex:function(e,t,n){if(0===t)return 0;if(1===t)return e[0];let r=e[e.length-1];for(let t=0;t<e.length-1;++t)r+=n[t]*e[t];return r},indexToLoc:function(e,t,n){if(0===t)return[];if(1===t)return[e];const r=new Array(t);for(let t=0;t<r.length-1;++t)r[t]=Math.floor(e/n[t]),e-=r[t]*n[t];return r[r.length-1]=e,r},isPromise:C,hexToLong:Fr,fingerPrint64:function(e,t=e.length){const n=Rr.fromNumber(81,!0);if(t<=32)return t<=16?function(e,t=e.length){if(t>=8){const n=Pr.add(2*t),r=zr(e,0).add(Pr),s=zr(e,t-8);return Ur(Kr(s,37).mul(n).add(r),Kr(r,25).add(s).mul(n),n)}if(t>=4){const n=Pr.add(2*t);return Ur(Wr(e,0).shl(3).add(t),Wr(e,t-4),n)}if(t>0){const n=e[0]+(e[t>>1]<<8),r=t+(e[t-1]<<2);return Or(Pr.mul(n).xor(Br.mul(r))).mul(Pr)}return Pr}(e,t):function(e,t=e.length){const n=Pr.add(2*t),r=zr(e,0).mul(Cr),s=zr(e,8),o=zr(e,t-8).mul(n),a=zr(e,t-16).mul(Pr);return Ur(Kr(r.add(s),43).add(Kr(o,30)).add(a),r.add(Kr(s.add(Pr),18)).add(o),n)}(e,t);if(t<=64)return function(e,t=e.length){const n=Pr.add(2*t),r=zr(e,0).mul(Pr),s=zr(e,8),o=zr(e,t-8).mul(n),a=zr(e,t-16).mul(Pr),i=Kr(r.add(s),43).add(Kr(o,30)).add(a),l=Ur(i,r.add(Kr(s.add(Pr),18)).add(o),n),u=zr(e,16).mul(n),c=zr(e,24),h=i.add(zr(e,t-32)).mul(n),d=l.add(zr(e,t-24)).mul(n);return Ur(Kr(u.add(c),43).add(Kr(h,30)).add(d),u.add(Kr(c.add(r),18)).add(h),n)}(e,t);let r=n,s=n.mul(Cr).add(113),o=Or(s.mul(Pr).add(113)).mul(Pr),a=[Rr.UZERO,Rr.UZERO],i=[Rr.UZERO,Rr.UZERO];r=r.mul(Pr).add(zr(e,0));let l=0;const u=64*(t-1>>6),c=u+(t-1&63)-63;do{r=Kr(r.add(s).add(a[0]).add(zr(e,l+8)),37).mul(Cr),s=Kr(s.add(a[1]).add(zr(e,l+48)),42).mul(Cr),r=r.xor(i[1]),s=s.add(a[0]).add(zr(e,l+40)),o=Kr(o.add(i[0]),33).mul(Cr),a=qr(e,l,a[1].mul(Cr),r.add(i[0])),i=qr(e,l+32,o.add(i[1]),s.add(zr(e,l+16))),[o,r]=[r,o],l+=64}while(l!==u);const h=Cr.add(o.and(255).shl(1));return l=c,i[0]=i[0].add(t-1&63),a[0]=a[0].add(i[0]),i[0]=i[0].add(a[0]),r=Kr(r.add(s).add(a[0]).add(zr(e,l+8)),37).mul(h),s=Kr(s.add(a[1]).add(zr(e,l+48)),42).mul(h),r=r.xor(i[1].mul(9)),s=s.add(a[0].mul(9).add(zr(e,l+40))),o=Kr(o.add(i[0]),33).mul(h),a=qr(e,l,a[1].mul(h),r.add(i[0])),i=qr(e,l+32,o.add(i[1]),s.add(zr(e,l+16))),[o,r]=[r,o],Ur(Ur(a[0],i[0],h).add(Or(s).mul(Br)).add(o),Ur(a[1],i[1],h).add(r),h)}};class Zr{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new Xr)}profileKernel(e,t,n){let r;const s=()=>{r=n()};let o;const a=Hr();if(this.backendTimer.timerAvailable())o=this.backendTimer.time(s);else{s();for(const e of r)e.dataSync();o=Promise.resolve({kernelMs:Hr()-a})}if(L().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<r.length;t++){const n=r[t];n.data().then((t=>{Yr(t,n.dtype,e)}))}return{kernelName:e,outputs:r,inputs:t,timeMs:o.then((e=>e.kernelMs)),extraInfo:o.then((e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():""))}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:r,inputs:s,extraInfo:o}=e;n.forEach((e=>{Promise.all([e.data(),r,o]).then((n=>{this.logger.logKernelProfile(t,e,n[0],n[1],s,n[2])}))}))}}function Yr(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const r=e[t];if(isNaN(r)||!isFinite(r))return console.warn(`Found ${r} in the result of '${n}'`),!0}return!1}class Xr{logKernelProfile(e,t,n,r,s,o){const a="number"==typeof r?p(`${r}ms`,9):r.error,i=p(e,25),l=t.rank,u=t.size,c=p(t.shape.toString(),14);let h="";for(const e in s){const n=s[e];if(null!=n){const r=n.shape||t.shape,s=r.length;h+=`${e}: ${s}D ${s>0?r:""} `}}console.log(`%c${i}\t%c${a}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${o}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function Qr(e,t,n,r){const s=N(t),o=function(e,t,n,r){const s=h(t),o=r[r.length-1],a=new Array(o).fill(0),i=t.length,l="complex64"===n?rs(e):e;if(i>1)for(let e=0;e<s/o;e++){const t=e*o;for(let e=0;e<o;e++)a[e]=Math.max(a[e],es(l[t+e],0,n).length)}return a}(e,t,n,s),a=t.length,i=ns(e,t,n,s,o),l=["Tensor"];return r&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${a}`),l.push(`  shape: [${t}]`),l.push("  values:")),l.push(i.map((e=>"    "+e)).join("\n")),l.join("\n")}function es(e,t,n){let r;return r=Array.isArray(e)?`${parseFloat(e[0].toFixed(7))} + ${parseFloat(e[1].toFixed(7))}j`:S(e)?`'${e}'`:"bool"===n?ts(e):parseFloat(e.toFixed(7)).toString(),p(r,t)}function ts(e){return 0===e?"false":"true"}function ns(e,t,n,r,s,o=!0){const a="complex64"===n?2:1,i=t[0],l=t.length;if(0===l){if("complex64"===n){return[es(rs(e)[0],0,n)]}return"bool"===n?[ts(e[0])]:[e[0].toString()]}if(1===l){if(i>20){const t=3*a;let r=Array.from(e.slice(0,t)),o=Array.from(e.slice((i-3)*a,i*a));return"complex64"===n&&(r=rs(r),o=rs(o)),["["+r.map(((e,t)=>es(e,s[t],n))).join(", ")+", ..., "+o.map(((e,t)=>es(e,s[i-3+t],n))).join(", ")+"]"]}return["["+("complex64"===n?rs(e):Array.from(e)).map(((e,t)=>es(e,s[t],n))).join(", ")+"]"]}const u=t.slice(1),c=r.slice(1),h=r[0]*a,d=[];if(i>20){for(let t=0;t<3;t++){const r=t*h,o=r+h;d.push(...ns(e.slice(r,o),u,n,c,s,!1))}d.push("...");for(let t=i-3;t<i;t++){const r=t*h,o=r+h;d.push(...ns(e.slice(r,o),u,n,c,s,t===i-1))}}else for(let t=0;t<i;t++){const r=t*h,o=r+h;d.push(...ns(e.slice(r,o),u,n,c,s,t===i-1))}const f=2===l?",":"";d[0]="["+d[0]+f;for(let e=1;e<d.length-1;e++)d[e]=" "+d[e]+f;let p=",\n";for(let e=2;e<l;e++)p+="\n";return d[d.length-1]=" "+d[d.length-1]+"]"+(o?"":p),d}function rs(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class ss{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=h(e),null!=n){const e=n.length;i(e===this.size,(()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||y(t,this.size),this.strides=N(e)}set(e,...t){0===t.length&&(t=[0]),i(t.length===this.rank,(()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`));const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=${this.shape}`;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return os().makeTensor(this.values,this.shape,this.dtype)}}let os=null,as=null;class is{constructor(e,t,n,r){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=h(e),this.strides=N(e),this.dataId=n,this.id=r,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return as.buffer(this.shape,this.dtype,e)}bufferSync(){return as.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return D(this.shape,e,"complex64"===this.dtype)}arraySync(){return D(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const e=os().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map((e=>jr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataToGPU(e){return this.throwIfDisposed(),os().readToGPU(this.dataId,e)}dataSync(){this.throwIfDisposed();const e=os().readSync(this.dataId);if("string"===this.dtype)try{return e.map((e=>jr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await os().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(os().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return as.print(this,e)}clone(){return this.throwIfDisposed(),as.clone(this)}toString(e=!1){return Qr(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),as.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),os().makeVariable(this,e,t,n)}}Object.defineProperty(is,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),U("Tensor",(()=>is));class ls extends is{constructor(e,t,n,r){super(e.shape,e.dtype,e.dataId,r),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!d(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);os().disposeTensor(this),this.dataId=e.dataId,os().incRef(this,null)}dispose(){os().disposeVariable(this),this.isDisposedInternal=!0}}var us,cs,hs,ds,fs;Object.defineProperty(ls,Symbol.hasInstance,{value:e=>e instanceof is&&null!=e.assign&&e.assign instanceof Function}),function(e){e.R0="R0",e.R1="R1",e.R2="R2",e.R3="R3",e.R4="R4",e.R5="R5",e.R6="R6"}(us||(us={})),function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(cs||(cs={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(hs||(hs={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(ds||(ds={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(fs||(fs={}));const ps={float32:ds,int32:cs,bool:hs,complex64:fs};function gs(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return ps[e][t]}function ms(e){return gs(e,"int32")}function bs(e,t){if(e.dtype===t.dtype)return[e,t];const n=gs(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function ys(e,t){i(e.dtype===t.dtype,(()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`))}function ws(e){const t=[];return ks(e,t,new Set),t}function ks(e,t,n){if(null==e)return;if(e instanceof is)return void t.push(e);if(r=e,!Array.isArray(r)&&"object"!=typeof r)return;var r;const s=e;for(const e in s){const r=s[e];n.has(r)||(n.add(r),ks(r,t,n))}}var vs={__proto__:null,makeTypesMatch:bs,assertTypesMatch:ys,isTensorInList:function(e,t){return t.some((t=>t.id===e.id))},getTensorsInContainer:ws};function xs(e){return null!=e.kernelName}class Es{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((e=>e.name))))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class Ss{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Es}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(Zn(`${e} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new Zr(this.backendInstance),!0}setupRegisteredKernels(){tr(this.backendName).forEach((e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(e){tr(e).forEach((t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])}))}initializeBackend(e){const t=this.registryFactory[e];if(null==t)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const r=t.factory();if(!r||r instanceof n||"function"!=typeof r.then)return this.registry[e]=r,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,n=r.then((n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0))).catch((n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,Zn(`Initialization of backend ${e} failed`),Zn(n.stack||n.message)),!1)));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(t){return Zn(`Initialization of backend ${e} failed`),Zn(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(`${e} backend not found in registry`);this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority))}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:r,asyncInit:s}=this.initializeBackend(n);if(s||r)return{name:n,asyncInit:s}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),r=n.backend,s=this.readSync(t),o=r.refCount(t);r.disposeData(t,!0),n.backend=e,e.move(t,s,n.shape,n.dtype,o),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,r=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");r=e}return this.scopedRun((()=>this.startScope(r)),(()=>this.endScope(n)),(()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return Ss.nextTensorId++}nextVariableId(){return Ss.nextVariableId++}clone(e){const t=As.runKernel("Identity",{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],(e=>({x:()=>{const t={x:e},n={dtype:"float32"};return As.runKernel("Cast",t,n)}})),[],{}),t}runKernel(e,t,n){null==this.backendName&&this.backend;if(!(null!=Qn(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const r=this.backend.numDataIds();let s=0;n.forEach((e=>{s+="complex64"===e.dtype?3:1}));const o=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],a=r-t-s-o;if(a>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${a} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const r=this.isTapeOn(),s=this.state.numBytes,o=this.state.numTensors;let a,l;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const u=xs(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(xs(e)){const{kernelName:t,inputs:s,attrs:o}=e;null==this.backendName&&this.backend;const u=Qn(t,this.backendName);i(null!=u,(()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`)),a=()=>{const e=this.backend.numDataIds();l=u.kernelFunc({inputs:s,attrs:o,backend:this.backend});const a=Array.isArray(l)?l:[l];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,a);const i=a.map((e=>{if(null!=e.rank)return e;const{dataId:t,shape:n,dtype:r}=e;return this.makeTensorFromDataId(t,n,r)}));if(r){const e=this.getTensorsForGradient(t,s,i);n=this.saveTensorsForBackwardMode(e)}return i}}else{const{forwardFunc:t}=e,s=e=>{r&&(n=e.map((e=>this.keep(this.clone(e)))))};a=()=>{const e=this.backend.numDataIds();l=this.tidy((()=>t(this.backend,s)));const n=Array.isArray(l)?l:[l];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(u,e,n),n}}const{inputs:c,attrs:h}=e,d=xs(e)?null:e.backwardsFunc;let f;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(f=this.profiler.profileKernel(u,c,(()=>a())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(f),t=f.outputs):t=a()})),r&&this.addTapeNode(u,c,t,d,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:u,bytesAdded:this.state.numBytes-s,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-o,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(c).map((e=>null!=c[e]?c[e].shape:null)),outputShapes:t.map((e=>e.shape)),kernelTimeMs:f.timeMs,extraInfo:f.extraInfo}),Array.isArray(l)?t:t[0]}saveTensorsForBackwardMode(e){return e.map((e=>this.keep(this.clone(e))))}getTensorsForGradient(e,t,n){const r=er(e);if(null!=r){const e=r.inputsToSave||[],s=r.outputsToSave||[];let o;r.saveAllInputs?(i(Array.isArray(t),(()=>"saveAllInputs is true, expected inputs to be an array.")),o=Object.keys(t).map((e=>t[e]))):o=e.map((e=>t[e]));const a=n.filter(((e,t)=>s[t]));return o.concat(a)}return[]}makeTensor(e,t,n,r){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",r=r||this.backend;let s=e;"string"===n&&S(e[0])&&(s=e.map((e=>Vr(e))));const o=r.write(s,t,n),a=new is(t,n,o,this.nextTensorId());if(this.trackTensor(a,r),"string"===n){const e=this.state.tensorInfo.get(o),t=E(s);this.state.numBytes+=t-e.bytes,e.bytes=t}return a}makeTensorFromDataId(e,t,n,r){const s=new is(t,n=n||"float32",e,this.nextTensorId());return this.trackTensor(s,r),s}makeVariable(e,t=!0,n,r){n=n||this.nextVariableId().toString(),null!=r&&r!==e.dtype&&(e=e.cast(r));const s=new ls(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[s.name])throw new Error(`Variable with name ${s.name} was already registered`);return this.state.registeredVariables[s.name]=s,this.incRef(s,this.backend),s}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*x(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof ls||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*x(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((e=>e.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,r,s,o){const a={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:s},i=er(e);null!=i&&(r=i.gradFunc),null!=r&&(a.gradient=e=>(e=e.map(((e,t)=>{if(null==e){const e=n[t],r=F(e.size,e.dtype);return this.makeTensor(r,e.shape,e.dtype)}return e})),r(e.length>1?e:e[0],s,o))),this.state.activeTape.push(a)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=ws(e),n=new Set(t.map((e=>e.id)));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const r=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach((e=>{e.kept||e.scopeId!==r.id||this.track(e)}))}gradients(e,t,n,r=!1){if(i(t.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const s=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",e)));i(s instanceof is,(()=>"The result y returned by f() must be a tensor."));const o=function(e,t,n){const r={},s={};for(let e=0;e<t.length;e++)r[t[e].id]=!0;for(let n=0;n<e.length;n++){const o=e[n],a=o.inputs;for(const e in a){const n=a[e];let i=!1;for(let e=0;e<t.length;e++)if(r[n.id]){o.outputs.forEach((e=>r[e.id]=!0)),i=!0,s[o.id]=!0;break}if(i)break}}const o={};o[n.id]=!0;const a={};for(let t=e.length-1;t>=0;t--){const n=e[t],r=n.inputs;for(let e=0;e<n.outputs.length;e++)if(o[n.outputs[e].id]){for(const e in r)o[r[e].id]=!0,a[n.id]=!0;break}}const i=[];for(let t=0;t<e.length;t++){const n=e[t];if(s[n.id]&&a[n.id]){const e={};for(const t in n.inputs){const s=n.inputs[t];r[s.id]&&(e[t]=s)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,i.push(t)}}return i}(this.state.activeTape,t,s);if(!r&&0===o.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const e={};e[s.id]=null==n?function(e){const t=R(h(e),"float32");return As.makeTensor(t,e,"float32")}(s.shape):n,function(e,t,n,r){for(let s=t.length-1;s>=0;s--){const o=t[s],a=[];if(o.outputs.forEach((t=>{const n=e[t.id];null!=n?a.push(n):a.push(null)})),null==o.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${o.kernelName}.`);const i=o.gradient(a);for(const t in o.inputs){if(!(t in i))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(i)}.`);const s=n((()=>i[t]()));if("float32"!==s.dtype)throw new Error(`Error in gradient for op ${o.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${s.dtype}'`);const a=o.inputs[t];if(!d(s.shape,a.shape))throw new Error(`Error in gradient for op ${o.kernelName}. The gradient of input '${t}' has shape '${s.shape}', which does not match the shape of the input '${a.shape}'`);if(null==e[a.id])e[a.id]=s;else{const t=e[a.id];e[a.id]=r(t,s),t.dispose()}}}}(e,o,(e=>this.tidy(e)),_s);const r=t.map((t=>e[t.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((e=>{for(const t of e.saved)t.dispose()})),this.state.activeTape=null),{value:s,grads:r}}))}customGrad(e){return i(I(e),(()=>"The f passed in customGrad(f) must be a function.")),(...t)=>{let n;i(t.every((e=>e instanceof is)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const r={};t.forEach(((e,t)=>{r[t]=e}));return this.runKernelFunc({forwardFunc:(r,s)=>(n=e(...t,s),i(n.value instanceof is,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),i(I(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(e,r)=>{const s=n.gradFunc(e,r),o=Array.isArray(s)?s:[s];i(o.length===t.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),i(o.every((e=>e instanceof is)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const a={};return o.forEach(((e,t)=>{a[t]=()=>e})),a},inputs:r})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}readToGPU(e,t){return this.state.tensorInfo.get(e).backend.readToGPU(e,t)}async time(e){const t=Hr(),n=await this.backend.time(e);return n.wallMs=Hr()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Es;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function $s(){const e=K();if(null==e._tfengine){const t=new P(e);e._tfengine=new Ss(t)}var t;return t=e._tfengine.ENV,W=t,os=()=>e._tfengine,e._tfengine}Ss.nextTensorId=0,Ss.nextVariableId=0;const As=$s();function _s(e,t){const n={a:e,b:t};return As.runKernel("Add",n)}let Is;function Ms(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var Ns={__proto__:null,mockIsMobile:function(e){Is=e},isMobile:function(e){if(void 0!==Is)return Is;if(e||"undefined"!=typeof navigator&&null!=navigator){if(e||(e=navigator),"ReactNative"===e.product)return!0;const t=e.userAgent||e.vendor||("undefined"!=typeof window?window.opera:"");if(!t){const t=e;return t.userAgentData&&t.userAgentData.mobile}return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(t)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0,4))}return!1},isBrowser:Ms};const Ts=L();function Ds(e,t){let n=e;if(v(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const r=[];for(;Array.isArray(n)||v(n)&&"string"!==t;)r.push(n.length),n=n[0];return Array.isArray(e)&&L().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&Rs(e,r,[]),r}function Rs(e,t,n){if(n=n||[],!Array.isArray(e)&&!v(e))return void i(0===t.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`));i(t.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`)),i(e.length===t[0],(()=>`Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`));const r=t.slice(1);for(let t=0;t<e.length;++t)Rs(e[t],r,n.concat(t))}function Fs(e,t,n,r){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${r}' must be ${e} tensor, but got ${t} tensor`)}}function Bs(e,t,n,r="numeric"){if(e instanceof is)return Fs(r,e.dtype,t,n),e;let s=_(e);if("string"!==s&&["bool","int32","float32"].indexOf(r)>=0&&(s=r),Fs(r,s,t,n),null==e||!v(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const r=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${r}'`)}const o=Ds(e,s);v(e)||Array.isArray(e)||(e=[e]);const a="string"!==s?Gr(e,s):c(e,[],!0);return As.makeTensor(a,o,s)}function Cs(e,t,n,r="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map(((e,s)=>Bs(e,`${t}[${s}]`,n,r)))}Ts.registerFlag("DEBUG",(()=>!1),(e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),Ts.registerFlag("IS_BROWSER",(()=>Ms())),Ts.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&"undefined"!=typeof process.versions&&"undefined"!=typeof process.versions.node)),Ts.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),Ts.registerFlag("PROD",(()=>!1)),Ts.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>Ts.getBool("DEBUG"))),Ts.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),Ts.registerFlag("IS_TEST",(()=>!1)),Ts.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),Ts.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1));const Ps="__op";function Os(e){const t=Object.keys(e);if(1!==t.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);let n=t[0];const r=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const s=(...e)=>{As.startScope(n);try{const t=r(...e);return C(t)&&console.error("Cannot return a Promise inside of tidy."),As.endScope(t),t}catch(e){throw As.endScope(null),e}};return Object.defineProperty(s,"name",{value:n,configurable:!0}),s}const Ls=Os({complex_:function(e,t){const n=Bs(e,"real","complex"),r=Bs(t,"imag","complex");l(n.shape,r.shape,`real and imag shapes, ${n.shape} and ${r.shape}, must match in call to tf.complex().`);const s={real:n,imag:r};return As.runKernel("Complex",s)}});function zs(e,t,n,r){if(null==r&&(r=_(e)),"complex64"===r)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!v(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){B(t);const e=h(t),r=h(n);i(e===r,(()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${r}`));for(let e=0;e<n.length;++e){const r=n[e],s=e!==n.length-1||r!==h(t.slice(e));i(n[e]===t[e]||!s,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `))}}return v(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==r?Gr(e,r):c(e,[],!0),As.makeTensor(e,t,r)}function Ws(e,t,n){return zs(e,t,Ds(e,n),n)}const Ks={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};function Us(e,t){const n={};let r,s=0;for(const o of t){const t=o.name,a=o.dtype,i=o.shape,l=h(i);let u;if("quantization"in o){const n=o.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${o.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${o.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==a)throw new Error(`Weight ${o.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${a}.`)}const i=Ks[n.dtype],c=e.slice(s,s+l*i),h="uint8"===n.dtype?new Uint8Array(c):new Uint16Array(c);if("float32"===a)if("uint8"===n.dtype||"uint16"===n.dtype){u=new Float32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=t*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===r&&(r=Xs()),u=r(h)}else{if("int32"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);u=new Int32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=Math.round(t*n.scale+n.min)}}s+=l*i}else if("string"===a){const t=h(o.shape);u=[];for(let n=0;n<t;n++){const t=new Uint32Array(e.slice(s,s+4))[0];s+=4;const n=new Uint8Array(e.slice(s,s+t));u.push(n),s+=t}}else{const r=Ks[a],o=e.slice(s,s+l*r);if("float32"===a)u=new Float32Array(o);else if("int32"===a)u=new Int32Array(o);else if("bool"===a)u=new Uint8Array(o);else{if("complex64"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);{u=new Float32Array(o);const e=new Float32Array(u.length/2),r=new Float32Array(u.length/2);for(let t=0;t<e.length;t++)e[t]=u[2*t],r[t]=u[2*t+1];const s=Ws(e,i,"float32"),a=Ws(r,i,"float32");n[t]=Ls(s,a),s.dispose(),a.dispose()}}s+=l*r}"complex64"!==a&&(n[t]=Ws(u,i,a))}return n}function qs(e){if(null===e)throw new Error(`Invalid input value: ${JSON.stringify(e)}`);let t=0;const n=[];e.forEach((e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error(`Unsupported TypedArray subtype: ${e.constructor.name}`)}));const r=new Uint8Array(t);let s=0;return n.forEach((e=>{r.set(new Uint8Array(e.buffer),s),s+=e.byteLength})),r.buffer}const Gs="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function Hs(e){return Gs?Buffer.byteLength(e):new Blob([e]).size}function Vs(e){if(1===e.length)return e[0];let t=0;e.forEach((e=>{t+=e.byteLength}));const n=new Uint8Array(t);let r=0;return e.forEach((e=>{n.set(new Uint8Array(e),r),r+=e.byteLength})),n.buffer}function js(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function Js(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:t};return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),n}async function Zs(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};if(null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),null!=e.weightsManifest){const[r,s]=await t(e.weightsManifest);n.weightSpecs=r,n.weightData=s}return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),n}function Ys(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:Hs(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:Hs(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:e.weightData.byteLength}}function Xs(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return r=>{const s=new ArrayBuffer(4*r.length),o=new Uint32Array(s);for(let s=0;s<r.length;s++){const a=r[s],i=e[n[a>>10]+(1023&a)]+t[a>>10];o[s]=i}return new Float32Array(s)}}class Qs{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==Qs.instance&&(Qs.instance=new Qs),Qs.instance}static registerSaveRouter(e){Qs.getInstance().saveRouters.push(e)}static registerLoadRouter(e){Qs.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return Qs.getHandlers(e,"save")}static getLoadHandlers(e,t){return Qs.getHandlers(e,"load",t)}static getHandlers(e,t,n){const r=[];return("load"===t?Qs.getInstance().loadRouters:Qs.getInstance().saveRouters).forEach((t=>{const s=t(e,n);null!==s&&r.push(s)})),r}}function eo(){if(!L().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function to(e){const t=e.result;t.createObjectStore("models_store",{keyPath:"modelPath"}),t.createObjectStore("model_info_store",{keyPath:"modelPath"})}class no{constructor(e){if(this.indexedDB=eo(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise(((e,n)=>{const r=this.indexedDB.open("tensorflowjs",1);r.onupgradeneeded=()=>to(r),r.onsuccess=()=>{const s=r.result;if(null==t){const t=s.transaction("models_store","readonly"),r=t.objectStore("models_store").get(this.modelPath);r.onsuccess=()=>{if(null==r.result)return s.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(r.result.modelArtifacts)},r.onerror=e=>(s.close(),n(r.error)),t.oncomplete=()=>s.close()}else{const r=Ys(t),o=s.transaction("model_info_store","readwrite");let a=o.objectStore("model_info_store");const i=a.put({modelPath:this.modelPath,modelArtifactsInfo:r});let l;i.onsuccess=()=>{l=s.transaction("models_store","readwrite");const i=l.objectStore("models_store").put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:r});i.onsuccess=()=>e({modelArtifactsInfo:r}),i.onerror=e=>{a=o.objectStore("model_info_store");const t=a.delete(this.modelPath);t.onsuccess=()=>(s.close(),n(i.error)),t.onerror=e=>(s.close(),n(i.error))}},i.onerror=e=>(s.close(),n(i.error)),o.oncomplete=()=>{null==l?s.close():l.oncomplete=()=>s.close()}}},r.onerror=e=>n(r.error)}))}}no.URL_SCHEME="indexeddb://";const ro=e=>{return L().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(no.URL_SCHEME)?(t=e.slice(no.URL_SCHEME.length),new no(t)):null;var t};Qs.registerSaveRouter(ro),Qs.registerLoadRouter(ro);class so{constructor(){this.indexedDB=eo()}async listModels(){return new Promise(((e,t)=>{const n=this.indexedDB.open("tensorflowjs",1);n.onupgradeneeded=()=>to(n),n.onsuccess=()=>{const r=n.result,s=r.transaction("model_info_store","readonly"),o=s.objectStore("model_info_store").getAll();o.onsuccess=()=>{const t={};for(const e of o.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},o.onerror=e=>(r.close(),t(o.error)),s.oncomplete=()=>r.close()},n.onerror=e=>t(n.error)}))}async removeModel(e){var t;return e=(t=e).startsWith(no.URL_SCHEME)?t.slice(no.URL_SCHEME.length):t,new Promise(((t,n)=>{const r=this.indexedDB.open("tensorflowjs",1);r.onupgradeneeded=()=>to(r),r.onsuccess=()=>{const s=r.result,o=s.transaction("model_info_store","readwrite"),a=o.objectStore("model_info_store"),i=a.get(e);let l;i.onsuccess=()=>{if(null==i.result)return s.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const r=a.delete(e),o=()=>{l=s.transaction("models_store","readwrite");const r=l.objectStore("models_store").delete(e);r.onsuccess=()=>t(i.result.modelArtifactsInfo),r.onerror=e=>n(i.error)};r.onsuccess=o,r.onerror=e=>(o(),s.close(),n(i.error))}},i.onerror=e=>(s.close(),n(i.error)),o.oncomplete=()=>{null==l?s.close():l.oncomplete=()=>s.close()}},r.onerror=e=>n(r.error)}))}}const oo="tensorflowjs_models",ao="info",io="model_topology",lo="weight_specs",uo="weight_data",co="model_metadata";function ho(e){return{info:[oo,e,ao].join("/"),topology:[oo,e,io].join("/"),weightSpecs:[oo,e,lo].join("/"),weightData:[oo,e,uo].join("/"),modelMetadata:[oo,e,co].join("/")}}function fo(e){for(const t of Object.values(e))window.localStorage.removeItem(t)}function po(e){const t=e.split("/");if(t.length<3)throw new Error(`Invalid key format: ${e}`);return t.slice(1,t.length-1).join("/")}class go{constructor(e){if(!L().getBool("IS_BROWSER")||"undefined"==typeof window||"undefined"==typeof window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=ho(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),r=Ys(e);try{this.LS.setItem(this.keys.info,JSON.stringify(r)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(Gs)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,r=t.length;e<r;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(e.weightData));const s={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,signature:null!=e.signature?e.signature:void 0,userDefinedMetadata:null!=e.userDefinedMetadata?e.userDefinedMetadata:void 0,modelInitializer:null!=e.modelInitializer?e.modelInitializer:void 0,trainingConfig:null!=e.trainingConfig?e.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(s)),{modelArtifactsInfo:r}}catch(e){throw fo(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${r.modelTopologyBytes}, weightSpecsBytes=${r.weightSpecsBytes}, weightDataBytes=${r.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const r=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==r)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=r;const s=this.LS.getItem(this.keys.modelMetadata);if(null!=s){const e=JSON.parse(s);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(t.trainingConfig=e.trainingConfig)}const o=this.LS.getItem(this.keys.weightData);if(null==o)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(Gs){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(o),t}}go.URL_SCHEME="localstorage://";const mo=e=>{return L().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(go.URL_SCHEME)?(t=e.slice(go.URL_SCHEME.length),new go(t)):null;var t};Qs.registerSaveRouter(mo),Qs.registerLoadRouter(mo);class bo{constructor(){i(L().getBool("IS_BROWSER"),(()=>"Current environment is not a web browser")),i("undefined"==typeof window||"undefined"!=typeof window.localStorage,(()=>"Current browser does not appear to support localStorage")),this.LS=window.localStorage}async listModels(){const e={},t=oo+"/",n="/"+ao;for(let r=0;r<this.LS.length;++r){const s=this.LS.key(r);if(s.startsWith(t)&&s.endsWith(n)){e[po(s)]=JSON.parse(this.LS.getItem(s))}}return e}async removeModel(e){var t;const n=ho(e=(t=e).startsWith(go.URL_SCHEME)?t.slice(go.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const r=JSON.parse(this.LS.getItem(n.info));return fo(n),r}}class yo{constructor(){this.managers={}}static getInstance(){return null==yo.instance&&(yo.instance=new yo),yo.instance}static registerManager(e,t){i(null!=e,(()=>"scheme must not be undefined or null.")),e.endsWith("://")&&(e=e.slice(0,e.indexOf("://"))),i(e.length>0,(()=>"scheme must not be an empty string."));const n=yo.getInstance();i(null==n.managers[e],(()=>`A model store manager is already registered for scheme '${e}'.`)),n.managers[e]=t}static getManager(e){const t=this.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(this.getInstance().managers)}}function wo(e){if(-1===e.indexOf("://"))throw new Error(`The url string provided does not contain a scheme. Supported schemes are: ${yo.getSchemes().join(",")}`);return{scheme:e.split("://")[0],path:e.split("://")[1]}}async function ko(e,t,n=!1){i(e!==t,(()=>`Old path and new path are the same: '${e}'`));const r=Qs.getLoadHandlers(e);i(r.length>0,(()=>`Copying failed because no load handler is found for source URL ${e}.`)),i(r.length<2,(()=>`Copying failed because more than one (${r.length}) load handlers for source URL ${e}.`));const s=r[0],o=Qs.getSaveHandlers(t);i(o.length>0,(()=>`Copying failed because no save handler is found for destination URL ${t}.`)),i(o.length<2,(()=>`Copying failed because more than one (${r.length}) save handlers for destination URL ${t}.`));const a=o[0],l=wo(e).scheme,u=wo(e).path,c=l===wo(e).scheme,h=await s.load();n&&c&&await yo.getManager(l).removeModel(u);const d=await a.save(h);return n&&!c&&await yo.getManager(l).removeModel(u),d.modelArtifactsInfo}class vo{fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Browser's encoder only supports utf-8, but got ${t}`);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}}if(L().get("IS_BROWSER")){L().setPlatform("browser",new vo);try{yo.registerManager(go.URL_SCHEME,new bo)}catch(e){}try{yo.registerManager(no.URL_SCHEME,new so)}catch(e){}}const xo=()=>require("node-fetch");let Eo;class So{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=L().global.fetch?L().global.fetch(e,t):(null==Eo&&(Eo=xo()),Eo(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Node built-in encoder only supports utf-8, but got ${t}`);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}}function $o(e,t="float32",n){return t=t||"float32",B(e),new ss(e,t,n)}L().get("IS_NODE")&&L().setPlatform("node",new So);const Ao=Os({cast_:function(e,t){const n=Bs(e,"x","cast");if(!k(t))throw new Error(`Failed to cast to unknown dtype ${t}`);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const r={x:n},s={dtype:t};return As.runKernel("Cast",r,s)}});const _o=Os({clone_:function(e){const t={x:Bs(e,"x","clone","string_or_numeric")};return As.runKernel("Identity",t)}});function Io(e,t=!1){console.log(e.toString(t))}$s();as={buffer:$o,cast:Ao,clone:_o,print:Io};function Mo(e){return new Promise((e=>setTimeout(e))).then(e)}class No{constructor(e){if(!L().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(No.URL_SCHEME)&&(e=e.slice(No.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelJsonFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=window.URL.createObjectURL(new Blob([e.weightData],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=Js(e,[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}]),r=window.URL.createObjectURL(new Blob([JSON.stringify(n)],{type:"application/json"})),s=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(s.download=this.modelJsonFileName,s.href=r,await Mo((()=>s.dispatchEvent(new MouseEvent("click")))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=t,await Mo((()=>e.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:Ys(e)}}}}No.URL_SCHEME="downloads://";class To{constructor(e){if(null==e||e.length<1)throw new Error(`When calling browserFiles, at least 1 file is required, but received ${e}`);this.jsonFile=e[0],this.weightsFiles=e.slice(1)}async load(){return new Promise(((e,t)=>{const n=new FileReader;n.onload=n=>{const r=JSON.parse(n.target.result),s=r.modelTopology;if(null==s)return void t(new Error(`modelTopology field is missing from file ${this.jsonFile.name}`));if(null==r.weightsManifest)return void t(new Error(`weightManifest field is missing from file ${this.jsonFile.name}`));if(0===this.weightsFiles.length)return void e({modelTopology:s});const o=Zs(r,(e=>this.loadWeights(e)));e(o)},n.onerror=e=>t(`Failed to read model topology and weights manifest JSON from file '${this.jsonFile.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),n.readAsText(this.jsonFile)}))}loadWeights(e){const t=[],n=[];for(const r of e)t.push(...r.weights),n.push(...r.paths);const r=this.checkManifestAndWeightFiles(e),s=n.map((e=>this.loadWeightsFile(e,r[e])));return Promise.all(s).then((e=>[t,Vs(e)]))}loadWeightsFile(e,t){return new Promise(((n,r)=>{const s=new FileReader;s.onload=e=>{const t=e.target.result;n(t)},s.onerror=t=>r(`Failed to weights data from file of path '${e}'.`),s.readAsArrayBuffer(t)}))}checkManifestAndWeightFiles(e){const t=[],n=this.weightsFiles.map((e=>js(e.name))),r={};for(const s of e)s.paths.forEach((e=>{const s=js(e);if(-1!==t.indexOf(s))throw new Error(`Duplicate file basename found in weights manifest: '${s}'`);if(t.push(s),-1===n.indexOf(s))throw new Error(`Weight file with basename '${s}' is not provided.`);r[e]=this.weightsFiles[n.indexOf(s)]}));if(t.length!==this.weightsFiles.length)throw new Error(`Mismatch in the number of files in weights manifest (${t.length}) and the number of weight files provided (${this.weightsFiles.length}).`);return r}}function Do(e,t,n,r){!function(e){i(null!=e&&Array.isArray(e)&&e.length>0,(()=>"promises must be a none empty array"))}(e),function(e,t){i(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${e}`)),i(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${t}`)),i(t>=e,(()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction ${t}`))}(n=null==n?0:n,r=null==r?1:r);let s=0;return Promise.all(e.map((o=>(o.then((o=>{const a=n+ ++s/e.length*(r-n);return t(a),o})),o))))}async function Ro(e,t){null==t&&(t={});const n=null==t.fetchFunc?L().platform.fetch:t.fetchFunc,r=e.map((e=>n(e,t.requestInit,{isBinary:!0}))),s=(null==t.onProgress?await Promise.all(r):await Do(r,t.onProgress,0,.5)).map((e=>e.arrayBuffer()));return null==t.onProgress?await Promise.all(s):await Do(s,t.onProgress,.5,1)}function Fo(e){return async(t,n="",r)=>{const s=t.map((()=>!1)),o={},a=null!=r?r.map((()=>!1)):[],i=[];if(t.forEach(((e,t)=>{let n=0;e.weights.forEach((e=>{const l="quantization"in e?e.quantization.dtype:e.dtype,u=Ks[l]*h(e.shape),c=()=>{s[t]=!0,null==o[t]&&(o[t]=[]),o[t].push({manifestEntry:e,groupOffset:n,sizeBytes:u})};null!=r?r.forEach(((t,n)=>{t===e.name&&(c(),a[n]=!0)})):c(),i.push(e.name),n+=u}))})),!a.every((e=>e))){const e=r.filter(((e,t)=>!a[t]));throw new Error(`Could not find weights in manifest with names: ${e.join(", ")}. \nManifest JSON has weights with names: ${i.join(", ")}.`)}const l=s.reduce(((e,t,n)=>(t&&e.push(n),e)),[]),u=[];l.forEach((e=>{t[e].paths.forEach((e=>{const t=n+(n.endsWith("/")?"":"/")+e;u.push(t)}))}));const c=await e(u),d={};let f=0;return l.forEach((e=>{const n=t[e].paths.length;let r=0;for(let e=0;e<n;e++)r+=c[f+e].byteLength;const s=new ArrayBuffer(r),a=new Uint8Array(s);let i=0;for(let e=0;e<n;e++){const t=new Uint8Array(c[f+e]);a.set(t,i),i+=t.byteLength}o[e].forEach((e=>{const t=Us(s.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)d[e]=t[e]})),f+=n})),d}}Qs.registerSaveRouter((e=>L().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(No.URL_SCHEME)?function(e="model"){return new No(e)}(e.slice(No.URL_SCHEME.length)):null));class Bo{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.onProgress=t.onProgress,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(i("function"==typeof t.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=t.fetchFunc):this.fetch=L().platform.fetch,i(null!=e&&e.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(e)&&i(2===e.length,(()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`)),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{}}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=Js(e,[{paths:["./model.weights.bin"],weights:e.weightSpecs}]);t.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=e.weightData&&t.body.append("model.weights.bin",new Blob([e.weightData],{type:"application/octet-stream"}),"model.weights.bin");const r=await this.fetch(this.path,t);if(r.ok)return{modelArtifactsInfo:Ys(e),responses:[r]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${r.status}.`)}async load(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code ${e.status}. Please verify this URL points to the model JSON of the model to load.`);let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,r=t.weightsManifest;if(null==n&&null==r)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return Zs(t,(e=>this.loadWeights(e)))}async loadWeights(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,r]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),r=e.substring(0,t),s=n>t?e.substring(n):"";return[r+"/",s]}(t),s=this.weightPathPrefix||n,o=[];for(const t of e)o.push(...t.weights);const a=[],i=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?i.push(this.weightUrlConverter(e)):a.push(s+e+r);this.weightUrlConverter&&a.push(...await Promise.all(i));return[o,Vs(await Ro(a,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function Co(e){return null!=e.match(Bo.URL_SCHEME_REGEX)}Bo.URL_SCHEME_REGEX=/^https?:\/\//;const Po=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every((e=>Co(e))):Co(e),n)return Oo(e,t)}return null};function Oo(e,t){return new Bo(e,t)}Qs.registerSaveRouter(Po),Qs.registerLoadRouter(Po);class Lo{constructor(e){this.modelArtifacts=e}async load(){return this.modelArtifacts}}class zo{constructor(e){this.saveHandler=e}async save(e){return this.saveHandler(e)}}var Wo={__proto__:null,browserFiles:function(e){return new To(e)},browserHTTPRequest:function(e,t){return Oo(e,t)},concatenateArrayBuffers:Vs,decodeWeights:Us,encodeWeights:async function(e,t){const n=[],r=[],s=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);for(let o=0;o<s.length;++o){const a=s[o],i=Array.isArray(e)?e[o].tensor:e[a];if("float32"!==i.dtype&&"int32"!==i.dtype&&"bool"!==i.dtype&&"string"!==i.dtype&&"complex64"!==i.dtype)throw new Error(`Unsupported dtype in weight '${a}': ${i.dtype}`);const l={name:a,shape:i.shape,dtype:i.dtype};if("string"===i.dtype){const e=new Promise((async e=>{const t=await i.bytes(),n=t.reduce(((e,t)=>e+t.length),0)+4*t.length,r=new Uint8Array(n);let s=0;for(let e=0;e<t.length;e++){const n=t[e],o=new Uint8Array(new Uint32Array([n.length]).buffer);r.set(o,s),s+=4,r.set(n,s),s+=n.length}e(r)}));r.push(e)}else r.push(i.data());null!=t&&(l.group=t),n.push(l)}return{data:qs(await Promise.all(r)),specs:n}},fromMemory:function(e,t,n,r){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new Lo(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new Lo({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new Lo({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:r})},getLoadHandlers:(e,t)=>Qs.getLoadHandlers(e,t),getModelArtifactsForJSON:Zs,getModelArtifactsInfoForJSON:Ys,getSaveHandlers:e=>Qs.getSaveHandlers(e),http:Oo,isHTTPScheme:Co,loadWeights:async function(e,t="",n,r){return Fo((e=>Ro(e,{requestInit:r})))(e,t,n)},registerLoadRouter:e=>Qs.registerLoadRouter(e),registerSaveRouter:e=>Qs.registerSaveRouter(e),weightsLoaderFactory:Fo,withSaveHandler:function(e){return new zo(e)},copyModel:async function(e,t){return ko(e,t,!1)},listModels:async function(){const e=yo.getSchemes(),t={};for(const n of e){const e=await yo.getManager(n).listModels();for(const r in e){t[n+"://"+r]=e[r]}}return t},moveModel:async function(e,t){return ko(e,t,!0)},removeModel:async function(e){const t=wo(e);return yo.getManager(t.scheme).removeModel(t.path)}};const Ko=Os({matMul_:function(e,t,n=!1,r=!1){let s=Bs(e,"a","matMul"),o=Bs(t,"b","matMul");[s,o]=bs(s,o);const a={a:s,b:o},i={transposeA:n,transposeB:r};return As.runKernel("BatchMatMul",a,i)}});const Uo=Os({oneHot_:function(e,t,n=1,r=0){if(t<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);const s={indices:Bs(e,"indices","oneHot","int32")},o={depth:t,onValue:n,offValue:r};return As.runKernel("OneHot",s,o)}});const qo=Os({transpose_:function(e,t){const n=Bs(e,"x","transpose");if(null==t&&(t=n.shape.map(((e,t)=>t)).reverse()),i(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of perm ${t}.`)),t.forEach((e=>{i(e>=0&&e<n.rank,(()=>"All entries in 'perm' must be between 0 and "+(n.rank-1)+` but got ${t}`))})),n.rank<=1)return n.clone();const r={x:n},s={perm:t};return As.runKernel("Transpose",r,s)}});var Go={__proto__:null,confusionMatrix:Os({confusionMatrix_:function(e,t,n){const r=Bs(e,"labels","confusionMatrix"),s=Bs(t,"predictions","confusionMatrix");i(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),i(1===r.rank,(()=>`Expected the rank of labels to be 1, but got ${r.rank}`)),i(1===s.rank,(()=>`Expected the rank of predictions to be 1, but got ${s.rank}`)),i(r.shape[0]===s.shape[0],(()=>`Mismatch in the number of examples: ${r.shape[0]} vs. ${s.shape[0]}. Labels and predictions should have the same number of elements.`)),i(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const o=Uo(Ao(r,"int32"),n),a=Uo(Ao(s,"int32"),n),l=qo(o),u=Ko(l,a);return Ao(u,"int32")}})};function Ho(e,t){const n=e.length,r=[];for(let s=0;s<n;s++){const o=n-1-s,a=e[o]||1;(t[t.length-1-s]||1)>1&&1===a&&r.unshift(o)}return r}function Vo(e,t){const n=[];for(let r=0;r<t.length;r++){const s=e[e.length-r-1],o=t.length-r-1,a=t[o];(null==s||1===s&&a>1)&&n.unshift(o)}return n}function jo(e,t){const n=[],r=Math.max(e.length,t.length);for(let s=0;s<r;s++){let r=e[e.length-s-1];null==r&&(r=1);let o=t[t.length-s-1];if(null==o&&(o=1),1===r)n.unshift(o);else if(1===o)n.unshift(r);else{if(r!==o){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(r)}}return n}var Jo={__proto__:null,getBroadcastDims:Ho,getReductionAxes:Vo,assertAndGetBroadcastShape:jo};function Zo(e,t,n){if(u(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const r=Ds(e,n);if(3!==r.length&&1!==r.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return zs(e,t,r,n)}let Yo;function Xo(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,r=!1,s=!1,o=!1,a=!1,i=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)r=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)s=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)o=!0;else if(null!=e.getContext)a=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${e.constructor.name}`);i=!0}if(s){const t=2;if(s&&e.readyState<t)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=Qn("FromPixels",As.backendName)){const n={pixels:e},r={numChannels:t};return As.runKernel("FromPixels",n,r)}const[l,u]=s?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(a)c=e.getContext("2d").getImageData(0,0,l,u).data;else if(r||n)c=e.data;else if(o||s||i){if(null==Yo)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");Yo=new OffscreenCanvas(1,1).getContext("2d")}else Yo=document.createElement("canvas").getContext("2d");Yo.canvas.width=l,Yo.canvas.height=u,Yo.drawImage(e,0,0,l,u),c=Yo.getImageData(0,0,l,u).data}if(4===t)h=new Int32Array(c);else{const e=l*u;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return Zo(h,[u,l,t],"int32")}function Qo(e){return"undefined"!=typeof window&&"undefined"!=typeof ImageBitmap&&window.hasOwnProperty("createImageBitmap")&&!(e instanceof ImageBitmap)&&function(e){return null!=e&&0!==e.width&&0!==e.height}(e)&&!function(e){return null!=e&&e.data instanceof Uint8Array}(e)}var ea={__proto__:null,fromPixelsAsync:async function(e,t=3){let n=null;if(L().getBool("WRAP_TO_IMAGEBITMAP")&&Qo(e)){let t;try{t=await createImageBitmap(e,{premultiplyAlpha:"none"})}catch(e){t=null}n=null!=t&&t.width===e.width&&t.height===e.height?t:e}else n=e;return Xo(n,t)},toPixels:async function(e,t){let n=Bs(e,"img","toPixels");if(!(e instanceof is)){const e=n;n=Ao(e,"int32"),e.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[r,s]=n.shape.slice(0,2),o=2===n.rank?1:n.shape[2];if(o>4||2===o)throw new Error(`toPixels only supports depth of size 1, 3 or 4 but got ${o}`);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const a=await n.data(),i="float32"===n.dtype?255:1,l=new Uint8ClampedArray(s*r*4);for(let e=0;e<r*s;++e){const t=[0,0,0,255];for(let r=0;r<o;r++){const s=a[e*o+r];if("float32"===n.dtype){if(s<0||s>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${s}.`)}else if("int32"===n.dtype&&(s<0||s>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${s}.`);1===o?(t[0]=s*i,t[1]=s*i,t[2]=s*i):t[r]=s*i}const r=4*e;l[r+0]=Math.round(t[0]),l[r+1]=Math.round(t[1]),l[r+2]=Math.round(t[2]),l[r+3]=Math.round(t[3])}if(null!=t){t.width=s,t.height=r;const e=t.getContext("2d"),n=new ImageData(l,s,r);e.putImageData(n,0,0)}return n!==e&&n.dispose(),l},fromPixels:Os({fromPixels_:Xo})};function ta(e,t){const n=e.shape.length,r=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(r<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${r}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[r-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[r-1]} vs. ${n}`);if(0===h(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const s=t.shape,o=s[s.length-1];let a=1;for(let e=0;e<s.length-1;++e)a*=s[e];const i=e.shape,l=s.slice();l.pop();let u=1;for(let e=o;e<n;++e)u*=i[e],l.push(i[e]);const c=[...N(e.shape).map((e=>e/u)),1].slice(0,o);return[l,a,u,c]}var na={__proto__:null,prepareAndValidate:ta};function ra(e,t,n){const r=t.rank>1?t.shape[t.rank-1]:1,s=t.rank>1?t.rank-1:1,o=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${r}, and batchDim: ${s}.`;if(n.rank<s)throw new Error(o+` update.rank < ${s}. `);if(e.length<r+(n.rank-s))throw new Error(o+` Output shape length < ${r+(n.rank-s)}`);if(n.rank!==s+e.length-r)throw new Error(o+" update.rank != "+(s+e.length-r));for(let e=0;e<s;++e)if(n.shape[e]!==t.shape[e])throw new Error(o+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-s;++t)if(n.shape[t+s]!==e[t+r])throw new Error(o+` updates.shape[${t+s}] (${n.shape[t+s]}) != shape[${t+s}] (${e[t+s]})`)}function sa(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===t.size)throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);if(0===e.size)throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`)}ra(n,t,e)}function oa(e,t,n){const r=t.shape.length,s=r>1?t.shape[r-1]:1,o=n.length;let a=1;for(let e=s;e<o;++e)a*=n[e];const i=s<1?1:s;return{sliceRank:s,numUpdates:h(t.shape)/i,sliceSize:a,strides:[...N(n.slice(0,s)),1],outputSize:h(n)}}var aa={__proto__:null,validateUpdateShape:ra,validateInput:sa,calculateShapes:oa};function ia(e,t,n,r){const s=[...e];for(let e=s.length;e<r.length;e++)s.push(1);for(let e=0;e<n;e++)0===e?s[t]=1:(s.splice(t,0,1),s.pop());return s}function la(e,t,n){return n<=e?n:n-(t-1)}function ua(e,t){const n=[];for(let r=0;r<e;r++)n.push(t+r);return n}function ca(e,t,n,r,s){const o=[...s],a=ua(n,t);for(let s=0;s<o.length;s++)if(a.indexOf(s)>-1)o[s]=0;else{const a=la(t,n,s);let i=r[a];e&1<<a&&(i=0),o[s]=i}return o}function ha(e,t,n,r,s){const a=[...s],i=ua(n,t);for(let s=0;s<a.length;s++)if(i.indexOf(s)>-1)a[s]=Number.MAX_SAFE_INTEGER;else{const o=la(t,n,s);let i=r[o];e&1<<o&&(i=Number.MAX_SAFE_INTEGER),a[s]=i}for(let e=0;e<a.length;e++){const t=s[e];a[e]<0&&(a[e]+=t),a[e]=o(0,a[e],s[e])}return a}function da(e,t,n){let r=e[t];return(n&1<<t||null==r)&&(r=1),r}function fa(e,t,n,r,s,a){let i=t[s];const l=n[s]||1;(e&1<<s||a&1<<s||null==i)&&(i=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=r[s];return i<0&&(i+=u),i=o(0,i,u-1),i}function pa(e,t,n,r,s,a){let i=t[s];const l=n[s]||1;(e&1<<s||a&1<<s||null==i)&&(i=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=r[s];return i<0&&(i+=u),i=l>0?o(0,i,u):o(-1,i,u-1),i}function ga(e,t,n,r,s,o){if(s[t])return n>0?o[t]:o[t+1&1];{const t=e<0?r+e:e;return t<o[0]?o[0]:t>o[1]?o[1]:t}}var ma={__proto__:null,assertParamsValid:function(e,t,n){const r=e.shape.length;i(r===t.length,(()=>`Error in slice${r}D: Length of begin ${t} must match the rank of the array (${r}).`)),i(r===n.length,(()=>`Error in slice${r}D: Length of size ${n} must match the rank of the array (${r}).`));for(let s=0;s<r;++s)i(t[s]+n[s]<=e.shape[s],(()=>`Error in slice${r}D: begin[${s}] + size[${s}] (${t[s]+n[s]}) would overflow input.shape[${s}] (${e.shape[s]})`))},maskToAxes:function(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t},computeOutShape:function(e,t,n){const r=[];for(let s=0;s<e.length;s++)r[s]=Math.ceil((t[s]-e[s])/n[s]);return r},stridesWithElidedDims:ia,getNormalizedAxes:function(e,t,n,r,s,o,a,i,l){const u=e.length;let c=new Array(u),h=new Array(u),d=new Array(u);if(t.length&&n>0){const l=t[0],u=n+1;c=ca(a,l,u,r,e),h=ha(i,l,u,s,e),d=ia(o,l,u,e)}else for(let t=0;t<u;t++)c[t]=fa(a,r,o,e,t,l),h[t]=pa(i,s,o,e,t,l),d[t]=da(o,t,l);return{begin:c,end:h,strides:d}},startIndicesWithElidedDims:ca,stopIndicesWithElidedDims:ha,stridesForAxis:da,startForAxis:fa,stopForAxis:pa,isSliceContinous:function(e,t,n){let r=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){r=e;break}for(let s=r+1;s<n.length;s++)if(t[s]>0||n[s]!==e[s])return!1;return!0},computeFlatOffset:function(e,t){let n=e.length>0?e[e.length-1]:1;for(let r=0;r<e.length-1;r++)n+=e[r]*t[r];return n},parseSliceParams:function(e,t,n){let r;const s=e.shape.length;let o;return r="number"==typeof t?[t,...new Array(s-1).fill(0)]:t.length<s?t.concat(new Array(s-t.length).fill(0)):t.slice(),r.forEach((e=>{i(-1!==e,(()=>"slice() does not support negative begin indexing."))})),o=null==n?new Array(s).fill(-1):"number"==typeof n?[n,...new Array(s-1).fill(-1)]:n.length<s?n.concat(new Array(s-n.length).fill(-1)):n,o=o.map(((t,n)=>t>=0?t:(i(-1===t,(()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`)),e.shape[n]-r[n]))),[r,o]},sliceInfo:function(e,t,n,r,s,o,a,i,l){let u;if(null==r?(u=new Array(t.length),u.fill(1)):u=r,null!=a&&0!=(a&a-1))throw new Error("Multiple ellipses in slice is not allowed.");let c=!1;const h={dims:u.length,numAddAxisAfterEllipsis:0,begin:t.slice(),end:n.slice(),strides:u.slice(),beginMask:s,endMask:o,ellipsisMask:a,newAxisMask:i,shrinkAxisMask:l};for(let e=0;e<h.dims;e++)c&&0!=(1<<e&i)&&h.numAddAxisAfterEllipsis++,1<<e&a&&(c=!0);c||(h.ellipsisMask|=1<<h.dims,h.dims++);const d={dims:e.length,beginMask:0,endMask:0,beginValid:!1,endValid:!1};!function(e,t){t.beginMask=0,t.endMask=0,t.shrinkAxisMask=0;let n=0;t.beginValid=null!=e.begin,t.endValid=null!=e.end,t.begin=new Array(t.dims),t.end=new Array(t.dims),t.strides=new Array(t.dims),t.finalShapeGatherIndices=[],t.finalShapeGatherIndicesSparse=[],t.inputShapeGatherIndicesSparse=new Array(t.dims);for(let r=0;r<e.dims;r++)if(1<<r&e.ellipsisMask){const s=Math.min(t.dims-(e.dims-r)+1+e.numAddAxisAfterEllipsis,t.dims);for(;n<s;n++)t.begin[n]=0,t.end[n]=0,t.strides[n]=1,t.beginMask|=1<<n,t.endMask|=1<<n,t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(-1),t.inputShapeGatherIndicesSparse[n]=r}else if(1<<r&e.newAxisMask)t.finalShapeGatherIndices.push(-2),t.finalShapeGatherIndicesSparse.push(-1);else{if(n===t.begin.length)throw Error(`Index out of range using input dim ${n}; input has only ${t.dims} dims, ${t.begin.length}.`);null!=e.begin&&(t.begin[n]=e.begin[r]),null!=e.end&&(t.end[n]=e.end[r]),t.strides[n]=e.strides[r],e.beginMask&1<<r&&(t.beginMask|=1<<n),e.endMask&1<<r&&(t.endMask|=1<<n),e.shrinkAxisMask&1<<r?(t.finalShapeGatherIndices.push(-1),t.finalShapeGatherIndicesSparse.push(-1),t.shrinkAxisMask|=1<<n):(t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(r)),t.inputShapeGatherIndicesSparse[n]=r,n++}}(h,d);let f=!0,p=!0,g=!0;const m=[],b=[];for(let t=0;t<e.length;++t){if(0===d.strides[t])throw Error(`strides[${t}] must be non-zero`);const n=!!(d.shrinkAxisMask&1<<t),r=e[t];if(-1===r){m.push(n?1:-1);continue}const s=[d.beginMask&1<<t,d.endMask&1<<t],o=[d.strides[t]>0?0:-1,d.strides[t]>0?r:r-1];if(n&&d.strides[t]<=0)throw Error("only stride 1 allowed on non-range indexing.");g=g&&1===d.strides[t];const a=!!(d.beginMask&1<<t&&d.endMask&1<<t);if(d.beginValid&&d.endValid){if(n){const e=d.begin[t]<0?r+d.begin[t]:d.begin[t];if(d.begin[t]=e,d.end[t]=d.begin[t]+1,e<0||e>=r)throw Error(`slice index ${d.begin[t]} of dimension ${t} out of bounds.`)}else d.begin[t]=ga(d.begin[t],0,d.strides[t],r,s,o),d.end[t]=ga(d.end[t],1,d.strides[t],r,s,o);const e=1===d.strides[t]&&0===d.begin[t]&&d.end[t]===r;f=f&&e,p=p&&(0===t&&1===d.strides[t]||e)}else f=f&&1===d.strides[t]&&a,p=p&&(0===t&&1===d.strides[t]||a);let i,l=!1;if(d.beginValid&&d.endValid?(i=d.end[t]-d.begin[t],l=!0):n?(i=1,l=!0):a&&r>=0&&(i=d.strides[t]<0?-r:r,l=!0),l){let e;e=0===i||i<0!=d.strides[t]<0?0:Math.trunc(i/d.strides[t])+(i%d.strides[t]!=0?1:0),m.push(e)}else m.push(-1)}for(let e=0;e<d.finalShapeGatherIndices.length;++e){const t=d.finalShapeGatherIndices[e];t>=0?b.push(m[t]):-2===t&&b.push(1)}return{finalShapeSparse:b.filter(((e,t)=>-2!==d.finalShapeGatherIndices[t])),finalShape:b,isIdentity:f,sliceDim0:p,isSimpleSlice:g,begin:d.begin,end:d.end,strides:d.strides}}};class ba{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class ya{constructor(){this.classNameMap={}}static getMap(){return null==ya.instance&&(ya.instance=new ya),ya.instance}static register(e){ya.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function wa(e){i(null!=e.className,(()=>"Class being registered does not have the static className property defined.")),i("string"==typeof e.className,(()=>"className is required to be a string, but got type "+typeof e.className)),i(e.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),ya.register(e)}var ka={__proto__:null,Serializable:ba,SerializationMap:ya,registerClass:wa};function va(){return 32===As.backend.floatPrecision()?.001:.1}function xa(e,t,n){let r=!0;if((v(e)||v(t))&&(r=!1),v(e)&&v(t)&&(r=!0),r){const n=e.constructor.name,r=t.constructor.name;if(n!==r)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: ${r}`)}if(Array.isArray(e)&&Array.isArray(t)){const n=Ds(e),r=Ds(t);if(!d(n,r))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${r}]`)}const s=v(e)?e:c(e),o=v(t)?t:c(t);if(s.length!==o.length)throw new Error(`Arrays have different lengths actual: ${s.length} vs expected: ${o.length}.\nActual:   ${s}.\nExpected: ${o}.`);for(let e=0;e<o.length;++e){const t=s[e],r=o[e];if(!n(t,r))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${r}.\nActual:   ${s}.\nExpected: ${o}.`)}}function Ea(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var Sa={__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(e,t,n){return null==n&&(n=va()),xa(e,t,((e,t)=>Ea(e,t,n)))},testEpsilon:va,expectPromiseToFail:function(e,t){e().then((()=>t.fail()),(()=>t()))},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return S(e)||S(e[0])||S(t)||S(t[0])?xa(e,n,((e,t)=>e==t)):xa(e,t,((e,t)=>Ea(e,t,0)))},expectNumbersClose:function(e,t,n){if(null==n&&(n=va()),!Ea(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`)},expectValuesInRange:function(e,t,n){for(let r=0;r<e.length;r++)if(e[r]<t||e[r]>n)throw new Error(`Value out of range:${e[r]} low: ${t}, high: ${n}`)},expectArrayBuffersEqual:function(e,t){const n=new Float32Array(e),r=new Float32Array(t);if(n.length!==r.length)throw new Error(`Expected ArrayBuffer to be of length ${r.length}, but it was ${n.length}`);for(let e=0;e<r.length;e++)if(n[e]!==r[e])throw new Error(`Expected ArrayBuffer value at ${e} to be ${r[e]} but got ${n[e]} instead`)},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const r=t[n];Array.isArray(r)?e(r):t[n]=Vr(r)}return t}};const $a="3.13.0";function Aa(){L().set("PROD",!0)}function _a(){L().set("DEBUG",!0)}function Ia(){L().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")}function Ma(e){L().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")}function Na(){As.disposeVariables()}function Ta(){return As}function Da(){return As.memory()}function Ra(e){return As.profile(e)}function Fa(e,t){return As.tidy(e,t)}function Ba(e){ws(e).forEach((e=>e.dispose()))}function Ca(e){return As.keep(e)}function Pa(e){return As.time(e)}function Oa(e){return As.setBackend(e)}function La(){return As.ready()}function za(){return As.backendName}function Wa(e){As.removeBackend(e)}function Ka(e){return As.findBackend(e)}function Ua(e){return As.findBackendFactory(e)}function qa(e,t,n=1){return As.registerBackend(e,t,n)}function Ga(){return As.backend}function Ha(e,t){L().setPlatform(e,t)}const Va=Os({add_:function(e,t){let n=Bs(e,"a","add"),r=Bs(t,"b","add");[n,r]=bs(n,r);const s={a:n,b:r};return As.runKernel("Add",s)}});const ja=Os({floorDiv_:function(e,t){let n=Bs(e,"a","floorDiv"),r=Bs(t,"b","floorDiv");[n,r]=bs(n,r);const s={a:n,b:r};return As.runKernel("FloorDiv",s)}});const Ja=Os({div_:function(e,t){let n=Bs(e,"a","div"),r=Bs(t,"b","div");if([n,r]=bs(n,r),"int32"===n.dtype&&"int32"===r.dtype)return ja(n,r);const s={a:n,b:r};return As.runKernel("RealDiv",s,{})}});const Za=Os({mul_:function(e,t){let n=Bs(e,"a","mul"),r=Bs(t,"b","mul");[n,r]=bs(n,r);const s={a:n,b:r};return As.runKernel("Multiply",s)}});const Ya=Os({abs_:function(e){const t=Bs(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return As.runKernel("ComplexAbs",e)}{const e={x:t};return As.runKernel("Abs",e)}}});const Xa=Os({acos_:function(e){const t={x:Bs(e,"x","acos")};return As.runKernel("Acos",t)}});const Qa=Os({acosh_:function(e){const t={x:Bs(e,"x","acosh")};return As.runKernel("Acosh",t)}});const ei=Os({addN_:function(e){i(Array.isArray(e),(()=>"The argument passed to tf.addN() must be a list of tensors")),i(e.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${e.length}`));const t=e.map(((e,t)=>Bs(e,`tensors${t}`,"addN"))),n=t[0];t.forEach((e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),t.forEach((e=>{if(!d(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const r=t;return As.runKernel("AddN",r)}});const ti=Os({all_:function(e,t=null,n=!1){const r={x:Bs(e,"x","all","bool")},s={axis:t,keepDims:n};return As.runKernel("All",r,s)}});const ni=Os({any_:function(e,t=null,n=!1){const r={x:Bs(e,"x","any","bool")},s={axis:t,keepDims:n};return As.runKernel("Any",r,s)}});const ri=Os({argMax_:function(e,t=0){const n={x:Bs(e,"x","argMax")},r={axis:t};return As.runKernel("ArgMax",n,r)}});const si=Os({argMin_:function(e,t=0){const n={x:Bs(e,"x","argMin")},r={axis:t};return As.runKernel("ArgMin",n,r)}});const oi=Os({asin_:function(e){const t={x:Bs(e,"x","asin")};return As.runKernel("Asin",t)}});const ai=Os({asinh_:function(e){const t={x:Bs(e,"x","asinh")};return As.runKernel("Asinh",t)}});const ii=Os({atan_:function(e){const t={x:Bs(e,"x","atan")};return As.runKernel("Atan",t)}});const li=Os({atan2_:function(e,t){let n=Bs(e,"a","atan2"),r=Bs(t,"b","atan2");[n,r]=bs(n,r);const s={a:n,b:r};return As.runKernel("Atan2",s)}});const ui=Os({atanh_:function(e){const t={x:Bs(e,"x","atanh")};return As.runKernel("Atanh",t)}});function ci(e,t,n,r,s,o,a="channelsLast"){const[i,l]=pi(t);let u;if("channelsLast"===a)u=[i,l,e[3],e[3]];else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);u=[i,l,e[1],e[1]]}return hi(e,u,n,r,s,o,!1,a)}function hi(e,t,n,r,s,o,a=!1,i="channelsLast"){let[l,u,c,h]=[-1,-1,-1,-1];if("channelsLast"===i)[l,u,c,h]=e;else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);[l,h,u,c]=e}const[d,f,,p]=t,[g,m]=pi(n),[b,y]=pi(r),w=mi(d,b),k=mi(f,y),{padInfo:v,outHeight:x,outWidth:E}=function(e,t,n,r,s,o,a,i,l){let u,c,h;if("number"==typeof e){u={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const s=function(e,t,n,r,s){null==r&&(r=fi(e,t,n));const o=e[0],a=e[1],i=bi((o-t+2*r)/n+1,s),l=bi((a-t+2*r)/n+1,s);return[i,l]}([t,n],o,r,e,i);c=s[0],h=s[1]}else if("same"===e){c=Math.ceil(t/r),h=Math.ceil(n/s);const e=Math.max(0,(c-1)*r+o-t),i=Math.max(0,(h-1)*s+a-n),l=Math.floor(e/2),d=e-l,f=Math.floor(i/2);u={top:l,bottom:d,left:f,right:i-f,type:"SAME"}}else if("valid"===e)u={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-o+1)/r),h=Math.ceil((n-a+1)/s);else{if("object"!=typeof e)throw Error(`Unknown padding parameter: ${e}`);{const d="channelsLast"===l?e[1][0]:e[2][0],f="channelsLast"===l?e[1][1]:e[2][1],p="channelsLast"===l?e[2][0]:e[3][0],g="channelsLast"===l?e[2][1]:e[3][1];u={top:d,bottom:f,left:p,right:g,type:0===d&&0===f&&0===p&&0===g?"VALID":"EXPLICIT"},c=bi((t-o+d+f)/r+1,i),h=bi((n-a+p+g)/s+1,i)}}return{padInfo:u,outHeight:c,outWidth:h}}(s,u,c,g,m,w,k,o,i),S=a?p*h:p;let $;return"channelsFirst"===i?$=[l,S,x,E]:"channelsLast"===i&&($=[l,x,E,S]),{batchSize:l,dataFormat:i,inHeight:u,inWidth:c,inChannels:h,outHeight:x,outWidth:E,outChannels:S,padInfo:v,strideHeight:g,strideWidth:m,filterHeight:d,filterWidth:f,effectiveFilterHeight:w,effectiveFilterWidth:k,dilationHeight:b,dilationWidth:y,inShape:e,outShape:$,filterShape:t}}function di(e,t,n,r,s,o=!1,a="channelsLast",i){let[l,u,c,h,d]=[-1,-1,-1,-1,-1];if("channelsLast"===a)[l,u,c,h,d]=e;else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);[l,d,u,c,h]=e}const[f,p,g,,m]=t,[b,y,w]=gi(n),[k,v,x]=gi(r),E=mi(f,k),S=mi(p,v),$=mi(g,x),{padInfo:A,outDepth:_,outHeight:I,outWidth:M}=function(e,t,n,r,s,o,a,i,l,u,c){let h,d,f,p;if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const o=function(e,t,n,r,s,o){null==s&&(s=fi(e,t,r));const a=e[0],i=e[1],l=e[2],u=bi((a-t+2*s)/r+1,o),c=bi((i-t+2*s)/r+1,o),h=bi((l-t+2*s)/r+1,o);return[u,c,h,n]}([t,n,r,1],i,1,s,e,c);d=o[0],f=o[1],p=o[2]}else if("same"===e){d=Math.ceil(t/s),f=Math.ceil(n/o),p=Math.ceil(r/a);const e=(d-1)*s+i-t,c=(f-1)*o+l-n,g=(p-1)*a+u-r,m=Math.floor(e/2),b=e-m,y=Math.floor(c/2),w=c-y,k=Math.floor(g/2);h={top:y,bottom:w,left:k,right:g-k,front:m,back:b,type:"SAME"}}else{if("valid"!==e)throw Error(`Unknown padding parameter: ${e}`);h={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},d=Math.ceil((t-i+1)/s),f=Math.ceil((n-l+1)/o),p=Math.ceil((r-u+1)/a)}return{padInfo:h,outDepth:d,outHeight:f,outWidth:p}}(s,u,c,h,b,y,w,E,S,$,i),N=o?m*d:m;let T;return"channelsFirst"===a?T=[l,N,_,I,M]:"channelsLast"===a&&(T=[l,_,I,M,N]),{batchSize:l,dataFormat:a,inDepth:u,inHeight:c,inWidth:h,inChannels:d,outDepth:_,outHeight:I,outWidth:M,outChannels:N,padInfo:A,strideDepth:b,strideHeight:y,strideWidth:w,filterDepth:f,filterHeight:p,filterWidth:g,effectiveFilterDepth:E,effectiveFilterHeight:S,effectiveFilterWidth:$,dilationDepth:k,dilationHeight:v,dilationWidth:x,inShape:e,outShape:T,filterShape:t}}function fi(e,t,n,r=1){const s=mi(t,r);return Math.floor((e[0]*(n-1)-n+s)/2)}function pi(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function gi(e){return"number"==typeof e?[e,e,e]:e}function mi(e,t){return t<=1?e:e+(e-1)*(t-1)}function bi(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error(`Unknown roundingMode ${t}`)}}function yi(e){const[t,n,r]=pi(e);return 1===t&&1===n&&1===r}function wi(e,t){return yi(e)||yi(t)}function ki(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error(`Unknown dataFormat ${e}`)}function vi(e,t,n){if(null!=n){if("string"==typeof t)throw Error(`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);if("number"==typeof t)i(f(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`));else{if("object"!=typeof t)throw Error(`Error in ${e}: Unknown padding parameter: ${t}`);t.forEach((t=>{t.forEach((t=>{i(f(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`))}))}))}}}const xi=Os({reshape_:function(e,t){const n={x:Bs(e,"x","reshape","string_or_numeric")},r={shape:t};return As.runKernel("Reshape",n,r)}});const Ei=Os({avgPool_:function(e,t,n,r,s){const o=Bs(e,"x","avgPool","float32");i(wi(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let a=o,l=!1;3===o.rank&&(l=!0,a=xi(o,[1,o.shape[0],o.shape[1],o.shape[2]])),i(4===a.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${a.rank}.`)),vi("avgPool",r,s);const u={x:a},c={filterSize:t,strides:n,pad:r,dimRoundingMode:s};let h=As.runKernel("AvgPool",u,c);return h=Ao(h,o.dtype),l?xi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Si=Os({avgPool3d_:function(e,t,n,r,s,o="NDHWC"){const a=Bs(e,"x","avgPool3d","float32");let l=a,u=!1;4===a.rank&&(u=!0,l=xi(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),i(5===l.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${l.rank}.`)),i("NDHWC"===o,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${o}`)),vi("avgPool3d",r,s);const c={x:l},h={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:o};let d=As.runKernel("AvgPool3D",c,h);return d=Ao(d,l.dtype),u?xi(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const $i=Os({concat_:function(e,t=0){i(e.length>=1,(()=>"Pass at least one tensor to concat"));const n=Cs(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)})),1===n.length)return _o(n[0]);const r=n,s={axis:t};return As.runKernel("Concat",r,s)}});const Ai=Os({sigmoid_:function(e){const t={x:Bs(e,"x","sigmoid","float32")};return As.runKernel("Sigmoid",t)}});const _i=Os({slice_:function(e,t,n){const r=Bs(e,"x","slice","string_or_numeric");if(0===r.rank)throw new Error("Slicing scalar is not possible");const s={x:r},o={begin:t,size:n};return As.runKernel("Slice",s,o)}});const Ii=Os({tanh_:function(e){const t={x:Bs(e,"x","tanh","float32")};return As.runKernel("Tanh",t)}});const Mi=Os({basicLSTMCell_:function(e,t,n,r,s,o){const a=Bs(e,"forgetBias","basicLSTMCell"),i=Bs(t,"lstmKernel","basicLSTMCell"),l=Bs(n,"lstmBias","basicLSTMCell"),u=Bs(r,"data","basicLSTMCell"),c=Bs(s,"c","basicLSTMCell"),h=Bs(o,"h","basicLSTMCell"),d=$i([u,h],1),f=Ko(d,i),p=Va(f,l),g=p.shape[0],m=p.shape[1]/4,b=[g,m],y=_i(p,[0,0],b),w=_i(p,[0,m],b),k=_i(p,[0,2*m],b),v=_i(p,[0,3*m],b),x=Va(Za(Ai(y),Ii(w)),Za(c,Ai(Va(a,k))));return[x,Za(Ii(x),Ai(v))]}});const Ni=Os({batchToSpaceND_:function(e,t,n){const r=Bs(e,"x","batchToSpaceND"),s=t.reduce(((e,t)=>e*t));i(r.rank>=1+t.length,(()=>`input rank is ${r.rank} but should be > than blockShape.length ${t.length}`)),i(n.length===t.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`)),i(r.shape[0]%s==0,(()=>`input tensor batch is ${r.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${s}`));const o={x:r},a={blockShape:t,crops:n};return As.runKernel("BatchToSpaceND",o,a)}});const Ti=Os({batchNorm_:function(e,t,n,r,s,o){null==o&&(o=.001);const a=Bs(e,"x","batchNorm"),l=Bs(t,"mean","batchNorm"),u=Bs(n,"variance","batchNorm");let c,h;null!=s&&(c=Bs(s,"scale","batchNorm")),null!=r&&(h=Bs(r,"offset","batchNorm")),i(l.rank===u.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),i(null==h||l.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),i(null==c||l.rank===c.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const d={x:function(e){let t;return t=0===e.rank||1===e.rank?xi(e,[1,1,1,e.size]):2===e.rank?xi(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?xi(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(a),scale:c,offset:h,mean:l,variance:u},f={varianceEpsilon:o},p=As.runKernel("FusedBatchNorm",d,f);return xi(p,a.shape)}});const Di=Os({batchNorm2d_:function(e,t,n,r,s,o){const a=Bs(e,"x","batchNorm"),l=Bs(t,"mean","batchNorm"),u=Bs(n,"variance","batchNorm");let c,h;return null!=s&&(c=Bs(s,"scale","batchNorm")),null!=r&&(h=Bs(r,"offset","batchNorm")),i(2===a.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${a.rank}.`)),i(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${l.rank}.`)),i(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=c&&i(2===c.rank||1===c.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`)),null!=h&&i(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),Ti(a,l,u,h,c,o)}});const Ri=Os({batchNorm3d_:function(e,t,n,r,s,o){const a=Bs(e,"x","batchNorm"),l=Bs(t,"mean","batchNorm"),u=Bs(n,"variance","batchNorm");let c,h;return null!=s&&(c=Bs(s,"scale","batchNorm")),null!=r&&(h=Bs(r,"offset","batchNorm")),i(3===a.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${a.rank}.`)),i(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${l.rank}.`)),i(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=c&&i(3===c.rank||1===c.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`)),null!=h&&i(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),Ti(a,l,u,h,c,o)}});const Fi=Os({batchNorm4d_:function(e,t,n,r,s,o){const a=Bs(e,"x","batchNorm"),l=Bs(t,"mean","batchNorm"),u=Bs(n,"variance","batchNorm");let c,h;return null!=s&&(c=Bs(s,"scale","batchNorm")),null!=r&&(h=Bs(r,"offset","batchNorm")),i(4===a.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${a.rank}.`)),i(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${l.rank}.`)),i(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=c&&i(4===c.rank||1===c.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`)),null!=h&&i(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),Ti(a,l,u,h,c,o)}});const Bi=Os({bincount_:function(e,t,n){const r=Bs(e,"x","bincount"),s=Bs(t,"weights","bincount");i("int32"===r.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${r.dtype}`)),i(n>=0,(()=>`size must be non-negative, but got ${n}.`)),i(s.size===r.size||0===s.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${r.shape}, weights shape: ${s.shape}.`));const o={x:r,weights:s},a={size:n};return As.runKernel("Bincount",o,a)}});const Ci=Os({broadcastArgs_:function(e,t){const n=Bs(e,"s0","broadcastArgs","int32"),r=Bs(t,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==r.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${r.rank}`);const s={s0:n,s1:r};return As.runKernel("BroadcastArgs",s)}});const Pi=Os({broadcastTo_:function(e,t){let n=Bs(e,"broadcastTo","x");const r=n.shape;if(t.some((e=>!(e>0)||e%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=xi(n,e)}const s=n.shape,o=Array.from(t);for(let e=t.length-1;e>=0;e--)if(s[e]===t[e])o[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${t}].`);if(0===o.map(((e,t)=>e>1?t:-1)).filter((e=>e>=0)).length)return _o(n);const a={x:n},i={reps:o};return As.runKernel("Tile",a,i)}});const Oi=Os({ceil_:function(e){const t={x:Bs(e,"x","ceil","float32")};return As.runKernel("Ceil",t)}});const Li=Os({clipByValue_:function(e,t,n){const r=Bs(e,"x","clipByValue");i(t<=n,(()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`));const s={x:r},o={clipValueMin:t,clipValueMax:n};return As.runKernel("ClipByValue",s,o)}});const zi=Os({concat1d_:function(e){return $i(e,0)}});const Wi=Os({concat2d_:function(e,t){return $i(e,t)}});const Ki=Os({concat3d_:function(e,t){return $i(e,t)}});const Ui=Os({concat4d_:function(e,t){return $i(e,t)}});const qi=Os({conv2d_:function(e,t,n,r,s="NHWC",o=[1,1],a){const l=Bs(e,"x","conv2d","float32"),u=Bs(t,"filter","conv2d","float32");let c=l,h=!1;3===l.rank&&(h=!0,c=xi(l,[1,l.shape[0],l.shape[1],l.shape[2]])),i(4===c.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`)),i(4===u.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${u.rank}.`)),vi("conv2d",r,a);const d="NHWC"===s?c.shape[3]:c.shape[1];i(d===u.shape[2],(()=>`Error in conv2d: depth of input (${d}) must match input depth for filter ${u.shape[2]}.`)),i(wi(n,o),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`));const f={x:c,filter:u},p={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:a},g=As.runKernel("Conv2D",f,p);return h?xi(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Gi=Os({conv1d_:function(e,t,n,r,s="NWC",o=1,a){const l=Bs(e,"x","conv1d"),u=Bs(t,"filter","conv1d");let c=l,h=!1;2===l.rank&&(h=!0,c=xi(l,[1,l.shape[0],l.shape[1]])),i(3===c.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`)),i(3===u.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${u.rank}.`)),vi("conv1d",r,a),i(c.shape[2]===u.shape[1],(()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${u.shape[1]}.`)),i(wi(n,o),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${o}'`)),i("NWC"===s,(()=>`Error in conv1d: got dataFormat of ${s} but only NWC is currently supported.`));const d=xi(u,[1,u.shape[0],u.shape[1],u.shape[2]]),f=xi(c,[c.shape[0],1,c.shape[1],c.shape[2]]),p=qi(f,d,[1,n],r,"NHWC",[1,o],a);return xi(p,h?[p.shape[2],p.shape[3]]:[p.shape[0],p.shape[2],p.shape[3]])}});const Hi=Os({conv2DBackpropInput_:function(e,t,n,r,s,o="NHWC",a){i(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let l=e,u=t,c=!1;3===t.rank&&(c=!0,u=xi(t,[1,t.shape[0],t.shape[1],t.shape[2]]),l=[1,e[0],e[1],e[2]]),i(4===l.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${l.length}.`)),i(4===u.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${u.rank}`)),i(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===o?l[3]:l[1],d="NHWC"===o?u.shape[3]:u.shape[1];i(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),i(d===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${d}) must match output depth for filter ${n.shape[3]}.`)),vi("conv2dDerInput",s,a);const f={dy:u,filter:n},p={strides:r,pad:s,dataFormat:o,dimRoundingMode:a,inputShape:l},g=As.runKernel("Conv2DBackpropInput",f,p);return c?xi(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Vi=Os({conv2dTranspose_:function(e,t,n,r,s,o){const a=Bs(e,"x","conv2dTranspose"),i=Bs(t,"filter","conv2dTranspose");return Hi(n,a,i,r,s,"NHWC",o)}});const ji=Os({conv3d_:function(e,t,n,r,s="NDHWC",o=[1,1,1]){const a=Bs(e,"x","conv3d"),l=Bs(t,"filter","conv3d");let u=a,c=!1;4===a.rank&&(c=!0,u=xi(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),i(5===u.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${u.rank}.`)),i(5===l.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${l.rank}.`)),i(u.shape[4]===l.shape[3],(()=>`Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${l.shape[3]}.`)),i(wi(n,o),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),i("NDHWC"===s,(()=>`Error in conv3d: got dataFormat of ${s} but only NDHWC is currently supported.`));const h={x:u,filter:l},d={strides:n,pad:r,dataFormat:s,dilations:o},f=As.runKernel("Conv3D",h,d);return c?xi(f,[f.shape[1],f.shape[2],f.shape[3],f.shape[4]]):f}});const Ji=Os({conv3DBackpropInput_:function(e,t,n,r,s){i(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let o=e,a=t,l=!1;4===t.rank&&(l=!0,a=xi(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),o=[1,e[0],e[1],e[2],e[3]]);const u=o[4],c=a.shape[4];i(5===o.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${o.length}.`)),i(5===a.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${a.rank}`)),i(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),i(u===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`)),i(c===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`));const h={dy:a,filter:n},d={pad:s,strides:r,inputShape:o},f=As.runKernel("Conv3DBackpropInputV2",h,d);return l?xi(f,[f.shape[1],f.shape[2],f.shape[3],f.shape[4]]):f}});const Zi=Os({conv3dTranspose_:function(e,t,n,r,s){const o=Bs(e,"x","conv3dTranspose"),a=Bs(t,"filter","conv3dTranspose");return Ji(n,o,a,r,s)}});const Yi=Os({cos_:function(e){const t={x:Bs(e,"x","cos","float32")};return As.runKernel("Cos",t)}});const Xi=Os({cosh_:function(e){const t={x:Bs(e,"x","cosh","float32")};return As.runKernel("Cosh",t)}});const Qi=Os({cumsum_:function(e,t=0,n=!1,r=!1){const s={x:Bs(e,"x","cumsum")},o={axis:t,exclusive:n,reverse:r};return As.runKernel("Cumsum",s,o)}});const el=Os({denseBincount_:function(e,t,n,r=!1){const s=Bs(e,"x","denseBincount"),o=Bs(t,"weights","denseBincount");i("int32"===s.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${s.dtype}`)),i(s.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${s.rank}.`)),i(n>=0,(()=>`size must be non-negative, but got ${n}.`)),i(o.size===s.size||0===o.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${s.shape}, weights shape: ${o.shape}.`));const a={x:s,weights:o},l={size:n,binaryOutput:r};return As.runKernel("DenseBincount",a,l)}});const tl=Os({depthToSpace_:function(e,t,n="NHWC"){const r=Bs(e,"x","depthToSpace","float32"),s="NHWC"===n?r.shape[1]:r.shape[2],o="NHWC"===n?r.shape[2]:r.shape[3],a="NHWC"===n?r.shape[3]:r.shape[1];i(t>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${t}`)),i(s*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${s} and ${t}  for depthToSpace with input shape\n    ${r.shape}`)),i(o*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${o} and ${t} for depthToSpace with input shape\n        ${r.shape}`)),i(a%(t*t)==0,(()=>`Dimension size must be evenly divisible by ${t*t} but is ${a} for depthToSpace with input shape ${r.shape}`));const l={x:r},u={blockSize:t,dataFormat:n};return As.runKernel("DepthToSpace",l,u)}});const nl=Os({depthwiseConv2d_:function(e,t,n,r,s="NHWC",o=[1,1],a){const l=Bs(e,"x","depthwiseConv2d","float32"),u=Bs(t,"filter","depthwiseConv2d","float32");let c=l,h=!1;3===l.rank&&(h=!0,c=xi(l,[1,l.shape[0],l.shape[1],l.shape[2]])),i(4===c.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`)),i(4===u.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${u.rank}.`)),i(c.shape[3]===u.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${c.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`)),vi("depthwiseConv2d",r,a);const d={x:c,filter:u},f={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:a},p=As.runKernel("DepthwiseConv2dNative",d,f);return h?xi(p,[p.shape[1],p.shape[2],p.shape[3]]):p}});const rl=Os({diag_:function(e){const t={x:Bs(e,"x","diag")};return As.runKernel("Diag",t)}});const sl=Os({dilation2d_:function(e,t,n,r,s=[1,1],o="NHWC"){const a=Bs(e,"x","dilation2d"),l=Bs(t,"filter","dilation2d");i(3===a.rank||4===a.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${a.rank}.`)),i(3===l.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${l.rank}.`)),i("NHWC"===o,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${o}`));let u=a,c=!1;3===a.rank&&(u=xi(a,[1,a.shape[0],a.shape[1],a.shape[2]]),c=!0);const h={x:u,filter:l},d={strides:n,pad:r,dilations:s},f=As.runKernel("Dilation2D",h,d);return c?xi(f,[f.shape[1],f.shape[2],f.shape[3]]):f}});const ol=Os({equal_:function(e,t){let n=Bs(e,"a","equal","string_or_numeric"),r=Bs(t,"b","equal","string_or_numeric");[n,r]=bs(n,r),jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("Equal",s)}});const al=Os({where_:function(e,t,n){const r=Bs(t,"a","where"),s=Bs(n,"b","where"),o=Bs(e,"condition","where","bool"),a=jo(jo(o.shape,r.shape),s.shape),i={condition:Pi(o,a),t:Pi(r,a),e:Pi(s,a)};return As.runKernel("Select",i)}});const il=Os({zerosLike_:function(e){const t={x:Bs(e,"x","zerosLike")};return As.runKernel("ZerosLike",t)}});const ll=Os({divNoNan_:function(e,t){let n=Bs(e,"a","div"),r=Bs(t,"b","div");[n,r]=bs(n,r);const s=Ja(n,r),o=il(s),a=ol(r,o);return al(a,o,s)}});const ul=Os({dot_:function(e,t){const n=Bs(e,"t1","dot"),r=Bs(t,"t2","dot");i(!(1!==n.rank&&2!==n.rank||1!==r.rank&&2!==r.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${r.rank}.`));const s=1===n.rank?n.size:n.shape[1],o=1===r.rank?r.size:r.shape[0];if(i(s===o,(()=>`Error in dot: inner dimensions of inputs must match, but got ${s} and ${o}.`)),1===n.rank&&1===r.rank){const e=xi(n,[1,-1]),t=xi(r,[-1,1]),s=Ko(e,t);return xi(s,[])}if(1===n.rank&&2===r.rank){const e=xi(n,[1,-1]),t=xi(r,[r.shape[0],r.shape[1]]),s=Ko(e,t);return xi(s,[s.size])}if(2===n.rank&&1===r.rank){const e=xi(r,[-1,1]),t=Ko(n,e);return xi(t,[t.size])}{const e=xi(r,[r.shape[0],r.shape[1]]);return Ko(n,e)}}});const cl=Os({einsum_:function(e,...t){const n=t.map(((e,t)=>Bs(e,`tensors${t}`,"einsum"))),r={equation:e};return As.runKernel("Einsum",n,r)}});const hl=Os({elu_:function(e){const t={x:Bs(e,"x","elu","float32")};return As.runKernel("Elu",t)}});const dl=Os({erf_:function(e){let t=Bs(e,"x","erf");i("int32"===t.dtype||"float32"===t.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===t.dtype&&(t=Ao(t,"float32"));const n={x:t};return As.runKernel("Erf",n)}});const fl=Os({exp_:function(e){const t={x:Bs(e,"x","exp")};return As.runKernel("Exp",t)}});const pl=Os({expandDims_:function(e,t=0){const n=Bs(e,"x","expandDims","string_or_numeric");i(t<=n.rank,(()=>"Axis must be <= rank of the tensor"));const r={input:n},s={dim:t};return As.runKernel("ExpandDims",r,s)}});const gl=Os({expm1_:function(e){const t={x:Bs(e,"x","expm1")};return As.runKernel("Expm1",t)}});const ml=Os({tile_:function(e,t){const n=Bs(e,"x","tile","string_or_numeric");i(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`));const r={x:n},s={reps:t};return As.runKernel("Tile",r,s)}});const bl=Os({eye_:function(e,t,n,r="float32"){null==t&&(t=e);const s=$o([e,t],r),o=e<=t?e:t;for(let e=0;e<o;++e)s.set(1,e,e);const a=xi(s.toTensor(),[e,t]);if(null==n)return a;if(1===n.length)return ml(pl(a,0),[n[0],1,1]);if(2===n.length)return ml(pl(pl(a,0),0),[n[0],n[1],1,1]);if(3===n.length)return ml(pl(pl(pl(a,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function yl(e,t,n){const r={shape:e,value:t,dtype:n};return As.runKernel("Fill",{},r)}const wl=Os({floor_:function(e){const t={x:Bs(e,"x","floor","float32")};return As.runKernel("Floor",t)}});const kl=Os({gather_:function(e,t,n=0,r=0){const s={x:Bs(e,"x","gather"),indices:Bs(t,"indices","gather","int32")},o={axis:n,batchDims:r};return As.runKernel("GatherV2",s,o)}});const vl=Os({greater_:function(e,t){let n=Bs(e,"a","greater","string_or_numeric"),r=Bs(t,"b","greater","string_or_numeric");[n,r]=bs(n,r),jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("Greater",s)}});const xl=Os({greaterEqual_:function(e,t){let n=Bs(e,"a","greaterEqual","string_or_numeric"),r=Bs(t,"b","greaterEqual","string_or_numeric");[n,r]=bs(n,r),jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("GreaterEqual",s)}});const El=Os({imag_:function(e){const t={input:Bs(e,"input","imag")};return As.runKernel("Imag",t)}});const Sl=Os({isFinite_:function(e){const t={x:Bs(e,"x","isFinite")};return As.runKernel("IsFinite",t)}});const $l=Os({isInf_:function(e){const t={x:Bs(e,"x","isInf")};return As.runKernel("IsInf",t)}});const Al=Os({isNaN_:function(e){const t={x:Bs(e,"x","isNaN")};return As.runKernel("IsNan",t)}});const _l=Os({leakyRelu_:function(e,t=.2){const n={x:Bs(e,"x","leakyRelu")},r={alpha:t};return As.runKernel("LeakyRelu",n,r)}});const Il=Os({less_:function(e,t){let n=Bs(e,"a","less","string_or_numeric"),r=Bs(t,"b","less","string_or_numeric");[n,r]=bs(n,r),jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("Less",s)}});const Ml=Os({lessEqual_:function(e,t){let n=Bs(e,"a","lessEqual","string_or_numeric"),r=Bs(t,"b","lessEqual","string_or_numeric");[n,r]=bs(n,r),jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("LessEqual",s)}});function Nl(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const r={start:e,stop:t,num:n};return As.runKernel("LinSpace",{},r)}const Tl=Os({localResponseNormalization_:function(e,t=5,n=1,r=1,s=.5){const o=Bs(e,"x","localResponseNormalization");i(4===o.rank||3===o.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${o.rank}.`)),i(f(t),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`));let a=o,l=!1;3===o.rank&&(l=!0,a=xi(o,[1,o.shape[0],o.shape[1],o.shape[2]]));const u={x:a},c={depthRadius:t,bias:n,alpha:r,beta:s},h=As.runKernel("LRN",u,c);return l?xi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Dl=Os({log_:function(e){const t={x:Bs(e,"x","log","float32")};return As.runKernel("Log",t)}});const Rl=Os({log1p_:function(e){const t={x:Bs(e,"x","log1p")};return As.runKernel("Log1p",t)}});function Fl(e){return i(I(e),(()=>"The f passed in grad(f) must be a function")),(t,n)=>{const r=Bs(t,"x","tf.grad","string_or_numeric"),s=null!=n?Bs(n,"dy","tf.grad"):null;return As.tidy((()=>{const{value:t,grads:n}=As.gradients((()=>e(r)),[r],s);return null!=s&&l(t.shape,s.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),zl(n),n[0]}))}}function Bl(e){return i(I(e),(()=>"The f passed in grads(f) must be a function")),(t,n)=>{i(Array.isArray(t),(()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s"));const r=Cs(t,"args","tf.grads","string_or_numeric"),s=null!=n?Bs(n,"dy","tf.grads"):null;return As.tidy((()=>{const{value:t,grads:n}=As.gradients((()=>e(...r)),r,s);return null!=s&&l(t.shape,s.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),zl(n),n}))}}function Cl(e){return i(I(e),(()=>"The f passed in valueAndGrad(f) must be a function")),(t,n)=>{i(t instanceof is,(()=>"The x passed in valueAndGrad(f)(x) must be a tensor")),i(null==n||n instanceof is,(()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor"));const{grads:r,value:s}=As.gradients((()=>e(t)),[t],n);return zl(r),{grad:r[0],value:s}}}function Pl(e){return i(I(e),(()=>"The f passed in valueAndGrads(f) must be a function")),(t,n)=>{i(Array.isArray(t)&&t.every((e=>e instanceof is)),(()=>"The args passed in valueAndGrads(f)(args) must be array of tensors")),i(null==n||n instanceof is,(()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor"));const r=As.gradients((()=>e(...t)),t,n);return null!=n&&l(r.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),zl(r.grads),r}}function Ol(e,t){i(I(e),(()=>"The f passed in variableGrads(f) must be a function")),i(null==t||Array.isArray(t)&&t.every((e=>e instanceof ls)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=t;if(!n){t=[];for(const e in As.registeredVariables)t.push(As.registeredVariables[e])}const r=n?t.filter((e=>!e.trainable)):null,s=t.length;i((t=t.filter((e=>e.trainable))).length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${s} variables is trainable.`));const{value:o,grads:a}=As.gradients(e,t,null,!0);i(a.some((e=>null!=e)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),i(0===o.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${o.rank} tensor`));const l={};return t.forEach(((e,t)=>{null!=a[t]&&(l[e.name]=a[t])})),null!=r&&r.forEach((e=>l[e.name]=null)),{value:o,grads:l}}function Ll(e){return As.customGrad(e)}function zl(e){if(e.filter((e=>null==e)).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const Wl=Os({neg_:function(e){const t={x:Bs(e,"x","neg")};return As.runKernel("Neg",t)}});const Kl=Os({softplus_:function(e){const t={x:Bs(e,"x","softplus")};return As.runKernel("Softplus",t)}});const Ul=Os({logSigmoid_:function(e){const t=Bs(e,"x","logSigmoid");return Ll((e=>({value:Wl(Kl(Wl(e))),gradFunc:t=>Za(t,Ai(Wl(e)))})))(t)}});const ql=Os({max_:function(e,t=null,n=!1){const r={x:Bs(e,"x","max")},s={reductionIndices:t,keepDims:n};return As.runKernel("Max",r,s)}});const Gl=Os({sub_:function(e,t){let n=Bs(e,"a","sub"),r=Bs(t,"b","sub");[n,r]=bs(n,r);const s={a:n,b:r};return As.runKernel("Sub",s)}});const Hl=Os({sum_:function(e,t=null,n=!1){let r=Bs(e,"x","sum");"bool"===r.dtype&&(r=Ao(r,"int32"));const s={x:r},o={axis:t,keepDims:n};return As.runKernel("Sum",s,o)}});const Vl=Os({logSoftmax_:function(e,t=-1){const n=Bs(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);return Ll(((e,n)=>{const r=ql(e,t,!0),s=Gl(e,r),o=Gl(Ao(s,"float32"),Dl(Hl(fl(s),t,!0)));n([o]);return{value:o,gradFunc:(e,n)=>{const[r]=n,s=fl(r);return Gl(e,Za(Hl(e,t,!0),s))}}}))(n)}});function jl(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function Jl(e,t,n){const r=e.length+t.length,s=[];let o=0,a=0;for(let i=0;i<r;i++)-1===n.indexOf(i)?s.push(e[o++]):s.push(t[a++]);return s}function Zl(e,t){return Jl(e,t.map((e=>1)),t)}const Yl=Os({logSumExp_:function(e,t=null,n=!1){const r=Bs(e,"x","logSumExp"),s=g(t,r.shape),o=ql(r,s,!0),a=Gl(r,o),i=fl(a),l=Hl(i,s),u=Dl(l),c=Va(xi(o,u.shape),u);if(n){const e=Zl(c.shape,s);return xi(c,e)}return c}});const Xl=Os({logicalAnd_:function(e,t){const n=Bs(e,"a","logicalAnd","bool"),r=Bs(t,"b","logicalAnd","bool");jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("LogicalAnd",s)}});const Ql=Os({logicalNot_:function(e){const t={x:Bs(e,"x","logicalNot","bool")};return As.runKernel("LogicalNot",t)}});const eu=Os({logicalOr_:function(e,t){const n=Bs(e,"a","logicalOr","bool"),r=Bs(t,"b","logicalOr","bool");jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("LogicalOr",s)}});const tu=Os({logicalXor_:function(e,t){const n=Bs(e,"a","logicalXor","bool"),r=Bs(t,"b","logicalXor","bool");return jo(n.shape,r.shape),Xl(eu(e,t),Ql(Xl(e,t)))}});const nu=Os({maxPool_:function(e,t,n,r,s){const o=Bs(e,"x","maxPool");let a=o,l=!1;3===o.rank&&(l=!0,a=xi(o,[1,o.shape[0],o.shape[1],o.shape[2]])),i(4===a.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${a.rank}.`)),i(wi(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),vi("maxPool",r,s);const u={x:a},c={filterSize:t,strides:n,pad:r,dimRoundingMode:s},h=As.runKernel("MaxPool",u,c);return l?xi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const ru=Os({maxPool3d_:function(e,t=[1,1,1],n,r,s,o="NDHWC"){const a=Bs(e,"x","maxPool3d");let l=a,u=!1;4===a.rank&&(u=!0,l=xi(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),i(5===l.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${l.rank}.`)),i("NDHWC"===o,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${o}`)),vi("maxPool3d",r,s);const c={x:l},h={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:o},d=As.runKernel("MaxPool3D",c,h);return u?xi(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const su=Os({maxPoolWithArgmax_:function(e,t,n,r,s=!1){const o={x:Bs(e,"x","maxPoolWithArgmax")},a={filterSize:t,strides:n,pad:r,includeBatchInIndex:s},i=As.runKernel("MaxPoolWithArgmax",o,a);return{result:i[0],indexes:i[1]}}});const ou=Os({maximum_:function(e,t){let n=Bs(e,"a","maximum"),r=Bs(t,"b","maximum");[n,r]=bs(n,r),"bool"===n.dtype&&(n=Ao(n,"int32"),r=Ao(r,"int32")),jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("Maximum",s)}});const au=Os({mean_:function(e,t=null,n=!1){const r={x:Bs(e,"x","mean")},s={axis:t,keepDims:n};return As.runKernel("Mean",r,s)}});function iu(e,t="float32"){if("complex64"===t){const t=iu(e,"float32"),n=iu(e,"float32");return Ls(t,n)}const n=F(h(e),t);return As.makeTensor(n,e,t)}function lu(e,t="float32"){if("complex64"===t){const t=lu(e,"float32"),n=iu(e,"float32");return Ls(t,n)}const n=R(h(e),t);return As.makeTensor(n,e,t)}function uu(e,t,{indexing:n="xy"}={}){if("xy"!==n&&"ij"!==n)throw new TypeError(`${n} is not a valid third argument to meshgrid`);if(void 0===e)return[];let r=Bs(e,"x","meshgrid",e instanceof is?e.dtype:"float32");if(void 0===t)return[r];let s=Bs(t,"y","meshgrid",t instanceof is?t.dtype:"float32");const o=h(r.shape),a=h(s.shape);return"xy"===n?(r=xi(r,[1,-1]),s=xi(s,[-1,1]),[Ko(lu([a,1],r.dtype),r),Ko(s,lu([1,o],s.dtype))]):(r=xi(r,[-1,1]),s=xi(s,[1,-1]),[Ko(r,lu([1,a],r.dtype)),Ko(lu([o,1],s.dtype),s)])}const cu=Os({min_:function(e,t=null,n=!1){const r={x:Bs(e,"x","min")},s={axis:t,keepDims:n};return As.runKernel("Min",r,s)}});const hu=Os({minimum_:function(e,t){let n=Bs(e,"a","minimum"),r=Bs(t,"b","minimum");[n,r]=bs(n,r),"bool"===n.dtype&&(n=Ao(n,"int32"),r=Ao(r,"int32")),jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("Minimum",s)}});const du=Os({mirrorPad_:function(e,t,n){i("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const r=Bs(e,"x","mirrorPad");if(0===r.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");i(t.length===r.rank,(()=>`Padding doesn't match input. Must be ${r.rank}. Got ${t.length}.`));const s="reflect"===n?1:0;for(let e=0;e<r.rank;e++)i(2===t[e].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),i(t[e][0]>=0&&t[e][0]<=r.shape[e]-s&&t[e][1]>=0&&t[e][1]<=r.shape[e]-s,(()=>`Padding in dimension ${e} cannot be greater than or equal to ${r.shape[e]-s} or less than 0 for input of shape ${r.shape}`));const o={paddings:t,mode:n},a={x:r};return As.runKernel("MirrorPad",a,o)}});const fu=Os({mod_:function(e,t){let n=Bs(e,"a","mod"),r=Bs(t,"b","mod");[n,r]=bs(n,r);const s={a:n,b:r};return As.runKernel("Mod",s)}});const pu=Os({square_:function(e){const t=Bs(e,"x","square");return As.runKernel("Square",{x:t},{})}});const gu=Os({moments_:function(e,t=null,n=!1){const r=g(t,(e=Bs(e,"x","moments")).shape),s=au(e,r,n);let o=s.shape;n||(o=Zl(s.shape,r));const a=pu(Gl(Ao(e,"float32"),xi(s,o)));return{mean:s,variance:au(a,r,n)}}});const mu=Os({multiRNNCell_:function(e,t,n,r){const s=Bs(t,"data","multiRNNCell"),o=Cs(n,"c","multiRNNCell"),a=Cs(r,"h","multiRNNCell");let i=s;const l=[];for(let t=0;t<e.length;t++){const n=e[t](i,o[t],a[t]);l.push(n[0]),l.push(n[1]),i=n[1]}const u=[],c=[];for(let e=0;e<l.length;e+=2)u.push(l[e]),c.push(l[e+1]);return[u,c]}});const bu=Os({multinomial_:function(e,t,n,r=!1){const s=Bs(e,"logits","multinomial"),o=s.size,a=s.rank;if(o<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${o}.`);if(a>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${a}`);n=n||Math.random();const i={logits:1===a?xi(s,[1,-1]):s},l={numSamples:t,seed:n,normalized:r},u=As.runKernel("Multinomial",i,l);return 1===a?xi(u,[u.size]):u}});const yu=Os({notEqual_:function(e,t){let n=Bs(e,"a","notEqual","string_or_numeric"),r=Bs(t,"b","notEqual","string_or_numeric");[n,r]=bs(n,r),jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("NotEqual",s)}});const wu=Os({onesLike_:function(e){const t={x:Bs(e,"x","onesLike")};return As.runKernel("OnesLike",t)}});const ku=Os({outerProduct_:function(e,t){const n=Bs(e,"v1","outerProduct"),r=Bs(t,"v2","outerProduct");i(1===n.rank&&1===r.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${r.rank}.`));const s=xi(n,[-1,1]),o=xi(r,[1,-1]);return Ko(s,o)}});const vu=Os({pad_:function(e,t,n=0){const r=Bs(e,"x","pad");if(0===r.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const s={paddings:t,constantValue:n},o={x:r};return As.runKernel("PadV2",o,s)}});const xu=Os({pad1d_:function(e,t,n=0){return i(2===t.length,(()=>"Invalid number of paddings. Must be length of 2.")),vu(e,[t],n)}});const Eu=Os({pad2d_:function(e,t,n=0){return i(2===t.length&&2===t[0].length&&2===t[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),vu(e,t,n)}});const Su=Os({pad3d_:function(e,t,n=0){return i(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),vu(e,t,n)}});const $u=Os({pad4d_:function(e,t,n=0){return i(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),vu(e,t,n)}});const Au=Os({spaceToBatchND_:function(e,t,n){const r=Bs(e,"x","spaceToBatchND");i(r.rank>=1+t.length,(()=>`input rank ${r.rank} should be > than [blockShape] ${t.length}`)),i(n.length===t.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`)),i(r.shape.reduce(((e,r,s)=>s>0&&s<=t.length?e&&(r+n[s-1][0]+n[s-1][1])%t[s-1]==0:e),!0),(()=>`input spatial dimensions ${r.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`));const s={x:r},o={blockShape:t,paddings:n};return As.runKernel("SpaceToBatchND",s,o)}});const _u=Os({pool_:function(e,t,n,r,s,o,a){null==s&&(s=[1,1]),null==o&&(o=1),0===r&&(r="valid");const l=Bs(e,"x","maxPool");let u=l,c=!1;3===l.rank&&(c=!0,u=xi(l,[1,l.shape[0],l.shape[1],l.shape[2]])),i(wi(o,s),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${o} and dilations '${s}'`));const h=ci(u.shape,t,o,s,r),d=[h.dilationHeight,h.dilationWidth];let f;f="same"===r?function(e,t){const n=e.map(((e,n)=>e+(e-1)*(t[n]-1))).map((e=>e-1)),r=n.map((e=>Math.floor(e/2))),s=n.map(((e,t)=>e-r[t]));return n.map(((e,t)=>[r[t],s[t]]))}([h.filterHeight,h.filterWidth],d):[[0,0],[0,0]];const p=1===d[0]&&1===d[1],[g,m]=function(e,t,n){const r=n.map((e=>e[0])),s=n.map((e=>e[1])),o=e.concat(r,s),a=t.map(((e,t)=>(e-o[t]%e)%e)),i=s.map(((e,t)=>e+a[t])),l=t.map(((e,t)=>[r[t],i[t]])),u=t.map(((e,t)=>[0,a[t]]));return[l,u]}([h.inHeight,h.inWidth],d,f),b=p?r:"valid",y=p?u:Au(u,d,g),w=("avg"===n?()=>Ei(y,t,o,b,a):()=>nu(y,t,o,b,a))(),k=p?w:Ni(w,d,m);return c?xi(k,[k.shape[1],k.shape[2],k.shape[3]]):k}});const Iu=Os({pow_:function(e,t){let n=Bs(e,"base","pow"),r=Bs(t,"exp","pow");[n,r]=bs(n,r);const s={a:n,b:r};return As.runKernel("Pow",s)}});const Mu=Os({prelu_:function(e,t){const n={x:Bs(e,"x","prelu"),alpha:Bs(t,"alpha","prelu")};return As.runKernel("Prelu",n)}});const Nu=Os({prod_:function(e,t=null,n=!1){let r=Bs(e,"x","prod");"bool"===r.dtype&&(r=Ao(r,"int32"));const s={x:r},o={axis:t,keepDims:n};return As.runKernel("Prod",s,o)}});const Tu=Os({rand_:function(e,t,n){const r=h(e);let s=null;if(null==n||"float32"===n)s=new Float32Array(r);else if("int32"===n)s=new Int32Array(r);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);s=new Uint8Array(r)}for(let e=0;e<r;e++)s[e]=t();return As.makeTensor(s,e,n)}});var Du="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function Ru(e){var t={exports:{}};return e(t,t.exports),t.exports}var Fu=Ru((function(e){!function(e,t,n){function r(e){var t,n=this,r=(t=4022871197,function(e){e=String(e);for(var n=0;n<e.length;n++){var r=.02519603282416938*(t+=e.charCodeAt(n));r-=t=r>>>0,t=(r*=t)>>>0,t+=4294967296*(r-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=r(" "),n.s1=r(" "),n.s2=r(" "),n.s0-=r(e),n.s0<0&&(n.s0+=1),n.s1-=r(e),n.s1<0&&(n.s1+=1),n.s2-=r(e),n.s2<0&&(n.s2+=1),r=null}function s(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function o(e,t){var n=new r(e),o=t&&t.state,a=n.next;return a.int32=function(){return 4294967296*n.next()|0},a.double=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.alea=o}(0,e,!1)})),Bu=Ru((function(e){!function(e,t,n){function r(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xor128=o}(0,e,!1)})),Cu=Ru((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),r==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xorwow=o}(0,e,!1)})),Pu=Ru((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.x,s=t.i;return e=r[s],n=(e^=e>>>7)^e<<24,n^=(e=r[s+1&7])^e>>>10,n^=(e=r[s+3&7])^e>>>3,n^=(e=r[s+4&7])^e<<7,e=r[s+7&7],n^=(e^=e<<13)^e<<9,r[s]=n,t.i=s+1&7,n},function(e,t){var n,r=[];if(t===(0|t))r[0]=t;else for(t=""+t,n=0;n<t.length;++n)r[7&n]=r[7&n]<<15^t.charCodeAt(n)+r[n+1&7]<<13;for(;r.length<8;)r.push(0);for(n=0;n<8&&0===r[n];++n);for(8==n&&(r[7]=-1),e.x=r,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function s(e,t){return t.x=e.x.slice(),t.i=e.i,t}function o(e,t){null==e&&(e=+new Date);var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&(o.x&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xorshift7=o}(0,e,!1)})),Ou=Ru((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.w,s=t.X,o=t.i;return t.w=r=r+1640531527|0,n=s[o+34&127],e=s[o=o+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=s[o]=n^e,t.i=o,n+(r^r>>>16)|0},function(e,t){var n,r,s,o,a,i=[],l=128;for(t===(0|t)?(r=t,t=null):(t+="\0",r=0,l=Math.max(l,t.length)),s=0,o=-32;o<l;++o)t&&(r^=t.charCodeAt((o+32)%t.length)),0===o&&(a=r),r^=r<<10,r^=r>>>15,r^=r<<4,r^=r>>>13,o>=0&&(a=a+1640531527|0,s=0==(n=i[127&o]^=r+a)?s+1:0);for(s>=128&&(i[127&(t&&t.length||0)]=-1),s=127,o=512;o>0;--o)r=i[s+34&127],n=i[s=s+1&127],r^=r<<13,n^=n<<17,r^=r>>>15,n^=n>>>12,i[s]=r^n;e.w=a,e.X=i,e.i=s}(t,e)}function s(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function o(e,t){null==e&&(e=+new Date);var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&(o.X&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xor4096=o}(0,e,!1)})),Lu=Ru((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,r=t.d,s=t.a;return e=e<<25^e>>>7^n,n=n-r|0,r=r<<24^r>>>8^s,s=s-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-r|0,t.d=r<<16^n>>>16^s,t.a=s-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var r=0;r<n.length+20;r++)t.b^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.tychei=o}(0,e,!1)})),zu=Ru((function(t){!function(n,r,s){var o,a=256,i=s.pow(a,6),l=s.pow(2,52),u=2*l,c=255;function h(e,t,c){var h=[],b=g(p((t=1==t?{entropy:!0}:t||{}).entropy?[e,m(r)]:null==e?function(){try{var e;return o&&(e=o.randomBytes)?e=e(a):(e=new Uint8Array(a),(n.crypto||n.msCrypto).getRandomValues(e)),m(e)}catch(e){var t=n.navigator,s=t&&t.plugins;return[+new Date,n,s,n.screen,m(r)]}}():e,3),h),y=new d(h),w=function(){for(var e=y.g(6),t=i,n=0;e<l;)e=(e+n)*a,t*=a,n=y.g(1);for(;e>=u;)e/=2,t/=2,n>>>=1;return(e+n)/t};return w.int32=function(){return 0|y.g(4)},w.quick=function(){return y.g(4)/4294967296},w.double=w,g(m(y.S),r),(t.pass||c||function(e,t,n,r){return r&&(r.S&&f(r,y),e.state=function(){return f(y,{})}),n?(s.random=e,t):e})(w,b,"global"in t?t.global:this==s,t.state)}function d(e){var t,n=e.length,r=this,s=0,o=r.i=r.j=0,i=r.S=[];for(n||(e=[n++]);s<a;)i[s]=s++;for(s=0;s<a;s++)i[s]=i[o=c&o+e[s%n]+(t=i[s])],i[o]=t;(r.g=function(e){for(var t,n=0,s=r.i,o=r.j,i=r.S;e--;)t=i[s=c&s+1],n=n*a+i[c&(i[s]=i[o=c&o+t])+(i[o]=t)];return r.i=s,r.j=o,n})(a)}function f(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function p(e,t){var n,r=[],s=typeof e;if(t&&"object"==s)for(n in e)try{r.push(p(e[n],t-1))}catch(e){}return r.length?r:"string"==s?e:e+"\0"}function g(e,t){for(var n,r=e+"",s=0;s<r.length;)t[c&s]=c&(n^=19*t[c&s])+r.charCodeAt(s++);return m(t)}function m(e){return String.fromCharCode.apply(0,e)}if(g(s.random(),r),t.exports){t.exports=h;try{o=e}catch(e){}}else s.seedrandom=h}("undefined"!=typeof self?self:Du,[],Math)}));zu.alea=Fu,zu.xor128=Bu,zu.xorwow=Cu,zu.xorshift7=Pu,zu.xor4096=Ou,zu.tychei=Lu;var Wu=zu;class Ku{constructor(e,t,n,r,s){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=r,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const o=s||Math.random();this.random=Wu.alea(o.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let r,s,o;do{r=2*this.random()-1,s=2*this.random()-1,o=r*r+s*s}while(o>=1||0===o);const a=Math.sqrt(-2*Math.log(o)/o);e=this.mean+this.stdDev*r*a,t=this.mean+this.stdDev*s*a,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class Uu{constructor(e,t,n,r){this.alpha=e,this.beta=1/t,this.dtype=n;const s=r||Math.random();this.randu=Wu.alea(s.toString()),this.randn=new Ku(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,r,s,o;for(;;){do{r=this.randn.nextValue(),o=1+this.c*r}while(o<=0);if(o*=o*o,e=r*r,t=1-.331*e*e,n=.5*e+this.d*(1-o+Math.log(o)),s=this.randu(),s<t||Math.log(s)<n)break}return o=1/this.beta*this.d*o,this.alpha<1&&(o*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(o)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class qu{constructor(e=0,t=1,n,r){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==r&&(r=Math.random()),"number"==typeof r&&(r=r.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=Wu.alea(r)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const Gu=Os({randomGamma_:function(e,t,n=1,r="float32",s){if(null==n&&(n=1),null==r&&(r="float32"),"float32"!==r&&"int32"!==r)throw new Error(`Unsupported data type ${r}`);const o=new Uu(t,n,r,s),a=$o(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const Hu=Os({randomNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error(`Unsupported data type ${r}`);const o=new Ku(t,n,r,!1,s),a=$o(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const Vu=Os({randomUniform_:function(e,t=0,n=1,r="float32",s){const o=$o(e,r),a=new qu(t,n,null,s);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});function ju(e,t,n=1,r="float32"){if(0===n)throw new Error("Cannot have a step of zero");const s={start:e,stop:t,step:n,dtype:r};return As.runKernel("Range",{},s)}const Ju=Os({real_:function(e){const t={input:Bs(e,"input","real")};return As.runKernel("Real",t)}});const Zu=Os({reciprocal_:function(e){const t={x:Bs(e,"x","reciprocal")};return As.runKernel("Reciprocal",t)}});const Yu=Os({relu_:function(e){const t={x:Bs(e,"x","relu")};return As.runKernel("Relu",t)}});const Xu=Os({relu6_:function(e){const t={x:Bs(e,"x","relu6")};return As.runKernel("Relu6",t)}});const Qu=Os({reverse_:function(e,t){const n={x:Bs(e,"x","reverse")},r={dims:t};return As.runKernel("Reverse",n,r)}});const ec=Os({reverse1d_:function(e){const t=Bs(e,"x","reverse");return i(1===t.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`)),Qu(t,0)}});const tc=Os({reverse2d_:function(e,t){const n=Bs(e,"x","reverse");return i(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),Qu(n,t)}});const nc=Os({reverse3d_:function(e,t){const n=Bs(e,"x","reverse");return i(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),Qu(n,t)}});const rc=Os({reverse4d_:function(e,t){const n=Bs(e,"x","reverse");return i(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),Qu(n,t)}});const sc=Os({round_:function(e){const t={x:Bs(e,"x","round")};return As.runKernel("Round",t)}});const oc=Os({rsqrt_:function(e){const t={x:Bs(e,"x","rsqrt","float32")};return As.runKernel("Rsqrt",t)}});function ac(e,t){if((v(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&v(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return zs(e,[],[],t)}const ic=Os({selu_:function(e){const t={x:Bs(e,"x","selu")};return As.runKernel("Selu",t)}});const lc=Os({separableConv2d_:function(e,t,n,r,s,o=[1,1],a="NHWC"){const l=Bs(e,"x","separableConv2d"),u=Bs(t,"depthwiseFilter","separableConv2d"),c=Bs(n,"pointwiseFilter","separableConv2d");let h=l,d=!1;if(3===l.rank&&(d=!0,h=xi(l,[1,l.shape[0],l.shape[1],l.shape[2]])),"NCHW"===a)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");i(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),i(4===u.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`)),i(4===c.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`)),i(1===c.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`)),i(1===c.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`));const f=u.shape[2],p=u.shape[3];i(c.shape[2]===f*p,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${f*p}, but got ${c.shape[2]}.`));const g=nl(h,u,r,s,a,o),m=qi(g,c,1,"valid",a);return d?xi(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const uc=async function(e,t){const n=Bs(e,"x","setdiff1d"),r=Bs(t,"y","setdiff1d");i(n.dtype===r.dtype,(()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${r.dtype}).`)),i(1===n.rank,(()=>`x should be 1D tensor, but got x (${n.shape}).`)),i(1===r.rank,(()=>`y should be 1D tensor, but got y (${r.shape}).`));const s=await n.data(),o=await r.data(),a=new Set(o);let l=0;for(let e=0;e<s.length;e++)a.has(s[e])||l++;const u=new ss([l],n.dtype),c=new ss([l],"int32");for(let e=0,t=0;e<s.length;e++)a.has(s[e])||(u.values[t]=s[e],c.values[t]=e,t++);return[u.toTensor(),c.toTensor()]};const cc=Os({sign_:function(e){const t={x:Bs(e,"x","sign")};return As.runKernel("Sign",t)}});const hc=Os({sin_:function(e){const t={x:Bs(e,"x","sin","float32")};return As.runKernel("Sin",t)}});const dc=Os({sinh_:function(e){const t={x:Bs(e,"x","sinh")};return As.runKernel("Sinh",t)}});const fc=Os({slice1d_:function(e,t,n){const r=Bs(e,"x","slice1d");return i(1===r.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${r.rank} tensor`)),_i(r,[t],[n])}});const pc=Os({slice2d_:function(e,t,n){const r=Bs(e,"x","slice2d");return i(2===r.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${r.rank} tensor`)),_i(r,t,n)}});const gc=Os({slice3d_:function(e,t,n){const r=Bs(e,"x","slice3d");return i(3===r.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${r.rank} tensor`)),_i(r,t,n)}});const mc=Os({slice4d_:function(e,t,n){const r=Bs(e,"x","slice4d");return i(4===r.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${r.rank} tensor`)),_i(r,t,n)}});const bc=Os({softmax_:function(e,t=-1){const n=Bs(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const r={logits:n},s={dim:t};return As.runKernel("Softmax",r,s)}});const yc=Os({fft_:function(e){i("complex64"===e.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`));const t={input:e};return As.runKernel("FFT",t)}});const wc=Os({ifft_:function(e){i("complex64"===e.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`));const t={input:e};return As.runKernel("IFFT",t)}});const kc=Os({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let r;if(t<=2){const s=xi(e,[n,t]);r=wc(s)}else{const s=[n,2*(t-1)],o=xi(Ju(e),[n,t]),a=xi(El(e),[n,t]),i=Qu(_i(o,[0,1],[n,t-2]),1),l=Za(Qu(_i(a,[0,1],[n,t-2]),1),ac(-1)),u=$i([o,i],1),c=$i([a,l],1),h=xi(Ls(u,c),[s[0],s[1]]);r=wc(h)}if(r=Ju(r),3===e.rank&&0!==e.shape[0]){const t=r,n=e.shape[0];r=xi(r,[n,r.shape[0]/n,r.shape[1]]),t.dispose()}return r}});const vc=Os({split_:function(e,t,n=0){const r={x:Bs(e,"x","split")},s={numOrSizeSplits:t,axis:n};return As.runKernel("SplitV",r,s)}});const xc=Os({rfft_:function(e,t){i("float32"===e.dtype,(()=>`The dtype for rfft() must be real value but got ${e.dtype}`));let n=e.shape[e.shape.length-1];const r=e.size/n;let s;if(null!=t&&t<n){const r=e.shape.map((e=>0)),o=e.shape.map((e=>e));o[e.shape.length-1]=t,s=_i(e,r,o),n=t}else if(null!=t&&t>n){const r=e.shape.map((e=>e));r[e.shape.length-1]=t-n,s=$i([e,iu(r)],e.shape.length-1),n=t}else s=e;const o=il(s),a=xi(Ls(s,o),[r,n]),l=yc(a),u=Math.floor(n/2)+1,c=Ju(l),h=El(l),d=vc(c,[u,n-u],c.shape.length-1),f=vc(h,[u,n-u],h.shape.length-1),p=s.shape.slice();return p[s.shape.length-1]=u,xi(Ls(d[0],f[0]),p)}});const Ec=Os({sqrt_:function(e){const t={x:Bs(e,"x","sqrt","float32")};return As.runKernel("Sqrt",t)}});const Sc=Os({squaredDifference_:function(e,t){let n=Bs(e,"a","squaredDifference"),r=Bs(t,"b","squaredDifference");[n,r]=bs(n,r),jo(n.shape,r.shape);const s={a:n,b:r};return As.runKernel("SquaredDifference",s,{})}});const $c=Os({squeeze_:function(e,t){const n=Bs(e,"x","squeeze");return xi(n,m(n.shape,t).newShape)}});const Ac=Os({stack_:function(e,t=0){const n=Cs(e,"tensors","stack","string_or_numeric");i(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&i(t<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const r=n,s={axis:t};return As.runKernel("Pack",r,s)}});const _c=Os({step_:function(e,t=0){const n={x:Bs(e,"x","step")},r={alpha:t};return As.runKernel("Step",n,r)}});const Ic=Os({stridedSlice_:function(e,t,n,r,s=0,o=0,a=0,i=0,l=0){const u={x:Bs(e,"x","stridedSlice","string_or_numeric")},c={begin:t,end:n,strides:r,beginMask:s,endMask:o,ellipsisMask:a,newAxisMask:i,shrinkAxisMask:l};return As.runKernel("StridedSlice",u,c)}});const Mc=Os({tan_:function(e){const t={x:Bs(e,"x","tan","float32")};return As.runKernel("Tan",t)}});function Nc(e,t){u(e);const n=Ds(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return zs(e,null,n,t)}function Tc(e,t,n){if(u(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const r=Ds(e,n);if(2!==r.length&&1!==r.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return zs(e,t,r,n)}function Dc(e,t,n){if(u(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const r=Ds(e,n);if(4!==r.length&&1!==r.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return zs(e,t,r,n)}function Rc(e,t,n){if(u(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const r=Ds(e,n);if(5!==r.length&&1!==r.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return zs(e,t,r,n)}function Fc(e,t,n){if(u(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const r=Ds(e,n);if(6!==r.length&&1!==r.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return zs(e,t=t||r,r,n)}const Bc=Os({topk_:function(e,t=1,n=!0){const r=Bs(e,"x","topk");if(0===r.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const s=r.shape[r.shape.length-1];if(t<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${t}`);if(t>s)throw new Error(`'k' passed to topk() must be <= the last dimension (${s}) but got ${t}`);const o={x:r},a={k:t,sorted:n},[i,l]=As.runKernel("TopK",o,a);return{values:i,indices:l}}});const Cc=Os({truncatedNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error("Unsupported data type $ { dtype }");const o=new Ku(t,n,r,!0,s),a=$o(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const Pc=Os({unique_:function(e,t=0){const n=Bs(e,"x","unique","string_or_numeric");i(n.rank>0,(()=>"The input tensor must be at least 1D"));const r={x:n},s={axis:t},[o,a]=As.runKernel("Unique",r,s);return{values:o,indices:a}}});const Oc=Os({unsortedSegmentSum_:function(e,t,n){const r=Bs(e,"x","unsortedSegmentSum"),s=Bs(t,"segmentIds","unsortedSegmentSum","int32");i(f(n),(()=>"numSegments must be of dtype int"));const o={x:r,segmentIds:s},a={numSegments:n};return As.runKernel("UnsortedSegmentSum",o,a)}});const Lc=Os({unstack_:function(e,t=0){const n=Bs(e,"x","unstack","string_or_numeric");i(t>=-n.shape.length&&t<n.shape.length,(()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`));const r={value:n},s={axis:t};return As.runKernel("Unpack",r,s)}});function zc(e,t=!0,n,r){return As.makeVariable(e,t,n,r)}function Wc(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const r=$o(e,"int32"),s=$o([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const o=r.indexToLoc(n[t]),a=t*e.length;s.values.set(o,a)}return s.toTensor()}const Kc=async function(e){const t=Bs(e,"condition","whereAsync","bool"),n=await t.data(),r=Wc(t.shape,n);return e!==t&&t.dispose(),r};const Uc=async function(e,t,n){const r=Bs(e,"tensor","boolMask"),s=Bs(t,"mask","boolMask","bool"),o=null==n?0:n,a=s.rank,u=r.shape;i(a>0,(()=>"mask cannot be scalar")),l(u.slice(o,o+a),s.shape,"mask's shape must match the first K dimensions of tensor's shape,");let c=1;for(let e=o;e<o+a;e++)c*=u[e];const h=u.slice(0,o).concat([c],u.slice(o+a)),d=xi(r,h),f=xi(s,[-1]),p=await Kc(f),g=$c(p,[1]),m=kl(d,g,o);return e!==r&&r.dispose(),t!==s&&s.dispose(),g.dispose(),d.dispose(),f.dispose(),p.dispose(),m};function qc(e,t,n=null){if(0===e.rank)return Ya(e);if(1!==e.rank&&null===n)return qc(xi(e,[-1]),t,n);if(1===e.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===t)return Hl(Ya(e),n);if(t===1/0)return ql(Ya(e),n);if(t===-1/0)return cu(Ya(e),n);if("euclidean"===t||2===t)return Ec(Hl(Iu(Ya(e),ac(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}if(Array.isArray(n)&&2===n.length){if(1===t)return ql(Hl(Ya(e),n[0]),n[1]-1);if(t===1/0)return ql(Hl(Ya(e),n[1]),n[0]);if(t===-1/0)return cu(Hl(Ya(e),n[1]),n[0]);if("fro"===t||"euclidean"===t)return Ec(Hl(pu(e),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const Gc=Os({norm_:function(e,t="euclidean",n=null,r=!1){const s=qc(e=Bs(e,"x","norm"),t,n);let o=s.shape;if(r){const t=g(n,e.shape);o=Zl(s.shape,t)}return xi(s,o)}});const Hc=Os({movingAverage_:function(e,t,n,r,s=!0){const o=Bs(e,"v","movingAverage"),a=Bs(t,"x","movingAverage"),l=Bs(n,"decay","movingAverage");ys(o,a),i(d(o.shape,a.shape),(()=>"Shape mismatch in v and x"));const u=ac(1),c=Gl(u,l);let h=Za(Gl(a,o),c);if(s){i(null!=r,(()=>"When using zeroDebias: true, step is required."));const e=Bs(r,"step","movingAverage");h=Ja(h,Gl(u,Iu(l,e)))}return Va(o,h)}});const Vc=Os({scatterND_:function(e,t,n){const r=Bs(e,"indices","scatterND","int32"),s=Bs(t,"updates","scatterND");sa(s,r,n);const o={indices:r,updates:s},a={shape:n};return As.runKernel("ScatterNd",o,a)}});const jc=Os({sparseToDense_:function(e,t,n,r=0){const s=Bs(e,"sparseIndices","sparseToDense","int32"),o=Bs(t,"sparseValues","sparseToDense"),a=Bs(r,"defaultValue","sparseToDense",o.dtype);!function(e,t,n,r){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const s=e.rank>0?e.shape[0]:1,o=e.rank>1?e.shape[1]:1;if(n.length!==o)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${o}.`);const a=t.size;if(0!==t.rank&&(1!==t.rank||a!==s))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${s}]`);if(t.dtype!==r.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(s,o,n,a);const i={sparseIndices:s,sparseValues:o,defaultValue:a},l={outputShape:n};return As.runKernel("SparseToDense",i,l)}});const Jc=Os({gatherND_:function(e,t){const n=Bs(t,"indices","gatherND","int32"),r={params:Bs(e,"x","gatherND","string_or_numeric"),indices:n};return As.runKernel("GatherNd",r)}});const Zc=Os({dropout_:function(e,t,n,r){const s=Bs(e,"x","dropout");if(i("float32"===s.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${s.dtype} tensor instead.`)),i(t>=0&&t<1,(()=>`rate must be a float in the range [0, 1), but got ${t}.`)),0===t)return e instanceof is?s.clone():s;const o=function(e,t){if(null==t)return e.shape.slice();if(d(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let r=0;r<e.shape.length;r++)null==t[r]&&null!=e.shape[r]?n.push(e.shape[r]):n.push(t[r]);return n}return t}(s,n),a=1-t,l=Ja(wl(Va(Vu(o,0,1,"float32",r),a)),a);return Za(s,l)}});function Yc(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function Xc(e,t,n){const r=1-e%2,s=new Float32Array(e);for(let o=0;o<e;++o){const a=2*Math.PI*o/(e+r-1);s[o]=t-n*Math.cos(a)}return Nc(s,"float32")}const Qc=async function(e,t,n=1){const r=Bs(e,"predictions","inTopK"),s=Bs(t,"targets","inTopK");i(r.rank>1,(()=>`inTopK() expects the predictions to be of rank 2 or higher, but got ${r.rank}`)),i(r.rank-1===s.rank,(()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${r.rank} and targets rank ${s.rank}`)),l(r.shape.slice(0,r.shape.length-1),s.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const o=r.shape[r.shape.length-1];i(n>0&&n<=o,(()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${o}), but got ${n}`));const a=await r.data(),u=await s.data(),[c,h]=[a.length/o,o],d=b("bool",c);for(let e=0;e<c;e++){const t=e*h,r=a.subarray(t,t+h),s=[];for(let e=0;e<r.length;e++)s.push({value:r[e],index:e});s.sort(((e,t)=>t.value-e.value)),d[e]=0;for(let t=0;t<n;t++)if(s[t].index===u[e]){d[e]=1;break}}return e!==r&&r.dispose(),t!==s&&s.dispose(),Ws(d,s.shape,"bool")};const eh=Os({conv2DBackpropFilter_:function(e,t,n,r,s,o="NHWC",a){let l=e;3===e.rank&&(l=xi(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=xi(t,[1,t.shape[0],t.shape[1],t.shape[2]])),i(4===l.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${l.shape}.`)),i(4===u.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${u.shape}.`)),i(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const c="NHWC"===o?l.shape[3]:l.shape[1],h="NHWC"===o?u.shape[3]:u.shape[1];i(c===n[2],(()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`)),i(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),vi("conv2dDerFilter",s,a);const d={x:l,dy:u},f={strides:r,pad:s,dataFormat:o,dimRoundingMode:a,filterShape:n};return As.runKernel("Conv2DBackpropFilter",d,f)}});function th(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return Za(e,_c(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function nh(e,t){let n=t;const r=Vo(e.shape,t.shape);return r.length>0&&(n=Hl(n,r)),xi(n,e.shape)}function rh(e,t,n,r){if("linear"===t)return e;if("relu"===t)return Yu(e);if("elu"===t)return hl(e);if("relu6"===t)return Xu(e);if("prelu"===t)return Mu(e,n);if("leakyrelu"===t)return _l(e,r);if("sigmoid"===t)return Ai(e);throw new Error(`Unknown fused activation ${t}.`)}const sh=(e,t)=>!(e>0)||"linear"===t;const oh=Os({fusedConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:o=[1,1],dimRoundingMode:a,bias:l,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(u=u||"linear",!1===sh(As.state.gradientDepth,u)){let i=qi(e,t,n,r,s,o,a);return null!=l&&(i=Va(i,l)),rh(i,u,c,h)}const d=Bs(e,"x","conv2d","float32"),f=Bs(t,"filter","conv2d","float32");let p=d,g=!1;3===d.rank&&(g=!0,p=xi(d,[1,d.shape[0],d.shape[1],d.shape[2]])),i(4===p.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${p.rank}.`)),i(4===f.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${f.rank}.`)),vi("fused conv2d",r,a),i(p.shape[3]===f.shape[2],(()=>`Error in conv2d: depth of input (${p.shape[3]}) must match input depth for filter ${f.shape[2]}.`)),i(wi(n,o),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),i("NHWC"===s,(()=>`Error in conv2d: got dataFormat of ${s} but only NHWC is currently supported.`));const m=hi(p.shape,f.shape,n,o,r,a);let b,y;null!=l&&(b=Bs(l,"bias","fused conv2d"),[b]=bs(b,d),jo(m.outShape,b.shape)),null!=c&&(y=Bs(c,"prelu weights","fused conv2d"));const w=(e,t)=>{const[s,a,l,c]=t,h=th(e,l,u);i(yi(o),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${o}'`));const d=[Hi(a.shape,h,s,n,r),eh(a,h,s.shape,n,r)];if(null!=c){const e=nh(c,h);d.push(e)}return d},k={x:p,filter:f,bias:b,preluActivationWeights:y},v={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:a,activation:u,leakyreluAlpha:h};if(null==l){return Ll(((e,t,n)=>{let r=As.runKernel("FusedConv2D",k,v);return n([t,e,r]),g&&(r=xi(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}))(p,f)}return Ll(((e,t,n,r)=>{let s=As.runKernel("FusedConv2D",k,v);return r([t,e,s,n]),g&&(s=xi(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}))(p,f,b)}});const ah=Os({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,r,s,o=[1,1],a){let i=e;3===e.rank&&(i=xi(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=xi(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={x:i,dy:l},c={strides:r,pad:s,dimRoundingMode:a,dilations:o,filterShape:n};return As.runKernel("DepthwiseConv2dNativeBackpropFilter",u,c)}});const ih=Os({depthwiseConv2dNativeBackpropInput_:function(e,t,n,r,s,o=[1,1],a){let i=t,l=!1;3===t.rank&&(l=!0,i=xi(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={dy:i,filter:n},c={strides:r,pad:s,dimRoundingMode:a,dilations:o,inputShape:e},h=As.runKernel("DepthwiseConv2dNativeBackpropInput",u,c);return l?xi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});var lh={__proto__:null,conv2d:oh,depthwiseConv2d:Os({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:o=[1,1],dimRoundingMode:a,bias:l,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(!1===sh(As.state.gradientDepth,u)){let i=nl(e,t,n,r,s,o,a);return null!=l&&(i=Va(i,l)),rh(i,u,c,h)}const d=Bs(e,"x","depthwiseConv2d","float32"),f=Bs(t,"filter","depthwiseConv2d","float32");let p=d,g=!1;3===d.rank&&(g=!0,p=xi(d,[1,d.shape[0],d.shape[1],d.shape[2]])),i(4===p.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${p.rank}.`)),i(4===f.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${f.rank}.`)),i(p.shape[3]===f.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${p.shape[3]}) must match the inChannels dimension in filter ${f.shape[2]}.`)),null==o&&(o=[1,1]),i(wi(n,o),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),vi("fused depthwiseConv2d",r,a);const m=hi(p.shape,f.shape,n,o,r,a,!0);let b,y;null!=l&&(b=Bs(l,"bias","fused conv2d"),[b]=bs(b,d),jo(m.outShape,b.shape)),null!=c&&(y=Bs(c,"prelu weights","fused depthwiseConv2d"));const w=(e,t)=>{i(yi(o),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[s,l,c,h]=t,d=th(e,c,u),f=ih(l.shape,d,s,n,r,o,a),p=ah(l,d,s.shape,n,r,o,a);if(null!=h){return[f,p,nh(b,d)]}return[f,p]},k={x:p,filter:f,bias:b,preluActivationWeights:y},v={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:a,activation:u,leakyreluAlpha:h};if(null==l){return Ll(((e,t,n)=>{let r=As.runKernel("FusedDepthwiseConv2D",k,v);return n([t,e,r]),g&&(r=xi(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}))(p,f)}return Ll(((e,t,n,r)=>{let s=As.runKernel("FusedDepthwiseConv2D",k,v);return r([t,e,s,n]),g&&(s=xi(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}))(p,f,b)}}),matMul:Os({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:r=!1,bias:s,activation:o="linear",preluActivationWeights:a,leakyreluAlpha:l}){if(!1===sh(As.state.gradientDepth,o)){let i=Ko(e,t,n,r);return null!=s&&(i=Va(i,s)),rh(i,o,a,l)}let u=Bs(e,"a","fused matMul"),c=Bs(t,"b","fused matMul");[u,c]=bs(u,c);const d=n?u.shape[u.rank-2]:u.shape[u.rank-1],f=r?c.shape[c.rank-1]:c.shape[c.rank-2],p=n?u.shape[u.rank-1]:u.shape[u.rank-2],g=r?c.shape[c.rank-2]:c.shape[c.rank-1],m=u.shape.slice(0,-2),b=c.shape.slice(0,-2),y=h(m),w=h(b);i(d===f,(()=>`Error in fused matMul: inner shapes (${d}) and (${f}) of Tensors with shapes ${u.shape} and ${c.shape} and transposeA=${n} and transposeB=${r} must match.`));const k=jo(u.shape.slice(0,-2),c.shape.slice(0,-2)).concat([p,g]),v=xi(u,n?[y,d,p]:[y,p,d]),x=xi(c,r?[w,g,f]:[w,f,g]);let E,S;null!=s&&(E=Bs(s,"bias","fused matMul"),[E]=bs(E,u),jo(k,E.shape)),null!=a&&(S=Bs(a,"prelu weights","fused matMul"));const $=(e,t)=>{const[a,i,l,u]=t,c=th(xi(e,l.shape),l,o);let h,d;if(n||r?!n&&r?(h=Ko(c,i,!1,!1),d=Ko(c,a,!0,!1)):n&&!r?(h=Ko(i,c,!1,!0),d=Ko(a,c,!1,!1)):(h=Ko(i,c,!0,!0),d=Ko(c,a,!0,!0)):(h=Ko(c,i,!1,!0),d=Ko(a,c,!0,!1)),null!=s){return[h,d,nh(u,c)]}return[h,d]},A={a:v,b:x,bias:E,preluActivationWeights:S},_={transposeA:n,transposeB:r,activation:o,leakyreluAlpha:l};if(null==s){return Ll(((e,t,n)=>{const r=As.runKernel("_FusedMatMul",A,_);return n([e,t,r]),{value:xi(r,k),gradFunc:$}}))(v,x)}return Ll(((e,t,n,r)=>{const s=As.runKernel("_FusedMatMul",A,_);return r([e,t,s,n]),{value:xi(s,k),gradFunc:$}}))(v,x,E)}})};const uh=Os({hammingWindow_:function(e){return Xc(e,.54,.46)}});const ch=Os({hannWindow_:function(e){return Xc(e,.5,.5)}});const hh=Os({frame_:function(e,t,n,r=!1,s=0){let o=0;const a=[];for(;o+t<=e.size;)a.push(_i(e,o,t)),o+=n;if(r)for(;o<e.size;){const r=o+t-e.size,i=$i([_i(e,o,t-r),yl([r],s)]);a.push(i),o+=n}return 0===a.length?Tc([],[0,t]):xi($i(a),[a.length,t])}});const dh=Os({stft_:function(e,t,n,r,s=ch){null==r&&(r=Yc(t));const o=hh(e,t,n),a=Za(o,s(t));return xc(a,r)}});const fh=Os({cropAndResize_:function(e,t,n,r,s="bilinear",o=0){const a=Bs(e,"image","cropAndResize"),l=Bs(t,"boxes","cropAndResize","float32"),u=Bs(n,"boxInd","cropAndResize","int32"),c=l.shape[0];i(4===a.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${a.rank}.`)),i(2===l.rank&&4===l.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${l.shape}.`)),i(1===u.rank&&u.shape[0]===c,(()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${l.shape}.`)),i(2===r.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${r.length}.`)),i(r[0]>=1&&r[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${r}`)),i("bilinear"===s||"nearest"===s,(()=>`method must be bilinear or nearest, but was ${s}`));const h={image:a,boxes:l,boxInd:u},d={method:s,extrapolationValue:o,cropSize:r};return As.runKernel("CropAndResize",h,d)}});const ph=Os({flipLeftRight_:function(e){const t=Bs(e,"image","flipLeftRight","float32");i(4===t.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`));const n={image:t};return As.runKernel("FlipLeftRight",n,{})}});const gh=Os({grayscaleToRGB_:function(e){const t=Bs(e,"image","grayscaleToRGB"),n=t.rank-1,r=t.shape[n];i(t.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${t.rank}.`)),i(1===r,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${r}.`));const s=new Array(t.rank);return s.fill(1,0,n),s[n]=3,ml(t,s)}});const mh=Os({rotateWithOffset_:function(e,t,n=0,r=.5){const s=Bs(e,"image","rotateWithOffset","float32");i(4===s.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${s.rank}.`));const o={image:s},a={radians:t,fillValue:n,center:r};return As.runKernel("RotateWithOffset",o,a)}});function bh(e,t,n,r,s,o){null==r&&(r=.5),null==s&&(s=Number.NEGATIVE_INFINITY),null==o&&(o=0);const a=e.shape[0];return n=Math.min(n,a),i(0<=r&&r<=1,(()=>`iouThreshold must be in [0, 1], but was '${r}'`)),i(2===e.rank,(()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`)),i(4===e.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`)),i(1===t.rank,(()=>"scores must be a 1D tensor")),i(t.shape[0]===a,(()=>`scores has incompatible shape with boxes. Expected ${a}, but was ${t.shape[0]}`)),i(0<=o&&o<=1,(()=>`softNmsSigma must be in [0, 1], but was '${o}'`)),{maxOutputSize:n,iouThreshold:r,scoreThreshold:s,softNmsSigma:o}}const yh=Os({nonMaxSuppression_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const o=Bs(e,"boxes","nonMaxSuppression","float32"),a=Bs(t,"scores","nonMaxSuppression","float32"),i=bh(o,a,n,r,s),l={maxOutputSize:n=i.maxOutputSize,iouThreshold:r=i.iouThreshold,scoreThreshold:s=i.scoreThreshold};return As.runKernel("NonMaxSuppressionV3",{boxes:o,scores:a},l)}});function wh(e,t,n){const r=function(e,t,n){return function(e,t,n){let r=0,s=e.length,o=0,a=!1;for(;r<s;){o=r+(s-r>>>1);const i=n(t,e[o]);i>0?r=o+1:(s=o,a=!i)}return a?r:-r-1}(e,t,n||kh)}(e,t,n),s=r<0?-(r+1):r;e.splice(s,0,t)}function kh(e,t){return e>t?1:e<t?-1:0}function vh(e,t,n,r,s){return Sh(e,t,n,r,s,0)}function xh(e,t,n,r,s,o){return Sh(e,t,n,r,s,0,!1,o,!0)}function Eh(e,t,n,r,s,o){return Sh(e,t,n,r,s,o,!0)}function Sh(e,t,n,r,s,o,a=!1,i=!1,l=!1){const u=[];for(let e=0;e<t.length;e++)t[e]>s&&u.push({score:t[e],boxIndex:e,suppressBeginIndex:0});u.sort(_h);const c=o>0?-.5/o:0,h=[],d=[];for(;h.length<n&&u.length>0;){const t=u.pop(),{score:n,boxIndex:o,suppressBeginIndex:a}=t;if(n<s)break;let i=!1;for(let n=h.length-1;n>=a;--n){const a=$h(e,o,h[n]);if(a>=r){i=!0;break}if(t.score=t.score*Ah(r,c,a),t.score<=s)break}t.suppressBeginIndex=h.length,i||(t.score===n?(h.push(o),d.push(t.score)):t.score>s&&wh(u,t,_h))}const f=h.length,p=n-f;i&&p>0&&(h.push(...new Array(p).fill(0)),d.push(...new Array(p).fill(0)));const g={selectedIndices:h};return a&&(g.selectedScores=d),l&&(g.validOutputs=f),g}function $h(e,t,n){const r=e.subarray(4*t,4*t+4),s=e.subarray(4*n,4*n+4),o=Math.min(r[0],r[2]),a=Math.min(r[1],r[3]),i=Math.max(r[0],r[2]),l=Math.max(r[1],r[3]),u=Math.min(s[0],s[2]),c=Math.min(s[1],s[3]),h=Math.max(s[0],s[2]),d=Math.max(s[1],s[3]),f=(i-o)*(l-a),p=(h-u)*(d-c);if(f<=0||p<=0)return 0;const g=Math.max(o,u),m=Math.max(a,c),b=Math.min(i,h),y=Math.min(l,d),w=Math.max(b-g,0)*Math.max(y-m,0);return w/(f+p-w)}function Ah(e,t,n){const r=Math.exp(t*n*n);return n<=e?r:0}function _h(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const Ih=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const o=Bs(e,"boxes","nonMaxSuppressionAsync"),a=Bs(t,"scores","nonMaxSuppressionAsync"),i=bh(o,a,n,r,s);n=i.maxOutputSize,r=i.iouThreshold,s=i.scoreThreshold;const l=await Promise.all([o.data(),a.data()]),u=l[0],c=l[1],{selectedIndices:h}=vh(u,c,n,r,s);return o!==e&&o.dispose(),a!==t&&a.dispose(),Nc(h,"int32")};const Mh=Os({nonMaxSuppressionWithScore_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=0){const a=Bs(e,"boxes","nonMaxSuppression"),i=Bs(t,"scores","nonMaxSuppression"),l=bh(a,i,n,r,s,o),u={boxes:a,scores:i},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:r=l.iouThreshold,scoreThreshold:s=l.scoreThreshold,softNmsSigma:o=l.softNmsSigma},h=As.runKernel("NonMaxSuppressionV5",u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const Nh=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=0){const a=Bs(e,"boxes","nonMaxSuppressionAsync"),i=Bs(t,"scores","nonMaxSuppressionAsync"),l=bh(a,i,n,r,s,o);n=l.maxOutputSize,r=l.iouThreshold,s=l.scoreThreshold,o=l.softNmsSigma;const u=await Promise.all([a.data(),i.data()]),c=u[0],h=u[1],{selectedIndices:d,selectedScores:f}=Eh(c,h,n,r,s,o);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:Nc(d,"int32"),selectedScores:Nc(f)}};const Th=Os({nonMaxSuppressionPadded_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=!1){const a=Bs(e,"boxes","nonMaxSuppression"),i=Bs(t,"scores","nonMaxSuppression"),l=bh(a,i,n,r,s,null),u={boxes:a,scores:i},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:o},h=As.runKernel("NonMaxSuppressionV4",u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const Dh=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=!1){const a=Bs(e,"boxes","nonMaxSuppressionAsync"),i=Bs(t,"scores","nonMaxSuppressionAsync"),l=bh(a,i,n,r,s,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[d,f]=await Promise.all([a.data(),i.data()]),{selectedIndices:p,validOutputs:g}=xh(d,f,u,c,h,o);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:Nc(p,"int32"),validOutputs:ac(g,"int32")}};const Rh=Os({resizeBilinear_:function(e,t,n=!1,r=!1){const s=Bs(e,"images","resizeBilinear");i(3===s.rank||4===s.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${s.rank}.`)),i(2===t.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${t}.`)),i(!1===r||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let o=s,a=!1;3===s.rank&&(a=!0,o=xi(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const l={images:o},u={alignCorners:n,halfPixelCenters:r,size:t},c=As.runKernel("ResizeBilinear",l,u);return a?xi(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Fh=Os({resizeNearestNeighbor_:function(e,t,n=!1,r=!1){const s=Bs(e,"images","resizeNearestNeighbor");i(3===s.rank||4===s.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${s.rank}.`)),i(2===t.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`)),i("float32"===s.dtype||"int32"===s.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),i(!1===r||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let o=s,a=!1;3===s.rank&&(a=!0,o=xi(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const l={images:o},u={alignCorners:n,halfPixelCenters:r,size:t},c=As.runKernel("ResizeNearestNeighbor",l,u);return a?xi(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Bh=Os({threshold_:function(e,t="binary",n=!1,r=.5){const s=Bs(e,"image","threshold"),o=s.shape[0]*s.shape[1];let a,l,u,c,h=Za(Nc([r]),255);if(i(3===s.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${s.rank}.`)),i(3===s.shape[2]||1===s.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${s.shape[2]}.`)),i("int32"===s.dtype||"float32"===s.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${s.dtype}.`)),i("otsu"===t||"binary"===t,(()=>`Method must be binary or otsu, but was ${t}`)),3===s.shape[2]){[a,l,u]=vc(s,[1,1,1],-1);const e=Za(a,.2989),t=Za(l,.587),n=Za(u,.114);c=Va(Va(e,t),n)}else c=e;if("otsu"===t){h=function(e,t){let n,r,s,o,a,i,l=Nc([-1]),u=Nc([0]),c=Nc([0]);for(let h=0;h<e.size-1;h++){n=_i(e,0,h+1),r=_i(e,h+1),a=Ja(Hl(n),t),i=Ja(Hl(r),t);const d=Hl(Za(n,ju(0,n.size)));s=Ja(d,Hl(n));const f=yl(r.shape,n.size),p=Va(ju(0,r.size),f),g=Za(r,p);o=Ja(Hl(g),Hl(r));const m=Gl(s,o),b=Gl(s,o),y=Za(a,i);c=Za(Za(y,m),b);const w=vl(c,u);u=al(w,c,u),l=al(w,Nc([h]),l)}return l}(Bi(Ao(sc(c),"int32"),Ws([]),256),o)}const d=n?Ml(c,h):vl(c,h);return Ao(Za(d,255),"int32")}});const Ch=Os({transform_:function(e,t,n="nearest",r="constant",s=0,o){const a=Bs(e,"image","transform","float32"),l=Bs(t,"transforms","transform","float32");i(4===a.rank,(()=>`Error in transform: image must be rank 4,but got rank ${a.rank}.`)),i(2===l.rank&&(l.shape[0]===a.shape[0]||1===l.shape[0])&&8===l.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),i(null==o||2===o.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${o}.`));const u={image:a,transforms:l},c={interpolation:n,fillMode:r,fillValue:s,outputShape:o};return As.runKernel("Transform",u,c)}});const Ph=Os({bandPart_:function(e,t,n){i(t%1==0,(()=>`bandPart(): numLower must be an integer, got ${t}.`)),i(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const r=Bs(e,"a","bandPart");i(r.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${r.rank}.`));const s=r.shape,[o,a]=r.shape.slice(-2);if(!(t<=o))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${o}).`);if(!(n<=a))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${a}).`);t<0&&(t=o),n<0&&(n=a);const l=xi(ju(0,o,1,"int32"),[-1,1]),u=ju(0,a,1,"int32"),c=Gl(l,u),h=Xl(Ml(c,ac(+t,"int32")),xl(c,ac(-n,"int32"))),d=iu([o,a],r.dtype);return xi(Ac(Lc(xi(r,[-1,o,a])).map((e=>al(h,e,d)))),s)}});const Oh=Os({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,i(null!=e&&e.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=e[0].shape[0];for(let t=1;t<e.length;++t)i(e[t].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`))}else t=!0,e=vc(e,e.shape[0],0).map((e=>$c(e,[0])));i(e.length<=e[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`));const n=[],r=e;for(let t=0;t<e.length;++t)n.push(As.tidy((()=>{let e=r[t];if(t>0)for(let r=0;r<t;++r){const t=Za(Hl(Za(n[r],e)),n[r]);e=Gl(e,t)}return Ja(e,Gc(e,"euclidean"))})));return t?Ac(n,0):n}});function Lh(e,t=!1){return As.tidy((()=>{i(2===e.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`));const n=e.shape[0],r=e.shape[1];let s=bl(n),o=_o(e);const a=Tc([[1]],[1,1]);let l=_o(a);const u=n>=r?r:n;for(let e=0;e<u;++e){const t=o,i=l,u=s;[l,o,s]=As.tidy((()=>{const t=_i(o,[e,e],[n-e,1]),i=Gc(t),u=_i(o,[e,e],[1,1]),c=al(vl(u,0),Tc([[-1]]),Tc([[1]])),h=Gl(u,Za(c,i)),d=Ja(t,h);l=1===d.shape[0]?_o(a):$i([a,_i(d,[1,0],[d.shape[0]-1,d.shape[1]])],0);const f=Wl(Ja(Ko(c,h),i)),p=_i(o,[e,0],[n-e,r]),g=Za(f,l),m=qo(l);if(0===e)o=Gl(p,Ko(g,Ko(m,p)));else{const t=Gl(p,Ko(g,Ko(m,p)));o=$i([_i(o,[0,0],[e,r]),t],0)}const b=qo(g),y=_i(s,[0,e],[n,s.shape[1]-e]);if(0===e)s=Gl(y,Ko(Ko(y,l),b));else{const t=Gl(y,Ko(Ko(y,l),b));s=$i([_i(s,[0,0],[n,e]),t],1)}return[l,o,s]})),Ba([t,i,u])}return!t&&n>r&&(s=_i(s,[0,0],[n,r]),o=_i(o,[0,0],[r,r])),[s,o]}))}const zh=Os({qr_:function(e,t=!1){if(i(e.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`)),2===e.rank)return Lh(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce(((e,t)=>e*t)),r=Lc(xi(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),s=[],o=[];r.forEach((e=>{const[n,r]=Lh(e,t);s.push(n),o.push(r)}));return[xi(Ac(s,0),e.shape),xi(Ac(o,0),e.shape)]}}});var Wh;!function(e){e[e.NONE=0]="NONE",e[e.MEAN=1]="MEAN",e[e.SUM=2]="SUM",e[e.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(Wh||(Wh={}));const Kh=Os({computeWeightedLoss_:function(e,t,n=Wh.SUM_BY_NONZERO_WEIGHTS){const r=Bs(e,"losses","computeWeightedLoss");let s=null;null!=t&&(s=Bs(t,"weights","computeWeightedLoss"));const o=null==s?r:Za(r,s);if(n===Wh.NONE)return o;if(n===Wh.SUM)return Hl(o);if(n===Wh.MEAN){if(null==s)return au(o);{const e=r.size/s.size,t=Ja(Hl(o),Hl(s));return e>1?Ja(t,ac(e)):t}}if(n===Wh.SUM_BY_NONZERO_WEIGHTS){if(null==s)return Ja(Hl(o),ac(r.size));{const e=Za(s,lu(r.shape)),t=Ao(Hl(yu(e,ac(0))),"float32");return Ja(Hl(o),t)}}throw Error(`Unknown reduction: ${n}`)}});const Uh=Os({absoluteDifference_:function(e,t,n,r=Wh.SUM_BY_NONZERO_WEIGHTS){const s=Bs(e,"labels","absoluteDifference"),o=Bs(t,"predictions","absoluteDifference");let a=null;null!=n&&(a=Bs(n,"weights","absoluteDifference")),l(s.shape,o.shape,"Error in absoluteDifference: ");const i=Ya(Gl(s,o));return Kh(i,a,r)}});const qh=Os({cosineDistance_:function(e,t,n,r,s=Wh.SUM_BY_NONZERO_WEIGHTS){const o=Bs(e,"labels","cosineDistance"),a=Bs(t,"predictions","cosineDistance");let i=null;null!=r&&(i=Bs(r,"weights","cosineDistance")),l(o.shape,a.shape,"Error in cosineDistance: ");const u=ac(1),c=Gl(u,Hl(Za(o,a),n,!0));return Kh(c,i,s)}});const Gh=Os({hingeLoss_:function(e,t,n,r=Wh.SUM_BY_NONZERO_WEIGHTS){let s=Bs(e,"labels","hingeLoss");const o=Bs(t,"predictions","hingeLoss");let a=null;null!=n&&(a=Bs(n,"weights","hingeLoss")),l(s.shape,o.shape,"Error in hingeLoss: ");const i=ac(1);s=Gl(Za(ac(2),s),i);const u=Yu(Gl(i,Za(s,o)));return Kh(u,a,r)}});const Hh=Os({huberLoss_:function(e,t,n,r=1,s=Wh.SUM_BY_NONZERO_WEIGHTS){const o=Bs(e,"labels","huberLoss"),a=Bs(t,"predictions","huberLoss");let i=null;null!=n&&(i=Bs(n,"weights","huberLoss")),l(o.shape,a.shape,"Error in huberLoss: ");const u=ac(r),c=Ya(Gl(a,o)),h=hu(c,u),d=Gl(c,h),f=Va(Za(ac(.5),pu(h)),Za(u,d));return Kh(f,i,s)}});const Vh=Os({logLoss_:function(e,t,n,r=1e-7,s=Wh.SUM_BY_NONZERO_WEIGHTS){const o=Bs(e,"labels","logLoss"),a=Bs(t,"predictions","logLoss");let i=null;null!=n&&(i=Bs(n,"weights","logLoss")),l(o.shape,a.shape,"Error in logLoss: ");const u=ac(1),c=ac(r),h=Wl(Za(o,Dl(Va(a,c)))),d=Za(Gl(u,o),Dl(Va(Gl(u,a),c))),f=Gl(h,d);return Kh(f,i,s)}});const jh=Os({meanSquaredError_:function(e,t,n,r=Wh.SUM_BY_NONZERO_WEIGHTS){const s=Bs(e,"labels","meanSquaredError"),o=Bs(t,"predictions","meanSquaredError");let a=null;null!=n&&(a=Bs(n,"weights","meanSquaredError")),l(s.shape,o.shape,"Error in meanSquaredError: ");const i=Sc(s,o);return Kh(i,a,r)}});const Jh=Os({sigmoidCrossEntropy_:function(e,t,n,r=0,s=Wh.SUM_BY_NONZERO_WEIGHTS){let o=Bs(e,"multiClassLabels","sigmoidCrossEntropy");const a=Bs(t,"logits","sigmoidCrossEntropy");let i=null;if(null!=n&&(i=Bs(n,"weights","sigmoidCrossEntropy")),l(o.shape,a.shape,"Error in sigmoidCrossEntropy: "),r>0){const e=ac(r),t=ac(1),n=ac(.5);o=Va(Za(o,Gl(t,e)),Za(n,e))}const u=function(e,t){const n=Bs(e,"labels","sigmoidCrossEntropyWithLogits"),r=Bs(t,"logits","sigmoidCrossEntropyWithLogits");l(n.shape,r.shape,"Error in sigmoidCrossEntropyWithLogits: ");const s=Yu(r),o=Za(r,n),a=Rl(fl(Wl(Ya(r))));return Va(Gl(s,o),a)}(o,a);return Kh(u,i,s)}});const Zh=Os({softmaxCrossEntropy_:function(e,t,n,r=0,s=Wh.SUM_BY_NONZERO_WEIGHTS){let o=Bs(e,"onehotLabels","softmaxCrossEntropy");const a=Bs(t,"logits","softmaxCrossEntropy");let i=null;if(null!=n&&(i=Bs(n,"weights","softmaxCrossEntropy")),l(o.shape,a.shape,"Error in softmaxCrossEntropy: "),r>0){const e=ac(r),t=ac(1),n=ac(o.shape[1]);o=Va(Za(o,Gl(t,e)),Ja(e,n))}const u=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);return Ll(((e,t,r)=>{const s=Yl(t,[n],!0),o=Gl(Ao(t,"float32"),s);r([e,o]);const a=Wl(Za(o,e));return{value:Hl(a,[n]),gradFunc:(e,t)=>{const[r,s]=t,o=Zl(e.shape,[n]);return[Za(xi(e,o),Gl(Ao(r,"float32"),fl(s))),Za(xi(e,o),Gl(fl(s),Ao(r,"float32")))]}}}))(e,t)}(o,a);return Kh(u,i,s)}});const Yh=Os({sparseFillEmptyRows_:function(e,t,n,r){const s=Bs(e,"indices","sparseFillEmptyRows","int32"),o=Bs(t,"values","sparseFillEmptyRows"),a=Bs(n,"denseShape","sparseFillEmptyRows","int32"),i=Bs(r,"defaultValue","sparseFillEmptyRows",o.dtype);if(2!==s.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==o.rank)throw new Error(`Values should be Tensor1D but received shape ${o.shape}`);if(1!==a.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${a.shape}`);if(0!==i.rank)throw new Error(`Default value should be a scalar but received shape ${i.shape}`);const l={indices:s,values:o,denseShape:a,defaultValue:i},u=As.runKernel("SparseFillEmptyRows",l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}});const Xh=Os({sparseReshape_:function(e,t,n){const r=Bs(e,"inputIndices","sparseReshape","int32"),s=Bs(t,"inputShape","sparseReshape","int32"),o=Bs(n,"newShape","sparseReshape","int32");if(2!==r.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==s.rank)throw new Error(`Input shape should be Tensor1D but received shape ${s.shape}`);if(1!==o.rank)throw new Error(`New shape should be Tensor1D but received shape ${o.shape}`);const a={inputIndices:r,inputShape:s,newShape:o},i=As.runKernel("SparseReshape",a);return{outputIndices:i[0],outputShape:i[1]}}});const Qh=Os({sparseSegmentMean_:function(e,t,n){const r=Bs(e,"data","sparseSegmentMean"),s=Bs(t,"indices","sparseSegmentMean","int32"),o=Bs(n,"segmentIds","sparseSegmentMean","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${s.shape}`);if(1!==o.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${o.shape}`);const a={data:r,indices:s,segmentIds:o};return As.runKernel("SparseSegmentMean",a)}});const ed=Os({sparseSegmentSum_:function(e,t,n){const r=Bs(e,"data","sparseSegmentSum"),s=Bs(t,"indices","sparseSegmentSum","int32"),o=Bs(n,"segmentIds","sparseSegmentSum","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${s.shape}`);if(1!==o.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${o.shape}`);const a={data:r,indices:s,segmentIds:o};return As.runKernel("SparseSegmentSum",a)}});const td=Os({stringNGrams_:function(e,t,n,r,s,o,a,i){const l=Bs(e,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=Bs(t,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const c={separator:n,nGramWidths:r,leftPad:s,rightPad:o,padWidth:a,preserveShortSequences:i},h={data:l,dataSplits:u},d=As.runKernel("StringNGrams",h,c);return{nGrams:d[0],nGramsSplits:d[1]}}});const nd=Os({stringSplit_:function(e,t,n=!0){const r=Bs(e,"input","stringSplit","string"),s=Bs(t,"delimiter","stringSplit","string");if(1!==r.rank)throw new Error(`Input should be Tensor1D but received shape ${r.shape}`);if(0!==s.rank)throw new Error(`Delimiter should be a scalar but received shape ${s.shape}`);const o={skipEmpty:n},a={input:r,delimiter:s},i=As.runKernel("StringSplit",a,o);return{indices:i[0],values:i[1],shape:i[2]}}});const rd=Os({stringToHashBucketFast_:function(e,t){const n=Bs(e,"input","stringToHashBucketFast","string"),r={numBuckets:t};if(t<=0)throw new Error("Number of buckets must be at least 1");const s={input:n};return As.runKernel("StringToHashBucketFast",s,r)}}),sd={fft:yc,ifft:wc,rfft:xc,irfft:kc},od={hammingWindow:uh,hannWindow:ch,frame:hh,stft:dh},ad={flipLeftRight:ph,grayscaleToRGB:gh,resizeNearestNeighbor:Fh,resizeBilinear:Rh,rotateWithOffset:mh,cropAndResize:fh,nonMaxSuppression:yh,nonMaxSuppressionAsync:Ih,nonMaxSuppressionWithScore:Mh,nonMaxSuppressionWithScoreAsync:Nh,nonMaxSuppressionPadded:Th,nonMaxSuppressionPaddedAsync:Dh,threshold:Bh,transform:Ch},id={bandPart:Ph,gramSchmidt:Oh,qr:zh},ld={absoluteDifference:Uh,computeWeightedLoss:Kh,cosineDistance:qh,hingeLoss:Gh,huberLoss:Hh,logLoss:Vh,meanSquaredError:jh,sigmoidCrossEntropy:Jh,softmaxCrossEntropy:Zh},ud={sparseFillEmptyRows:Yh,sparseReshape:Xh,sparseSegmentMean:Qh,sparseSegmentSum:ed},cd={stringNGrams:td,stringSplit:nd,stringToHashBucketFast:rd};class hd extends ba{minimize(e,t=!1,n){const{value:r,grads:s}=this.computeGradients(e,n);if(null!=n){const e=n.map((e=>({name:e.name,tensor:s[e.name]})));this.applyGradients(e)}else this.applyGradients(s);return Ba(s),t?r:(r.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return Ol(e,t)}dispose(){null!=this.iterations_&&Ba(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:ac(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty(hd,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class dd extends hd{constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=As.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=As.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${t}/accum_grad`,variable:Fa((()=>il(r).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${t}/accum_var`,variable:Fa((()=>il(r).variable(false)))});const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const o=this.accumulatedGrads[n].variable,a=this.accumulatedUpdates[n].variable;Fa((()=>{const e=Va(Za(o,this.rho),Za(pu(s),1-this.rho)),t=Za(Ja(Ec(Va(a,this.epsilon)),Ec(Va(o,this.epsilon))),s),n=Va(Za(a,this.rho),Za(pu(t),1-this.rho));o.assign(e),a.assign(n);const i=Va(Za(t,-this.learningRate),r);r.assign(i)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(Ba(this.accumulatedGrads.map((e=>e.variable))),Ba(this.accumulatedUpdates.map((e=>e.variable))))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedUpdates=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}dd.className="Adadelta",wa(dd);class fd extends hd{constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=As.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:`${t}/accumulator`,variable:Fa((()=>yl(r.shape,this.initialAccumulatorValue).variable(e)))}}const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const o=this.accumulatedGrads[n].variable;Fa((()=>{const e=Va(o,pu(s));o.assign(e);const t=Va(Za(Ja(s,Ec(Va(e,As.backend.epsilon()))),-this.learningRate),r);r.assign(t)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&Ba(this.accumulatedGrads.map((e=>e.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}fd.className="Adagrad",wa(fd);class pd extends hd{constructor(e,t,n,r=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],Fa((()=>{this.accBeta1=ac(t).variable(),this.accBeta2=ac(n).variable()})),null==r&&(this.epsilon=As.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);Fa((()=>{const n=Gl(1,this.accBeta1),r=Gl(1,this.accBeta2);t.forEach(((t,s)=>{const o=As.registeredVariables[t];null==this.accumulatedFirstMoment[s]&&(this.accumulatedFirstMoment[s]={originalName:`${t}/m`,variable:Fa((()=>il(o).variable(false)))}),null==this.accumulatedSecondMoment[s]&&(this.accumulatedSecondMoment[s]={originalName:`${t}/v`,variable:Fa((()=>il(o).variable(false)))});const a=Array.isArray(e)?e[s].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[s].variable,l=this.accumulatedSecondMoment[s].variable,u=Va(Za(i,this.beta1),Za(a,1-this.beta1)),c=Va(Za(l,this.beta2),Za(pu(a),1-this.beta2)),h=Ja(u,n),d=Ja(c,r);i.assign(u),l.assign(c);const f=Va(Za(Ja(h,Va(Ec(d),this.epsilon)),-this.learningRate),o);o.assign(f)})),this.accBeta1.assign(Za(this.accBeta1,this.beta1)),this.accBeta2.assign(Za(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&Ba(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedSecondMoment&&Ba(this.accumulatedSecondMoment.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e),Fa((()=>{this.accBeta1.assign(Iu(this.beta1,this.iterations_+1)),this.accBeta2.assign(Iu(this.beta2,this.iterations_+1))}));const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedSecondMoment=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}pd.className="Adam",wa(pd);class gd extends hd{constructor(e,t,n,r=null,s=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.decay=s,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],Fa((()=>{this.iteration=ac(0).variable(),this.accBeta1=ac(t).variable()})),null==r&&(this.epsilon=As.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);Fa((()=>{const n=Gl(1,this.accBeta1),r=Ja(-this.learningRate,Va(Za(this.iteration,this.decay),1));t.forEach(((t,s)=>{const o=As.registeredVariables[t];null==this.accumulatedFirstMoment[s]&&(this.accumulatedFirstMoment[s]={originalName:`${t}/m`,variable:il(o).variable(false)}),null==this.accumulatedWeightedInfNorm[s]&&(this.accumulatedWeightedInfNorm[s]={originalName:`${t}/v`,variable:il(o).variable(false)});const a=Array.isArray(e)?e[s].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[s].variable,l=this.accumulatedWeightedInfNorm[s].variable,u=Va(Za(i,this.beta1),Za(a,1-this.beta1)),c=Za(l,this.beta2),h=Ya(a),d=ou(c,h);i.assign(u),l.assign(d);const f=Va(Za(Ja(r,n),Ja(u,Va(d,this.epsilon))),o);o.assign(f)})),this.iteration.assign(Va(this.iteration,1)),this.accBeta1.assign(Za(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&Ba(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedWeightedInfNorm&&Ba(this.accumulatedWeightedInfNorm.map((e=>e.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}gd.className="Adamax",wa(gd);class md extends hd{constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const s=As.registeredVariables[t];Fa((()=>{const e=Va(Za(this.c,r),s);s.assign(e)}))})),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=Ca(ac(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}md.className="SGD",wa(md);class bd extends md{constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=ac(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=As.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:`${t}/momentum`,variable:Fa((()=>il(r).variable(e)))}}const s=this.accumulations[n].variable,o=Array.isArray(e)?e[n].tensor:e[t];null!=o&&Fa((()=>{let e;const t=Va(Za(this.m,s),o);e=this.useNesterov?Va(Za(this.c,Va(o,Za(t,this.m))),r):Va(Za(this.c,t),r),s.assign(t),r.assign(e)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&Ba(this.accumulations.map((e=>e.variable)))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}bd.className="Momentum",wa(bd);class yd extends hd{constructor(e,t=.9,n=0,r=null,s=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=r,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=s,null==r&&(this.epsilon=As.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=As.registeredVariables[t],s=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${t}/rms`,variable:Fa((()=>il(r).variable(s)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${t}/momentum`,variable:Fa((()=>il(r).variable(s)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${t}/mg`,variable:Fa((()=>il(r).variable(s)))});const o=Array.isArray(e)?e[n].tensor:e[t];if(null==o)return;const a=this.accumulatedMeanSquares[n].variable,i=this.accumulatedMoments[n].variable;Fa((()=>{const e=Va(Za(a,this.decay),Za(pu(o),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,s=Va(Za(t,this.decay),Za(o,1-this.decay)),l=Ja(Za(o,this.learningRate),Ec(Gl(e,Va(pu(s),this.epsilon)))),u=Va(Za(i,this.momentum),l);a.assign(e),t.assign(s),i.assign(u);const c=Gl(r,u);r.assign(c)}else{const e=Va(Za(a,this.decay),Za(pu(o),1-this.decay)),t=Va(Za(i,this.momentum),Ja(Za(o,this.learningRate),Ec(Va(e,this.epsilon))));a.assign(e),i.assign(t);const n=Gl(r,t);r.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&Ba(this.accumulatedMeanSquares.map((e=>e.variable))),null!=this.accumulatedMeanGrads&&this.centered&&Ba(this.accumulatedMeanGrads.map((e=>e.variable))),null!=this.accumulatedMoments&&Ba(this.accumulatedMoments.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2,n=!1;this.accumulatedMeanSquares=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.accumulatedMoments=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}yd.className="RMSProp",wa(yd);class wd{static sgd(e){return new md(e)}static momentum(e,t,n=!1){return new bd(e,t,n)}static rmsprop(e,t=.9,n=0,r=null,s=!1){return new yd(e,t,n,r,s)}static adam(e=.001,t=.9,n=.999,r=null){return new pd(e,t,n,r)}static adadelta(e=.001,t=.95,n=null){return new dd(e,t,n)}static adamax(e=.002,t=.9,n=.999,r=null,s=0){return new gd(e,t,n,r,s)}static adagrad(e,t=.1){return new fd(e,t)}}const kd={sgd:wd.sgd,momentum:wd.momentum,adadelta:wd.adadelta,adagrad:wd.adagrad,rmsprop:wd.rmsprop,adamax:wd.adamax,adam:wd.adam},vd="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();function xd(){return new Promise((e=>vd((()=>e()))))}const Ed=/->/g;function Sd(e,t){const n=[];for(let r=0;r<e.length;++r)0!==e[r].length&&-1===e[r].indexOf(t)&&-1!==t||n.push(r);return n}var $d={__proto__:null,slice_util:ma,segment_util:{__proto__:null,segOpComputeOptimalWindowSize:function(e,t){let n,r=!1;for(e<=30?(n=e,r=!0):n=M(e,Math.floor(Math.sqrt(e)));!r;)n>t||n===e?r=!0:n=M(e,n+1);return n},computeOutShape:function(e,t,n){const r=[],s=e.length;for(let o=0;o<s;o++)o!==t?r.push(e[o]):r.push(n);return r},collectGatherOpShapeInfo:function(e,t,n,r){const s=t.shape.length,o=e.shape.length;if(0!==r&&(r<-s||r>s))throw new Error(`Expect batchDims in the range of [-${s}, ${s}], but got ${r}`);if(r<0&&(r+=s),r>o)throw new Error(`batchDims (${r}) must be less than rank(x) (\n    ${o}).`);if(n<r)throw new Error(`batchDims (${r}) must be less than or equal to axis (${n}).`);for(let n=0;n<r;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const a=e.shape[n],i=[];let l=1,u=1,c=1;for(let t=0;t<r;++t)i.push(e.shape[t]),l*=e.shape[t];for(let t=r;t<n;t++)i.push(e.shape[t]),u*=e.shape[t];for(let e=r;e<s;e++)i.push(t.shape[e]);for(let t=n+1;t<o;t++)i.push(e.shape[t]),c*=e.shape[t];return{batchSize:l,sliceSize:c,outerSize:u,dimSize:a,outputShape:i}}},fromUint8ToStringArray:function(e){try{return e.map((e=>jr(e)))}catch(e){throw new Error(`Failed to decode encoded string bytes into utf-8, error: ${e}`)}},fromStringArrayToUint8:function(e){return e.map((e=>Vr(e)))},upcastType:gs,axesAreInnerMostDims:jl,combineLocations:Jl,computeOutAndReduceShapes:function(e,t){const n=[],r=e.length;for(let s=0;s<r;s++)-1===t.indexOf(s)&&n.push(e[s]);return[n,t.map((t=>e[t]))]},expandShapeToKeepDim:Zl,assertAxesAreInnerMostDims:function(e,t,n){i(jl(t,n),(()=>`${e} supports only inner-most axes for now. Got axes ${t} and rank-${n} input.`))},getAxesPermutation:function(e,t){if(jl(e,t))return null;const n=[];for(let r=0;r<t;++r)-1===e.indexOf(r)&&n.push(r);return e.forEach((e=>n.push(e))),n},getUndoAxesPermutation:function(e){return e.map(((e,t)=>[t,e])).sort(((e,t)=>e[1]-t[1])).map((e=>e[0]))},getInnerMostAxes:function(e,t){const n=[];for(let r=t-e;r<t;++r)n.push(r);return n},getBroadcastDims:Ho,getReductionAxes:Vo,assertAndGetBroadcastShape:jo,assertParamsConsistent:function(e,t){const n=e[0].length;e.forEach(((e,t)=>{i(e.length===n,(()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`))})),i(t>=0&&t<n,(()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`));const r=e[0];e.forEach(((e,s)=>{for(let o=0;o<n;o++)i(o===t||e[o]===r[o],(()=>`Error in concat${n}D: Shape of tensors[${s}] (${e}) does not match the shape of the rest (${r}) along the non-concatenated axis ${s}.`))}))},computeOutShape:function(e,t){const n=e[0].slice();for(let r=1;r<e.length;r++)n[t]+=e[r][t];return n},computeDilation2DInfo:function(e,t,n,r,s="NHWC",o){return hi(e,[...t,e[3]],n,o,r,null,null,ki(s))},computePool2DInfo:ci,computePool3DInfo:function(e,t,n,r,s,o,a="NDHWC"){const[i,l,u]=gi(t);let c,h;if("NDHWC"===a)h="channelsLast",c=[i,l,u,e[4],e[4]];else{if("NCDHW"!==a)throw new Error(`Unknown dataFormat ${a}`);h="channelsFirst",c=[i,l,u,e[1],e[1]]}return di(e,c,n,r,s,!1,h,o)},computeConv2DInfo:hi,computeConv3DInfo:di,computeDefaultPad:fi,tupleValuesAreOne:yi,eitherStridesOrDilationsAreOne:wi,convertConv2DDataFormat:ki,checkPadOnDimRoundingMode:vi,getFusedDyActivation:th,getFusedBiasGradient:nh,applyActivation:rh,shouldFuse:sh,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:function(e){return e<=30?e:M(e,Math.floor(Math.sqrt(e)))},getImageCenter:function(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]},getReshaped:function(e,t,n,r=!0){let s=[];if(r)s=s.concat(t.slice(0)),s.push(e[0]/n),s=s.concat(e.slice(1));else{s=s.concat(e[0]);const n=t.length;for(let r=0;r<n;++r)s=s.concat([e[r+1]/t[r],t[r]]);s=s.concat(e.slice(n+1))}return s},getPermuted:function(e,t,n=!0){const r=[];if(n){r.push(t);for(let n=t+1;n<e;++n)n<=2*t?(r.push(n),r.push(n-(t+1))):r.push(n)}else{const n=[],s=[];for(let r=1;r<e;++r)r>=2*t+1||r%2==1?s.push(r):n.push(r);r.push(...n),r.push(0),r.push(...s)}return r},getReshapedPermuted:function(e,t,n,r=!0){const s=[];r?s.push(e[0]/n):s.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?r?s.push(t[n-1]*e[n]):s.push(e[n]/t[n-1]):s.push(e[n]);return s},getSliceBeginCoords:function(e,t){const n=[0];for(let r=0;r<t;++r)n.push(e[r][0]);return n},getSliceSize:function(e,t,n){const r=e.slice(0,1);for(let s=0;s<n;++s)r.push(e[s+1]-t[s][0]-t[s][1]);return r},prepareAndValidate:ta,validateUpdateShape:ra,validateInput:sa,calculateShapes:oa,SELU_SCALEALPHA:1.7580993408473768,SELU_SCALE:1.0507009873554805,ERF_P:.3275911,ERF_A1:.254829592,ERF_A2:-.284496736,ERF_A3:1.421413741,ERF_A4:-1.453152027,ERF_A5:1.061405429,warn:Zn,log:function(...e){L().getBool("IS_TEST")||L().getBool("PROD")||console.log(...e)},mergeRealAndImagArrays:function(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let r=0;r<n.length;r+=2)n[r]=e[r/2],n[r+1]=t[r/2];return n},splitRealAndImagArrays:function(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let r=0;r<e.length;r+=2)t[r/2]=e[r],n[r/2]=e[r+1];return{real:t,imag:n}},complexWithEvenIndex:function(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},complexWithOddIndex:function(e){const t=Math.floor(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},getComplexWithIndex:function(e,t){return{real:e[2*t],imag:e[2*t+1]}},assignToTypedArray:function(e,t,n,r){e[2*r]=t,e[2*r+1]=n},exponents:function(e,t){const n=new Float32Array(e/2),r=new Float32Array(e/2);for(let s=0;s<Math.ceil(e/2);s++){const o=(t?2:-2)*Math.PI*(s/e);n[s]=Math.cos(o),r[s]=Math.sin(o)}return{real:n,imag:r}},exponent:function(e,t,n){const r=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(r),imag:Math.sin(r)}},decodeEinsumEquation:function(e,t){const n=((e=e.replace(/\s/g,"")).length-e.replace(Ed,"").length)/"->".length;if(n<1)throw new Error("Equations without an arrow are not supported.");if(n>1)throw new Error('Equation must contain exactly one arrow ("->").');const[r,s]=e.split("->");i(-1===r.indexOf("..."),(()=>'The ellipsis notation ("...") is not supported yet.'));const o=r.split(","),a=o.length;if(t!==a)throw new Error(`Expected ${a} input tensors, received ${t}`);if(a>2)throw new Error("Support for more than 2 input tensors is not implemented yet.");const l=[];for(let e=0;e<s.length;++e){const t=s[e];if(!o.some((e=>-1!==e.indexOf(t))))throw new Error(`Output subscripts contain the label ${t} not present in the input subscripts.`);-1===l.indexOf(t)&&l.push(t)}for(let e=0;e<r.length;++e){const t=r[e];-1===l.indexOf(t)&&","!==t&&l.push(t)}const u=new Array(o.length);for(let e=0;e<a;++e){if(new Set(o[e].split("")).size!==o[e].length)throw new Error(`Found duplicate axes in input component ${o[e]}. Support for duplicate axes in input is not implemented yet.`);u[e]=[];for(let t=0;t<o[e].length;++t)u[e].push(l.indexOf(o[e][t]))}const c=l.length,h=[];for(let e=s.length;e<c;++e)h.push(e);return{allDims:l,summedDims:h,idDims:u}},getEinsumPermutation:function(e,t){let n=new Array(e);n.fill(-1);for(let e=0;e<t.length;++e)n[t[e]]=e;const r=[];for(let t=0;t<e;++t)-1===n[t]&&r.push(t);return n=n.filter((e=>-1!==e)),{permutationIndices:n,expandDims:r}},checkEinsumDimSizes:function(e,t,n){const r=new Array(e);for(let e=0;e<n.length;++e){const s=n[e].shape;for(let n=0;n<t[e].length;++n)void 0===r[t[e][n]]?r[t[e][n]]=s[n]:i(r[t[e][n]]===s[n],(()=>`Expected dimension ${r[t[e][n]]} at axis ${n} of input shaped ${JSON.stringify(s)}, but got dimension ${s[n]}`))}},getEinsumComputePath:function(e,t){const n=e,r=[];let s=0;0===e.length&&n.push(-1),s=e.length+1;for(let e=0;e<s;++e)r.push([]);const o=[];for(let e=0;e<n.length;++e){const s=Sd(t,n[e]);for(const t of s)-1===o.indexOf(t)&&(r[e].push(t),o.push(t))}return{path:n,steps:r}},isIdentityPermutation:function(e){return e.every(((e,t)=>e===t))},prepareSplitSize:function(e,t,n=0){let r=[];if("number"==typeof t)i(e.shape[n]%t==0,(()=>"Number of splits must evenly divide the axis.")),r=new Array(t).fill(e.shape[n]/t);else{i(t.reduce(((e,t)=>(-1===t&&(e+=1),e)),0)<=1,(()=>"There should be only one negative value in split array."));const s=t.indexOf(-1);if(-1!==s){const r=t.reduce(((e,t)=>t>0?e+t:e));t[s]=e.shape[n]-r}i(e.shape[n]===t.reduce(((e,t)=>e+t)),(()=>"The sum of sizes must match the size of the axis dimension.")),r=t}return r},getSparseFillEmptyRowsIndicesDenseShapeMismatch:function(e){return`Received SparseTensor with denseShape[0] = 0 but\n  indices.shape[0] = ${e}`},getSparseFillEmptyRowsNegativeIndexErrorMessage:function(e,t){return`indices(${e}, 0) is invalid: ${t} < 0`},getSparseFillEmptyRowsOutOfRangeIndexErrorMessage:function(e,t,n){return`indices(${e}, 0) is invalid: ${t} >= ${n}`},getSparseReshapeMultipleNegativeOneOutputDimErrorMessage:function(e,t){return`only one output dimension may be -1, not both ${e} and ${t}`},getSparseReshapeNegativeOutputDimErrorMessage:function(e,t){return`size ${e} must be non-negative, not ${t}`},getSparseReshapeEmptyTensorZeroOutputDimErrorMessage:function(){return"reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero"},getSparseReshapeInputOutputMultipleErrorMessage:function(e,t){return`Input to reshape is a SparseTensor with ${h(e)}\n  dense values, but the requested shape requires a multiple of ${h(t)}. inputShape=${e} outputShape= ${t}`},getSparseReshapeInputOutputMismatchErrorMessage:function(e,t){return`Input to reshape is a tensor with ${h(e)} dense values, but the requested shape has ${h(t)}. inputShape=${e} outputShape=${t}`},getSparseSegmentReductionNegativeSegmentIdsErrorMessage:function(){return"segment ids must be >= 0"},getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage:function(){return"segment ids are not increasing"},getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage:function(e,t){return`Segment id ${e} out of range [0, ${t}), possibly because segmentIds input is not sorted.`},getSparseSegmentReductionIndicesOutOfRangeErrorMessage:function(e,t,n){return`Bad: indices[${e}] == ${t} out of range [0, ${n})`}},Ad={__proto__:null,nonMaxSuppressionV3Impl:vh,nonMaxSuppressionV4Impl:xh,nonMaxSuppressionV5Impl:Eh,whereImpl:Wc};export{q as Abs,G as Acos,H as Acosh,dd as AdadeltaOptimizer,fd as AdagradOptimizer,pd as AdamOptimizer,gd as AdamaxOptimizer,V as Add,j as AddN,J as All,Z as Any,Y as ArgMax,X as ArgMin,Q as Asin,ee as Asinh,te as Atan,re as Atan2,ne as Atanh,se as AvgPool,ae as AvgPool3D,ie as AvgPool3DGrad,oe as AvgPoolGrad,le as BatchMatMul,ue as BatchToSpaceND,ce as Bincount,de as BroadcastArgs,he as BroadcastTo,fe as Cast,pe as Ceil,ge as ClipByValue,me as Complex,be as ComplexAbs,ye as Concat,we as Conv2D,ke as Conv2DBackpropFilter,ve as Conv2DBackpropInput,xe as Conv3D,Ee as Conv3DBackpropFilterV2,Se as Conv3DBackpropInputV2,$e as Cos,Ae as Cosh,Ie as CropAndResize,_e as Cumsum,t as DataStorage,Me as DenseBincount,Ne as DepthToSpace,Te as DepthwiseConv2dNative,De as DepthwiseConv2dNativeBackpropFilter,Re as DepthwiseConv2dNativeBackpropInput,Fe as Diag,Be as Dilation2D,Pe as Dilation2DBackpropFilter,Ce as Dilation2DBackpropInput,W as ENV,Le as Einsum,ze as Elu,We as EluGrad,P as Environment,Ue as Equal,Ke as Erf,qe as Exp,Ge as ExpandDims,He as Expm1,Ve as FFT,je as Fill,Je as FlipLeftRight,Ze as Floor,Ye as FloorDiv,Gn as FromPixels,Xe as FusedBatchNorm,jn as FusedConv2D,Jn as FusedDepthwiseConv2D,et as GatherNd,Qe as GatherV2,tt as Greater,nt as GreaterEqual,st as IFFT,rt as Identity,ot as Imag,at as IsFinite,it as IsInf,lt as IsNan,n as KernelBackend,wt as LRN,kt as LRNGrad,ut as LeakyRelu,ct as Less,ht as LessEqual,dt as LinSpace,ft as Log,pt as Log1p,yt as LogSoftmax,gt as LogicalAnd,mt as LogicalNot,bt as LogicalOr,vt as Max,Et as MaxPool,$t as MaxPool3D,At as MaxPool3DGrad,St as MaxPoolGrad,_t as MaxPoolWithArgmax,xt as Maximum,It as Mean,Mt as Min,Nt as Minimum,Tt as MirrorPad,Dt as Mod,bd as MomentumOptimizer,Rt as Multinomial,Ft as Multiply,Bt as Neg,Pt as NonMaxSuppressionV3,Ot as NonMaxSuppressionV4,Lt as NonMaxSuppressionV5,Ct as NotEqual,Ps as OP_SCOPE_SUFFIX,Wt as OneHot,zt as OnesLike,hd as Optimizer,wd as OptimizerConstructors,Kt as Pack,Ut as PadV2,qt as Pool,Gt as Pow,Ht as Prelu,Vt as Prod,yd as RMSPropOptimizer,jt as Range,us as Rank,Jt as Real,Oe as RealDiv,Zt as Reciprocal,Wh as Reduction,Yt as Relu,rn as Relu6,Xt as Reshape,tn as ResizeBilinear,nn as ResizeBilinearGrad,Qt as ResizeNearestNeighbor,en as ResizeNearestNeighborGrad,sn as Reverse,Hn as RotateWithOffset,on as Round,an as Rsqrt,md as SGDOptimizer,ln as ScatterNd,un as Select,cn as Selu,gn as Sigmoid,pn as Sign,dn as Sin,fn as Sinh,hn as Slice,vn as Softmax,mn as Softplus,wn as SpaceToBatchND,xn as SparseFillEmptyRows,En as SparseReshape,Sn as SparseSegmentMean,$n as SparseSegmentSum,An as SparseToDense,kn as SplitV,bn as Sqrt,In as Square,_n as SquaredDifference,qn as Step,Mn as StridedSlice,Nn as StringNGrams,Tn as StringSplit,Dn as StringToHashBucketFast,Rn as Sub,yn as Sum,Fn as Tan,Bn as Tanh,is as Tensor,ss as TensorBuffer,Cn as Tile,Pn as TopK,On as Transform,Ln as Transpose,zn as Unique,Wn as Unpack,Kn as UnsortedSegmentSum,ls as Variable,Un as ZerosLike,Vn as _FusedMatMul,Ya as abs,Xa as acos,Qa as acosh,Va as add,ei as addN,ti as all,ni as any,ri as argMax,si as argMin,oi as asin,ai as asinh,ii as atan,li as atan2,ui as atanh,Ei as avgPool,Si as avgPool3d,Ga as backend,$d as backend_util,Mi as basicLSTMCell,Ti as batchNorm,Di as batchNorm2d,Ri as batchNorm3d,Fi as batchNorm4d,Ni as batchToSpaceND,Bi as bincount,Uc as booleanMaskAsync,Ci as broadcastArgs,Pi as broadcastTo,Jo as broadcast_util,ea as browser,$o as buffer,Ao as cast,Oi as ceil,Li as clipByValue,_o as clone,Ls as complex,$i as concat,zi as concat1d,Wi as concat2d,Ki as concat3d,Ui as concat4d,Gi as conv1d,qi as conv2d,Vi as conv2dTranspose,ji as conv3d,Zi as conv3dTranspose,ar as copyRegisteredKernels,Yi as cos,Xi as cosh,Xc as cosineWindow,Qi as cumsum,Ll as customGrad,el as denseBincount,Ma as deprecationWarn,tl as depthToSpace,nl as depthwiseConv2d,Ns as device_util,rl as diag,sl as dilation2d,Ia as disableDeprecationWarnings,Ba as dispose,Na as disposeVariables,Ja as div,ll as divNoNan,ul as dot,Zc as dropout,cl as einsum,hl as elu,_a as enableDebugMode,Aa as enableProdMode,Yc as enclosingPowerOfTwo,Ta as engine,L as env,ol as equal,dl as erf,fl as exp,pl as expandDims,gl as expm1,bl as eye,yc as fft,yl as fill,Ka as findBackend,Ua as findBackendFactory,wl as floor,ja as floorDiv,lh as fused,kl as gather,Jc as gatherND,na as gather_util,za as getBackend,er as getGradient,Qn as getKernel,tr as getKernelsForBackend,Fl as grad,Bl as grads,vl as greater,xl as greaterEqual,wc as ifft,El as imag,ad as image,Qc as inTopKAsync,Wo as io,kc as irfft,Sl as isFinite,$l as isInf,Al as isNaN,Ca as keep,Ad as kernel_impls,_l as leakyRelu,Il as less,Ml as lessEqual,id as linalg,Nl as linspace,Tl as localResponseNormalization,Dl as log,Rl as log1p,Ul as logSigmoid,Vl as logSoftmax,Yl as logSumExp,Xl as logicalAnd,Ql as logicalNot,eu as logicalOr,tu as logicalXor,ld as losses,Ko as matMul,Go as math,ql as max,nu as maxPool,ru as maxPool3d,su as maxPoolWithArgmax,ou as maximum,au as mean,Da as memory,uu as meshgrid,cu as min,hu as minimum,du as mirrorPad,fu as mod,gu as moments,Hc as movingAverage,Za as mul,mu as multiRNNCell,bu as multinomial,Wl as neg,xd as nextFrame,Gc as norm,yu as notEqual,Uo as oneHot,lu as ones,wu as onesLike,Os as op,ku as outerProduct,vu as pad,xu as pad1d,Eu as pad2d,Su as pad3d,$u as pad4d,_u as pool,Iu as pow,Mu as prelu,Io as print,Nu as prod,Ra as profile,Tu as rand,Gu as randomGamma,Hu as randomNormal,Vu as randomUniform,ju as range,La as ready,Ju as real,Zu as reciprocal,qa as registerBackend,rr as registerGradient,nr as registerKernel,Yu as relu,Xu as relu6,Wa as removeBackend,xi as reshape,Qu as reverse,ec as reverse1d,tc as reverse2d,nc as reverse3d,rc as reverse4d,xc as rfft,sc as round,oc as rsqrt,ac as scalar,Vc as scatterND,aa as scatter_util,ic as selu,lc as separableConv2d,ka as serialization,Oa as setBackend,Ha as setPlatform,uc as setdiff1dAsync,Ai as sigmoid,cc as sign,od as signal,hc as sin,dc as sinh,_i as slice,fc as slice1d,pc as slice2d,gc as slice3d,mc as slice4d,ma as slice_util,bc as softmax,Kl as softplus,Au as spaceToBatchND,ud as sparse,jc as sparseToDense,sd as spectral,vc as split,Ec as sqrt,pu as square,Sc as squaredDifference,$c as squeeze,Ac as stack,_c as step,Ic as stridedSlice,cd as string,Gl as sub,Hl as sum,ms as sumOutType,Mc as tan,Ii as tanh,Ws as tensor,Nc as tensor1d,Tc as tensor2d,Zo as tensor3d,Dc as tensor4d,Rc as tensor5d,Fc as tensor6d,vs as tensor_util,Sa as test_util,Fa as tidy,ml as tile,Pa as time,Bc as topk,kd as train,qo as transpose,Cc as truncatedNormal,Pc as unique,or as unregisterGradient,sr as unregisterKernel,Oc as unsortedSegmentSum,Lc as unstack,gs as upcastType,Jr as util,Cl as valueAndGrad,Pl as valueAndGrads,zc as variable,Ol as variableGrads,$a as version_core,al as where,Kc as whereAsync,iu as zeros,il as zerosLike};
//# sourceMappingURL=tf-core.fesm.min.js.map
