/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("crypto")):"function"==typeof define&&define.amd?define(["exports","crypto"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).tf=e.tf||{},e.require$$0)}(this,(function(e,t){"use strict";function n(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var r=n(t);class s{refCount(e){return o("refCount")}incRef(e){return o("incRef")}timerAvailable(){return!0}time(e){return o("time")}read(e){return o("read")}readSync(e){return o("readSync")}readToGPU(e,t){return o("readToGPU")}numDataIds(){return o("numDataIds")}disposeData(e,t){return o("disposeData")}write(e,t,n){return o("write")}move(e,t,n,r,s){return o("move")}memory(){return o("memory")}floatPrecision(){return o("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return o("dispose")}}function o(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function a(e){let t=e.length,n=0;for(;t>0;)n=Math.random()*t|0,t--,l(e,t,n)}function i(e,t,n){return Math.max(e,Math.min(t,n))}function l(e,t,n){const r=e[t];e[t]=e[n],e[n]=r}function u(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function c(e,t,n=""){u(f(e,t),(()=>n+` Shapes ${e} and ${t} must match`))}function h(e){u(null!=e,(()=>"The input to the tensor constructor must be a non-null value."))}function d(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||E(e)&&!n)for(let r=0;r<e.length;++r)d(e[r],t,n);else t.push(e);return t}function p(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function f(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function g(e){return e%1==0}function m(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function b(e,t){const n=t.length;return u((e=null==e?t.map(((e,t)=>t)):[].concat(e)).every((e=>e>=-n&&e<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`)),u(e.every((e=>g(e))),(()=>`All values in axis param must be integers but got axis ${e}`)),e.map((e=>e<0?n+e:e))}function y(e,t){const n=[],r=[],s=null!=t&&Array.isArray(t)&&0===t.length,o=null==t||s?null:b(t,e).sort();let a=0;for(let t=0;t<e.length;++t){if(null!=o){if(o[a]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==o[a]||o[a]>t)&&1===e[t]&&(n.push(e[t]),r.push(t)),o[a]<=t&&a++}1!==e[t]&&(n.push(e[t]),r.push(t))}return{newShape:n,keptDims:r}}function w(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error(`Unknown data type ${e}`);n=new Uint8Array(t)}return n}function k(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error(`Unknown data type ${e}`);n=new Array(t)}return n}function v(e,t){for(let n=0;n<e.length;n++){const r=e[n];if(isNaN(r)||!isFinite(r))throw Error(`A tensor of type ${t} being uploaded contains ${r}.`)}}function x(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function E(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray}function S(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error(`Unknown dtype ${e}`)}function $(e){if(null==e)return 0;let t=0;return e.forEach((e=>t+=e.length)),t}function A(e){return"string"==typeof e||e instanceof String}function I(e){return"boolean"==typeof e}function _(e){return"number"==typeof e}function N(e){return Array.isArray(e)?N(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray?"int32":_(e)?"float32":A(e)?"string":I(e)?"bool":"float32"}function M(e){return!!(e&&e.constructor&&e.call&&e.apply)}function T(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function D(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let r=t-3;r>=0;--r)n[r]=n[r+1]*e[r+1];return n}function R(e,t,n,r=!1){const s=new Array;if(1===t.length){const o=t[0]*(r?2:1);for(let t=0;t<o;t++)s[t]=n[e+t]}else{const o=t[0],a=t.slice(1),i=a.reduce(((e,t)=>e*t))*(r?2:1);for(let t=0;t<o;t++)s[t]=R(e+t*i,a,n,r)}return s}function B(e,t,n=!1){if(0===e.length)return t[0];const r=e.reduce(((e,t)=>e*t))*(n?2:1);if(0===r)return[];if(r!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}${n?" for a complex tensor":""}.`);return R(0,e,t,n)}function F(e,t){const n=C(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function C(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error(`Unknown data type ${t}`)}function P(e){e.forEach((t=>{u(Number.isInteger(t)&&t>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`))}))}function O(e){return e&&e.then&&"function"==typeof e.then}const L="tfjsflags";class z{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=q,this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&(K().getBool("IS_TEST")||K().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`)),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];K().getBool("IS_TEST")||K().getBool("PROD")||console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(O(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const e=this.getQueryParams(this.global.location.search);if(L in e){e.tfjsflags.split(",").forEach((e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)}))}}}function q(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("=")))),t}function K(){return e.ENV}let W;function G(){if(null==W){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}W=e}return W}function U(e,t){const n=function(){const e=G();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const r=t();return n.set(e,r),n.get(e)}}e.ENV=null;const V="Acos",H="Acosh",j="Add",J="AddN",Z="ArgMax",Y="ArgMin",X="Asin",Q="Asinh",ee="Atan",te="Atanh",ne="Atan2",re="AvgPool",se="AvgPool3D",oe="BatchMatMul",ae="BatchToSpaceND",ie="Bincount",le="BroadcastArgs",ue="Cast",ce="Ceil",he="ClipByValue",de="Complex",pe="ComplexAbs",fe="Concat",ge="Conv2D",me="Conv2DBackpropFilter",be="Conv2DBackpropInput",ye="Conv3D",we="Conv3DBackpropInputV2",ke="Cosh",ve="Cumsum",xe="CropAndResize",Ee="DenseBincount",Se="DepthToSpace",$e="DepthwiseConv2dNative",Ae="DepthwiseConv2dNativeBackpropFilter",Ie="DepthwiseConv2dNativeBackpropInput",_e="Diag",Ne="Dilation2D",Me="RealDiv",Te="Einsum",De="Equal",Re="ExpandDims",Be="Expm1",Fe="Fill",Ce="FlipLeftRight",Pe="Floor",Oe="FloorDiv",Le="FusedBatchNorm",ze="GatherV2",qe="GatherNd",Ke="Greater",We="GreaterEqual",Ge="Identity",Ue="IFFT",Ve="Imag",He="IsFinite",je="IsInf",Je="IsNan",Ze="LeakyRelu",Ye="Less",Xe="LessEqual",Qe="LinSpace",et="Log1p",tt="LogicalAnd",nt="LogicalNot",rt="LogicalOr",st="Maximum",ot="MaxPool",at="MaxPool3D",it="MaxPoolWithArgmax",lt="Mean",ut="Minimum",ct="MirrorPad",ht="Multinomial",dt="Multiply",pt="NotEqual",ft="NonMaxSuppressionV3",gt="NonMaxSuppressionV4",mt="NonMaxSuppressionV5",bt="OnesLike",yt="OneHot",wt="Pack",kt="PadV2",vt="Prelu",xt="Prod",Et="Range",St="Real",$t="Reciprocal",At="Relu",It="Reshape",_t="ResizeNearestNeighbor",Nt="ResizeBilinear",Mt="Relu6",Tt="Reverse",Dt="Round",Rt="Rsqrt",Bt="ScatterNd",Ft="Select",Ct="Selu",Pt="Slice",Ot="Sinh",Lt="Sign",zt="Sigmoid",qt="Softplus",Kt="Sqrt",Wt="SpaceToBatchND",Gt="SplitV",Ut="Softmax",Vt="SparseFillEmptyRows",Ht="SparseReshape",jt="SparseSegmentMean",Jt="SparseSegmentSum",Zt="SparseToDense",Yt="SquaredDifference",Xt="StridedSlice",Qt="StringNGrams",en="StringSplit",tn="StringToHashBucketFast",nn="Tanh",rn="Tile",sn="TopK",on="Transform",an="Transpose",ln="Unique",un="Unpack",cn="UnsortedSegmentSum",hn="ZerosLike",dn="Step",pn="FromPixels",fn="RotateWithOffset",gn="_FusedMatMul",mn="FusedConv2D",bn="FusedDepthwiseConv2D";function yn(...e){K().getBool("IS_TEST")||K().getBool("PROD")||console.warn(...e)}const wn=U("kernelRegistry",(()=>new Map)),kn=U("gradRegistry",(()=>new Map));function vn(e,t){const n=$n(e,t);return wn.get(n)}function xn(e){return kn.get(e)}function En(e){const t=wn.entries(),n=[];for(;;){const{done:r,value:s}=t.next();if(r)break;const[o,a]=s,[i]=o.split("_");i===e&&n.push(a)}return n}function Sn(e){const{kernelName:t,backendName:n}=e,r=$n(t,n);wn.has(r)&&yn(`The kernel '${t}' for backend '${n}' is already registered`),wn.set(r,e)}function $n(e,t){return`${t}_${e}`}var An=_n,In=null;try{In=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(e){}function _n(e,t,n){this.low=0|e,this.high=0|t,this.unsigned=!!n}function Nn(e){return!0===(e&&e.__isLong__)}_n.prototype.__isLong__,Object.defineProperty(_n.prototype,"__isLong__",{value:!0}),_n.isLong=Nn;var Mn={},Tn={};function Dn(e,t){var n,r,s;return t?(s=0<=(e>>>=0)&&e<256)&&(r=Tn[e])?r:(n=Bn(e,(0|e)<0?-1:0,!0),s&&(Tn[e]=n),n):(s=-128<=(e|=0)&&e<128)&&(r=Mn[e])?r:(n=Bn(e,e<0?-1:0,!1),s&&(Mn[e]=n),n)}function Rn(e,t){if(isNaN(e))return t?Wn:Kn;if(t){if(e<0)return Wn;if(e>=Ln)return jn}else{if(e<=-zn)return Jn;if(e+1>=zn)return Hn}return e<0?Rn(-e,t).neg():Bn(e%On|0,e/On|0,t)}function Bn(e,t,n){return new _n(e,t,n)}_n.fromInt=Dn,_n.fromNumber=Rn,_n.fromBits=Bn;var Fn=Math.pow;function Cn(e,t,n){if(0===e.length)throw Error("empty string");if("NaN"===e||"Infinity"===e||"+Infinity"===e||"-Infinity"===e)return Kn;if("number"==typeof t?(n=t,t=!1):t=!!t,(n=n||10)<2||36<n)throw RangeError("radix");var r;if((r=e.indexOf("-"))>0)throw Error("interior hyphen");if(0===r)return Cn(e.substring(1),t,n).neg();for(var s=Rn(Fn(n,8)),o=Kn,a=0;a<e.length;a+=8){var i=Math.min(8,e.length-a),l=parseInt(e.substring(a,a+i),n);if(i<8){var u=Rn(Fn(n,i));o=o.mul(u).add(Rn(l))}else o=(o=o.mul(s)).add(Rn(l))}return o.unsigned=t,o}function Pn(e,t){return"number"==typeof e?Rn(e,t):"string"==typeof e?Cn(e,t):Bn(e.low,e.high,"boolean"==typeof t?t:e.unsigned)}_n.fromString=Cn,_n.fromValue=Pn;var On=4294967296,Ln=On*On,zn=Ln/2,qn=Dn(1<<24),Kn=Dn(0);_n.ZERO=Kn;var Wn=Dn(0,!0);_n.UZERO=Wn;var Gn=Dn(1);_n.ONE=Gn;var Un=Dn(1,!0);_n.UONE=Un;var Vn=Dn(-1);_n.NEG_ONE=Vn;var Hn=Bn(-1,2147483647,!1);_n.MAX_VALUE=Hn;var jn=Bn(-1,-1,!0);_n.MAX_UNSIGNED_VALUE=jn;var Jn=Bn(0,-2147483648,!1);_n.MIN_VALUE=Jn;var Zn=_n.prototype;Zn.toInt=function(){return this.unsigned?this.low>>>0:this.low},Zn.toNumber=function(){return this.unsigned?(this.high>>>0)*On+(this.low>>>0):this.high*On+(this.low>>>0)},Zn.toString=function(e){if((e=e||10)<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(Jn)){var t=Rn(e),n=this.div(t),r=n.mul(t).sub(this);return n.toString(e)+r.toInt().toString(e)}return"-"+this.neg().toString(e)}for(var s=Rn(Fn(e,6),this.unsigned),o=this,a="";;){var i=o.div(s),l=(o.sub(i.mul(s)).toInt()>>>0).toString(e);if((o=i).isZero())return l+a;for(;l.length<6;)l="0"+l;a=""+l+a}},Zn.getHighBits=function(){return this.high},Zn.getHighBitsUnsigned=function(){return this.high>>>0},Zn.getLowBits=function(){return this.low},Zn.getLowBitsUnsigned=function(){return this.low>>>0},Zn.getNumBitsAbs=function(){if(this.isNegative())return this.eq(Jn)?64:this.neg().getNumBitsAbs();for(var e=0!=this.high?this.high:this.low,t=31;t>0&&0==(e&1<<t);t--);return 0!=this.high?t+33:t+1},Zn.isZero=function(){return 0===this.high&&0===this.low},Zn.eqz=Zn.isZero,Zn.isNegative=function(){return!this.unsigned&&this.high<0},Zn.isPositive=function(){return this.unsigned||this.high>=0},Zn.isOdd=function(){return 1==(1&this.low)},Zn.isEven=function(){return 0==(1&this.low)},Zn.equals=function(e){return Nn(e)||(e=Pn(e)),(this.unsigned===e.unsigned||this.high>>>31!=1||e.high>>>31!=1)&&(this.high===e.high&&this.low===e.low)},Zn.eq=Zn.equals,Zn.notEquals=function(e){return!this.eq(e)},Zn.neq=Zn.notEquals,Zn.ne=Zn.notEquals,Zn.lessThan=function(e){return this.comp(e)<0},Zn.lt=Zn.lessThan,Zn.lessThanOrEqual=function(e){return this.comp(e)<=0},Zn.lte=Zn.lessThanOrEqual,Zn.le=Zn.lessThanOrEqual,Zn.greaterThan=function(e){return this.comp(e)>0},Zn.gt=Zn.greaterThan,Zn.greaterThanOrEqual=function(e){return this.comp(e)>=0},Zn.gte=Zn.greaterThanOrEqual,Zn.ge=Zn.greaterThanOrEqual,Zn.compare=function(e){if(Nn(e)||(e=Pn(e)),this.eq(e))return 0;var t=this.isNegative(),n=e.isNegative();return t&&!n?-1:!t&&n?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1},Zn.comp=Zn.compare,Zn.negate=function(){return!this.unsigned&&this.eq(Jn)?Jn:this.not().add(Gn)},Zn.neg=Zn.negate,Zn.add=function(e){Nn(e)||(e=Pn(e));var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,o=e.high>>>16,a=65535&e.high,i=e.low>>>16,l=0,u=0,c=0,h=0;return c+=(h+=s+(65535&e.low))>>>16,u+=(c+=r+i)>>>16,l+=(u+=n+a)>>>16,l+=t+o,Bn((c&=65535)<<16|(h&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},Zn.subtract=function(e){return Nn(e)||(e=Pn(e)),this.add(e.neg())},Zn.sub=Zn.subtract,Zn.multiply=function(e){if(this.isZero())return Kn;if(Nn(e)||(e=Pn(e)),In)return Bn(In.mul(this.low,this.high,e.low,e.high),In.get_high(),this.unsigned);if(e.isZero())return Kn;if(this.eq(Jn))return e.isOdd()?Jn:Kn;if(e.eq(Jn))return this.isOdd()?Jn:Kn;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(qn)&&e.lt(qn))return Rn(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,o=e.high>>>16,a=65535&e.high,i=e.low>>>16,l=65535&e.low,u=0,c=0,h=0,d=0;return h+=(d+=s*l)>>>16,c+=(h+=r*l)>>>16,h&=65535,c+=(h+=s*i)>>>16,u+=(c+=n*l)>>>16,c&=65535,u+=(c+=r*i)>>>16,c&=65535,u+=(c+=s*a)>>>16,u+=t*l+n*i+r*a+s*o,Bn((h&=65535)<<16|(d&=65535),(u&=65535)<<16|(c&=65535),this.unsigned)},Zn.mul=Zn.multiply,Zn.divide=function(e){if(Nn(e)||(e=Pn(e)),e.isZero())throw Error("division by zero");var t,n,r;if(In)return this.unsigned||-2147483648!==this.high||-1!==e.low||-1!==e.high?Bn((this.unsigned?In.div_u:In.div_s)(this.low,this.high,e.low,e.high),In.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?Wn:Kn;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return Wn;if(e.gt(this.shru(1)))return Un;r=Wn}else{if(this.eq(Jn))return e.eq(Gn)||e.eq(Vn)?Jn:e.eq(Jn)?Gn:(t=this.shr(1).div(e).shl(1)).eq(Kn)?e.isNegative()?Gn:Vn:(n=this.sub(e.mul(t)),r=t.add(n.div(e)));if(e.eq(Jn))return this.unsigned?Wn:Kn;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();r=Kn}for(n=this;n.gte(e);){t=Math.max(1,Math.floor(n.toNumber()/e.toNumber()));for(var s=Math.ceil(Math.log(t)/Math.LN2),o=s<=48?1:Fn(2,s-48),a=Rn(t),i=a.mul(e);i.isNegative()||i.gt(n);)i=(a=Rn(t-=o,this.unsigned)).mul(e);a.isZero()&&(a=Gn),r=r.add(a),n=n.sub(i)}return r},Zn.div=Zn.divide,Zn.modulo=function(e){return Nn(e)||(e=Pn(e)),In?Bn((this.unsigned?In.rem_u:In.rem_s)(this.low,this.high,e.low,e.high),In.get_high(),this.unsigned):this.sub(this.div(e).mul(e))},Zn.mod=Zn.modulo,Zn.rem=Zn.modulo,Zn.not=function(){return Bn(~this.low,~this.high,this.unsigned)},Zn.and=function(e){return Nn(e)||(e=Pn(e)),Bn(this.low&e.low,this.high&e.high,this.unsigned)},Zn.or=function(e){return Nn(e)||(e=Pn(e)),Bn(this.low|e.low,this.high|e.high,this.unsigned)},Zn.xor=function(e){return Nn(e)||(e=Pn(e)),Bn(this.low^e.low,this.high^e.high,this.unsigned)},Zn.shiftLeft=function(e){return Nn(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Bn(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):Bn(0,this.low<<e-32,this.unsigned)},Zn.shl=Zn.shiftLeft,Zn.shiftRight=function(e){return Nn(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Bn(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):Bn(this.high>>e-32,this.high>=0?0:-1,this.unsigned)},Zn.shr=Zn.shiftRight,Zn.shiftRightUnsigned=function(e){if(Nn(e)&&(e=e.toInt()),0===(e&=63))return this;var t=this.high;return e<32?Bn(this.low>>>e|t<<32-e,t>>>e,this.unsigned):Bn(32===e?t:t>>>e-32,0,this.unsigned)},Zn.shru=Zn.shiftRightUnsigned,Zn.shr_u=Zn.shiftRightUnsigned,Zn.toSigned=function(){return this.unsigned?Bn(this.low,this.high,!1):this},Zn.toUnsigned=function(){return this.unsigned?this:Bn(this.low,this.high,!0)},Zn.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()},Zn.toBytesLE=function(){var e=this.high,t=this.low;return[255&t,t>>>8&255,t>>>16&255,t>>>24,255&e,e>>>8&255,e>>>16&255,e>>>24]},Zn.toBytesBE=function(){var e=this.high,t=this.low;return[e>>>24,e>>>16&255,e>>>8&255,255&e,t>>>24,t>>>16&255,t>>>8&255,255&t]},_n.fromBytes=function(e,t,n){return n?_n.fromBytesLE(e,t):_n.fromBytesBE(e,t)},_n.fromBytesLE=function(e,t){return new _n(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,t)},_n.fromBytesBE=function(e,t){return new _n(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],t)};const Yn=An||Object.assign(Object.create(null),An,{default:An});function Xn(e){return Yn.fromString(e,!0,16)}const Qn=Xn("c3a5c85c97cb3127"),er=Xn("b492b66fbe98f273"),tr=Xn("9ae16a3b2f90404f");function nr(e){return e.xor(e.shru(47))}function rr(e,t,n){const r=e.slice(t,t+n);return Yn.fromBytes(Array.from(r),!0,!0)}function sr(e,t){return rr(e,t,8)}function or(e,t){return rr(e,t,4)}function ar(e,t){return 0===t?e:e.shru(t).or(e.shl(64-t))}function ir(e,t,n=Xn("9ddfea08eb382d69")){let r=e.xor(t).mul(n);r=r.xor(r.shru(47));let s=t.xor(r).mul(n);return s=s.xor(s.shru(47)),s=s.mul(n),s}function lr(e,t,n,r){return function(e,t,n,r,s,o){s=s.add(e),o=ar(o.add(s).add(r),21);const a=s;return s=(s=s.add(t)).add(n),o=o.add(ar(s,44)),[s.add(r),o.add(a)]}(sr(e,t),sr(e,t+8),sr(e,t+16),sr(e,t+24),n,r)}function ur(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=d(e)),K().getBool("DEBUG")&&v(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error(`Unknown data type ${t}`)}function cr(){return K().platform.now()}function hr(e,t="utf-8"){return t=t||"utf-8",K().platform.encode(e,t)}function dr(e,t="utf-8"){return t=t||"utf-8",K().platform.decode(e,t)}var pr={__proto__:null,createScalarValue:function(e,t){return"string"===t?hr(e):ur([e],t)},toTypedArray:ur,now:cr,fetch:function(e,t){return K().platform.fetch(e,t)},encodeString:hr,decodeString:dr,shuffle:a,shuffleCombo:function(e,t){if(e.length!==t.length)throw new Error(`Array sizes must match to be shuffled together First array length was ${e.length}Second array length was ${t.length}`);let n=e.length,r=0;for(;n>0;)r=Math.random()*n|0,n--,l(e,n,r),l(t,n,r)},clamp:i,nearestLargerEven:function(e){return e%2==0?e:e+1},swap:l,sum:function(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t},randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},distSquared:function(e,t){let n=0;for(let r=0;r<e.length;r++){const s=Number(e[r])-Number(t[r]);n+=s*s}return n},assert:u,assertShapesMatch:c,assertNonNull:h,flatten:d,sizeFromShape:p,isScalarShape:function(e){return 0===e.length},arraysEqual:f,isInt:g,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},sizeToSquarishShape:function(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]},createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return a(t),t},rightPad:m,repeatedTry:function(e,t=(e=>0),n){return new Promise(((r,s)=>{let o=0;const a=()=>{if(e())return void r();o++;const i=t(o);null!=n&&o>=n?s():setTimeout(a,i)};a()}))},inferFromImplicitShape:function(e,t){let n=1,r=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==r)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${r} and dim ${t}`);r=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===r){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const s=e.slice();return s[r]=t/n,s},parseAxisParam:b,squeezeShape:y,getTypedArrayFromDType:w,getArrayFromDType:k,checkConversionForErrors:v,isValidDtype:x,hasEncodingLoss:function(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))},isTypedArray:E,bytesPerElement:S,bytesFromStringArray:$,isString:A,isBoolean:I,isNumber:_,inferDtype:N,isFunction:M,nearestDivisor:T,computeStrides:D,toNestedArray:B,makeOnesTypedArray:F,makeZerosTypedArray:C,makeZerosNestedTypedArray:function(e,t){const n=e.reduce(((e,t)=>e*t),1);if(null==t||"float32"===t)return B(e,new Float32Array(n));if("int32"===t)return B(e,new Int32Array(n));if("bool"===t)return B(e,new Uint8Array(n));throw new Error(`Unknown data type ${t}`)},assertNonNegativeIntegerDimensions:P,locToIndex:function(e,t,n){if(0===t)return 0;if(1===t)return e[0];let r=e[e.length-1];for(let t=0;t<e.length-1;++t)r+=n[t]*e[t];return r},indexToLoc:function(e,t,n){if(0===t)return[];if(1===t)return[e];const r=new Array(t);for(let t=0;t<r.length-1;++t)r[t]=Math.floor(e/n[t]),e-=r[t]*n[t];return r[r.length-1]=e,r},isPromise:O,hexToLong:Xn,fingerPrint64:function(e,t=e.length){const n=Yn.fromNumber(81,!0);if(t<=32)return t<=16?function(e,t=e.length){if(t>=8){const n=tr.add(2*t),r=sr(e,0).add(tr),s=sr(e,t-8);return ir(ar(s,37).mul(n).add(r),ar(r,25).add(s).mul(n),n)}if(t>=4){const n=tr.add(2*t);return ir(or(e,0).shl(3).add(t),or(e,t-4),n)}if(t>0){const n=e[0]+(e[t>>1]<<8),r=t+(e[t-1]<<2);return nr(tr.mul(n).xor(Qn.mul(r))).mul(tr)}return tr}(e,t):function(e,t=e.length){const n=tr.add(2*t),r=sr(e,0).mul(er),s=sr(e,8),o=sr(e,t-8).mul(n),a=sr(e,t-16).mul(tr);return ir(ar(r.add(s),43).add(ar(o,30)).add(a),r.add(ar(s.add(tr),18)).add(o),n)}(e,t);if(t<=64)return function(e,t=e.length){const n=tr.add(2*t),r=sr(e,0).mul(tr),s=sr(e,8),o=sr(e,t-8).mul(n),a=sr(e,t-16).mul(tr),i=ar(r.add(s),43).add(ar(o,30)).add(a),l=ir(i,r.add(ar(s.add(tr),18)).add(o),n),u=sr(e,16).mul(n),c=sr(e,24),h=i.add(sr(e,t-32)).mul(n),d=l.add(sr(e,t-24)).mul(n);return ir(ar(u.add(c),43).add(ar(h,30)).add(d),u.add(ar(c.add(r),18)).add(h),n)}(e,t);let r=n,s=n.mul(er).add(113),o=nr(s.mul(tr).add(113)).mul(tr),a=[Yn.UZERO,Yn.UZERO],i=[Yn.UZERO,Yn.UZERO];r=r.mul(tr).add(sr(e,0));let l=0;const u=64*(t-1>>6),c=u+(t-1&63)-63;do{r=ar(r.add(s).add(a[0]).add(sr(e,l+8)),37).mul(er),s=ar(s.add(a[1]).add(sr(e,l+48)),42).mul(er),r=r.xor(i[1]),s=s.add(a[0]).add(sr(e,l+40)),o=ar(o.add(i[0]),33).mul(er),a=lr(e,l,a[1].mul(er),r.add(i[0])),i=lr(e,l+32,o.add(i[1]),s.add(sr(e,l+16))),[o,r]=[r,o],l+=64}while(l!==u);const h=er.add(o.and(255).shl(1));return l=c,i[0]=i[0].add(t-1&63),a[0]=a[0].add(i[0]),i[0]=i[0].add(a[0]),r=ar(r.add(s).add(a[0]).add(sr(e,l+8)),37).mul(h),s=ar(s.add(a[1]).add(sr(e,l+48)),42).mul(h),r=r.xor(i[1].mul(9)),s=s.add(a[0].mul(9).add(sr(e,l+40))),o=ar(o.add(i[0]),33).mul(h),a=lr(e,l,a[1].mul(h),r.add(i[0])),i=lr(e,l+32,o.add(i[1]),s.add(sr(e,l+16))),[o,r]=[r,o],ir(ir(a[0],i[0],h).add(nr(s).mul(Qn)).add(o),ir(a[1],i[1],h).add(r),h)}};class fr{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new mr)}profileKernel(e,t,n){let r;const s=()=>{r=n()};let o;const a=cr();if(this.backendTimer.timerAvailable())o=this.backendTimer.time(s);else{s();for(const e of r)e.dataSync();o=Promise.resolve({kernelMs:cr()-a})}if(K().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<r.length;t++){const n=r[t];n.data().then((t=>{gr(t,n.dtype,e)}))}return{kernelName:e,outputs:r,inputs:t,timeMs:o.then((e=>e.kernelMs)),extraInfo:o.then((e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():""))}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:r,inputs:s,extraInfo:o}=e;n.forEach((e=>{Promise.all([e.data(),r,o]).then((n=>{this.logger.logKernelProfile(t,e,n[0],n[1],s,n[2])}))}))}}function gr(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const r=e[t];if(isNaN(r)||!isFinite(r))return console.warn(`Found ${r} in the result of '${n}'`),!0}return!1}class mr{logKernelProfile(e,t,n,r,s,o){const a="number"==typeof r?m(`${r}ms`,9):r.error,i=m(e,25),l=t.rank,u=t.size,c=m(t.shape.toString(),14);let h="";for(const e in s){const n=s[e];if(null!=n){const r=n.shape||t.shape,s=r.length;h+=`${e}: ${s}D ${s>0?r:""} `}}console.log(`%c${i}\t%c${a}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${o}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function br(e,t,n,r){const s=D(t),o=function(e,t,n,r){const s=p(t),o=r[r.length-1],a=new Array(o).fill(0),i=t.length,l="complex64"===n?vr(e):e;if(i>1)for(let e=0;e<s/o;e++){const t=e*o;for(let e=0;e<o;e++)a[e]=Math.max(a[e],yr(l[t+e],0,n).length)}return a}(e,t,n,s),a=t.length,i=kr(e,t,n,s,o),l=["Tensor"];return r&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${a}`),l.push(`  shape: [${t}]`),l.push("  values:")),l.push(i.map((e=>"    "+e)).join("\n")),l.join("\n")}function yr(e,t,n){let r;return r=Array.isArray(e)?`${parseFloat(e[0].toFixed(7))} + ${parseFloat(e[1].toFixed(7))}j`:A(e)?`'${e}'`:"bool"===n?wr(e):parseFloat(e.toFixed(7)).toString(),m(r,t)}function wr(e){return 0===e?"false":"true"}function kr(e,t,n,r,s,o=!0){const a="complex64"===n?2:1,i=t[0],l=t.length;if(0===l){if("complex64"===n){return[yr(vr(e)[0],0,n)]}return"bool"===n?[wr(e[0])]:[e[0].toString()]}if(1===l){if(i>20){const t=3*a;let r=Array.from(e.slice(0,t)),o=Array.from(e.slice((i-3)*a,i*a));return"complex64"===n&&(r=vr(r),o=vr(o)),["["+r.map(((e,t)=>yr(e,s[t],n))).join(", ")+", ..., "+o.map(((e,t)=>yr(e,s[i-3+t],n))).join(", ")+"]"]}return["["+("complex64"===n?vr(e):Array.from(e)).map(((e,t)=>yr(e,s[t],n))).join(", ")+"]"]}const u=t.slice(1),c=r.slice(1),h=r[0]*a,d=[];if(i>20){for(let t=0;t<3;t++){const r=t*h,o=r+h;d.push(...kr(e.slice(r,o),u,n,c,s,!1))}d.push("...");for(let t=i-3;t<i;t++){const r=t*h,o=r+h;d.push(...kr(e.slice(r,o),u,n,c,s,t===i-1))}}else for(let t=0;t<i;t++){const r=t*h,o=r+h;d.push(...kr(e.slice(r,o),u,n,c,s,t===i-1))}const p=2===l?",":"";d[0]="["+d[0]+p;for(let e=1;e<d.length-1;e++)d[e]=" "+d[e]+p;let f=",\n";for(let e=2;e<l;e++)f+="\n";return d[d.length-1]=" "+d[d.length-1]+"]"+(o?"":f),d}function vr(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class xr{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=p(e),null!=n){const e=n.length;u(e===this.size,(()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||k(t,this.size),this.strides=D(e)}set(e,...t){0===t.length&&(t=[0]),u(t.length===this.rank,(()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`));const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=${this.shape}`;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return Er().makeTensor(this.values,this.shape,this.dtype)}}let Er=null,Sr=null;class $r{constructor(e,t,n,r){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=p(e),this.strides=D(e),this.dataId=n,this.id=r,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return Sr.buffer(this.shape,this.dtype,e)}bufferSync(){return Sr.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return B(this.shape,e,"complex64"===this.dtype)}arraySync(){return B(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const e=Er().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map((e=>dr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataToGPU(e){return this.throwIfDisposed(),Er().readToGPU(this.dataId,e)}dataSync(){this.throwIfDisposed();const e=Er().readSync(this.dataId);if("string"===this.dtype)try{return e.map((e=>dr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await Er().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(Er().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return Sr.print(this,e)}clone(){return this.throwIfDisposed(),Sr.clone(this)}toString(e=!1){return br(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),Sr.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),Er().makeVariable(this,e,t,n)}}Object.defineProperty($r,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),U("Tensor",(()=>$r));class Ar extends $r{constructor(e,t,n,r){super(e.shape,e.dtype,e.dataId,r),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!f(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);Er().disposeTensor(this),this.dataId=e.dataId,Er().incRef(this,null)}dispose(){Er().disposeVariable(this),this.isDisposedInternal=!0}}var Ir,_r,Nr,Mr,Tr;Object.defineProperty(Ar,Symbol.hasInstance,{value:e=>e instanceof $r&&null!=e.assign&&e.assign instanceof Function}),e.Rank=void 0,(Ir=e.Rank||(e.Rank={})).R0="R0",Ir.R1="R1",Ir.R2="R2",Ir.R3="R3",Ir.R4="R4",Ir.R5="R5",Ir.R6="R6",function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(_r||(_r={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(Nr||(Nr={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(Mr||(Mr={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(Tr||(Tr={}));const Dr={float32:Mr,int32:_r,bool:Nr,complex64:Tr};function Rr(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return Dr[e][t]}function Br(e,t){if(e.dtype===t.dtype)return[e,t];const n=Rr(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function Fr(e,t){u(e.dtype===t.dtype,(()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`))}function Cr(e){const t=[];return Pr(e,t,new Set),t}function Pr(e,t,n){if(null==e)return;if(e instanceof $r)return void t.push(e);if(r=e,!Array.isArray(r)&&"object"!=typeof r)return;var r;const s=e;for(const e in s){const r=s[e];n.has(r)||(n.add(r),Pr(r,t,n))}}var Or={__proto__:null,makeTypesMatch:Br,assertTypesMatch:Fr,isTensorInList:function(e,t){return t.some((t=>t.id===e.id))},getTensorsInContainer:Cr};function Lr(e){return null!=e.kernelName}class zr{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((e=>e.name))))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class qr{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new zr}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(yn(`${e} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new fr(this.backendInstance),!0}setupRegisteredKernels(){En(this.backendName).forEach((e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(e){En(e).forEach((t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])}))}initializeBackend(e){const t=this.registryFactory[e];if(null==t)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const n=t.factory();if(!n||n instanceof s||"function"!=typeof n.then)return this.registry[e]=n,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,r=n.then((n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0))).catch((n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,yn(`Initialization of backend ${e} failed`),yn(n.stack||n.message)),!1)));return this.pendingBackendInit=r,{success:r,asyncInit:!0}}}catch(t){return yn(`Initialization of backend ${e} failed`),yn(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(`${e} backend not found in registry`);this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority))}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:r,asyncInit:s}=this.initializeBackend(n);if(s||r)return{name:n,asyncInit:s}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),r=n.backend,s=this.readSync(t),o=r.refCount(t);r.disposeData(t,!0),n.backend=e,e.move(t,s,n.shape,n.dtype,o),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,r=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");r=e}return this.scopedRun((()=>this.startScope(r)),(()=>this.endScope(n)),(()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return qr.nextTensorId++}nextVariableId(){return qr.nextVariableId++}clone(e){const t=Wr.runKernel(Ge,{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],(e=>({x:()=>{const t={x:e},n={dtype:"float32"};return Wr.runKernel(ue,t,n)}})),[],{}),t}runKernel(e,t,n){null==this.backendName&&this.backend;if(!(null!=vn(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const r=this.backend.numDataIds();let s=0;n.forEach((e=>{s+="complex64"===e.dtype?3:1}));const o=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],a=r-t-s-o;if(a>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${a} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const r=this.isTapeOn(),s=this.state.numBytes,o=this.state.numTensors;let a,i;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const l=Lr(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Lr(e)){const{kernelName:t,inputs:s,attrs:o}=e;null==this.backendName&&this.backend;const l=vn(t,this.backendName);u(null!=l,(()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`)),a=()=>{const e=this.backend.numDataIds();i=l.kernelFunc({inputs:s,attrs:o,backend:this.backend});const a=Array.isArray(i)?i:[i];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,a);const u=a.map((e=>{if(null!=e.rank)return e;const{dataId:t,shape:n,dtype:r}=e;return this.makeTensorFromDataId(t,n,r)}));if(r){const e=this.getTensorsForGradient(t,s,u);n=this.saveTensorsForBackwardMode(e)}return u}}else{const{forwardFunc:t}=e,s=e=>{r&&(n=e.map((e=>this.keep(this.clone(e)))))};a=()=>{const e=this.backend.numDataIds();i=this.tidy((()=>t(this.backend,s)));const n=Array.isArray(i)?i:[i];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(l,e,n),n}}const{inputs:c,attrs:h}=e,d=Lr(e)?null:e.backwardsFunc;let p;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(p=this.profiler.profileKernel(l,c,(()=>a())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(p),t=p.outputs):t=a()})),r&&this.addTapeNode(l,c,t,d,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:l,bytesAdded:this.state.numBytes-s,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-o,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(c).map((e=>null!=c[e]?c[e].shape:null)),outputShapes:t.map((e=>e.shape)),kernelTimeMs:p.timeMs,extraInfo:p.extraInfo}),Array.isArray(i)?t:t[0]}saveTensorsForBackwardMode(e){return e.map((e=>this.keep(this.clone(e))))}getTensorsForGradient(e,t,n){const r=xn(e);if(null!=r){const e=r.inputsToSave||[],s=r.outputsToSave||[];let o;r.saveAllInputs?(u(Array.isArray(t),(()=>"saveAllInputs is true, expected inputs to be an array.")),o=Object.keys(t).map((e=>t[e]))):o=e.map((e=>t[e]));const a=n.filter(((e,t)=>s[t]));return o.concat(a)}return[]}makeTensor(e,t,n,r){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",r=r||this.backend;let s=e;"string"===n&&A(e[0])&&(s=e.map((e=>hr(e))));const o=r.write(s,t,n),a=new $r(t,n,o,this.nextTensorId());if(this.trackTensor(a,r),"string"===n){const e=this.state.tensorInfo.get(o),t=$(s);this.state.numBytes+=t-e.bytes,e.bytes=t}return a}makeTensorFromDataId(e,t,n,r){const s=new $r(t,n=n||"float32",e,this.nextTensorId());return this.trackTensor(s,r),s}makeVariable(e,t=!0,n,r){n=n||this.nextVariableId().toString(),null!=r&&r!==e.dtype&&(e=e.cast(r));const s=new Ar(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[s.name])throw new Error(`Variable with name ${s.name} was already registered`);return this.state.registeredVariables[s.name]=s,this.incRef(s,this.backend),s}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*S(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof Ar||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*S(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((e=>e.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,r,s,o){const a={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:s},i=xn(e);null!=i&&(r=i.gradFunc),null!=r&&(a.gradient=e=>(e=e.map(((e,t)=>{if(null==e){const e=n[t],r=C(e.size,e.dtype);return this.makeTensor(r,e.shape,e.dtype)}return e})),r(e.length>1?e:e[0],s,o))),this.state.activeTape.push(a)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=Cr(e),n=new Set(t.map((e=>e.id)));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const r=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach((e=>{e.kept||e.scopeId!==r.id||this.track(e)}))}gradients(e,t,n,r=!1){if(u(t.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const s=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",e)));u(s instanceof $r,(()=>"The result y returned by f() must be a tensor."));const o=function(e,t,n){const r={},s={};for(let e=0;e<t.length;e++)r[t[e].id]=!0;for(let n=0;n<e.length;n++){const o=e[n],a=o.inputs;for(const e in a){const n=a[e];let i=!1;for(let e=0;e<t.length;e++)if(r[n.id]){o.outputs.forEach((e=>r[e.id]=!0)),i=!0,s[o.id]=!0;break}if(i)break}}const o={};o[n.id]=!0;const a={};for(let t=e.length-1;t>=0;t--){const n=e[t],r=n.inputs;for(let e=0;e<n.outputs.length;e++)if(o[n.outputs[e].id]){for(const e in r)o[r[e].id]=!0,a[n.id]=!0;break}}const i=[];for(let t=0;t<e.length;t++){const n=e[t];if(s[n.id]&&a[n.id]){const e={};for(const t in n.inputs){const s=n.inputs[t];r[s.id]&&(e[t]=s)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,i.push(t)}}return i}(this.state.activeTape,t,s);if(!r&&0===o.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const e={};e[s.id]=null==n?function(e){const t=F(p(e),"float32");return Wr.makeTensor(t,e,"float32")}(s.shape):n,function(e,t,n,r){for(let s=t.length-1;s>=0;s--){const o=t[s],a=[];if(o.outputs.forEach((t=>{const n=e[t.id];null!=n?a.push(n):a.push(null)})),null==o.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${o.kernelName}.`);const i=o.gradient(a);for(const t in o.inputs){if(!(t in i))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(i)}.`);const s=n((()=>i[t]()));if("float32"!==s.dtype)throw new Error(`Error in gradient for op ${o.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${s.dtype}'`);const a=o.inputs[t];if(!f(s.shape,a.shape))throw new Error(`Error in gradient for op ${o.kernelName}. The gradient of input '${t}' has shape '${s.shape}', which does not match the shape of the input '${a.shape}'`);if(null==e[a.id])e[a.id]=s;else{const t=e[a.id];e[a.id]=r(t,s),t.dispose()}}}}(e,o,(e=>this.tidy(e)),Gr);const r=t.map((t=>e[t.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((e=>{for(const t of e.saved)t.dispose()})),this.state.activeTape=null),{value:s,grads:r}}))}customGrad(e){return u(M(e),(()=>"The f passed in customGrad(f) must be a function.")),(...t)=>{let n;u(t.every((e=>e instanceof $r)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const r={};t.forEach(((e,t)=>{r[t]=e}));return this.runKernelFunc({forwardFunc:(r,s)=>(n=e(...t,s),u(n.value instanceof $r,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),u(M(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(e,r)=>{const s=n.gradFunc(e,r),o=Array.isArray(s)?s:[s];u(o.length===t.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),u(o.every((e=>e instanceof $r)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const a={};return o.forEach(((e,t)=>{a[t]=()=>e})),a},inputs:r})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}readToGPU(e,t){return this.state.tensorInfo.get(e).backend.readToGPU(e,t)}async time(e){const t=cr(),n=await this.backend.time(e);return n.wallMs=cr()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new zr;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function Kr(){const t=G();if(null==t._tfengine){const e=new z(t);t._tfengine=new qr(e)}var n;return n=t._tfengine.ENV,e.ENV=n,Er=()=>t._tfengine,t._tfengine}qr.nextTensorId=0,qr.nextVariableId=0;const Wr=Kr();function Gr(e,t){const n={a:e,b:t};return Wr.runKernel(j,n)}let Ur;function Vr(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var Hr={__proto__:null,mockIsMobile:function(e){Ur=e},isMobile:function(e){if(void 0!==Ur)return Ur;if(e||"undefined"!=typeof navigator&&null!=navigator){if(e||(e=navigator),"ReactNative"===e.product)return!0;const t=e.userAgent||e.vendor||("undefined"!=typeof window?window.opera:"");if(!t){const t=e;return t.userAgentData&&t.userAgentData.mobile}return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(t)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0,4))}return!1},isBrowser:Vr};const jr=K();function Jr(e,t){let n=e;if(E(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const r=[];for(;Array.isArray(n)||E(n)&&"string"!==t;)r.push(n.length),n=n[0];return Array.isArray(e)&&K().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&Zr(e,r,[]),r}function Zr(e,t,n){if(n=n||[],!Array.isArray(e)&&!E(e))return void u(0===t.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`));u(t.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`)),u(e.length===t[0],(()=>`Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`));const r=t.slice(1);for(let t=0;t<e.length;++t)Zr(e[t],r,n.concat(t))}function Yr(e,t,n,r){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${r}' must be ${e} tensor, but got ${t} tensor`)}}function Xr(e,t,n,r="numeric"){if(e instanceof $r)return Yr(r,e.dtype,t,n),e;let s=N(e);if("string"!==s&&["bool","int32","float32"].indexOf(r)>=0&&(s=r),Yr(r,s,t,n),null==e||!E(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const r=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${r}'`)}const o=Jr(e,s);E(e)||Array.isArray(e)||(e=[e]);const a="string"!==s?ur(e,s):d(e,[],!0);return Wr.makeTensor(a,o,s)}function Qr(e,t,n,r="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map(((e,s)=>Xr(e,`${t}[${s}]`,n,r)))}jr.registerFlag("DEBUG",(()=>!1),(e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),jr.registerFlag("IS_BROWSER",(()=>Vr())),jr.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&"undefined"!=typeof process.versions&&"undefined"!=typeof process.versions.node)),jr.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),jr.registerFlag("PROD",(()=>!1)),jr.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>jr.getBool("DEBUG"))),jr.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),jr.registerFlag("IS_TEST",(()=>!1)),jr.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),jr.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1));const es="__op";function ts(e){const t=Object.keys(e);if(1!==t.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);let n=t[0];const r=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+=es;const s=(...e)=>{Wr.startScope(n);try{const t=r(...e);return O(t)&&console.error("Cannot return a Promise inside of tidy."),Wr.endScope(t),t}catch(e){throw Wr.endScope(null),e}};return Object.defineProperty(s,"name",{value:n,configurable:!0}),s}const ns=ts({complex_:function(e,t){const n=Xr(e,"real","complex"),r=Xr(t,"imag","complex");c(n.shape,r.shape,`real and imag shapes, ${n.shape} and ${r.shape}, must match in call to tf.complex().`);const s={real:n,imag:r};return Wr.runKernel(de,s)}});function rs(e,t,n,r){if(null==r&&(r=N(e)),"complex64"===r)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!E(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){P(t);const e=p(t),r=p(n);u(e===r,(()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${r}`));for(let e=0;e<n.length;++e){const r=n[e],s=e!==n.length-1||r!==p(t.slice(e));u(n[e]===t[e]||!s,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `))}}return E(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==r?ur(e,r):d(e,[],!0),Wr.makeTensor(e,t,r)}function ss(e,t,n){return rs(e,t,Jr(e,n),n)}const os={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};function as(e,t){const n={};let r,s=0;for(const o of t){const t=o.name,a=o.dtype,i=o.shape,l=p(i);let u;if("quantization"in o){const n=o.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${o.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${o.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==a)throw new Error(`Weight ${o.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${a}.`)}const i=os[n.dtype],c=e.slice(s,s+l*i),h="uint8"===n.dtype?new Uint8Array(c):new Uint16Array(c);if("float32"===a)if("uint8"===n.dtype||"uint16"===n.dtype){u=new Float32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=t*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===r&&(r=gs()),u=r(h)}else{if("int32"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);u=new Int32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=Math.round(t*n.scale+n.min)}}s+=l*i}else if("string"===a){const t=p(o.shape);u=[];for(let n=0;n<t;n++){const t=new Uint32Array(e.slice(s,s+4))[0];s+=4;const n=new Uint8Array(e.slice(s,s+t));u.push(n),s+=t}}else{const r=os[a],o=e.slice(s,s+l*r);if("float32"===a)u=new Float32Array(o);else if("int32"===a)u=new Int32Array(o);else if("bool"===a)u=new Uint8Array(o);else{if("complex64"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);{u=new Float32Array(o);const e=new Float32Array(u.length/2),r=new Float32Array(u.length/2);for(let t=0;t<e.length;t++)e[t]=u[2*t],r[t]=u[2*t+1];const s=ss(e,i,"float32"),a=ss(r,i,"float32");n[t]=ns(s,a),s.dispose(),a.dispose()}}s+=l*r}"complex64"!==a&&(n[t]=ss(u,i,a))}return n}function is(e){if(null===e)throw new Error(`Invalid input value: ${JSON.stringify(e)}`);let t=0;const n=[];e.forEach((e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error(`Unsupported TypedArray subtype: ${e.constructor.name}`)}));const r=new Uint8Array(t);let s=0;return n.forEach((e=>{r.set(new Uint8Array(e.buffer),s),s+=e.byteLength})),r.buffer}const ls="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function us(e){return ls?Buffer.byteLength(e):new Blob([e]).size}function cs(e){if(1===e.length)return e[0];let t=0;e.forEach((e=>{t+=e.byteLength}));const n=new Uint8Array(t);let r=0;return e.forEach((e=>{n.set(new Uint8Array(e),r),r+=e.byteLength})),n.buffer}function hs(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function ds(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:t};return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),n}async function ps(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};if(null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),null!=e.weightsManifest){const[r,s]=await t(e.weightsManifest);n.weightSpecs=r,n.weightData=s}return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),n}function fs(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:us(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:us(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:e.weightData.byteLength}}function gs(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return r=>{const s=new ArrayBuffer(4*r.length),o=new Uint32Array(s);for(let s=0;s<r.length;s++){const a=r[s],i=e[n[a>>10]+(1023&a)]+t[a>>10];o[s]=i}return new Float32Array(s)}}class ms{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==ms.instance&&(ms.instance=new ms),ms.instance}static registerSaveRouter(e){ms.getInstance().saveRouters.push(e)}static registerLoadRouter(e){ms.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return ms.getHandlers(e,"save")}static getLoadHandlers(e,t){return ms.getHandlers(e,"load",t)}static getHandlers(e,t,n){const r=[];return("load"===t?ms.getInstance().loadRouters:ms.getInstance().saveRouters).forEach((t=>{const s=t(e,n);null!==s&&r.push(s)})),r}}const bs="tensorflowjs",ys="models_store",ws="model_info_store";function ks(){if(!K().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function vs(e){const t=e.result;t.createObjectStore(ys,{keyPath:"modelPath"}),t.createObjectStore(ws,{keyPath:"modelPath"})}class xs{constructor(e){if(this.indexedDB=ks(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise(((e,n)=>{const r=this.indexedDB.open(bs,1);r.onupgradeneeded=()=>vs(r),r.onsuccess=()=>{const s=r.result;if(null==t){const t=s.transaction(ys,"readonly"),r=t.objectStore(ys).get(this.modelPath);r.onsuccess=()=>{if(null==r.result)return s.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(r.result.modelArtifacts)},r.onerror=e=>(s.close(),n(r.error)),t.oncomplete=()=>s.close()}else{const r=fs(t),o=s.transaction(ws,"readwrite");let a=o.objectStore(ws);const i=a.put({modelPath:this.modelPath,modelArtifactsInfo:r});let l;i.onsuccess=()=>{l=s.transaction(ys,"readwrite");const i=l.objectStore(ys).put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:r});i.onsuccess=()=>e({modelArtifactsInfo:r}),i.onerror=e=>{a=o.objectStore(ws);const t=a.delete(this.modelPath);t.onsuccess=()=>(s.close(),n(i.error)),t.onerror=e=>(s.close(),n(i.error))}},i.onerror=e=>(s.close(),n(i.error)),o.oncomplete=()=>{null==l?s.close():l.oncomplete=()=>s.close()}}},r.onerror=e=>n(r.error)}))}}xs.URL_SCHEME="indexeddb://";const Es=e=>{return K().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(xs.URL_SCHEME)?(t=e.slice(xs.URL_SCHEME.length),new xs(t)):null;var t};ms.registerSaveRouter(Es),ms.registerLoadRouter(Es);class Ss{constructor(){this.indexedDB=ks()}async listModels(){return new Promise(((e,t)=>{const n=this.indexedDB.open(bs,1);n.onupgradeneeded=()=>vs(n),n.onsuccess=()=>{const r=n.result,s=r.transaction(ws,"readonly"),o=s.objectStore(ws).getAll();o.onsuccess=()=>{const t={};for(const e of o.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},o.onerror=e=>(r.close(),t(o.error)),s.oncomplete=()=>r.close()},n.onerror=e=>t(n.error)}))}async removeModel(e){var t;return e=(t=e).startsWith(xs.URL_SCHEME)?t.slice(xs.URL_SCHEME.length):t,new Promise(((t,n)=>{const r=this.indexedDB.open(bs,1);r.onupgradeneeded=()=>vs(r),r.onsuccess=()=>{const s=r.result,o=s.transaction(ws,"readwrite"),a=o.objectStore(ws),i=a.get(e);let l;i.onsuccess=()=>{if(null==i.result)return s.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const r=a.delete(e),o=()=>{l=s.transaction(ys,"readwrite");const r=l.objectStore(ys).delete(e);r.onsuccess=()=>t(i.result.modelArtifactsInfo),r.onerror=e=>n(i.error)};r.onsuccess=o,r.onerror=e=>(o(),s.close(),n(i.error))}},i.onerror=e=>(s.close(),n(i.error)),o.oncomplete=()=>{null==l?s.close():l.oncomplete=()=>s.close()}},r.onerror=e=>n(r.error)}))}}const $s="/",As="tensorflowjs_models",Is="info",_s="model_topology",Ns="weight_specs",Ms="weight_data",Ts="model_metadata";function Ds(e){return{info:[As,e,Is].join($s),topology:[As,e,_s].join($s),weightSpecs:[As,e,Ns].join($s),weightData:[As,e,Ms].join($s),modelMetadata:[As,e,Ts].join($s)}}function Rs(e){for(const t of Object.values(e))window.localStorage.removeItem(t)}function Bs(e){const t=e.split($s);if(t.length<3)throw new Error(`Invalid key format: ${e}`);return t.slice(1,t.length-1).join($s)}class Fs{constructor(e){if(!K().getBool("IS_BROWSER")||"undefined"==typeof window||"undefined"==typeof window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=Ds(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),r=fs(e);try{this.LS.setItem(this.keys.info,JSON.stringify(r)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(ls)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,r=t.length;e<r;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(e.weightData));const s={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,signature:null!=e.signature?e.signature:void 0,userDefinedMetadata:null!=e.userDefinedMetadata?e.userDefinedMetadata:void 0,modelInitializer:null!=e.modelInitializer?e.modelInitializer:void 0,trainingConfig:null!=e.trainingConfig?e.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(s)),{modelArtifactsInfo:r}}catch(e){throw Rs(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${r.modelTopologyBytes}, weightSpecsBytes=${r.weightSpecsBytes}, weightDataBytes=${r.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const r=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==r)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=r;const s=this.LS.getItem(this.keys.modelMetadata);if(null!=s){const e=JSON.parse(s);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(t.trainingConfig=e.trainingConfig)}const o=this.LS.getItem(this.keys.weightData);if(null==o)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(ls){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(o),t}}Fs.URL_SCHEME="localstorage://";const Cs=e=>{return K().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Fs.URL_SCHEME)?(t=e.slice(Fs.URL_SCHEME.length),new Fs(t)):null;var t};ms.registerSaveRouter(Cs),ms.registerLoadRouter(Cs);class Ps{constructor(){u(K().getBool("IS_BROWSER"),(()=>"Current environment is not a web browser")),u("undefined"==typeof window||"undefined"!=typeof window.localStorage,(()=>"Current browser does not appear to support localStorage")),this.LS=window.localStorage}async listModels(){const e={},t=As+$s,n=$s+Is;for(let r=0;r<this.LS.length;++r){const s=this.LS.key(r);if(s.startsWith(t)&&s.endsWith(n)){e[Bs(s)]=JSON.parse(this.LS.getItem(s))}}return e}async removeModel(e){var t;const n=Ds(e=(t=e).startsWith(Fs.URL_SCHEME)?t.slice(Fs.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const r=JSON.parse(this.LS.getItem(n.info));return Rs(n),r}}const Os="://";class Ls{constructor(){this.managers={}}static getInstance(){return null==Ls.instance&&(Ls.instance=new Ls),Ls.instance}static registerManager(e,t){u(null!=e,(()=>"scheme must not be undefined or null.")),e.endsWith(Os)&&(e=e.slice(0,e.indexOf(Os))),u(e.length>0,(()=>"scheme must not be an empty string."));const n=Ls.getInstance();u(null==n.managers[e],(()=>`A model store manager is already registered for scheme '${e}'.`)),n.managers[e]=t}static getManager(e){const t=this.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(this.getInstance().managers)}}function zs(e){if(-1===e.indexOf(Os))throw new Error(`The url string provided does not contain a scheme. Supported schemes are: ${Ls.getSchemes().join(",")}`);return{scheme:e.split(Os)[0],path:e.split(Os)[1]}}async function qs(e,t,n=!1){u(e!==t,(()=>`Old path and new path are the same: '${e}'`));const r=ms.getLoadHandlers(e);u(r.length>0,(()=>`Copying failed because no load handler is found for source URL ${e}.`)),u(r.length<2,(()=>`Copying failed because more than one (${r.length}) load handlers for source URL ${e}.`));const s=r[0],o=ms.getSaveHandlers(t);u(o.length>0,(()=>`Copying failed because no save handler is found for destination URL ${t}.`)),u(o.length<2,(()=>`Copying failed because more than one (${r.length}) save handlers for destination URL ${t}.`));const a=o[0],i=zs(e).scheme,l=zs(e).path,c=i===zs(e).scheme,h=await s.load();n&&c&&await Ls.getManager(i).removeModel(l);const d=await a.save(h);return n&&!c&&await Ls.getManager(i).removeModel(l),d.modelArtifactsInfo}class Ks{fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Browser's encoder only supports utf-8, but got ${t}`);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}}if(K().get("IS_BROWSER")){K().setPlatform("browser",new Ks);try{Ls.registerManager(Fs.URL_SCHEME,new Ps)}catch(e){}try{Ls.registerManager(xs.URL_SCHEME,new Ss)}catch(e){}}const Ws=()=>require("node-fetch");let Gs;class Us{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=K().global.fetch?K().global.fetch(e,t):(null==Gs&&(Gs=Ws()),Gs(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Node built-in encoder only supports utf-8, but got ${t}`);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}}function Vs(e,t="float32",n){return t=t||"float32",P(e),new xr(e,t,n)}K().get("IS_NODE")&&K().setPlatform("node",new Us);const Hs=ts({cast_:function(e,t){const n=Xr(e,"x","cast");if(!x(t))throw new Error(`Failed to cast to unknown dtype ${t}`);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const r={x:n},s={dtype:t};return Wr.runKernel(ue,r,s)}});const js=ts({clone_:function(e){const t={x:Xr(e,"x","clone","string_or_numeric")};return Wr.runKernel(Ge,t)}});function Js(e,t=!1){console.log(e.toString(t))}Kr();Sr={buffer:Vs,cast:Hs,clone:js,print:Js};function Zs(e){return new Promise((e=>setTimeout(e))).then(e)}class Ys{constructor(e){if(!K().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(Ys.URL_SCHEME)&&(e=e.slice(Ys.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelJsonFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=window.URL.createObjectURL(new Blob([e.weightData],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=ds(e,[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}]),r=window.URL.createObjectURL(new Blob([JSON.stringify(n)],{type:"application/json"})),s=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(s.download=this.modelJsonFileName,s.href=r,await Zs((()=>s.dispatchEvent(new MouseEvent("click")))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=t,await Zs((()=>e.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:fs(e)}}}}Ys.URL_SCHEME="downloads://";class Xs{constructor(e){if(null==e||e.length<1)throw new Error(`When calling browserFiles, at least 1 file is required, but received ${e}`);this.jsonFile=e[0],this.weightsFiles=e.slice(1)}async load(){return new Promise(((e,t)=>{const n=new FileReader;n.onload=n=>{const r=JSON.parse(n.target.result),s=r.modelTopology;if(null==s)return void t(new Error(`modelTopology field is missing from file ${this.jsonFile.name}`));if(null==r.weightsManifest)return void t(new Error(`weightManifest field is missing from file ${this.jsonFile.name}`));if(0===this.weightsFiles.length)return void e({modelTopology:s});const o=ps(r,(e=>this.loadWeights(e)));e(o)},n.onerror=e=>t(`Failed to read model topology and weights manifest JSON from file '${this.jsonFile.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),n.readAsText(this.jsonFile)}))}loadWeights(e){const t=[],n=[];for(const r of e)t.push(...r.weights),n.push(...r.paths);const r=this.checkManifestAndWeightFiles(e),s=n.map((e=>this.loadWeightsFile(e,r[e])));return Promise.all(s).then((e=>[t,cs(e)]))}loadWeightsFile(e,t){return new Promise(((n,r)=>{const s=new FileReader;s.onload=e=>{const t=e.target.result;n(t)},s.onerror=t=>r(`Failed to weights data from file of path '${e}'.`),s.readAsArrayBuffer(t)}))}checkManifestAndWeightFiles(e){const t=[],n=this.weightsFiles.map((e=>hs(e.name))),r={};for(const s of e)s.paths.forEach((e=>{const s=hs(e);if(-1!==t.indexOf(s))throw new Error(`Duplicate file basename found in weights manifest: '${s}'`);if(t.push(s),-1===n.indexOf(s))throw new Error(`Weight file with basename '${s}' is not provided.`);r[e]=this.weightsFiles[n.indexOf(s)]}));if(t.length!==this.weightsFiles.length)throw new Error(`Mismatch in the number of files in weights manifest (${t.length}) and the number of weight files provided (${this.weightsFiles.length}).`);return r}}function Qs(e,t,n,r){!function(e){u(null!=e&&Array.isArray(e)&&e.length>0,(()=>"promises must be a none empty array"))}(e),function(e,t){u(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${e}`)),u(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${t}`)),u(t>=e,(()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction ${t}`))}(n=null==n?0:n,r=null==r?1:r);let s=0;return Promise.all(e.map((o=>(o.then((o=>{const a=n+ ++s/e.length*(r-n);return t(a),o})),o))))}async function eo(e,t){null==t&&(t={});const n=null==t.fetchFunc?K().platform.fetch:t.fetchFunc,r=e.map((e=>n(e,t.requestInit,{isBinary:!0}))),s=(null==t.onProgress?await Promise.all(r):await Qs(r,t.onProgress,0,.5)).map((e=>e.arrayBuffer()));return null==t.onProgress?await Promise.all(s):await Qs(s,t.onProgress,.5,1)}function to(e){return async(t,n="",r)=>{const s=t.map((()=>!1)),o={},a=null!=r?r.map((()=>!1)):[],i=[];if(t.forEach(((e,t)=>{let n=0;e.weights.forEach((e=>{const l="quantization"in e?e.quantization.dtype:e.dtype,u=os[l]*p(e.shape),c=()=>{s[t]=!0,null==o[t]&&(o[t]=[]),o[t].push({manifestEntry:e,groupOffset:n,sizeBytes:u})};null!=r?r.forEach(((t,n)=>{t===e.name&&(c(),a[n]=!0)})):c(),i.push(e.name),n+=u}))})),!a.every((e=>e))){const e=r.filter(((e,t)=>!a[t]));throw new Error(`Could not find weights in manifest with names: ${e.join(", ")}. \nManifest JSON has weights with names: ${i.join(", ")}.`)}const l=s.reduce(((e,t,n)=>(t&&e.push(n),e)),[]),u=[];l.forEach((e=>{t[e].paths.forEach((e=>{const t=n+(n.endsWith("/")?"":"/")+e;u.push(t)}))}));const c=await e(u),h={};let d=0;return l.forEach((e=>{const n=t[e].paths.length;let r=0;for(let e=0;e<n;e++)r+=c[d+e].byteLength;const s=new ArrayBuffer(r),a=new Uint8Array(s);let i=0;for(let e=0;e<n;e++){const t=new Uint8Array(c[d+e]);a.set(t,i),i+=t.byteLength}o[e].forEach((e=>{const t=as(s.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)h[e]=t[e]})),d+=n})),h}}ms.registerSaveRouter((e=>K().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Ys.URL_SCHEME)?function(e="model"){return new Ys(e)}(e.slice(Ys.URL_SCHEME.length)):null));class no{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.onProgress=t.onProgress,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(u("function"==typeof t.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=t.fetchFunc):this.fetch=K().platform.fetch,u(null!=e&&e.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(e)&&u(2===e.length,(()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`)),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{}}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=ds(e,[{paths:["./model.weights.bin"],weights:e.weightSpecs}]);t.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=e.weightData&&t.body.append("model.weights.bin",new Blob([e.weightData],{type:"application/octet-stream"}),"model.weights.bin");const r=await this.fetch(this.path,t);if(r.ok)return{modelArtifactsInfo:fs(e),responses:[r]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${r.status}.`)}async load(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code ${e.status}. Please verify this URL points to the model JSON of the model to load.`);let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,r=t.weightsManifest;if(null==n&&null==r)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return ps(t,(e=>this.loadWeights(e)))}async loadWeights(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,r]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),r=e.substring(0,t),s=n>t?e.substring(n):"";return[r+"/",s]}(t),s=this.weightPathPrefix||n,o=[];for(const t of e)o.push(...t.weights);const a=[],i=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?i.push(this.weightUrlConverter(e)):a.push(s+e+r);this.weightUrlConverter&&a.push(...await Promise.all(i));return[o,cs(await eo(a,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function ro(e){return null!=e.match(no.URL_SCHEME_REGEX)}no.URL_SCHEME_REGEX=/^https?:\/\//;const so=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every((e=>ro(e))):ro(e),n)return oo(e,t)}return null};function oo(e,t){return new no(e,t)}ms.registerSaveRouter(so),ms.registerLoadRouter(so);class ao{constructor(e){this.modelArtifacts=e}async load(){return this.modelArtifacts}}class io{constructor(e){this.saveHandler=e}async save(e){return this.saveHandler(e)}}var lo={__proto__:null,browserFiles:function(e){return new Xs(e)},browserHTTPRequest:function(e,t){return oo(e,t)},concatenateArrayBuffers:cs,decodeWeights:as,encodeWeights:async function(e,t){const n=[],r=[],s=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);for(let o=0;o<s.length;++o){const a=s[o],i=Array.isArray(e)?e[o].tensor:e[a];if("float32"!==i.dtype&&"int32"!==i.dtype&&"bool"!==i.dtype&&"string"!==i.dtype&&"complex64"!==i.dtype)throw new Error(`Unsupported dtype in weight '${a}': ${i.dtype}`);const l={name:a,shape:i.shape,dtype:i.dtype};if("string"===i.dtype){const e=new Promise((async e=>{const t=await i.bytes(),n=t.reduce(((e,t)=>e+t.length),0)+4*t.length,r=new Uint8Array(n);let s=0;for(let e=0;e<t.length;e++){const n=t[e],o=new Uint8Array(new Uint32Array([n.length]).buffer);r.set(o,s),s+=4,r.set(n,s),s+=n.length}e(r)}));r.push(e)}else r.push(i.data());null!=t&&(l.group=t),n.push(l)}return{data:is(await Promise.all(r)),specs:n}},fromMemory:function(e,t,n,r){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new ao(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new ao({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new ao({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:r})},getLoadHandlers:(e,t)=>ms.getLoadHandlers(e,t),getModelArtifactsForJSON:ps,getModelArtifactsInfoForJSON:fs,getSaveHandlers:e=>ms.getSaveHandlers(e),http:oo,isHTTPScheme:ro,loadWeights:async function(e,t="",n,r){return to((e=>eo(e,{requestInit:r})))(e,t,n)},registerLoadRouter:e=>ms.registerLoadRouter(e),registerSaveRouter:e=>ms.registerSaveRouter(e),weightsLoaderFactory:to,withSaveHandler:function(e){return new io(e)},copyModel:async function(e,t){return qs(e,t,!1)},listModels:async function(){const e=Ls.getSchemes(),t={};for(const n of e){const e=await Ls.getManager(n).listModels();for(const r in e){t[n+Os+r]=e[r]}}return t},moveModel:async function(e,t){return qs(e,t,!0)},removeModel:async function(e){const t=zs(e);return Ls.getManager(t.scheme).removeModel(t.path)}};const uo=ts({matMul_:function(e,t,n=!1,r=!1){let s=Xr(e,"a","matMul"),o=Xr(t,"b","matMul");[s,o]=Br(s,o);const a={a:s,b:o},i={transposeA:n,transposeB:r};return Wr.runKernel(oe,a,i)}});const co=ts({oneHot_:function(e,t,n=1,r=0){if(t<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);const s={indices:Xr(e,"indices","oneHot","int32")},o={depth:t,onValue:n,offValue:r};return Wr.runKernel(yt,s,o)}});const ho=ts({transpose_:function(e,t){const n=Xr(e,"x","transpose");if(null==t&&(t=n.shape.map(((e,t)=>t)).reverse()),u(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of perm ${t}.`)),t.forEach((e=>{u(e>=0&&e<n.rank,(()=>"All entries in 'perm' must be between 0 and "+(n.rank-1)+` but got ${t}`))})),n.rank<=1)return n.clone();const r={x:n},s={perm:t};return Wr.runKernel(an,r,s)}});var po={__proto__:null,confusionMatrix:ts({confusionMatrix_:function(e,t,n){const r=Xr(e,"labels","confusionMatrix"),s=Xr(t,"predictions","confusionMatrix");u(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),u(1===r.rank,(()=>`Expected the rank of labels to be 1, but got ${r.rank}`)),u(1===s.rank,(()=>`Expected the rank of predictions to be 1, but got ${s.rank}`)),u(r.shape[0]===s.shape[0],(()=>`Mismatch in the number of examples: ${r.shape[0]} vs. ${s.shape[0]}. Labels and predictions should have the same number of elements.`)),u(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const o=co(Hs(r,"int32"),n),a=co(Hs(s,"int32"),n),i=ho(o),l=uo(i,a);return Hs(l,"int32")}})};function fo(e,t){const n=e.length,r=[];for(let s=0;s<n;s++){const o=n-1-s,a=e[o]||1;(t[t.length-1-s]||1)>1&&1===a&&r.unshift(o)}return r}function go(e,t){const n=[];for(let r=0;r<t.length;r++){const s=e[e.length-r-1],o=t.length-r-1,a=t[o];(null==s||1===s&&a>1)&&n.unshift(o)}return n}function mo(e,t){const n=[],r=Math.max(e.length,t.length);for(let s=0;s<r;s++){let r=e[e.length-s-1];null==r&&(r=1);let o=t[t.length-s-1];if(null==o&&(o=1),1===r)n.unshift(o);else if(1===o)n.unshift(r);else{if(r!==o){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(r)}}return n}var bo={__proto__:null,getBroadcastDims:fo,getReductionAxes:go,assertAndGetBroadcastShape:mo};function yo(e,t,n){if(h(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const r=Jr(e,n);if(3!==r.length&&1!==r.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return rs(e,t,r,n)}let wo;function ko(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,r=!1,s=!1,o=!1,a=!1,i=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)r=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)s=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)o=!0;else if(null!=e.getContext)a=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${e.constructor.name}`);i=!0}if(s){const t=2;if(s&&e.readyState<t)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=vn(pn,Wr.backendName)){const n={pixels:e},r={numChannels:t};return Wr.runKernel(pn,n,r)}const[l,u]=s?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(a)c=e.getContext("2d").getImageData(0,0,l,u).data;else if(r||n)c=e.data;else if(o||s||i){if(null==wo)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");wo=new OffscreenCanvas(1,1).getContext("2d")}else wo=document.createElement("canvas").getContext("2d");wo.canvas.width=l,wo.canvas.height=u,wo.drawImage(e,0,0,l,u),c=wo.getImageData(0,0,l,u).data}if(4===t)h=new Int32Array(c);else{const e=l*u;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return yo(h,[u,l,t],"int32")}function vo(e){return"undefined"!=typeof window&&"undefined"!=typeof ImageBitmap&&window.hasOwnProperty("createImageBitmap")&&!(e instanceof ImageBitmap)&&function(e){return null!=e&&0!==e.width&&0!==e.height}(e)&&!function(e){return null!=e&&e.data instanceof Uint8Array}(e)}var xo={__proto__:null,fromPixelsAsync:async function(e,t=3){let n=null;if(K().getBool("WRAP_TO_IMAGEBITMAP")&&vo(e)){let t;try{t=await createImageBitmap(e,{premultiplyAlpha:"none"})}catch(e){t=null}n=null!=t&&t.width===e.width&&t.height===e.height?t:e}else n=e;return ko(n,t)},toPixels:async function(e,t){let n=Xr(e,"img","toPixels");if(!(e instanceof $r)){const e=n;n=Hs(e,"int32"),e.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[r,s]=n.shape.slice(0,2),o=2===n.rank?1:n.shape[2];if(o>4||2===o)throw new Error(`toPixels only supports depth of size 1, 3 or 4 but got ${o}`);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const a=await n.data(),i="float32"===n.dtype?255:1,l=new Uint8ClampedArray(s*r*4);for(let e=0;e<r*s;++e){const t=[0,0,0,255];for(let r=0;r<o;r++){const s=a[e*o+r];if("float32"===n.dtype){if(s<0||s>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${s}.`)}else if("int32"===n.dtype&&(s<0||s>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${s}.`);1===o?(t[0]=s*i,t[1]=s*i,t[2]=s*i):t[r]=s*i}const r=4*e;l[r+0]=Math.round(t[0]),l[r+1]=Math.round(t[1]),l[r+2]=Math.round(t[2]),l[r+3]=Math.round(t[3])}if(null!=t){t.width=s,t.height=r;const e=t.getContext("2d"),n=new ImageData(l,s,r);e.putImageData(n,0,0)}return n!==e&&n.dispose(),l},fromPixels:ts({fromPixels_:ko})};function Eo(e,t){const n=e.shape.length,r=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(r<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${r}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[r-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[r-1]} vs. ${n}`);if(0===p(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const s=t.shape,o=s[s.length-1];let a=1;for(let e=0;e<s.length-1;++e)a*=s[e];const i=e.shape,l=s.slice();l.pop();let u=1;for(let e=o;e<n;++e)u*=i[e],l.push(i[e]);const c=[...D(e.shape).map((e=>e/u)),1].slice(0,o);return[l,a,u,c]}var So={__proto__:null,prepareAndValidate:Eo};function $o(e,t,n){const r=t.rank>1?t.shape[t.rank-1]:1,s=t.rank>1?t.rank-1:1,o=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${r}, and batchDim: ${s}.`;if(n.rank<s)throw new Error(o+` update.rank < ${s}. `);if(e.length<r+(n.rank-s))throw new Error(o+` Output shape length < ${r+(n.rank-s)}`);if(n.rank!==s+e.length-r)throw new Error(o+" update.rank != "+(s+e.length-r));for(let e=0;e<s;++e)if(n.shape[e]!==t.shape[e])throw new Error(o+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-s;++t)if(n.shape[t+s]!==e[t+r])throw new Error(o+` updates.shape[${t+s}] (${n.shape[t+s]}) != shape[${t+s}] (${e[t+s]})`)}function Ao(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===t.size)throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);if(0===e.size)throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`)}$o(n,t,e)}function Io(e,t,n){const r=t.shape.length,s=r>1?t.shape[r-1]:1,o=n.length;let a=1;for(let e=s;e<o;++e)a*=n[e];const i=s<1?1:s;return{sliceRank:s,numUpdates:p(t.shape)/i,sliceSize:a,strides:[...D(n.slice(0,s)),1],outputSize:p(n)}}var _o={__proto__:null,validateUpdateShape:$o,validateInput:Ao,calculateShapes:Io};function No(e,t,n,r){const s=[...e];for(let e=s.length;e<r.length;e++)s.push(1);for(let e=0;e<n;e++)0===e?s[t]=1:(s.splice(t,0,1),s.pop());return s}function Mo(e,t,n){return n<=e?n:n-(t-1)}function To(e,t){const n=[];for(let r=0;r<e;r++)n.push(t+r);return n}function Do(e,t,n,r,s){const o=[...s],a=To(n,t);for(let s=0;s<o.length;s++)if(a.indexOf(s)>-1)o[s]=0;else{const a=Mo(t,n,s);let i=r[a];e&1<<a&&(i=0),o[s]=i}return o}function Ro(e,t,n,r,s){const o=[...s],a=To(n,t);for(let s=0;s<o.length;s++)if(a.indexOf(s)>-1)o[s]=Number.MAX_SAFE_INTEGER;else{const a=Mo(t,n,s);let i=r[a];e&1<<a&&(i=Number.MAX_SAFE_INTEGER),o[s]=i}for(let e=0;e<o.length;e++){const t=s[e];o[e]<0&&(o[e]+=t),o[e]=i(0,o[e],s[e])}return o}function Bo(e,t,n){let r=e[t];return(n&1<<t||null==r)&&(r=1),r}function Fo(e,t,n,r,s,o){let a=t[s];const l=n[s]||1;(e&1<<s||o&1<<s||null==a)&&(a=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=r[s];return a<0&&(a+=u),a=i(0,a,u-1),a}function Co(e,t,n,r,s,o){let a=t[s];const l=n[s]||1;(e&1<<s||o&1<<s||null==a)&&(a=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=r[s];return a<0&&(a+=u),a=l>0?i(0,a,u):i(-1,a,u-1),a}function Po(e,t,n,r,s,o){if(s[t])return n>0?o[t]:o[t+1&1];{const t=e<0?r+e:e;return t<o[0]?o[0]:t>o[1]?o[1]:t}}var Oo={__proto__:null,assertParamsValid:function(e,t,n){const r=e.shape.length;u(r===t.length,(()=>`Error in slice${r}D: Length of begin ${t} must match the rank of the array (${r}).`)),u(r===n.length,(()=>`Error in slice${r}D: Length of size ${n} must match the rank of the array (${r}).`));for(let s=0;s<r;++s)u(t[s]+n[s]<=e.shape[s],(()=>`Error in slice${r}D: begin[${s}] + size[${s}] (${t[s]+n[s]}) would overflow input.shape[${s}] (${e.shape[s]})`))},maskToAxes:function(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t},computeOutShape:function(e,t,n){const r=[];for(let s=0;s<e.length;s++)r[s]=Math.ceil((t[s]-e[s])/n[s]);return r},stridesWithElidedDims:No,getNormalizedAxes:function(e,t,n,r,s,o,a,i,l){const u=e.length;let c=new Array(u),h=new Array(u),d=new Array(u);if(t.length&&n>0){const l=t[0],u=n+1;c=Do(a,l,u,r,e),h=Ro(i,l,u,s,e),d=No(o,l,u,e)}else for(let t=0;t<u;t++)c[t]=Fo(a,r,o,e,t,l),h[t]=Co(i,s,o,e,t,l),d[t]=Bo(o,t,l);return{begin:c,end:h,strides:d}},startIndicesWithElidedDims:Do,stopIndicesWithElidedDims:Ro,stridesForAxis:Bo,startForAxis:Fo,stopForAxis:Co,isSliceContinous:function(e,t,n){let r=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){r=e;break}for(let s=r+1;s<n.length;s++)if(t[s]>0||n[s]!==e[s])return!1;return!0},computeFlatOffset:function(e,t){let n=e.length>0?e[e.length-1]:1;for(let r=0;r<e.length-1;r++)n+=e[r]*t[r];return n},parseSliceParams:function(e,t,n){let r;const s=e.shape.length;let o;return r="number"==typeof t?[t,...new Array(s-1).fill(0)]:t.length<s?t.concat(new Array(s-t.length).fill(0)):t.slice(),r.forEach((e=>{u(-1!==e,(()=>"slice() does not support negative begin indexing."))})),o=null==n?new Array(s).fill(-1):"number"==typeof n?[n,...new Array(s-1).fill(-1)]:n.length<s?n.concat(new Array(s-n.length).fill(-1)):n,o=o.map(((t,n)=>t>=0?t:(u(-1===t,(()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`)),e.shape[n]-r[n]))),[r,o]},sliceInfo:function(e,t,n,r,s,o,a,i,l){let u;if(null==r?(u=new Array(t.length),u.fill(1)):u=r,null!=a&&0!=(a&a-1))throw new Error("Multiple ellipses in slice is not allowed.");let c=!1;const h={dims:u.length,numAddAxisAfterEllipsis:0,begin:t.slice(),end:n.slice(),strides:u.slice(),beginMask:s,endMask:o,ellipsisMask:a,newAxisMask:i,shrinkAxisMask:l};for(let e=0;e<h.dims;e++)c&&0!=(1<<e&i)&&h.numAddAxisAfterEllipsis++,1<<e&a&&(c=!0);c||(h.ellipsisMask|=1<<h.dims,h.dims++);const d={dims:e.length,beginMask:0,endMask:0,beginValid:!1,endValid:!1};!function(e,t){t.beginMask=0,t.endMask=0,t.shrinkAxisMask=0;let n=0;t.beginValid=null!=e.begin,t.endValid=null!=e.end,t.begin=new Array(t.dims),t.end=new Array(t.dims),t.strides=new Array(t.dims),t.finalShapeGatherIndices=[],t.finalShapeGatherIndicesSparse=[],t.inputShapeGatherIndicesSparse=new Array(t.dims);for(let r=0;r<e.dims;r++)if(1<<r&e.ellipsisMask){const s=Math.min(t.dims-(e.dims-r)+1+e.numAddAxisAfterEllipsis,t.dims);for(;n<s;n++)t.begin[n]=0,t.end[n]=0,t.strides[n]=1,t.beginMask|=1<<n,t.endMask|=1<<n,t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(-1),t.inputShapeGatherIndicesSparse[n]=r}else if(1<<r&e.newAxisMask)t.finalShapeGatherIndices.push(-2),t.finalShapeGatherIndicesSparse.push(-1);else{if(n===t.begin.length)throw Error(`Index out of range using input dim ${n}; input has only ${t.dims} dims, ${t.begin.length}.`);null!=e.begin&&(t.begin[n]=e.begin[r]),null!=e.end&&(t.end[n]=e.end[r]),t.strides[n]=e.strides[r],e.beginMask&1<<r&&(t.beginMask|=1<<n),e.endMask&1<<r&&(t.endMask|=1<<n),e.shrinkAxisMask&1<<r?(t.finalShapeGatherIndices.push(-1),t.finalShapeGatherIndicesSparse.push(-1),t.shrinkAxisMask|=1<<n):(t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(r)),t.inputShapeGatherIndicesSparse[n]=r,n++}}(h,d);let p=!0,f=!0,g=!0;const m=[],b=[];for(let t=0;t<e.length;++t){if(0===d.strides[t])throw Error(`strides[${t}] must be non-zero`);const n=!!(d.shrinkAxisMask&1<<t),r=e[t];if(-1===r){m.push(n?1:-1);continue}const s=[d.beginMask&1<<t,d.endMask&1<<t],o=[d.strides[t]>0?0:-1,d.strides[t]>0?r:r-1];if(n&&d.strides[t]<=0)throw Error("only stride 1 allowed on non-range indexing.");g=g&&1===d.strides[t];const a=!!(d.beginMask&1<<t&&d.endMask&1<<t);if(d.beginValid&&d.endValid){if(n){const e=d.begin[t]<0?r+d.begin[t]:d.begin[t];if(d.begin[t]=e,d.end[t]=d.begin[t]+1,e<0||e>=r)throw Error(`slice index ${d.begin[t]} of dimension ${t} out of bounds.`)}else d.begin[t]=Po(d.begin[t],0,d.strides[t],r,s,o),d.end[t]=Po(d.end[t],1,d.strides[t],r,s,o);const e=1===d.strides[t]&&0===d.begin[t]&&d.end[t]===r;p=p&&e,f=f&&(0===t&&1===d.strides[t]||e)}else p=p&&1===d.strides[t]&&a,f=f&&(0===t&&1===d.strides[t]||a);let i,l=!1;if(d.beginValid&&d.endValid?(i=d.end[t]-d.begin[t],l=!0):n?(i=1,l=!0):a&&r>=0&&(i=d.strides[t]<0?-r:r,l=!0),l){let e;e=0===i||i<0!=d.strides[t]<0?0:Math.trunc(i/d.strides[t])+(i%d.strides[t]!=0?1:0),m.push(e)}else m.push(-1)}for(let e=0;e<d.finalShapeGatherIndices.length;++e){const t=d.finalShapeGatherIndices[e];t>=0?b.push(m[t]):-2===t&&b.push(1)}return{finalShapeSparse:b.filter(((e,t)=>-2!==d.finalShapeGatherIndices[t])),finalShape:b,isIdentity:p,sliceDim0:f,isSimpleSlice:g,begin:d.begin,end:d.end,strides:d.strides}}};class Lo{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class zo{constructor(){this.classNameMap={}}static getMap(){return null==zo.instance&&(zo.instance=new zo),zo.instance}static register(e){zo.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function qo(e){u(null!=e.className,(()=>"Class being registered does not have the static className property defined.")),u("string"==typeof e.className,(()=>"className is required to be a string, but got type "+typeof e.className)),u(e.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),zo.register(e)}var Ko={__proto__:null,Serializable:Lo,SerializationMap:zo,registerClass:qo};function Wo(){return 32===Wr.backend.floatPrecision()?.001:.1}function Go(e,t,n){let r=!0;if((E(e)||E(t))&&(r=!1),E(e)&&E(t)&&(r=!0),r){const n=e.constructor.name,r=t.constructor.name;if(n!==r)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: ${r}`)}if(Array.isArray(e)&&Array.isArray(t)){const n=Jr(e),r=Jr(t);if(!f(n,r))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${r}]`)}const s=E(e)?e:d(e),o=E(t)?t:d(t);if(s.length!==o.length)throw new Error(`Arrays have different lengths actual: ${s.length} vs expected: ${o.length}.\nActual:   ${s}.\nExpected: ${o}.`);for(let e=0;e<o.length;++e){const t=s[e],r=o[e];if(!n(t,r))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${r}.\nActual:   ${s}.\nExpected: ${o}.`)}}function Uo(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var Vo={__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(e,t,n){return null==n&&(n=Wo()),Go(e,t,((e,t)=>Uo(e,t,n)))},testEpsilon:Wo,expectPromiseToFail:function(e,t){e().then((()=>t.fail()),(()=>t()))},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return A(e)||A(e[0])||A(t)||A(t[0])?Go(e,n,((e,t)=>e==t)):Go(e,t,((e,t)=>Uo(e,t,0)))},expectNumbersClose:function(e,t,n){if(null==n&&(n=Wo()),!Uo(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`)},expectValuesInRange:function(e,t,n){for(let r=0;r<e.length;r++)if(e[r]<t||e[r]>n)throw new Error(`Value out of range:${e[r]} low: ${t}, high: ${n}`)},expectArrayBuffersEqual:function(e,t){const n=new Float32Array(e),r=new Float32Array(t);if(n.length!==r.length)throw new Error(`Expected ArrayBuffer to be of length ${r.length}, but it was ${n.length}`);for(let e=0;e<r.length;e++)if(n[e]!==r[e])throw new Error(`Expected ArrayBuffer value at ${e} to be ${r[e]} but got ${n[e]} instead`)},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const r=t[n];Array.isArray(r)?e(r):t[n]=hr(r)}return t}};function Ho(e,t){return Wr.tidy(e,t)}function jo(e){Cr(e).forEach((e=>e.dispose()))}function Jo(e){return Wr.keep(e)}const Zo=ts({add_:function(e,t){let n=Xr(e,"a","add"),r=Xr(t,"b","add");[n,r]=Br(n,r);const s={a:n,b:r};return Wr.runKernel(j,s)}});const Yo=ts({floorDiv_:function(e,t){let n=Xr(e,"a","floorDiv"),r=Xr(t,"b","floorDiv");[n,r]=Br(n,r);const s={a:n,b:r};return Wr.runKernel(Oe,s)}});const Xo=ts({div_:function(e,t){let n=Xr(e,"a","div"),r=Xr(t,"b","div");if([n,r]=Br(n,r),"int32"===n.dtype&&"int32"===r.dtype)return Yo(n,r);const s={a:n,b:r};return Wr.runKernel(Me,s,{})}});const Qo=ts({mul_:function(e,t){let n=Xr(e,"a","mul"),r=Xr(t,"b","mul");[n,r]=Br(n,r);const s={a:n,b:r};return Wr.runKernel(dt,s)}});const ea=ts({abs_:function(e){const t=Xr(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return Wr.runKernel(pe,e)}{const e={x:t};return Wr.runKernel("Abs",e)}}});const ta=ts({acos_:function(e){const t={x:Xr(e,"x","acos")};return Wr.runKernel(V,t)}});const na=ts({acosh_:function(e){const t={x:Xr(e,"x","acosh")};return Wr.runKernel(H,t)}});const ra=ts({addN_:function(e){u(Array.isArray(e),(()=>"The argument passed to tf.addN() must be a list of tensors")),u(e.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${e.length}`));const t=e.map(((e,t)=>Xr(e,`tensors${t}`,"addN"))),n=t[0];t.forEach((e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),t.forEach((e=>{if(!f(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const r=t;return Wr.runKernel(J,r)}});const sa=ts({all_:function(e,t=null,n=!1){const r={x:Xr(e,"x","all","bool")},s={axis:t,keepDims:n};return Wr.runKernel("All",r,s)}});const oa=ts({any_:function(e,t=null,n=!1){const r={x:Xr(e,"x","any","bool")},s={axis:t,keepDims:n};return Wr.runKernel("Any",r,s)}});const aa=ts({argMax_:function(e,t=0){const n={x:Xr(e,"x","argMax")},r={axis:t};return Wr.runKernel(Z,n,r)}});const ia=ts({argMin_:function(e,t=0){const n={x:Xr(e,"x","argMin")},r={axis:t};return Wr.runKernel(Y,n,r)}});const la=ts({asin_:function(e){const t={x:Xr(e,"x","asin")};return Wr.runKernel(X,t)}});const ua=ts({asinh_:function(e){const t={x:Xr(e,"x","asinh")};return Wr.runKernel(Q,t)}});const ca=ts({atan_:function(e){const t={x:Xr(e,"x","atan")};return Wr.runKernel(ee,t)}});const ha=ts({atan2_:function(e,t){let n=Xr(e,"a","atan2"),r=Xr(t,"b","atan2");[n,r]=Br(n,r);const s={a:n,b:r};return Wr.runKernel(ne,s)}});const da=ts({atanh_:function(e){const t={x:Xr(e,"x","atanh")};return Wr.runKernel(te,t)}});function pa(e,t,n,r,s,o,a="channelsLast"){const[i,l]=ba(t);let u;if("channelsLast"===a)u=[i,l,e[3],e[3]];else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);u=[i,l,e[1],e[1]]}return fa(e,u,n,r,s,o,!1,a)}function fa(e,t,n,r,s,o,a=!1,i="channelsLast"){let[l,u,c,h]=[-1,-1,-1,-1];if("channelsLast"===i)[l,u,c,h]=e;else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);[l,h,u,c]=e}const[d,p,,f]=t,[g,m]=ba(n),[b,y]=ba(r),w=wa(d,b),k=wa(p,y),{padInfo:v,outHeight:x,outWidth:E}=function(e,t,n,r,s,o,a,i,l){let u,c,h;if("number"==typeof e){u={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const s=function(e,t,n,r,s){null==r&&(r=ma(e,t,n));const o=e[0],a=e[1],i=ka((o-t+2*r)/n+1,s),l=ka((a-t+2*r)/n+1,s);return[i,l]}([t,n],o,r,e,i);c=s[0],h=s[1]}else if("same"===e){c=Math.ceil(t/r),h=Math.ceil(n/s);const e=Math.max(0,(c-1)*r+o-t),i=Math.max(0,(h-1)*s+a-n),l=Math.floor(e/2),d=e-l,p=Math.floor(i/2);u={top:l,bottom:d,left:p,right:i-p,type:"SAME"}}else if("valid"===e)u={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-o+1)/r),h=Math.ceil((n-a+1)/s);else{if("object"!=typeof e)throw Error(`Unknown padding parameter: ${e}`);{const d="channelsLast"===l?e[1][0]:e[2][0],p="channelsLast"===l?e[1][1]:e[2][1],f="channelsLast"===l?e[2][0]:e[3][0],g="channelsLast"===l?e[2][1]:e[3][1];u={top:d,bottom:p,left:f,right:g,type:0===d&&0===p&&0===f&&0===g?"VALID":"EXPLICIT"},c=ka((t-o+d+p)/r+1,i),h=ka((n-a+f+g)/s+1,i)}}return{padInfo:u,outHeight:c,outWidth:h}}(s,u,c,g,m,w,k,o,i),S=a?f*h:f;let $;return"channelsFirst"===i?$=[l,S,x,E]:"channelsLast"===i&&($=[l,x,E,S]),{batchSize:l,dataFormat:i,inHeight:u,inWidth:c,inChannels:h,outHeight:x,outWidth:E,outChannels:S,padInfo:v,strideHeight:g,strideWidth:m,filterHeight:d,filterWidth:p,effectiveFilterHeight:w,effectiveFilterWidth:k,dilationHeight:b,dilationWidth:y,inShape:e,outShape:$,filterShape:t}}function ga(e,t,n,r,s,o=!1,a="channelsLast",i){let[l,u,c,h,d]=[-1,-1,-1,-1,-1];if("channelsLast"===a)[l,u,c,h,d]=e;else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);[l,d,u,c,h]=e}const[p,f,g,,m]=t,[b,y,w]=ya(n),[k,v,x]=ya(r),E=wa(p,k),S=wa(f,v),$=wa(g,x),{padInfo:A,outDepth:I,outHeight:_,outWidth:N}=function(e,t,n,r,s,o,a,i,l,u,c){let h,d,p,f;if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const o=function(e,t,n,r,s,o){null==s&&(s=ma(e,t,r));const a=e[0],i=e[1],l=e[2],u=ka((a-t+2*s)/r+1,o),c=ka((i-t+2*s)/r+1,o),h=ka((l-t+2*s)/r+1,o);return[u,c,h,n]}([t,n,r,1],i,1,s,e,c);d=o[0],p=o[1],f=o[2]}else if("same"===e){d=Math.ceil(t/s),p=Math.ceil(n/o),f=Math.ceil(r/a);const e=(d-1)*s+i-t,c=(p-1)*o+l-n,g=(f-1)*a+u-r,m=Math.floor(e/2),b=e-m,y=Math.floor(c/2),w=c-y,k=Math.floor(g/2);h={top:y,bottom:w,left:k,right:g-k,front:m,back:b,type:"SAME"}}else{if("valid"!==e)throw Error(`Unknown padding parameter: ${e}`);h={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},d=Math.ceil((t-i+1)/s),p=Math.ceil((n-l+1)/o),f=Math.ceil((r-u+1)/a)}return{padInfo:h,outDepth:d,outHeight:p,outWidth:f}}(s,u,c,h,b,y,w,E,S,$,i),M=o?m*d:m;let T;return"channelsFirst"===a?T=[l,M,I,_,N]:"channelsLast"===a&&(T=[l,I,_,N,M]),{batchSize:l,dataFormat:a,inDepth:u,inHeight:c,inWidth:h,inChannels:d,outDepth:I,outHeight:_,outWidth:N,outChannels:M,padInfo:A,strideDepth:b,strideHeight:y,strideWidth:w,filterDepth:p,filterHeight:f,filterWidth:g,effectiveFilterDepth:E,effectiveFilterHeight:S,effectiveFilterWidth:$,dilationDepth:k,dilationHeight:v,dilationWidth:x,inShape:e,outShape:T,filterShape:t}}function ma(e,t,n,r=1){const s=wa(t,r);return Math.floor((e[0]*(n-1)-n+s)/2)}function ba(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function ya(e){return"number"==typeof e?[e,e,e]:e}function wa(e,t){return t<=1?e:e+(e-1)*(t-1)}function ka(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error(`Unknown roundingMode ${t}`)}}function va(e){const[t,n,r]=ba(e);return 1===t&&1===n&&1===r}function xa(e,t){return va(e)||va(t)}function Ea(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error(`Unknown dataFormat ${e}`)}function Sa(e,t,n){if(null!=n){if("string"==typeof t)throw Error(`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);if("number"==typeof t)u(g(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`));else{if("object"!=typeof t)throw Error(`Error in ${e}: Unknown padding parameter: ${t}`);t.forEach((t=>{t.forEach((t=>{u(g(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`))}))}))}}}const $a=ts({reshape_:function(e,t){const n={x:Xr(e,"x","reshape","string_or_numeric")},r={shape:t};return Wr.runKernel(It,n,r)}});const Aa=ts({avgPool_:function(e,t,n,r,s){const o=Xr(e,"x","avgPool","float32");u(xa(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let a=o,i=!1;3===o.rank&&(i=!0,a=$a(o,[1,o.shape[0],o.shape[1],o.shape[2]])),u(4===a.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${a.rank}.`)),Sa("avgPool",r,s);const l={x:a},c={filterSize:t,strides:n,pad:r,dimRoundingMode:s};let h=Wr.runKernel(re,l,c);return h=Hs(h,o.dtype),i?$a(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Ia=ts({avgPool3d_:function(e,t,n,r,s,o="NDHWC"){const a=Xr(e,"x","avgPool3d","float32");let i=a,l=!1;4===a.rank&&(l=!0,i=$a(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),u(5===i.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${i.rank}.`)),u("NDHWC"===o,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${o}`)),Sa("avgPool3d",r,s);const c={x:i},h={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:o};let d=Wr.runKernel(se,c,h);return d=Hs(d,i.dtype),l?$a(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const _a=ts({concat_:function(e,t=0){u(e.length>=1,(()=>"Pass at least one tensor to concat"));const n=Qr(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)})),1===n.length)return js(n[0]);const r=n,s={axis:t};return Wr.runKernel(fe,r,s)}});const Na=ts({sigmoid_:function(e){const t={x:Xr(e,"x","sigmoid","float32")};return Wr.runKernel(zt,t)}});const Ma=ts({slice_:function(e,t,n){const r=Xr(e,"x","slice","string_or_numeric");if(0===r.rank)throw new Error("Slicing scalar is not possible");const s={x:r},o={begin:t,size:n};return Wr.runKernel(Pt,s,o)}});const Ta=ts({tanh_:function(e){const t={x:Xr(e,"x","tanh","float32")};return Wr.runKernel(nn,t)}});const Da=ts({basicLSTMCell_:function(e,t,n,r,s,o){const a=Xr(e,"forgetBias","basicLSTMCell"),i=Xr(t,"lstmKernel","basicLSTMCell"),l=Xr(n,"lstmBias","basicLSTMCell"),u=Xr(r,"data","basicLSTMCell"),c=Xr(s,"c","basicLSTMCell"),h=Xr(o,"h","basicLSTMCell"),d=_a([u,h],1),p=uo(d,i),f=Zo(p,l),g=f.shape[0],m=f.shape[1]/4,b=[g,m],y=Ma(f,[0,0],b),w=Ma(f,[0,m],b),k=Ma(f,[0,2*m],b),v=Ma(f,[0,3*m],b),x=Zo(Qo(Na(y),Ta(w)),Qo(c,Na(Zo(a,k))));return[x,Qo(Ta(x),Na(v))]}});const Ra=ts({batchToSpaceND_:function(e,t,n){const r=Xr(e,"x","batchToSpaceND"),s=t.reduce(((e,t)=>e*t));u(r.rank>=1+t.length,(()=>`input rank is ${r.rank} but should be > than blockShape.length ${t.length}`)),u(n.length===t.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`)),u(r.shape[0]%s==0,(()=>`input tensor batch is ${r.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${s}`));const o={x:r},a={blockShape:t,crops:n};return Wr.runKernel(ae,o,a)}});const Ba=ts({batchNorm_:function(e,t,n,r,s,o){null==o&&(o=.001);const a=Xr(e,"x","batchNorm"),i=Xr(t,"mean","batchNorm"),l=Xr(n,"variance","batchNorm");let c,h;null!=s&&(c=Xr(s,"scale","batchNorm")),null!=r&&(h=Xr(r,"offset","batchNorm")),u(i.rank===l.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),u(null==h||i.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),u(null==c||i.rank===c.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const d={x:function(e){let t;return t=0===e.rank||1===e.rank?$a(e,[1,1,1,e.size]):2===e.rank?$a(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?$a(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(a),scale:c,offset:h,mean:i,variance:l},p={varianceEpsilon:o},f=Wr.runKernel(Le,d,p);return $a(f,a.shape)}});const Fa=ts({batchNorm2d_:function(e,t,n,r,s,o){const a=Xr(e,"x","batchNorm"),i=Xr(t,"mean","batchNorm"),l=Xr(n,"variance","batchNorm");let c,h;return null!=s&&(c=Xr(s,"scale","batchNorm")),null!=r&&(h=Xr(r,"offset","batchNorm")),u(2===a.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${a.rank}.`)),u(2===i.rank||1===i.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${i.rank}.`)),u(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${l.rank}.`)),null!=c&&u(2===c.rank||1===c.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`)),null!=h&&u(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),Ba(a,i,l,h,c,o)}});const Ca=ts({batchNorm3d_:function(e,t,n,r,s,o){const a=Xr(e,"x","batchNorm"),i=Xr(t,"mean","batchNorm"),l=Xr(n,"variance","batchNorm");let c,h;return null!=s&&(c=Xr(s,"scale","batchNorm")),null!=r&&(h=Xr(r,"offset","batchNorm")),u(3===a.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${a.rank}.`)),u(3===i.rank||1===i.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${i.rank}.`)),u(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${l.rank}.`)),null!=c&&u(3===c.rank||1===c.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`)),null!=h&&u(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),Ba(a,i,l,h,c,o)}});const Pa=ts({batchNorm4d_:function(e,t,n,r,s,o){const a=Xr(e,"x","batchNorm"),i=Xr(t,"mean","batchNorm"),l=Xr(n,"variance","batchNorm");let c,h;return null!=s&&(c=Xr(s,"scale","batchNorm")),null!=r&&(h=Xr(r,"offset","batchNorm")),u(4===a.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${a.rank}.`)),u(4===i.rank||1===i.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${i.rank}.`)),u(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${l.rank}.`)),null!=c&&u(4===c.rank||1===c.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`)),null!=h&&u(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),Ba(a,i,l,h,c,o)}});const Oa=ts({bincount_:function(e,t,n){const r=Xr(e,"x","bincount"),s=Xr(t,"weights","bincount");u("int32"===r.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${r.dtype}`)),u(n>=0,(()=>`size must be non-negative, but got ${n}.`)),u(s.size===r.size||0===s.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${r.shape}, weights shape: ${s.shape}.`));const o={x:r,weights:s},a={size:n};return Wr.runKernel(ie,o,a)}});const La=ts({broadcastArgs_:function(e,t){const n=Xr(e,"s0","broadcastArgs","int32"),r=Xr(t,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==r.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${r.rank}`);const s={s0:n,s1:r};return Wr.runKernel(le,s)}});const za=ts({broadcastTo_:function(e,t){let n=Xr(e,"broadcastTo","x");const r=n.shape;if(t.some((e=>!(e>0)||e%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=$a(n,e)}const s=n.shape,o=Array.from(t);for(let e=t.length-1;e>=0;e--)if(s[e]===t[e])o[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${t}].`);if(0===o.map(((e,t)=>e>1?t:-1)).filter((e=>e>=0)).length)return js(n);const a={x:n},i={reps:o};return Wr.runKernel(rn,a,i)}});const qa=ts({ceil_:function(e){const t={x:Xr(e,"x","ceil","float32")};return Wr.runKernel(ce,t)}});const Ka=ts({clipByValue_:function(e,t,n){const r=Xr(e,"x","clipByValue");u(t<=n,(()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`));const s={x:r},o={clipValueMin:t,clipValueMax:n};return Wr.runKernel(he,s,o)}});const Wa=ts({concat1d_:function(e){return _a(e,0)}});const Ga=ts({concat2d_:function(e,t){return _a(e,t)}});const Ua=ts({concat3d_:function(e,t){return _a(e,t)}});const Va=ts({concat4d_:function(e,t){return _a(e,t)}});const Ha=ts({conv2d_:function(e,t,n,r,s="NHWC",o=[1,1],a){const i=Xr(e,"x","conv2d","float32"),l=Xr(t,"filter","conv2d","float32");let c=i,h=!1;3===i.rank&&(h=!0,c=$a(i,[1,i.shape[0],i.shape[1],i.shape[2]])),u(4===c.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`)),u(4===l.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${l.rank}.`)),Sa("conv2d",r,a);const d="NHWC"===s?c.shape[3]:c.shape[1];u(d===l.shape[2],(()=>`Error in conv2d: depth of input (${d}) must match input depth for filter ${l.shape[2]}.`)),u(xa(n,o),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`));const p={x:c,filter:l},f={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:a},g=Wr.runKernel(ge,p,f);return h?$a(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const ja=ts({conv1d_:function(e,t,n,r,s="NWC",o=1,a){const i=Xr(e,"x","conv1d"),l=Xr(t,"filter","conv1d");let c=i,h=!1;2===i.rank&&(h=!0,c=$a(i,[1,i.shape[0],i.shape[1]])),u(3===c.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`)),u(3===l.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${l.rank}.`)),Sa("conv1d",r,a),u(c.shape[2]===l.shape[1],(()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${l.shape[1]}.`)),u(xa(n,o),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${o}'`)),u("NWC"===s,(()=>`Error in conv1d: got dataFormat of ${s} but only NWC is currently supported.`));const d=$a(l,[1,l.shape[0],l.shape[1],l.shape[2]]),p=$a(c,[c.shape[0],1,c.shape[1],c.shape[2]]),f=Ha(p,d,[1,n],r,"NHWC",[1,o],a);return $a(f,h?[f.shape[2],f.shape[3]]:[f.shape[0],f.shape[2],f.shape[3]])}});const Ja=ts({conv2DBackpropInput_:function(e,t,n,r,s,o="NHWC",a){u(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let i=e,l=t,c=!1;3===t.rank&&(c=!0,l=$a(t,[1,t.shape[0],t.shape[1],t.shape[2]]),i=[1,e[0],e[1],e[2]]),u(4===i.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${i.length}.`)),u(4===l.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${l.rank}`)),u(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===o?i[3]:i[1],d="NHWC"===o?l.shape[3]:l.shape[1];u(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),u(d===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${d}) must match output depth for filter ${n.shape[3]}.`)),Sa("conv2dDerInput",s,a);const p={dy:l,filter:n},f={strides:r,pad:s,dataFormat:o,dimRoundingMode:a,inputShape:i},g=Wr.runKernel(be,p,f);return c?$a(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Za=ts({conv2dTranspose_:function(e,t,n,r,s,o){const a=Xr(e,"x","conv2dTranspose"),i=Xr(t,"filter","conv2dTranspose");return Ja(n,a,i,r,s,"NHWC",o)}});const Ya=ts({conv3d_:function(e,t,n,r,s="NDHWC",o=[1,1,1]){const a=Xr(e,"x","conv3d"),i=Xr(t,"filter","conv3d");let l=a,c=!1;4===a.rank&&(c=!0,l=$a(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),u(5===l.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${l.rank}.`)),u(5===i.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${i.rank}.`)),u(l.shape[4]===i.shape[3],(()=>`Error in conv3d: depth of input (${l.shape[4]}) must match input depth for filter ${i.shape[3]}.`)),u(xa(n,o),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),u("NDHWC"===s,(()=>`Error in conv3d: got dataFormat of ${s} but only NDHWC is currently supported.`));const h={x:l,filter:i},d={strides:n,pad:r,dataFormat:s,dilations:o},p=Wr.runKernel(ye,h,d);return c?$a(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Xa=ts({conv3DBackpropInput_:function(e,t,n,r,s){u(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let o=e,a=t,i=!1;4===t.rank&&(i=!0,a=$a(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),o=[1,e[0],e[1],e[2],e[3]]);const l=o[4],c=a.shape[4];u(5===o.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${o.length}.`)),u(5===a.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${a.rank}`)),u(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),u(l===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[3]}.`)),u(c===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`));const h={dy:a,filter:n},d={pad:s,strides:r,inputShape:o},p=Wr.runKernel(we,h,d);return i?$a(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Qa=ts({conv3dTranspose_:function(e,t,n,r,s){const o=Xr(e,"x","conv3dTranspose"),a=Xr(t,"filter","conv3dTranspose");return Xa(n,o,a,r,s)}});const ei=ts({cos_:function(e){const t={x:Xr(e,"x","cos","float32")};return Wr.runKernel("Cos",t)}});const ti=ts({cosh_:function(e){const t={x:Xr(e,"x","cosh","float32")};return Wr.runKernel(ke,t)}});const ni=ts({cumsum_:function(e,t=0,n=!1,r=!1){const s={x:Xr(e,"x","cumsum")},o={axis:t,exclusive:n,reverse:r};return Wr.runKernel(ve,s,o)}});const ri=ts({denseBincount_:function(e,t,n,r=!1){const s=Xr(e,"x","denseBincount"),o=Xr(t,"weights","denseBincount");u("int32"===s.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${s.dtype}`)),u(s.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${s.rank}.`)),u(n>=0,(()=>`size must be non-negative, but got ${n}.`)),u(o.size===s.size||0===o.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${s.shape}, weights shape: ${o.shape}.`));const a={x:s,weights:o},i={size:n,binaryOutput:r};return Wr.runKernel(Ee,a,i)}});const si=ts({depthToSpace_:function(e,t,n="NHWC"){const r=Xr(e,"x","depthToSpace","float32"),s="NHWC"===n?r.shape[1]:r.shape[2],o="NHWC"===n?r.shape[2]:r.shape[3],a="NHWC"===n?r.shape[3]:r.shape[1];u(t>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${t}`)),u(s*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${s} and ${t}  for depthToSpace with input shape\n    ${r.shape}`)),u(o*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${o} and ${t} for depthToSpace with input shape\n        ${r.shape}`)),u(a%(t*t)==0,(()=>`Dimension size must be evenly divisible by ${t*t} but is ${a} for depthToSpace with input shape ${r.shape}`));const i={x:r},l={blockSize:t,dataFormat:n};return Wr.runKernel(Se,i,l)}});const oi=ts({depthwiseConv2d_:function(e,t,n,r,s="NHWC",o=[1,1],a){const i=Xr(e,"x","depthwiseConv2d","float32"),l=Xr(t,"filter","depthwiseConv2d","float32");let c=i,h=!1;3===i.rank&&(h=!0,c=$a(i,[1,i.shape[0],i.shape[1],i.shape[2]])),u(4===c.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`)),u(4===l.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${l.rank}.`)),u(c.shape[3]===l.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${c.shape[3]}) must match the inChannels dimension in filter ${l.shape[2]}.`)),Sa("depthwiseConv2d",r,a);const d={x:c,filter:l},p={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:a},f=Wr.runKernel($e,d,p);return h?$a(f,[f.shape[1],f.shape[2],f.shape[3]]):f}});const ai=ts({diag_:function(e){const t={x:Xr(e,"x","diag")};return Wr.runKernel(_e,t)}});const ii=ts({dilation2d_:function(e,t,n,r,s=[1,1],o="NHWC"){const a=Xr(e,"x","dilation2d"),i=Xr(t,"filter","dilation2d");u(3===a.rank||4===a.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${a.rank}.`)),u(3===i.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${i.rank}.`)),u("NHWC"===o,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${o}`));let l=a,c=!1;3===a.rank&&(l=$a(a,[1,a.shape[0],a.shape[1],a.shape[2]]),c=!0);const h={x:l,filter:i},d={strides:n,pad:r,dilations:s},p=Wr.runKernel(Ne,h,d);return c?$a(p,[p.shape[1],p.shape[2],p.shape[3]]):p}});const li=ts({equal_:function(e,t){let n=Xr(e,"a","equal","string_or_numeric"),r=Xr(t,"b","equal","string_or_numeric");[n,r]=Br(n,r),mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(De,s)}});const ui=ts({where_:function(e,t,n){const r=Xr(t,"a","where"),s=Xr(n,"b","where"),o=Xr(e,"condition","where","bool"),a=mo(mo(o.shape,r.shape),s.shape),i={condition:za(o,a),t:za(r,a),e:za(s,a)};return Wr.runKernel(Ft,i)}});const ci=ts({zerosLike_:function(e){const t={x:Xr(e,"x","zerosLike")};return Wr.runKernel(hn,t)}});const hi=ts({divNoNan_:function(e,t){let n=Xr(e,"a","div"),r=Xr(t,"b","div");[n,r]=Br(n,r);const s=Xo(n,r),o=ci(s),a=li(r,o);return ui(a,o,s)}});const di=ts({dot_:function(e,t){const n=Xr(e,"t1","dot"),r=Xr(t,"t2","dot");u(!(1!==n.rank&&2!==n.rank||1!==r.rank&&2!==r.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${r.rank}.`));const s=1===n.rank?n.size:n.shape[1],o=1===r.rank?r.size:r.shape[0];if(u(s===o,(()=>`Error in dot: inner dimensions of inputs must match, but got ${s} and ${o}.`)),1===n.rank&&1===r.rank){const e=$a(n,[1,-1]),t=$a(r,[-1,1]),s=uo(e,t);return $a(s,[])}if(1===n.rank&&2===r.rank){const e=$a(n,[1,-1]),t=$a(r,[r.shape[0],r.shape[1]]),s=uo(e,t);return $a(s,[s.size])}if(2===n.rank&&1===r.rank){const e=$a(r,[-1,1]),t=uo(n,e);return $a(t,[t.size])}{const e=$a(r,[r.shape[0],r.shape[1]]);return uo(n,e)}}});const pi=ts({einsum_:function(e,...t){const n=t.map(((e,t)=>Xr(e,`tensors${t}`,"einsum"))),r={equation:e};return Wr.runKernel(Te,n,r)}});const fi=ts({elu_:function(e){const t={x:Xr(e,"x","elu","float32")};return Wr.runKernel("Elu",t)}});const gi=ts({erf_:function(e){let t=Xr(e,"x","erf");u("int32"===t.dtype||"float32"===t.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===t.dtype&&(t=Hs(t,"float32"));const n={x:t};return Wr.runKernel("Erf",n)}});const mi=ts({exp_:function(e){const t={x:Xr(e,"x","exp")};return Wr.runKernel("Exp",t)}});const bi=ts({expandDims_:function(e,t=0){const n=Xr(e,"x","expandDims","string_or_numeric");u(t<=n.rank,(()=>"Axis must be <= rank of the tensor"));const r={input:n},s={dim:t};return Wr.runKernel(Re,r,s)}});const yi=ts({expm1_:function(e){const t={x:Xr(e,"x","expm1")};return Wr.runKernel(Be,t)}});const wi=ts({tile_:function(e,t){const n=Xr(e,"x","tile","string_or_numeric");u(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`));const r={x:n},s={reps:t};return Wr.runKernel(rn,r,s)}});const ki=ts({eye_:function(e,t,n,r="float32"){null==t&&(t=e);const s=Vs([e,t],r),o=e<=t?e:t;for(let e=0;e<o;++e)s.set(1,e,e);const a=$a(s.toTensor(),[e,t]);if(null==n)return a;if(1===n.length)return wi(bi(a,0),[n[0],1,1]);if(2===n.length)return wi(bi(bi(a,0),0),[n[0],n[1],1,1]);if(3===n.length)return wi(bi(bi(bi(a,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function vi(e,t,n){const r={shape:e,value:t,dtype:n};return Wr.runKernel(Fe,{},r)}const xi=ts({floor_:function(e){const t={x:Xr(e,"x","floor","float32")};return Wr.runKernel(Pe,t)}});const Ei=ts({gather_:function(e,t,n=0,r=0){const s={x:Xr(e,"x","gather"),indices:Xr(t,"indices","gather","int32")},o={axis:n,batchDims:r};return Wr.runKernel(ze,s,o)}});const Si=ts({greater_:function(e,t){let n=Xr(e,"a","greater","string_or_numeric"),r=Xr(t,"b","greater","string_or_numeric");[n,r]=Br(n,r),mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(Ke,s)}});const $i=ts({greaterEqual_:function(e,t){let n=Xr(e,"a","greaterEqual","string_or_numeric"),r=Xr(t,"b","greaterEqual","string_or_numeric");[n,r]=Br(n,r),mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(We,s)}});const Ai=ts({imag_:function(e){const t={input:Xr(e,"input","imag")};return Wr.runKernel(Ve,t)}});const Ii=ts({isFinite_:function(e){const t={x:Xr(e,"x","isFinite")};return Wr.runKernel(He,t)}});const _i=ts({isInf_:function(e){const t={x:Xr(e,"x","isInf")};return Wr.runKernel(je,t)}});const Ni=ts({isNaN_:function(e){const t={x:Xr(e,"x","isNaN")};return Wr.runKernel(Je,t)}});const Mi=ts({leakyRelu_:function(e,t=.2){const n={x:Xr(e,"x","leakyRelu")},r={alpha:t};return Wr.runKernel(Ze,n,r)}});const Ti=ts({less_:function(e,t){let n=Xr(e,"a","less","string_or_numeric"),r=Xr(t,"b","less","string_or_numeric");[n,r]=Br(n,r),mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(Ye,s)}});const Di=ts({lessEqual_:function(e,t){let n=Xr(e,"a","lessEqual","string_or_numeric"),r=Xr(t,"b","lessEqual","string_or_numeric");[n,r]=Br(n,r),mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(Xe,s)}});const Ri=ts({localResponseNormalization_:function(e,t=5,n=1,r=1,s=.5){const o=Xr(e,"x","localResponseNormalization");u(4===o.rank||3===o.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${o.rank}.`)),u(g(t),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`));let a=o,i=!1;3===o.rank&&(i=!0,a=$a(o,[1,o.shape[0],o.shape[1],o.shape[2]]));const l={x:a},c={depthRadius:t,bias:n,alpha:r,beta:s},h=Wr.runKernel("LRN",l,c);return i?$a(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Bi=ts({log_:function(e){const t={x:Xr(e,"x","log","float32")};return Wr.runKernel("Log",t)}});const Fi=ts({log1p_:function(e){const t={x:Xr(e,"x","log1p")};return Wr.runKernel(et,t)}});function Ci(e,t){u(M(e),(()=>"The f passed in variableGrads(f) must be a function")),u(null==t||Array.isArray(t)&&t.every((e=>e instanceof Ar)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=t;if(!n){t=[];for(const e in Wr.registeredVariables)t.push(Wr.registeredVariables[e])}const r=n?t.filter((e=>!e.trainable)):null,s=t.length;u((t=t.filter((e=>e.trainable))).length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${s} variables is trainable.`));const{value:o,grads:a}=Wr.gradients(e,t,null,!0);u(a.some((e=>null!=e)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),u(0===o.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${o.rank} tensor`));const i={};return t.forEach(((e,t)=>{null!=a[t]&&(i[e.name]=a[t])})),null!=r&&r.forEach((e=>i[e.name]=null)),{value:o,grads:i}}function Pi(e){return Wr.customGrad(e)}function Oi(e){if(e.filter((e=>null==e)).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const Li=ts({neg_:function(e){const t={x:Xr(e,"x","neg")};return Wr.runKernel("Neg",t)}});const zi=ts({softplus_:function(e){const t={x:Xr(e,"x","softplus")};return Wr.runKernel(qt,t)}});const qi=ts({logSigmoid_:function(e){const t=Xr(e,"x","logSigmoid");return Pi((e=>({value:Li(zi(Li(e))),gradFunc:t=>Qo(t,Na(Li(e)))})))(t)}});const Ki=ts({max_:function(e,t=null,n=!1){const r={x:Xr(e,"x","max")},s={reductionIndices:t,keepDims:n};return Wr.runKernel("Max",r,s)}});const Wi=ts({sub_:function(e,t){let n=Xr(e,"a","sub"),r=Xr(t,"b","sub");[n,r]=Br(n,r);const s={a:n,b:r};return Wr.runKernel("Sub",s)}});const Gi=ts({sum_:function(e,t=null,n=!1){let r=Xr(e,"x","sum");"bool"===r.dtype&&(r=Hs(r,"int32"));const s={x:r},o={axis:t,keepDims:n};return Wr.runKernel("Sum",s,o)}});const Ui=ts({logSoftmax_:function(e,t=-1){const n=Xr(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);return Pi(((e,n)=>{const r=Ki(e,t,!0),s=Wi(e,r),o=Wi(Hs(s,"float32"),Bi(Gi(mi(s),t,!0)));n([o]);return{value:o,gradFunc:(e,n)=>{const[r]=n,s=mi(r);return Wi(e,Qo(Gi(e,t,!0),s))}}}))(n)}});function Vi(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function Hi(e,t,n){const r=e.length+t.length,s=[];let o=0,a=0;for(let i=0;i<r;i++)-1===n.indexOf(i)?s.push(e[o++]):s.push(t[a++]);return s}function ji(e,t){return Hi(e,t.map((e=>1)),t)}const Ji=ts({logSumExp_:function(e,t=null,n=!1){const r=Xr(e,"x","logSumExp"),s=b(t,r.shape),o=Ki(r,s,!0),a=Wi(r,o),i=mi(a),l=Gi(i,s),u=Bi(l),c=Zo($a(o,u.shape),u);if(n){const e=ji(c.shape,s);return $a(c,e)}return c}});const Zi=ts({logicalAnd_:function(e,t){const n=Xr(e,"a","logicalAnd","bool"),r=Xr(t,"b","logicalAnd","bool");mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(tt,s)}});const Yi=ts({logicalNot_:function(e){const t={x:Xr(e,"x","logicalNot","bool")};return Wr.runKernel(nt,t)}});const Xi=ts({logicalOr_:function(e,t){const n=Xr(e,"a","logicalOr","bool"),r=Xr(t,"b","logicalOr","bool");mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(rt,s)}});const Qi=ts({logicalXor_:function(e,t){const n=Xr(e,"a","logicalXor","bool"),r=Xr(t,"b","logicalXor","bool");return mo(n.shape,r.shape),Zi(Xi(e,t),Yi(Zi(e,t)))}});const el=ts({maxPool_:function(e,t,n,r,s){const o=Xr(e,"x","maxPool");let a=o,i=!1;3===o.rank&&(i=!0,a=$a(o,[1,o.shape[0],o.shape[1],o.shape[2]])),u(4===a.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${a.rank}.`)),u(xa(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),Sa("maxPool",r,s);const l={x:a},c={filterSize:t,strides:n,pad:r,dimRoundingMode:s},h=Wr.runKernel(ot,l,c);return i?$a(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const tl=ts({maxPool3d_:function(e,t=[1,1,1],n,r,s,o="NDHWC"){const a=Xr(e,"x","maxPool3d");let i=a,l=!1;4===a.rank&&(l=!0,i=$a(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),u(5===i.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${i.rank}.`)),u("NDHWC"===o,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${o}`)),Sa("maxPool3d",r,s);const c={x:i},h={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:o},d=Wr.runKernel(at,c,h);return l?$a(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const nl=ts({maxPoolWithArgmax_:function(e,t,n,r,s=!1){const o={x:Xr(e,"x","maxPoolWithArgmax")},a={filterSize:t,strides:n,pad:r,includeBatchInIndex:s},i=Wr.runKernel(it,o,a);return{result:i[0],indexes:i[1]}}});const rl=ts({maximum_:function(e,t){let n=Xr(e,"a","maximum"),r=Xr(t,"b","maximum");[n,r]=Br(n,r),"bool"===n.dtype&&(n=Hs(n,"int32"),r=Hs(r,"int32")),mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(st,s)}});const sl=ts({mean_:function(e,t=null,n=!1){const r={x:Xr(e,"x","mean")},s={axis:t,keepDims:n};return Wr.runKernel(lt,r,s)}});function ol(e,t="float32"){if("complex64"===t){const t=ol(e,"float32"),n=ol(e,"float32");return ns(t,n)}const n=C(p(e),t);return Wr.makeTensor(n,e,t)}function al(e,t="float32"){if("complex64"===t){const t=al(e,"float32"),n=ol(e,"float32");return ns(t,n)}const n=F(p(e),t);return Wr.makeTensor(n,e,t)}const il=ts({min_:function(e,t=null,n=!1){const r={x:Xr(e,"x","min")},s={axis:t,keepDims:n};return Wr.runKernel("Min",r,s)}});const ll=ts({minimum_:function(e,t){let n=Xr(e,"a","minimum"),r=Xr(t,"b","minimum");[n,r]=Br(n,r),"bool"===n.dtype&&(n=Hs(n,"int32"),r=Hs(r,"int32")),mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(ut,s)}});const ul=ts({mirrorPad_:function(e,t,n){u("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const r=Xr(e,"x","mirrorPad");if(0===r.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");u(t.length===r.rank,(()=>`Padding doesn't match input. Must be ${r.rank}. Got ${t.length}.`));const s="reflect"===n?1:0;for(let e=0;e<r.rank;e++)u(2===t[e].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),u(t[e][0]>=0&&t[e][0]<=r.shape[e]-s&&t[e][1]>=0&&t[e][1]<=r.shape[e]-s,(()=>`Padding in dimension ${e} cannot be greater than or equal to ${r.shape[e]-s} or less than 0 for input of shape ${r.shape}`));const o={paddings:t,mode:n},a={x:r};return Wr.runKernel(ct,a,o)}});const cl=ts({mod_:function(e,t){let n=Xr(e,"a","mod"),r=Xr(t,"b","mod");[n,r]=Br(n,r);const s={a:n,b:r};return Wr.runKernel("Mod",s)}});const hl=ts({square_:function(e){const t=Xr(e,"x","square");return Wr.runKernel("Square",{x:t},{})}});const dl=ts({moments_:function(e,t=null,n=!1){const r=b(t,(e=Xr(e,"x","moments")).shape),s=sl(e,r,n);let o=s.shape;n||(o=ji(s.shape,r));const a=hl(Wi(Hs(e,"float32"),$a(s,o)));return{mean:s,variance:sl(a,r,n)}}});const pl=ts({multiRNNCell_:function(e,t,n,r){const s=Xr(t,"data","multiRNNCell"),o=Qr(n,"c","multiRNNCell"),a=Qr(r,"h","multiRNNCell");let i=s;const l=[];for(let t=0;t<e.length;t++){const n=e[t](i,o[t],a[t]);l.push(n[0]),l.push(n[1]),i=n[1]}const u=[],c=[];for(let e=0;e<l.length;e+=2)u.push(l[e]),c.push(l[e+1]);return[u,c]}});const fl=ts({multinomial_:function(e,t,n,r=!1){const s=Xr(e,"logits","multinomial"),o=s.size,a=s.rank;if(o<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${o}.`);if(a>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${a}`);n=n||Math.random();const i={logits:1===a?$a(s,[1,-1]):s},l={numSamples:t,seed:n,normalized:r},u=Wr.runKernel(ht,i,l);return 1===a?$a(u,[u.size]):u}});const gl=ts({notEqual_:function(e,t){let n=Xr(e,"a","notEqual","string_or_numeric"),r=Xr(t,"b","notEqual","string_or_numeric");[n,r]=Br(n,r),mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(pt,s)}});const ml=ts({onesLike_:function(e){const t={x:Xr(e,"x","onesLike")};return Wr.runKernel(bt,t)}});const bl=ts({outerProduct_:function(e,t){const n=Xr(e,"v1","outerProduct"),r=Xr(t,"v2","outerProduct");u(1===n.rank&&1===r.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${r.rank}.`));const s=$a(n,[-1,1]),o=$a(r,[1,-1]);return uo(s,o)}});const yl=ts({pad_:function(e,t,n=0){const r=Xr(e,"x","pad");if(0===r.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const s={paddings:t,constantValue:n},o={x:r};return Wr.runKernel(kt,o,s)}});const wl=ts({pad1d_:function(e,t,n=0){return u(2===t.length,(()=>"Invalid number of paddings. Must be length of 2.")),yl(e,[t],n)}});const kl=ts({pad2d_:function(e,t,n=0){return u(2===t.length&&2===t[0].length&&2===t[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),yl(e,t,n)}});const vl=ts({pad3d_:function(e,t,n=0){return u(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),yl(e,t,n)}});const xl=ts({pad4d_:function(e,t,n=0){return u(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),yl(e,t,n)}});const El=ts({spaceToBatchND_:function(e,t,n){const r=Xr(e,"x","spaceToBatchND");u(r.rank>=1+t.length,(()=>`input rank ${r.rank} should be > than [blockShape] ${t.length}`)),u(n.length===t.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`)),u(r.shape.reduce(((e,r,s)=>s>0&&s<=t.length?e&&(r+n[s-1][0]+n[s-1][1])%t[s-1]==0:e),!0),(()=>`input spatial dimensions ${r.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`));const s={x:r},o={blockShape:t,paddings:n};return Wr.runKernel(Wt,s,o)}});const Sl=ts({pool_:function(e,t,n,r,s,o,a){null==s&&(s=[1,1]),null==o&&(o=1),0===r&&(r="valid");const i=Xr(e,"x","maxPool");let l=i,c=!1;3===i.rank&&(c=!0,l=$a(i,[1,i.shape[0],i.shape[1],i.shape[2]])),u(xa(o,s),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${o} and dilations '${s}'`));const h=pa(l.shape,t,o,s,r),d=[h.dilationHeight,h.dilationWidth];let p;p="same"===r?function(e,t){const n=e.map(((e,n)=>e+(e-1)*(t[n]-1))).map((e=>e-1)),r=n.map((e=>Math.floor(e/2))),s=n.map(((e,t)=>e-r[t]));return n.map(((e,t)=>[r[t],s[t]]))}([h.filterHeight,h.filterWidth],d):[[0,0],[0,0]];const f=1===d[0]&&1===d[1],[g,m]=function(e,t,n){const r=n.map((e=>e[0])),s=n.map((e=>e[1])),o=e.concat(r,s),a=t.map(((e,t)=>(e-o[t]%e)%e)),i=s.map(((e,t)=>e+a[t])),l=t.map(((e,t)=>[r[t],i[t]])),u=t.map(((e,t)=>[0,a[t]]));return[l,u]}([h.inHeight,h.inWidth],d,p),b=f?r:"valid",y=f?l:El(l,d,g),w=("avg"===n?()=>Aa(y,t,o,b,a):()=>el(y,t,o,b,a))(),k=f?w:Ra(w,d,m);return c?$a(k,[k.shape[1],k.shape[2],k.shape[3]]):k}});const $l=ts({pow_:function(e,t){let n=Xr(e,"base","pow"),r=Xr(t,"exp","pow");[n,r]=Br(n,r);const s={a:n,b:r};return Wr.runKernel("Pow",s)}});const Al=ts({prelu_:function(e,t){const n={x:Xr(e,"x","prelu"),alpha:Xr(t,"alpha","prelu")};return Wr.runKernel(vt,n)}});const Il=ts({prod_:function(e,t=null,n=!1){let r=Xr(e,"x","prod");"bool"===r.dtype&&(r=Hs(r,"int32"));const s={x:r},o={axis:t,keepDims:n};return Wr.runKernel(xt,s,o)}});const _l=ts({rand_:function(e,t,n){const r=p(e);let s=null;if(null==n||"float32"===n)s=new Float32Array(r);else if("int32"===n)s=new Int32Array(r);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);s=new Uint8Array(r)}for(let e=0;e<r;e++)s[e]=t();return Wr.makeTensor(s,e,n)}});var Nl="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function Ml(e){var t={exports:{}};return e(t,t.exports),t.exports}var Tl=Ml((function(e){!function(e,t,n){function r(e){var t,n=this,r=(t=4022871197,function(e){e=String(e);for(var n=0;n<e.length;n++){var r=.02519603282416938*(t+=e.charCodeAt(n));r-=t=r>>>0,t=(r*=t)>>>0,t+=4294967296*(r-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=r(" "),n.s1=r(" "),n.s2=r(" "),n.s0-=r(e),n.s0<0&&(n.s0+=1),n.s1-=r(e),n.s1<0&&(n.s1+=1),n.s2-=r(e),n.s2<0&&(n.s2+=1),r=null}function s(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function o(e,t){var n=new r(e),o=t&&t.state,a=n.next;return a.int32=function(){return 4294967296*n.next()|0},a.double=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.alea=o}(0,e,!1)})),Dl=Ml((function(e){!function(e,t,n){function r(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xor128=o}(0,e,!1)})),Rl=Ml((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),r==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xorwow=o}(0,e,!1)})),Bl=Ml((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.x,s=t.i;return e=r[s],n=(e^=e>>>7)^e<<24,n^=(e=r[s+1&7])^e>>>10,n^=(e=r[s+3&7])^e>>>3,n^=(e=r[s+4&7])^e<<7,e=r[s+7&7],n^=(e^=e<<13)^e<<9,r[s]=n,t.i=s+1&7,n},function(e,t){var n,r=[];if(t===(0|t))r[0]=t;else for(t=""+t,n=0;n<t.length;++n)r[7&n]=r[7&n]<<15^t.charCodeAt(n)+r[n+1&7]<<13;for(;r.length<8;)r.push(0);for(n=0;n<8&&0===r[n];++n);for(8==n&&(r[7]=-1),e.x=r,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function s(e,t){return t.x=e.x.slice(),t.i=e.i,t}function o(e,t){null==e&&(e=+new Date);var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&(o.x&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xorshift7=o}(0,e,!1)})),Fl=Ml((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.w,s=t.X,o=t.i;return t.w=r=r+1640531527|0,n=s[o+34&127],e=s[o=o+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=s[o]=n^e,t.i=o,n+(r^r>>>16)|0},function(e,t){var n,r,s,o,a,i=[],l=128;for(t===(0|t)?(r=t,t=null):(t+="\0",r=0,l=Math.max(l,t.length)),s=0,o=-32;o<l;++o)t&&(r^=t.charCodeAt((o+32)%t.length)),0===o&&(a=r),r^=r<<10,r^=r>>>15,r^=r<<4,r^=r>>>13,o>=0&&(a=a+1640531527|0,s=0==(n=i[127&o]^=r+a)?s+1:0);for(s>=128&&(i[127&(t&&t.length||0)]=-1),s=127,o=512;o>0;--o)r=i[s+34&127],n=i[s=s+1&127],r^=r<<13,n^=n<<17,r^=r>>>15,n^=n>>>12,i[s]=r^n;e.w=a,e.X=i,e.i=s}(t,e)}function s(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function o(e,t){null==e&&(e=+new Date);var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&(o.X&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xor4096=o}(0,e,!1)})),Cl=Ml((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,r=t.d,s=t.a;return e=e<<25^e>>>7^n,n=n-r|0,r=r<<24^r>>>8^s,s=s-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-r|0,t.d=r<<16^n>>>16^s,t.a=s-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var r=0;r<n.length+20;r++)t.b^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.tychei=o}(0,e,!1)})),Pl=Ml((function(e){!function(t,n,s){var o,a=256,i=s.pow(a,6),l=s.pow(2,52),u=2*l,c=255;function h(e,r,c){var h=[],b=g(f((r=1==r?{entropy:!0}:r||{}).entropy?[e,m(n)]:null==e?function(){try{var e;return o&&(e=o.randomBytes)?e=e(a):(e=new Uint8Array(a),(t.crypto||t.msCrypto).getRandomValues(e)),m(e)}catch(e){var r=t.navigator,s=r&&r.plugins;return[+new Date,t,s,t.screen,m(n)]}}():e,3),h),y=new d(h),w=function(){for(var e=y.g(6),t=i,n=0;e<l;)e=(e+n)*a,t*=a,n=y.g(1);for(;e>=u;)e/=2,t/=2,n>>>=1;return(e+n)/t};return w.int32=function(){return 0|y.g(4)},w.quick=function(){return y.g(4)/4294967296},w.double=w,g(m(y.S),n),(r.pass||c||function(e,t,n,r){return r&&(r.S&&p(r,y),e.state=function(){return p(y,{})}),n?(s.random=e,t):e})(w,b,"global"in r?r.global:this==s,r.state)}function d(e){var t,n=e.length,r=this,s=0,o=r.i=r.j=0,i=r.S=[];for(n||(e=[n++]);s<a;)i[s]=s++;for(s=0;s<a;s++)i[s]=i[o=c&o+e[s%n]+(t=i[s])],i[o]=t;(r.g=function(e){for(var t,n=0,s=r.i,o=r.j,i=r.S;e--;)t=i[s=c&s+1],n=n*a+i[c&(i[s]=i[o=c&o+t])+(i[o]=t)];return r.i=s,r.j=o,n})(a)}function p(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function f(e,t){var n,r=[],s=typeof e;if(t&&"object"==s)for(n in e)try{r.push(f(e[n],t-1))}catch(e){}return r.length?r:"string"==s?e:e+"\0"}function g(e,t){for(var n,r=e+"",s=0;s<r.length;)t[c&s]=c&(n^=19*t[c&s])+r.charCodeAt(s++);return m(t)}function m(e){return String.fromCharCode.apply(0,e)}if(g(s.random(),n),e.exports){e.exports=h;try{o=r.default}catch(e){}}else s.seedrandom=h}("undefined"!=typeof self?self:Nl,[],Math)}));Pl.alea=Tl,Pl.xor128=Dl,Pl.xorwow=Rl,Pl.xorshift7=Bl,Pl.xor4096=Fl,Pl.tychei=Cl;var Ol=Pl;class Ll{constructor(e,t,n,r,s){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=r,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const o=s||Math.random();this.random=Ol.alea(o.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let r,s,o;do{r=2*this.random()-1,s=2*this.random()-1,o=r*r+s*s}while(o>=1||0===o);const a=Math.sqrt(-2*Math.log(o)/o);e=this.mean+this.stdDev*r*a,t=this.mean+this.stdDev*s*a,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class zl{constructor(e,t,n,r){this.alpha=e,this.beta=1/t,this.dtype=n;const s=r||Math.random();this.randu=Ol.alea(s.toString()),this.randn=new Ll(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,r,s,o;for(;;){do{r=this.randn.nextValue(),o=1+this.c*r}while(o<=0);if(o*=o*o,e=r*r,t=1-.331*e*e,n=.5*e+this.d*(1-o+Math.log(o)),s=this.randu(),s<t||Math.log(s)<n)break}return o=1/this.beta*this.d*o,this.alpha<1&&(o*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(o)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class ql{constructor(e=0,t=1,n,r){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==r&&(r=Math.random()),"number"==typeof r&&(r=r.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=Ol.alea(r)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const Kl=ts({randomGamma_:function(e,t,n=1,r="float32",s){if(null==n&&(n=1),null==r&&(r="float32"),"float32"!==r&&"int32"!==r)throw new Error(`Unsupported data type ${r}`);const o=new zl(t,n,r,s),a=Vs(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const Wl=ts({randomNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error(`Unsupported data type ${r}`);const o=new Ll(t,n,r,!1,s),a=Vs(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const Gl=ts({randomUniform_:function(e,t=0,n=1,r="float32",s){const o=Vs(e,r),a=new ql(t,n,null,s);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});function Ul(e,t,n=1,r="float32"){if(0===n)throw new Error("Cannot have a step of zero");const s={start:e,stop:t,step:n,dtype:r};return Wr.runKernel(Et,{},s)}const Vl=ts({real_:function(e){const t={input:Xr(e,"input","real")};return Wr.runKernel(St,t)}});const Hl=ts({reciprocal_:function(e){const t={x:Xr(e,"x","reciprocal")};return Wr.runKernel($t,t)}});const jl=ts({relu_:function(e){const t={x:Xr(e,"x","relu")};return Wr.runKernel(At,t)}});const Jl=ts({relu6_:function(e){const t={x:Xr(e,"x","relu6")};return Wr.runKernel(Mt,t)}});const Zl=ts({reverse_:function(e,t){const n={x:Xr(e,"x","reverse")},r={dims:t};return Wr.runKernel(Tt,n,r)}});const Yl=ts({reverse1d_:function(e){const t=Xr(e,"x","reverse");return u(1===t.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`)),Zl(t,0)}});const Xl=ts({reverse2d_:function(e,t){const n=Xr(e,"x","reverse");return u(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),Zl(n,t)}});const Ql=ts({reverse3d_:function(e,t){const n=Xr(e,"x","reverse");return u(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),Zl(n,t)}});const eu=ts({reverse4d_:function(e,t){const n=Xr(e,"x","reverse");return u(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),Zl(n,t)}});const tu=ts({round_:function(e){const t={x:Xr(e,"x","round")};return Wr.runKernel(Dt,t)}});const nu=ts({rsqrt_:function(e){const t={x:Xr(e,"x","rsqrt","float32")};return Wr.runKernel(Rt,t)}});function ru(e,t){if((E(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&E(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return rs(e,[],[],t)}const su=ts({selu_:function(e){const t={x:Xr(e,"x","selu")};return Wr.runKernel(Ct,t)}});const ou=ts({separableConv2d_:function(e,t,n,r,s,o=[1,1],a="NHWC"){const i=Xr(e,"x","separableConv2d"),l=Xr(t,"depthwiseFilter","separableConv2d"),c=Xr(n,"pointwiseFilter","separableConv2d");let h=i,d=!1;if(3===i.rank&&(d=!0,h=$a(i,[1,i.shape[0],i.shape[1],i.shape[2]])),"NCHW"===a)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");u(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),u(4===l.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${l.rank}.`)),u(4===c.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${l.rank}.`)),u(1===c.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`)),u(1===c.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`));const p=l.shape[2],f=l.shape[3];u(c.shape[2]===p*f,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${p*f}, but got ${c.shape[2]}.`));const g=oi(h,l,r,s,a,o),m=Ha(g,c,1,"valid",a);return d?$a(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const au=async function(e,t){const n=Xr(e,"x","setdiff1d"),r=Xr(t,"y","setdiff1d");u(n.dtype===r.dtype,(()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${r.dtype}).`)),u(1===n.rank,(()=>`x should be 1D tensor, but got x (${n.shape}).`)),u(1===r.rank,(()=>`y should be 1D tensor, but got y (${r.shape}).`));const s=await n.data(),o=await r.data(),a=new Set(o);let i=0;for(let e=0;e<s.length;e++)a.has(s[e])||i++;const l=new xr([i],n.dtype),c=new xr([i],"int32");for(let e=0,t=0;e<s.length;e++)a.has(s[e])||(l.values[t]=s[e],c.values[t]=e,t++);return[l.toTensor(),c.toTensor()]};const iu=ts({sign_:function(e){const t={x:Xr(e,"x","sign")};return Wr.runKernel(Lt,t)}});const lu=ts({sin_:function(e){const t={x:Xr(e,"x","sin","float32")};return Wr.runKernel("Sin",t)}});const uu=ts({sinh_:function(e){const t={x:Xr(e,"x","sinh")};return Wr.runKernel(Ot,t)}});const cu=ts({slice1d_:function(e,t,n){const r=Xr(e,"x","slice1d");return u(1===r.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${r.rank} tensor`)),Ma(r,[t],[n])}});const hu=ts({slice2d_:function(e,t,n){const r=Xr(e,"x","slice2d");return u(2===r.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${r.rank} tensor`)),Ma(r,t,n)}});const du=ts({slice3d_:function(e,t,n){const r=Xr(e,"x","slice3d");return u(3===r.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${r.rank} tensor`)),Ma(r,t,n)}});const pu=ts({slice4d_:function(e,t,n){const r=Xr(e,"x","slice4d");return u(4===r.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${r.rank} tensor`)),Ma(r,t,n)}});const fu=ts({softmax_:function(e,t=-1){const n=Xr(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const r={logits:n},s={dim:t};return Wr.runKernel(Ut,r,s)}});const gu=ts({fft_:function(e){u("complex64"===e.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Wr.runKernel("FFT",t)}});const mu=ts({ifft_:function(e){u("complex64"===e.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Wr.runKernel(Ue,t)}});const bu=ts({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let r;if(t<=2){const s=$a(e,[n,t]);r=mu(s)}else{const s=[n,2*(t-1)],o=$a(Vl(e),[n,t]),a=$a(Ai(e),[n,t]),i=Zl(Ma(o,[0,1],[n,t-2]),1),l=Qo(Zl(Ma(a,[0,1],[n,t-2]),1),ru(-1)),u=_a([o,i],1),c=_a([a,l],1),h=$a(ns(u,c),[s[0],s[1]]);r=mu(h)}if(r=Vl(r),3===e.rank&&0!==e.shape[0]){const t=r,n=e.shape[0];r=$a(r,[n,r.shape[0]/n,r.shape[1]]),t.dispose()}return r}});const yu=ts({split_:function(e,t,n=0){const r={x:Xr(e,"x","split")},s={numOrSizeSplits:t,axis:n};return Wr.runKernel(Gt,r,s)}});const wu=ts({rfft_:function(e,t){u("float32"===e.dtype,(()=>`The dtype for rfft() must be real value but got ${e.dtype}`));let n=e.shape[e.shape.length-1];const r=e.size/n;let s;if(null!=t&&t<n){const r=e.shape.map((e=>0)),o=e.shape.map((e=>e));o[e.shape.length-1]=t,s=Ma(e,r,o),n=t}else if(null!=t&&t>n){const r=e.shape.map((e=>e));r[e.shape.length-1]=t-n,s=_a([e,ol(r)],e.shape.length-1),n=t}else s=e;const o=ci(s),a=$a(ns(s,o),[r,n]),i=gu(a),l=Math.floor(n/2)+1,c=Vl(i),h=Ai(i),d=yu(c,[l,n-l],c.shape.length-1),p=yu(h,[l,n-l],h.shape.length-1),f=s.shape.slice();return f[s.shape.length-1]=l,$a(ns(d[0],p[0]),f)}});const ku=ts({sqrt_:function(e){const t={x:Xr(e,"x","sqrt","float32")};return Wr.runKernel(Kt,t)}});const vu=ts({squaredDifference_:function(e,t){let n=Xr(e,"a","squaredDifference"),r=Xr(t,"b","squaredDifference");[n,r]=Br(n,r),mo(n.shape,r.shape);const s={a:n,b:r};return Wr.runKernel(Yt,s,{})}});const xu=ts({squeeze_:function(e,t){const n=Xr(e,"x","squeeze");return $a(n,y(n.shape,t).newShape)}});const Eu=ts({stack_:function(e,t=0){const n=Qr(e,"tensors","stack","string_or_numeric");u(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&u(t<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const r=n,s={axis:t};return Wr.runKernel(wt,r,s)}});const Su=ts({step_:function(e,t=0){const n={x:Xr(e,"x","step")},r={alpha:t};return Wr.runKernel(dn,n,r)}});const $u=ts({stridedSlice_:function(e,t,n,r,s=0,o=0,a=0,i=0,l=0){const u={x:Xr(e,"x","stridedSlice","string_or_numeric")},c={begin:t,end:n,strides:r,beginMask:s,endMask:o,ellipsisMask:a,newAxisMask:i,shrinkAxisMask:l};return Wr.runKernel(Xt,u,c)}});const Au=ts({tan_:function(e){const t={x:Xr(e,"x","tan","float32")};return Wr.runKernel("Tan",t)}});function Iu(e,t){h(e);const n=Jr(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return rs(e,null,n,t)}function _u(e,t,n){if(h(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const r=Jr(e,n);if(2!==r.length&&1!==r.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return rs(e,t,r,n)}const Nu=ts({topk_:function(e,t=1,n=!0){const r=Xr(e,"x","topk");if(0===r.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const s=r.shape[r.shape.length-1];if(t<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${t}`);if(t>s)throw new Error(`'k' passed to topk() must be <= the last dimension (${s}) but got ${t}`);const o={x:r},a={k:t,sorted:n},[i,l]=Wr.runKernel(sn,o,a);return{values:i,indices:l}}});const Mu=ts({truncatedNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error("Unsupported data type $ { dtype }");const o=new Ll(t,n,r,!0,s),a=Vs(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const Tu=ts({unique_:function(e,t=0){const n=Xr(e,"x","unique","string_or_numeric");u(n.rank>0,(()=>"The input tensor must be at least 1D"));const r={x:n},s={axis:t},[o,a]=Wr.runKernel(ln,r,s);return{values:o,indices:a}}});const Du=ts({unsortedSegmentSum_:function(e,t,n){const r=Xr(e,"x","unsortedSegmentSum"),s=Xr(t,"segmentIds","unsortedSegmentSum","int32");u(g(n),(()=>"numSegments must be of dtype int"));const o={x:r,segmentIds:s},a={numSegments:n};return Wr.runKernel(cn,o,a)}});const Ru=ts({unstack_:function(e,t=0){const n=Xr(e,"x","unstack","string_or_numeric");u(t>=-n.shape.length&&t<n.shape.length,(()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`));const r={value:n},s={axis:t};return Wr.runKernel(un,r,s)}});function Bu(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const r=Vs(e,"int32"),s=Vs([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const o=r.indexToLoc(n[t]),a=t*e.length;s.values.set(o,a)}return s.toTensor()}const Fu=async function(e){const t=Xr(e,"condition","whereAsync","bool"),n=await t.data(),r=Bu(t.shape,n);return e!==t&&t.dispose(),r};const Cu=async function(e,t,n){const r=Xr(e,"tensor","boolMask"),s=Xr(t,"mask","boolMask","bool"),o=null==n?0:n,a=s.rank,i=r.shape;u(a>0,(()=>"mask cannot be scalar")),c(i.slice(o,o+a),s.shape,"mask's shape must match the first K dimensions of tensor's shape,");let l=1;for(let e=o;e<o+a;e++)l*=i[e];const h=i.slice(0,o).concat([l],i.slice(o+a)),d=$a(r,h),p=$a(s,[-1]),f=await Fu(p),g=xu(f,[1]),m=Ei(d,g,o);return e!==r&&r.dispose(),t!==s&&s.dispose(),g.dispose(),d.dispose(),p.dispose(),f.dispose(),m};function Pu(e,t,n=null){if(0===e.rank)return ea(e);if(1!==e.rank&&null===n)return Pu($a(e,[-1]),t,n);if(1===e.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===t)return Gi(ea(e),n);if(t===1/0)return Ki(ea(e),n);if(t===-1/0)return il(ea(e),n);if("euclidean"===t||2===t)return ku(Gi($l(ea(e),ru(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}if(Array.isArray(n)&&2===n.length){if(1===t)return Ki(Gi(ea(e),n[0]),n[1]-1);if(t===1/0)return Ki(Gi(ea(e),n[1]),n[0]);if(t===-1/0)return il(Gi(ea(e),n[1]),n[0]);if("fro"===t||"euclidean"===t)return ku(Gi(hl(e),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const Ou=ts({norm_:function(e,t="euclidean",n=null,r=!1){const s=Pu(e=Xr(e,"x","norm"),t,n);let o=s.shape;if(r){const t=b(n,e.shape);o=ji(s.shape,t)}return $a(s,o)}});const Lu=ts({movingAverage_:function(e,t,n,r,s=!0){const o=Xr(e,"v","movingAverage"),a=Xr(t,"x","movingAverage"),i=Xr(n,"decay","movingAverage");Fr(o,a),u(f(o.shape,a.shape),(()=>"Shape mismatch in v and x"));const l=ru(1),c=Wi(l,i);let h=Qo(Wi(a,o),c);if(s){u(null!=r,(()=>"When using zeroDebias: true, step is required."));const e=Xr(r,"step","movingAverage");h=Xo(h,Wi(l,$l(i,e)))}return Zo(o,h)}});const zu=ts({scatterND_:function(e,t,n){const r=Xr(e,"indices","scatterND","int32"),s=Xr(t,"updates","scatterND");Ao(s,r,n);const o={indices:r,updates:s},a={shape:n};return Wr.runKernel(Bt,o,a)}});const qu=ts({sparseToDense_:function(e,t,n,r=0){const s=Xr(e,"sparseIndices","sparseToDense","int32"),o=Xr(t,"sparseValues","sparseToDense"),a=Xr(r,"defaultValue","sparseToDense",o.dtype);!function(e,t,n,r){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const s=e.rank>0?e.shape[0]:1,o=e.rank>1?e.shape[1]:1;if(n.length!==o)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${o}.`);const a=t.size;if(0!==t.rank&&(1!==t.rank||a!==s))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${s}]`);if(t.dtype!==r.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(s,o,n,a);const i={sparseIndices:s,sparseValues:o,defaultValue:a},l={outputShape:n};return Wr.runKernel(Zt,i,l)}});const Ku=ts({gatherND_:function(e,t){const n=Xr(t,"indices","gatherND","int32"),r={params:Xr(e,"x","gatherND","string_or_numeric"),indices:n};return Wr.runKernel(qe,r)}});const Wu=ts({dropout_:function(e,t,n,r){const s=Xr(e,"x","dropout");if(u("float32"===s.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${s.dtype} tensor instead.`)),u(t>=0&&t<1,(()=>`rate must be a float in the range [0, 1), but got ${t}.`)),0===t)return e instanceof $r?s.clone():s;const o=function(e,t){if(null==t)return e.shape.slice();if(f(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let r=0;r<e.shape.length;r++)null==t[r]&&null!=e.shape[r]?n.push(e.shape[r]):n.push(t[r]);return n}return t}(s,n),a=1-t,i=Xo(xi(Zo(Gl(o,0,1,"float32",r),a)),a);return Qo(s,i)}});function Gu(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function Uu(e,t,n){const r=1-e%2,s=new Float32Array(e);for(let o=0;o<e;++o){const a=2*Math.PI*o/(e+r-1);s[o]=t-n*Math.cos(a)}return Iu(s,"float32")}const Vu=async function(e,t,n=1){const r=Xr(e,"predictions","inTopK"),s=Xr(t,"targets","inTopK");u(r.rank>1,(()=>`inTopK() expects the predictions to be of rank 2 or higher, but got ${r.rank}`)),u(r.rank-1===s.rank,(()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${r.rank} and targets rank ${s.rank}`)),c(r.shape.slice(0,r.shape.length-1),s.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const o=r.shape[r.shape.length-1];u(n>0&&n<=o,(()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${o}), but got ${n}`));const a=await r.data(),i=await s.data(),[l,h]=[a.length/o,o],d=w("bool",l);for(let e=0;e<l;e++){const t=e*h,r=a.subarray(t,t+h),s=[];for(let e=0;e<r.length;e++)s.push({value:r[e],index:e});s.sort(((e,t)=>t.value-e.value)),d[e]=0;for(let t=0;t<n;t++)if(s[t].index===i[e]){d[e]=1;break}}return e!==r&&r.dispose(),t!==s&&s.dispose(),ss(d,s.shape,"bool")};const Hu=ts({conv2DBackpropFilter_:function(e,t,n,r,s,o="NHWC",a){let i=e;3===e.rank&&(i=$a(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=$a(t,[1,t.shape[0],t.shape[1],t.shape[2]])),u(4===i.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${i.shape}.`)),u(4===l.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${l.shape}.`)),u(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const c="NHWC"===o?i.shape[3]:i.shape[1],h="NHWC"===o?l.shape[3]:l.shape[1];u(c===n[2],(()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`)),u(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),Sa("conv2dDerFilter",s,a);const d={x:i,dy:l},p={strides:r,pad:s,dataFormat:o,dimRoundingMode:a,filterShape:n};return Wr.runKernel(me,d,p)}});function ju(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return Qo(e,Su(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function Ju(e,t){let n=t;const r=go(e.shape,t.shape);return r.length>0&&(n=Gi(n,r)),$a(n,e.shape)}function Zu(e,t,n,r){if("linear"===t)return e;if("relu"===t)return jl(e);if("elu"===t)return fi(e);if("relu6"===t)return Jl(e);if("prelu"===t)return Al(e,n);if("leakyrelu"===t)return Mi(e,r);if("sigmoid"===t)return Na(e);throw new Error(`Unknown fused activation ${t}.`)}const Yu=(e,t)=>!(e>0)||"linear"===t;const Xu=ts({fusedConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:o=[1,1],dimRoundingMode:a,bias:i,activation:l="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(l=l||"linear",!1===Yu(Wr.state.gradientDepth,l)){let u=Ha(e,t,n,r,s,o,a);return null!=i&&(u=Zo(u,i)),Zu(u,l,c,h)}const d=Xr(e,"x","conv2d","float32"),p=Xr(t,"filter","conv2d","float32");let f=d,g=!1;3===d.rank&&(g=!0,f=$a(d,[1,d.shape[0],d.shape[1],d.shape[2]])),u(4===f.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${f.rank}.`)),u(4===p.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${p.rank}.`)),Sa("fused conv2d",r,a),u(f.shape[3]===p.shape[2],(()=>`Error in conv2d: depth of input (${f.shape[3]}) must match input depth for filter ${p.shape[2]}.`)),u(xa(n,o),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),u("NHWC"===s,(()=>`Error in conv2d: got dataFormat of ${s} but only NHWC is currently supported.`));const m=fa(f.shape,p.shape,n,o,r,a);let b,y;null!=i&&(b=Xr(i,"bias","fused conv2d"),[b]=Br(b,d),mo(m.outShape,b.shape)),null!=c&&(y=Xr(c,"prelu weights","fused conv2d"));const w=(e,t)=>{const[s,a,i,c]=t,h=ju(e,i,l);u(va(o),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${o}'`));const d=[Ja(a.shape,h,s,n,r),Hu(a,h,s.shape,n,r)];if(null!=c){const e=Ju(c,h);d.push(e)}return d},k={x:f,filter:p,bias:b,preluActivationWeights:y},v={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==i){return Pi(((e,t,n)=>{let r=Wr.runKernel(mn,k,v);return n([t,e,r]),g&&(r=$a(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}))(f,p)}return Pi(((e,t,n,r)=>{let s=Wr.runKernel(mn,k,v);return r([t,e,s,n]),g&&(s=$a(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}))(f,p,b)}});const Qu=ts({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,r,s,o=[1,1],a){let i=e;3===e.rank&&(i=$a(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=$a(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={x:i,dy:l},c={strides:r,pad:s,dimRoundingMode:a,dilations:o,filterShape:n};return Wr.runKernel(Ae,u,c)}});const ec=ts({depthwiseConv2dNativeBackpropInput_:function(e,t,n,r,s,o=[1,1],a){let i=t,l=!1;3===t.rank&&(l=!0,i=$a(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={dy:i,filter:n},c={strides:r,pad:s,dimRoundingMode:a,dilations:o,inputShape:e},h=Wr.runKernel(Ie,u,c);return l?$a(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});var tc={__proto__:null,conv2d:Xu,depthwiseConv2d:ts({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:o=[1,1],dimRoundingMode:a,bias:i,activation:l="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(!1===Yu(Wr.state.gradientDepth,l)){let u=oi(e,t,n,r,s,o,a);return null!=i&&(u=Zo(u,i)),Zu(u,l,c,h)}const d=Xr(e,"x","depthwiseConv2d","float32"),p=Xr(t,"filter","depthwiseConv2d","float32");let f=d,g=!1;3===d.rank&&(g=!0,f=$a(d,[1,d.shape[0],d.shape[1],d.shape[2]])),u(4===f.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${f.rank}.`)),u(4===p.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${p.rank}.`)),u(f.shape[3]===p.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${f.shape[3]}) must match the inChannels dimension in filter ${p.shape[2]}.`)),null==o&&(o=[1,1]),u(xa(n,o),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),Sa("fused depthwiseConv2d",r,a);const m=fa(f.shape,p.shape,n,o,r,a,!0);let b,y;null!=i&&(b=Xr(i,"bias","fused conv2d"),[b]=Br(b,d),mo(m.outShape,b.shape)),null!=c&&(y=Xr(c,"prelu weights","fused depthwiseConv2d"));const w=(e,t)=>{u(va(o),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[s,i,c,h]=t,d=ju(e,c,l),p=ec(i.shape,d,s,n,r,o,a),f=Qu(i,d,s.shape,n,r,o,a);if(null!=h){return[p,f,Ju(b,d)]}return[p,f]},k={x:f,filter:p,bias:b,preluActivationWeights:y},v={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==i){return Pi(((e,t,n)=>{let r=Wr.runKernel(bn,k,v);return n([t,e,r]),g&&(r=$a(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}))(f,p)}return Pi(((e,t,n,r)=>{let s=Wr.runKernel(bn,k,v);return r([t,e,s,n]),g&&(s=$a(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}))(f,p,b)}}),matMul:ts({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:r=!1,bias:s,activation:o="linear",preluActivationWeights:a,leakyreluAlpha:i}){if(!1===Yu(Wr.state.gradientDepth,o)){let l=uo(e,t,n,r);return null!=s&&(l=Zo(l,s)),Zu(l,o,a,i)}let l=Xr(e,"a","fused matMul"),c=Xr(t,"b","fused matMul");[l,c]=Br(l,c);const h=n?l.shape[l.rank-2]:l.shape[l.rank-1],d=r?c.shape[c.rank-1]:c.shape[c.rank-2],f=n?l.shape[l.rank-1]:l.shape[l.rank-2],g=r?c.shape[c.rank-2]:c.shape[c.rank-1],m=l.shape.slice(0,-2),b=c.shape.slice(0,-2),y=p(m),w=p(b);u(h===d,(()=>`Error in fused matMul: inner shapes (${h}) and (${d}) of Tensors with shapes ${l.shape} and ${c.shape} and transposeA=${n} and transposeB=${r} must match.`));const k=mo(l.shape.slice(0,-2),c.shape.slice(0,-2)).concat([f,g]),v=$a(l,n?[y,h,f]:[y,f,h]),x=$a(c,r?[w,g,d]:[w,d,g]);let E,S;null!=s&&(E=Xr(s,"bias","fused matMul"),[E]=Br(E,l),mo(k,E.shape)),null!=a&&(S=Xr(a,"prelu weights","fused matMul"));const $=(e,t)=>{const[a,i,l,u]=t,c=ju($a(e,l.shape),l,o);let h,d;if(n||r?!n&&r?(h=uo(c,i,!1,!1),d=uo(c,a,!0,!1)):n&&!r?(h=uo(i,c,!1,!0),d=uo(a,c,!1,!1)):(h=uo(i,c,!0,!0),d=uo(c,a,!0,!0)):(h=uo(c,i,!1,!0),d=uo(a,c,!0,!1)),null!=s){return[h,d,Ju(u,c)]}return[h,d]},A={a:v,b:x,bias:E,preluActivationWeights:S},I={transposeA:n,transposeB:r,activation:o,leakyreluAlpha:i};if(null==s){return Pi(((e,t,n)=>{const r=Wr.runKernel(gn,A,I);return n([e,t,r]),{value:$a(r,k),gradFunc:$}}))(v,x)}return Pi(((e,t,n,r)=>{const s=Wr.runKernel(gn,A,I);return r([e,t,s,n]),{value:$a(s,k),gradFunc:$}}))(v,x,E)}})};const nc=ts({hammingWindow_:function(e){return Uu(e,.54,.46)}});const rc=ts({hannWindow_:function(e){return Uu(e,.5,.5)}});const sc=ts({frame_:function(e,t,n,r=!1,s=0){let o=0;const a=[];for(;o+t<=e.size;)a.push(Ma(e,o,t)),o+=n;if(r)for(;o<e.size;){const r=o+t-e.size,i=_a([Ma(e,o,t-r),vi([r],s)]);a.push(i),o+=n}return 0===a.length?_u([],[0,t]):$a(_a(a),[a.length,t])}});const oc=ts({stft_:function(e,t,n,r,s=rc){null==r&&(r=Gu(t));const o=sc(e,t,n),a=Qo(o,s(t));return wu(a,r)}});const ac=ts({cropAndResize_:function(e,t,n,r,s="bilinear",o=0){const a=Xr(e,"image","cropAndResize"),i=Xr(t,"boxes","cropAndResize","float32"),l=Xr(n,"boxInd","cropAndResize","int32"),c=i.shape[0];u(4===a.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${a.rank}.`)),u(2===i.rank&&4===i.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${i.shape}.`)),u(1===l.rank&&l.shape[0]===c,(()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${i.shape}.`)),u(2===r.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${r.length}.`)),u(r[0]>=1&&r[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${r}`)),u("bilinear"===s||"nearest"===s,(()=>`method must be bilinear or nearest, but was ${s}`));const h={image:a,boxes:i,boxInd:l},d={method:s,extrapolationValue:o,cropSize:r};return Wr.runKernel(xe,h,d)}});const ic=ts({flipLeftRight_:function(e){const t=Xr(e,"image","flipLeftRight","float32");u(4===t.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`));const n={image:t};return Wr.runKernel(Ce,n,{})}});const lc=ts({grayscaleToRGB_:function(e){const t=Xr(e,"image","grayscaleToRGB"),n=t.rank-1,r=t.shape[n];u(t.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${t.rank}.`)),u(1===r,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${r}.`));const s=new Array(t.rank);return s.fill(1,0,n),s[n]=3,wi(t,s)}});const uc=ts({rotateWithOffset_:function(e,t,n=0,r=.5){const s=Xr(e,"image","rotateWithOffset","float32");u(4===s.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${s.rank}.`));const o={image:s},a={radians:t,fillValue:n,center:r};return Wr.runKernel(fn,o,a)}});function cc(e,t,n,r,s,o){null==r&&(r=.5),null==s&&(s=Number.NEGATIVE_INFINITY),null==o&&(o=0);const a=e.shape[0];return n=Math.min(n,a),u(0<=r&&r<=1,(()=>`iouThreshold must be in [0, 1], but was '${r}'`)),u(2===e.rank,(()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`)),u(4===e.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`)),u(1===t.rank,(()=>"scores must be a 1D tensor")),u(t.shape[0]===a,(()=>`scores has incompatible shape with boxes. Expected ${a}, but was ${t.shape[0]}`)),u(0<=o&&o<=1,(()=>`softNmsSigma must be in [0, 1], but was '${o}'`)),{maxOutputSize:n,iouThreshold:r,scoreThreshold:s,softNmsSigma:o}}const hc=ts({nonMaxSuppression_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const o=Xr(e,"boxes","nonMaxSuppression","float32"),a=Xr(t,"scores","nonMaxSuppression","float32"),i=cc(o,a,n,r,s),l={maxOutputSize:n=i.maxOutputSize,iouThreshold:r=i.iouThreshold,scoreThreshold:s=i.scoreThreshold};return Wr.runKernel(ft,{boxes:o,scores:a},l)}});function dc(e,t,n){const r=function(e,t,n){return function(e,t,n){let r=0,s=e.length,o=0,a=!1;for(;r<s;){o=r+(s-r>>>1);const i=n(t,e[o]);i>0?r=o+1:(s=o,a=!i)}return a?r:-r-1}(e,t,n||pc)}(e,t,n),s=r<0?-(r+1):r;e.splice(s,0,t)}function pc(e,t){return e>t?1:e<t?-1:0}function fc(e,t,n,r,s){return bc(e,t,n,r,s,0)}function gc(e,t,n,r,s,o){return bc(e,t,n,r,s,0,!1,o,!0)}function mc(e,t,n,r,s,o){return bc(e,t,n,r,s,o,!0)}function bc(e,t,n,r,s,o,a=!1,i=!1,l=!1){const u=[];for(let e=0;e<t.length;e++)t[e]>s&&u.push({score:t[e],boxIndex:e,suppressBeginIndex:0});u.sort(kc);const c=o>0?-.5/o:0,h=[],d=[];for(;h.length<n&&u.length>0;){const t=u.pop(),{score:n,boxIndex:o,suppressBeginIndex:a}=t;if(n<s)break;let i=!1;for(let n=h.length-1;n>=a;--n){const a=yc(e,o,h[n]);if(a>=r){i=!0;break}if(t.score=t.score*wc(r,c,a),t.score<=s)break}t.suppressBeginIndex=h.length,i||(t.score===n?(h.push(o),d.push(t.score)):t.score>s&&dc(u,t,kc))}const p=h.length,f=n-p;i&&f>0&&(h.push(...new Array(f).fill(0)),d.push(...new Array(f).fill(0)));const g={selectedIndices:h};return a&&(g.selectedScores=d),l&&(g.validOutputs=p),g}function yc(e,t,n){const r=e.subarray(4*t,4*t+4),s=e.subarray(4*n,4*n+4),o=Math.min(r[0],r[2]),a=Math.min(r[1],r[3]),i=Math.max(r[0],r[2]),l=Math.max(r[1],r[3]),u=Math.min(s[0],s[2]),c=Math.min(s[1],s[3]),h=Math.max(s[0],s[2]),d=Math.max(s[1],s[3]),p=(i-o)*(l-a),f=(h-u)*(d-c);if(p<=0||f<=0)return 0;const g=Math.max(o,u),m=Math.max(a,c),b=Math.min(i,h),y=Math.min(l,d),w=Math.max(b-g,0)*Math.max(y-m,0);return w/(p+f-w)}function wc(e,t,n){const r=Math.exp(t*n*n);return n<=e?r:0}function kc(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const vc=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const o=Xr(e,"boxes","nonMaxSuppressionAsync"),a=Xr(t,"scores","nonMaxSuppressionAsync"),i=cc(o,a,n,r,s);n=i.maxOutputSize,r=i.iouThreshold,s=i.scoreThreshold;const l=await Promise.all([o.data(),a.data()]),u=l[0],c=l[1],{selectedIndices:h}=fc(u,c,n,r,s);return o!==e&&o.dispose(),a!==t&&a.dispose(),Iu(h,"int32")};const xc=ts({nonMaxSuppressionWithScore_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=0){const a=Xr(e,"boxes","nonMaxSuppression"),i=Xr(t,"scores","nonMaxSuppression"),l=cc(a,i,n,r,s,o),u={boxes:a,scores:i},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:r=l.iouThreshold,scoreThreshold:s=l.scoreThreshold,softNmsSigma:o=l.softNmsSigma},h=Wr.runKernel(mt,u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const Ec=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=0){const a=Xr(e,"boxes","nonMaxSuppressionAsync"),i=Xr(t,"scores","nonMaxSuppressionAsync"),l=cc(a,i,n,r,s,o);n=l.maxOutputSize,r=l.iouThreshold,s=l.scoreThreshold,o=l.softNmsSigma;const u=await Promise.all([a.data(),i.data()]),c=u[0],h=u[1],{selectedIndices:d,selectedScores:p}=mc(c,h,n,r,s,o);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:Iu(d,"int32"),selectedScores:Iu(p)}};const Sc=ts({nonMaxSuppressionPadded_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=!1){const a=Xr(e,"boxes","nonMaxSuppression"),i=Xr(t,"scores","nonMaxSuppression"),l=cc(a,i,n,r,s,null),u={boxes:a,scores:i},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:o},h=Wr.runKernel(gt,u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const $c=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=!1){const a=Xr(e,"boxes","nonMaxSuppressionAsync"),i=Xr(t,"scores","nonMaxSuppressionAsync"),l=cc(a,i,n,r,s,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[d,p]=await Promise.all([a.data(),i.data()]),{selectedIndices:f,validOutputs:g}=gc(d,p,u,c,h,o);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:Iu(f,"int32"),validOutputs:ru(g,"int32")}};const Ac=ts({resizeBilinear_:function(e,t,n=!1,r=!1){const s=Xr(e,"images","resizeBilinear");u(3===s.rank||4===s.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${s.rank}.`)),u(2===t.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${t}.`)),u(!1===r||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let o=s,a=!1;3===s.rank&&(a=!0,o=$a(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const i={images:o},l={alignCorners:n,halfPixelCenters:r,size:t},c=Wr.runKernel(Nt,i,l);return a?$a(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Ic=ts({resizeNearestNeighbor_:function(e,t,n=!1,r=!1){const s=Xr(e,"images","resizeNearestNeighbor");u(3===s.rank||4===s.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${s.rank}.`)),u(2===t.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`)),u("float32"===s.dtype||"int32"===s.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),u(!1===r||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let o=s,a=!1;3===s.rank&&(a=!0,o=$a(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const i={images:o},l={alignCorners:n,halfPixelCenters:r,size:t},c=Wr.runKernel(_t,i,l);return a?$a(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const _c=ts({threshold_:function(e,t="binary",n=!1,r=.5){const s=Xr(e,"image","threshold"),o=s.shape[0]*s.shape[1];let a,i,l,c,h=Qo(Iu([r]),255);if(u(3===s.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${s.rank}.`)),u(3===s.shape[2]||1===s.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${s.shape[2]}.`)),u("int32"===s.dtype||"float32"===s.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${s.dtype}.`)),u("otsu"===t||"binary"===t,(()=>`Method must be binary or otsu, but was ${t}`)),3===s.shape[2]){[a,i,l]=yu(s,[1,1,1],-1);const e=Qo(a,.2989),t=Qo(i,.587),n=Qo(l,.114);c=Zo(Zo(e,t),n)}else c=e;if("otsu"===t){h=function(e,t){let n,r,s,o,a,i,l=Iu([-1]),u=Iu([0]),c=Iu([0]);for(let h=0;h<e.size-1;h++){n=Ma(e,0,h+1),r=Ma(e,h+1),a=Xo(Gi(n),t),i=Xo(Gi(r),t);const d=Gi(Qo(n,Ul(0,n.size)));s=Xo(d,Gi(n));const p=vi(r.shape,n.size),f=Zo(Ul(0,r.size),p),g=Qo(r,f);o=Xo(Gi(g),Gi(r));const m=Wi(s,o),b=Wi(s,o),y=Qo(a,i);c=Qo(Qo(y,m),b);const w=Si(c,u);u=ui(w,c,u),l=ui(w,Iu([h]),l)}return l}(Oa(Hs(tu(c),"int32"),ss([]),256),o)}const d=n?Di(c,h):Si(c,h);return Hs(Qo(d,255),"int32")}});const Nc=ts({transform_:function(e,t,n="nearest",r="constant",s=0,o){const a=Xr(e,"image","transform","float32"),i=Xr(t,"transforms","transform","float32");u(4===a.rank,(()=>`Error in transform: image must be rank 4,but got rank ${a.rank}.`)),u(2===i.rank&&(i.shape[0]===a.shape[0]||1===i.shape[0])&&8===i.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),u(null==o||2===o.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${o}.`));const l={image:a,transforms:i},c={interpolation:n,fillMode:r,fillValue:s,outputShape:o};return Wr.runKernel(on,l,c)}});const Mc=ts({bandPart_:function(e,t,n){u(t%1==0,(()=>`bandPart(): numLower must be an integer, got ${t}.`)),u(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const r=Xr(e,"a","bandPart");u(r.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${r.rank}.`));const s=r.shape,[o,a]=r.shape.slice(-2);if(!(t<=o))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${o}).`);if(!(n<=a))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${a}).`);t<0&&(t=o),n<0&&(n=a);const i=$a(Ul(0,o,1,"int32"),[-1,1]),l=Ul(0,a,1,"int32"),c=Wi(i,l),h=Zi(Di(c,ru(+t,"int32")),$i(c,ru(-n,"int32"))),d=ol([o,a],r.dtype);return $a(Eu(Ru($a(r,[-1,o,a])).map((e=>ui(h,e,d)))),s)}});const Tc=ts({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,u(null!=e&&e.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=e[0].shape[0];for(let t=1;t<e.length;++t)u(e[t].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`))}else t=!0,e=yu(e,e.shape[0],0).map((e=>xu(e,[0])));u(e.length<=e[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`));const n=[],r=e;for(let t=0;t<e.length;++t)n.push(Wr.tidy((()=>{let e=r[t];if(t>0)for(let r=0;r<t;++r){const t=Qo(Gi(Qo(n[r],e)),n[r]);e=Wi(e,t)}return Xo(e,Ou(e,"euclidean"))})));return t?Eu(n,0):n}});function Dc(e,t=!1){return Wr.tidy((()=>{u(2===e.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`));const n=e.shape[0],r=e.shape[1];let s=ki(n),o=js(e);const a=_u([[1]],[1,1]);let i=js(a);const l=n>=r?r:n;for(let e=0;e<l;++e){const t=o,l=i,u=s;[i,o,s]=Wr.tidy((()=>{const t=Ma(o,[e,e],[n-e,1]),l=Ou(t),u=Ma(o,[e,e],[1,1]),c=ui(Si(u,0),_u([[-1]]),_u([[1]])),h=Wi(u,Qo(c,l)),d=Xo(t,h);i=1===d.shape[0]?js(a):_a([a,Ma(d,[1,0],[d.shape[0]-1,d.shape[1]])],0);const p=Li(Xo(uo(c,h),l)),f=Ma(o,[e,0],[n-e,r]),g=Qo(p,i),m=ho(i);if(0===e)o=Wi(f,uo(g,uo(m,f)));else{const t=Wi(f,uo(g,uo(m,f)));o=_a([Ma(o,[0,0],[e,r]),t],0)}const b=ho(g),y=Ma(s,[0,e],[n,s.shape[1]-e]);if(0===e)s=Wi(y,uo(uo(y,i),b));else{const t=Wi(y,uo(uo(y,i),b));s=_a([Ma(s,[0,0],[n,e]),t],1)}return[i,o,s]})),jo([t,l,u])}return!t&&n>r&&(s=Ma(s,[0,0],[n,r]),o=Ma(o,[0,0],[r,r])),[s,o]}))}const Rc=ts({qr_:function(e,t=!1){if(u(e.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`)),2===e.rank)return Dc(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce(((e,t)=>e*t)),r=Ru($a(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),s=[],o=[];r.forEach((e=>{const[n,r]=Dc(e,t);s.push(n),o.push(r)}));return[$a(Eu(s,0),e.shape),$a(Eu(o,0),e.shape)]}}});var Bc;e.Reduction=void 0,(Bc=e.Reduction||(e.Reduction={}))[Bc.NONE=0]="NONE",Bc[Bc.MEAN=1]="MEAN",Bc[Bc.SUM=2]="SUM",Bc[Bc.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS";const Fc=ts({computeWeightedLoss_:function(t,n,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const s=Xr(t,"losses","computeWeightedLoss");let o=null;null!=n&&(o=Xr(n,"weights","computeWeightedLoss"));const a=null==o?s:Qo(s,o);if(r===e.Reduction.NONE)return a;if(r===e.Reduction.SUM)return Gi(a);if(r===e.Reduction.MEAN){if(null==o)return sl(a);{const e=s.size/o.size,t=Xo(Gi(a),Gi(o));return e>1?Xo(t,ru(e)):t}}if(r===e.Reduction.SUM_BY_NONZERO_WEIGHTS){if(null==o)return Xo(Gi(a),ru(s.size));{const e=Qo(o,al(s.shape)),t=Hs(Gi(gl(e,ru(0))),"float32");return Xo(Gi(a),t)}}throw Error(`Unknown reduction: ${r}`)}});const Cc=ts({absoluteDifference_:function(t,n,r,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const o=Xr(t,"labels","absoluteDifference"),a=Xr(n,"predictions","absoluteDifference");let i=null;null!=r&&(i=Xr(r,"weights","absoluteDifference")),c(o.shape,a.shape,"Error in absoluteDifference: ");const l=ea(Wi(o,a));return Fc(l,i,s)}});const Pc=ts({cosineDistance_:function(t,n,r,s,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Xr(t,"labels","cosineDistance"),i=Xr(n,"predictions","cosineDistance");let l=null;null!=s&&(l=Xr(s,"weights","cosineDistance")),c(a.shape,i.shape,"Error in cosineDistance: ");const u=ru(1),h=Wi(u,Gi(Qo(a,i),r,!0));return Fc(h,l,o)}});const Oc=ts({hingeLoss_:function(t,n,r,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let o=Xr(t,"labels","hingeLoss");const a=Xr(n,"predictions","hingeLoss");let i=null;null!=r&&(i=Xr(r,"weights","hingeLoss")),c(o.shape,a.shape,"Error in hingeLoss: ");const l=ru(1);o=Wi(Qo(ru(2),o),l);const u=jl(Wi(l,Qo(o,a)));return Fc(u,i,s)}});const Lc=ts({huberLoss_:function(t,n,r,s=1,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Xr(t,"labels","huberLoss"),i=Xr(n,"predictions","huberLoss");let l=null;null!=r&&(l=Xr(r,"weights","huberLoss")),c(a.shape,i.shape,"Error in huberLoss: ");const u=ru(s),h=ea(Wi(i,a)),d=ll(h,u),p=Wi(h,d),f=Zo(Qo(ru(.5),hl(d)),Qo(u,p));return Fc(f,l,o)}});const zc=ts({logLoss_:function(t,n,r,s=1e-7,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Xr(t,"labels","logLoss"),i=Xr(n,"predictions","logLoss");let l=null;null!=r&&(l=Xr(r,"weights","logLoss")),c(a.shape,i.shape,"Error in logLoss: ");const u=ru(1),h=ru(s),d=Li(Qo(a,Bi(Zo(i,h)))),p=Qo(Wi(u,a),Bi(Zo(Wi(u,i),h))),f=Wi(d,p);return Fc(f,l,o)}});const qc=ts({meanSquaredError_:function(t,n,r,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const o=Xr(t,"labels","meanSquaredError"),a=Xr(n,"predictions","meanSquaredError");let i=null;null!=r&&(i=Xr(r,"weights","meanSquaredError")),c(o.shape,a.shape,"Error in meanSquaredError: ");const l=vu(o,a);return Fc(l,i,s)}});const Kc=ts({sigmoidCrossEntropy_:function(t,n,r,s=0,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let a=Xr(t,"multiClassLabels","sigmoidCrossEntropy");const i=Xr(n,"logits","sigmoidCrossEntropy");let l=null;if(null!=r&&(l=Xr(r,"weights","sigmoidCrossEntropy")),c(a.shape,i.shape,"Error in sigmoidCrossEntropy: "),s>0){const e=ru(s),t=ru(1),n=ru(.5);a=Zo(Qo(a,Wi(t,e)),Qo(n,e))}const u=function(e,t){const n=Xr(e,"labels","sigmoidCrossEntropyWithLogits"),r=Xr(t,"logits","sigmoidCrossEntropyWithLogits");c(n.shape,r.shape,"Error in sigmoidCrossEntropyWithLogits: ");const s=jl(r),o=Qo(r,n),a=Fi(mi(Li(ea(r))));return Zo(Wi(s,o),a)}(a,i);return Fc(u,l,o)}});const Wc=ts({softmaxCrossEntropy_:function(t,n,r,s=0,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let a=Xr(t,"onehotLabels","softmaxCrossEntropy");const i=Xr(n,"logits","softmaxCrossEntropy");let l=null;if(null!=r&&(l=Xr(r,"weights","softmaxCrossEntropy")),c(a.shape,i.shape,"Error in softmaxCrossEntropy: "),s>0){const e=ru(s),t=ru(1),n=ru(a.shape[1]);a=Zo(Qo(a,Wi(t,e)),Xo(e,n))}const u=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);return Pi(((e,t,r)=>{const s=Ji(t,[n],!0),o=Wi(Hs(t,"float32"),s);r([e,o]);const a=Li(Qo(o,e));return{value:Gi(a,[n]),gradFunc:(e,t)=>{const[r,s]=t,o=ji(e.shape,[n]);return[Qo($a(e,o),Wi(Hs(r,"float32"),mi(s))),Qo($a(e,o),Wi(mi(s),Hs(r,"float32")))]}}}))(e,t)}(a,i);return Fc(u,l,o)}});const Gc=ts({sparseFillEmptyRows_:function(e,t,n,r){const s=Xr(e,"indices","sparseFillEmptyRows","int32"),o=Xr(t,"values","sparseFillEmptyRows"),a=Xr(n,"denseShape","sparseFillEmptyRows","int32"),i=Xr(r,"defaultValue","sparseFillEmptyRows",o.dtype);if(2!==s.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==o.rank)throw new Error(`Values should be Tensor1D but received shape ${o.shape}`);if(1!==a.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${a.shape}`);if(0!==i.rank)throw new Error(`Default value should be a scalar but received shape ${i.shape}`);const l={indices:s,values:o,denseShape:a,defaultValue:i},u=Wr.runKernel(Vt,l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}});const Uc=ts({sparseReshape_:function(e,t,n){const r=Xr(e,"inputIndices","sparseReshape","int32"),s=Xr(t,"inputShape","sparseReshape","int32"),o=Xr(n,"newShape","sparseReshape","int32");if(2!==r.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==s.rank)throw new Error(`Input shape should be Tensor1D but received shape ${s.shape}`);if(1!==o.rank)throw new Error(`New shape should be Tensor1D but received shape ${o.shape}`);const a={inputIndices:r,inputShape:s,newShape:o},i=Wr.runKernel(Ht,a);return{outputIndices:i[0],outputShape:i[1]}}});const Vc=ts({sparseSegmentMean_:function(e,t,n){const r=Xr(e,"data","sparseSegmentMean"),s=Xr(t,"indices","sparseSegmentMean","int32"),o=Xr(n,"segmentIds","sparseSegmentMean","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${s.shape}`);if(1!==o.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${o.shape}`);const a={data:r,indices:s,segmentIds:o};return Wr.runKernel(jt,a)}});const Hc=ts({sparseSegmentSum_:function(e,t,n){const r=Xr(e,"data","sparseSegmentSum"),s=Xr(t,"indices","sparseSegmentSum","int32"),o=Xr(n,"segmentIds","sparseSegmentSum","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${s.shape}`);if(1!==o.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${o.shape}`);const a={data:r,indices:s,segmentIds:o};return Wr.runKernel(Jt,a)}});const jc=ts({stringNGrams_:function(e,t,n,r,s,o,a,i){const l=Xr(e,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=Xr(t,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const c={separator:n,nGramWidths:r,leftPad:s,rightPad:o,padWidth:a,preserveShortSequences:i},h={data:l,dataSplits:u},d=Wr.runKernel(Qt,h,c);return{nGrams:d[0],nGramsSplits:d[1]}}});const Jc=ts({stringSplit_:function(e,t,n=!0){const r=Xr(e,"input","stringSplit","string"),s=Xr(t,"delimiter","stringSplit","string");if(1!==r.rank)throw new Error(`Input should be Tensor1D but received shape ${r.shape}`);if(0!==s.rank)throw new Error(`Delimiter should be a scalar but received shape ${s.shape}`);const o={skipEmpty:n},a={input:r,delimiter:s},i=Wr.runKernel(en,a,o);return{indices:i[0],values:i[1],shape:i[2]}}});const Zc=ts({stringToHashBucketFast_:function(e,t){const n=Xr(e,"input","stringToHashBucketFast","string"),r={numBuckets:t};if(t<=0)throw new Error("Number of buckets must be at least 1");const s={input:n};return Wr.runKernel(tn,s,r)}}),Yc={fft:gu,ifft:mu,rfft:wu,irfft:bu},Xc={hammingWindow:nc,hannWindow:rc,frame:sc,stft:oc},Qc={flipLeftRight:ic,grayscaleToRGB:lc,resizeNearestNeighbor:Ic,resizeBilinear:Ac,rotateWithOffset:uc,cropAndResize:ac,nonMaxSuppression:hc,nonMaxSuppressionAsync:vc,nonMaxSuppressionWithScore:xc,nonMaxSuppressionWithScoreAsync:Ec,nonMaxSuppressionPadded:Sc,nonMaxSuppressionPaddedAsync:$c,threshold:_c,transform:Nc},eh={bandPart:Mc,gramSchmidt:Tc,qr:Rc},th={absoluteDifference:Cc,computeWeightedLoss:Fc,cosineDistance:Pc,hingeLoss:Oc,huberLoss:Lc,logLoss:zc,meanSquaredError:qc,sigmoidCrossEntropy:Kc,softmaxCrossEntropy:Wc},nh={sparseFillEmptyRows:Gc,sparseReshape:Uc,sparseSegmentMean:Vc,sparseSegmentSum:Hc},rh={stringNGrams:jc,stringSplit:Jc,stringToHashBucketFast:Zc};class sh extends Lo{minimize(e,t=!1,n){const{value:r,grads:s}=this.computeGradients(e,n);if(null!=n){const e=n.map((e=>({name:e.name,tensor:s[e.name]})));this.applyGradients(e)}else this.applyGradients(s);return jo(s),t?r:(r.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return Ci(e,t)}dispose(){null!=this.iterations_&&jo(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:ru(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty(sh,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class oh extends sh{constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Wr.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Wr.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${t}/accum_grad`,variable:Ho((()=>ci(r).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${t}/accum_var`,variable:Ho((()=>ci(r).variable(false)))});const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const o=this.accumulatedGrads[n].variable,a=this.accumulatedUpdates[n].variable;Ho((()=>{const e=Zo(Qo(o,this.rho),Qo(hl(s),1-this.rho)),t=Qo(Xo(ku(Zo(a,this.epsilon)),ku(Zo(o,this.epsilon))),s),n=Zo(Qo(a,this.rho),Qo(hl(t),1-this.rho));o.assign(e),a.assign(n);const i=Zo(Qo(t,-this.learningRate),r);r.assign(i)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(jo(this.accumulatedGrads.map((e=>e.variable))),jo(this.accumulatedUpdates.map((e=>e.variable))))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedUpdates=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}oh.className="Adadelta",qo(oh);class ah extends sh{constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Wr.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:`${t}/accumulator`,variable:Ho((()=>vi(r.shape,this.initialAccumulatorValue).variable(e)))}}const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const o=this.accumulatedGrads[n].variable;Ho((()=>{const e=Zo(o,hl(s));o.assign(e);const t=Zo(Qo(Xo(s,ku(Zo(e,Wr.backend.epsilon()))),-this.learningRate),r);r.assign(t)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&jo(this.accumulatedGrads.map((e=>e.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}ah.className="Adagrad",qo(ah);class ih extends sh{constructor(e,t,n,r=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],Ho((()=>{this.accBeta1=ru(t).variable(),this.accBeta2=ru(n).variable()})),null==r&&(this.epsilon=Wr.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);Ho((()=>{const n=Wi(1,this.accBeta1),r=Wi(1,this.accBeta2);t.forEach(((t,s)=>{const o=Wr.registeredVariables[t];null==this.accumulatedFirstMoment[s]&&(this.accumulatedFirstMoment[s]={originalName:`${t}/m`,variable:Ho((()=>ci(o).variable(false)))}),null==this.accumulatedSecondMoment[s]&&(this.accumulatedSecondMoment[s]={originalName:`${t}/v`,variable:Ho((()=>ci(o).variable(false)))});const a=Array.isArray(e)?e[s].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[s].variable,l=this.accumulatedSecondMoment[s].variable,u=Zo(Qo(i,this.beta1),Qo(a,1-this.beta1)),c=Zo(Qo(l,this.beta2),Qo(hl(a),1-this.beta2)),h=Xo(u,n),d=Xo(c,r);i.assign(u),l.assign(c);const p=Zo(Qo(Xo(h,Zo(ku(d),this.epsilon)),-this.learningRate),o);o.assign(p)})),this.accBeta1.assign(Qo(this.accBeta1,this.beta1)),this.accBeta2.assign(Qo(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&jo(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedSecondMoment&&jo(this.accumulatedSecondMoment.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e),Ho((()=>{this.accBeta1.assign($l(this.beta1,this.iterations_+1)),this.accBeta2.assign($l(this.beta2,this.iterations_+1))}));const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedSecondMoment=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}ih.className="Adam",qo(ih);class lh extends sh{constructor(e,t,n,r=null,s=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.decay=s,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],Ho((()=>{this.iteration=ru(0).variable(),this.accBeta1=ru(t).variable()})),null==r&&(this.epsilon=Wr.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);Ho((()=>{const n=Wi(1,this.accBeta1),r=Xo(-this.learningRate,Zo(Qo(this.iteration,this.decay),1));t.forEach(((t,s)=>{const o=Wr.registeredVariables[t];null==this.accumulatedFirstMoment[s]&&(this.accumulatedFirstMoment[s]={originalName:`${t}/m`,variable:ci(o).variable(false)}),null==this.accumulatedWeightedInfNorm[s]&&(this.accumulatedWeightedInfNorm[s]={originalName:`${t}/v`,variable:ci(o).variable(false)});const a=Array.isArray(e)?e[s].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[s].variable,l=this.accumulatedWeightedInfNorm[s].variable,u=Zo(Qo(i,this.beta1),Qo(a,1-this.beta1)),c=Qo(l,this.beta2),h=ea(a),d=rl(c,h);i.assign(u),l.assign(d);const p=Zo(Qo(Xo(r,n),Xo(u,Zo(d,this.epsilon))),o);o.assign(p)})),this.iteration.assign(Zo(this.iteration,1)),this.accBeta1.assign(Qo(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&jo(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedWeightedInfNorm&&jo(this.accumulatedWeightedInfNorm.map((e=>e.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}lh.className="Adamax",qo(lh);class uh extends sh{constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const s=Wr.registeredVariables[t];Ho((()=>{const e=Zo(Qo(this.c,r),s);s.assign(e)}))})),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=Jo(ru(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}uh.className="SGD",qo(uh);class ch extends uh{constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=ru(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Wr.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:`${t}/momentum`,variable:Ho((()=>ci(r).variable(e)))}}const s=this.accumulations[n].variable,o=Array.isArray(e)?e[n].tensor:e[t];null!=o&&Ho((()=>{let e;const t=Zo(Qo(this.m,s),o);e=this.useNesterov?Zo(Qo(this.c,Zo(o,Qo(t,this.m))),r):Zo(Qo(this.c,t),r),s.assign(t),r.assign(e)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&jo(this.accumulations.map((e=>e.variable)))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}ch.className="Momentum",qo(ch);class hh extends sh{constructor(e,t=.9,n=0,r=null,s=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=r,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=s,null==r&&(this.epsilon=Wr.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Wr.registeredVariables[t],s=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${t}/rms`,variable:Ho((()=>ci(r).variable(s)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${t}/momentum`,variable:Ho((()=>ci(r).variable(s)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${t}/mg`,variable:Ho((()=>ci(r).variable(s)))});const o=Array.isArray(e)?e[n].tensor:e[t];if(null==o)return;const a=this.accumulatedMeanSquares[n].variable,i=this.accumulatedMoments[n].variable;Ho((()=>{const e=Zo(Qo(a,this.decay),Qo(hl(o),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,s=Zo(Qo(t,this.decay),Qo(o,1-this.decay)),l=Xo(Qo(o,this.learningRate),ku(Wi(e,Zo(hl(s),this.epsilon)))),u=Zo(Qo(i,this.momentum),l);a.assign(e),t.assign(s),i.assign(u);const c=Wi(r,u);r.assign(c)}else{const e=Zo(Qo(a,this.decay),Qo(hl(o),1-this.decay)),t=Zo(Qo(i,this.momentum),Xo(Qo(o,this.learningRate),ku(Zo(e,this.epsilon))));a.assign(e),i.assign(t);const n=Wi(r,t);r.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&jo(this.accumulatedMeanSquares.map((e=>e.variable))),null!=this.accumulatedMeanGrads&&this.centered&&jo(this.accumulatedMeanGrads.map((e=>e.variable))),null!=this.accumulatedMoments&&jo(this.accumulatedMoments.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2,n=!1;this.accumulatedMeanSquares=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.accumulatedMoments=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}hh.className="RMSProp",qo(hh);class dh{static sgd(e){return new uh(e)}static momentum(e,t,n=!1){return new ch(e,t,n)}static rmsprop(e,t=.9,n=0,r=null,s=!1){return new hh(e,t,n,r,s)}static adam(e=.001,t=.9,n=.999,r=null){return new ih(e,t,n,r)}static adadelta(e=.001,t=.95,n=null){return new oh(e,t,n)}static adamax(e=.002,t=.9,n=.999,r=null,s=0){return new lh(e,t,n,r,s)}static adagrad(e,t=.1){return new ah(e,t)}}const ph={sgd:dh.sgd,momentum:dh.momentum,adadelta:dh.adadelta,adagrad:dh.adagrad,rmsprop:dh.rmsprop,adamax:dh.adamax,adam:dh.adam},fh="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();const gh="->",mh=/->/g;function bh(e,t){const n=[];for(let r=0;r<e.length;++r)0!==e[r].length&&-1===e[r].indexOf(t)&&-1!==t||n.push(r);return n}var yh={__proto__:null,slice_util:Oo,segment_util:{__proto__:null,segOpComputeOptimalWindowSize:function(e,t){let n,r=!1;for(e<=30?(n=e,r=!0):n=T(e,Math.floor(Math.sqrt(e)));!r;)n>t||n===e?r=!0:n=T(e,n+1);return n},computeOutShape:function(e,t,n){const r=[],s=e.length;for(let o=0;o<s;o++)o!==t?r.push(e[o]):r.push(n);return r},collectGatherOpShapeInfo:function(e,t,n,r){const s=t.shape.length,o=e.shape.length;if(0!==r&&(r<-s||r>s))throw new Error(`Expect batchDims in the range of [-${s}, ${s}], but got ${r}`);if(r<0&&(r+=s),r>o)throw new Error(`batchDims (${r}) must be less than rank(x) (\n    ${o}).`);if(n<r)throw new Error(`batchDims (${r}) must be less than or equal to axis (${n}).`);for(let n=0;n<r;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const a=e.shape[n],i=[];let l=1,u=1,c=1;for(let t=0;t<r;++t)i.push(e.shape[t]),l*=e.shape[t];for(let t=r;t<n;t++)i.push(e.shape[t]),u*=e.shape[t];for(let e=r;e<s;e++)i.push(t.shape[e]);for(let t=n+1;t<o;t++)i.push(e.shape[t]),c*=e.shape[t];return{batchSize:l,sliceSize:c,outerSize:u,dimSize:a,outputShape:i}}},fromUint8ToStringArray:function(e){try{return e.map((e=>dr(e)))}catch(e){throw new Error(`Failed to decode encoded string bytes into utf-8, error: ${e}`)}},fromStringArrayToUint8:function(e){return e.map((e=>hr(e)))},upcastType:Rr,axesAreInnerMostDims:Vi,combineLocations:Hi,computeOutAndReduceShapes:function(e,t){const n=[],r=e.length;for(let s=0;s<r;s++)-1===t.indexOf(s)&&n.push(e[s]);return[n,t.map((t=>e[t]))]},expandShapeToKeepDim:ji,assertAxesAreInnerMostDims:function(e,t,n){u(Vi(t,n),(()=>`${e} supports only inner-most axes for now. Got axes ${t} and rank-${n} input.`))},getAxesPermutation:function(e,t){if(Vi(e,t))return null;const n=[];for(let r=0;r<t;++r)-1===e.indexOf(r)&&n.push(r);return e.forEach((e=>n.push(e))),n},getUndoAxesPermutation:function(e){return e.map(((e,t)=>[t,e])).sort(((e,t)=>e[1]-t[1])).map((e=>e[0]))},getInnerMostAxes:function(e,t){const n=[];for(let r=t-e;r<t;++r)n.push(r);return n},getBroadcastDims:fo,getReductionAxes:go,assertAndGetBroadcastShape:mo,assertParamsConsistent:function(e,t){const n=e[0].length;e.forEach(((e,t)=>{u(e.length===n,(()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`))})),u(t>=0&&t<n,(()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`));const r=e[0];e.forEach(((e,s)=>{for(let o=0;o<n;o++)u(o===t||e[o]===r[o],(()=>`Error in concat${n}D: Shape of tensors[${s}] (${e}) does not match the shape of the rest (${r}) along the non-concatenated axis ${s}.`))}))},computeOutShape:function(e,t){const n=e[0].slice();for(let r=1;r<e.length;r++)n[t]+=e[r][t];return n},computeDilation2DInfo:function(e,t,n,r,s="NHWC",o){return fa(e,[...t,e[3]],n,o,r,null,null,Ea(s))},computePool2DInfo:pa,computePool3DInfo:function(e,t,n,r,s,o,a="NDHWC"){const[i,l,u]=ya(t);let c,h;if("NDHWC"===a)h="channelsLast",c=[i,l,u,e[4],e[4]];else{if("NCDHW"!==a)throw new Error(`Unknown dataFormat ${a}`);h="channelsFirst",c=[i,l,u,e[1],e[1]]}return ga(e,c,n,r,s,!1,h,o)},computeConv2DInfo:fa,computeConv3DInfo:ga,computeDefaultPad:ma,tupleValuesAreOne:va,eitherStridesOrDilationsAreOne:xa,convertConv2DDataFormat:Ea,checkPadOnDimRoundingMode:Sa,getFusedDyActivation:ju,getFusedBiasGradient:Ju,applyActivation:Zu,shouldFuse:Yu,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:function(e){return e<=30?e:T(e,Math.floor(Math.sqrt(e)))},getImageCenter:function(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]},getReshaped:function(e,t,n,r=!0){let s=[];if(r)s=s.concat(t.slice(0)),s.push(e[0]/n),s=s.concat(e.slice(1));else{s=s.concat(e[0]);const n=t.length;for(let r=0;r<n;++r)s=s.concat([e[r+1]/t[r],t[r]]);s=s.concat(e.slice(n+1))}return s},getPermuted:function(e,t,n=!0){const r=[];if(n){r.push(t);for(let n=t+1;n<e;++n)n<=2*t?(r.push(n),r.push(n-(t+1))):r.push(n)}else{const n=[],s=[];for(let r=1;r<e;++r)r>=2*t+1||r%2==1?s.push(r):n.push(r);r.push(...n),r.push(0),r.push(...s)}return r},getReshapedPermuted:function(e,t,n,r=!0){const s=[];r?s.push(e[0]/n):s.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?r?s.push(t[n-1]*e[n]):s.push(e[n]/t[n-1]):s.push(e[n]);return s},getSliceBeginCoords:function(e,t){const n=[0];for(let r=0;r<t;++r)n.push(e[r][0]);return n},getSliceSize:function(e,t,n){const r=e.slice(0,1);for(let s=0;s<n;++s)r.push(e[s+1]-t[s][0]-t[s][1]);return r},prepareAndValidate:Eo,validateUpdateShape:$o,validateInput:Ao,calculateShapes:Io,SELU_SCALEALPHA:1.7580993408473768,SELU_SCALE:1.0507009873554805,ERF_P:.3275911,ERF_A1:.254829592,ERF_A2:-.284496736,ERF_A3:1.421413741,ERF_A4:-1.453152027,ERF_A5:1.061405429,warn:yn,log:function(...e){K().getBool("IS_TEST")||K().getBool("PROD")||console.log(...e)},mergeRealAndImagArrays:function(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let r=0;r<n.length;r+=2)n[r]=e[r/2],n[r+1]=t[r/2];return n},splitRealAndImagArrays:function(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let r=0;r<e.length;r+=2)t[r/2]=e[r],n[r/2]=e[r+1];return{real:t,imag:n}},complexWithEvenIndex:function(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},complexWithOddIndex:function(e){const t=Math.floor(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},getComplexWithIndex:function(e,t){return{real:e[2*t],imag:e[2*t+1]}},assignToTypedArray:function(e,t,n,r){e[2*r]=t,e[2*r+1]=n},exponents:function(e,t){const n=new Float32Array(e/2),r=new Float32Array(e/2);for(let s=0;s<Math.ceil(e/2);s++){const o=(t?2:-2)*Math.PI*(s/e);n[s]=Math.cos(o),r[s]=Math.sin(o)}return{real:n,imag:r}},exponent:function(e,t,n){const r=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(r),imag:Math.sin(r)}},decodeEinsumEquation:function(e,t){const n=((e=e.replace(/\s/g,"")).length-e.replace(mh,"").length)/gh.length;if(n<1)throw new Error("Equations without an arrow are not supported.");if(n>1)throw new Error('Equation must contain exactly one arrow ("->").');const[r,s]=e.split(gh);u(-1===r.indexOf("..."),(()=>'The ellipsis notation ("...") is not supported yet.'));const o=r.split(","),a=o.length;if(t!==a)throw new Error(`Expected ${a} input tensors, received ${t}`);if(a>2)throw new Error("Support for more than 2 input tensors is not implemented yet.");const i=[];for(let e=0;e<s.length;++e){const t=s[e];if(!o.some((e=>-1!==e.indexOf(t))))throw new Error(`Output subscripts contain the label ${t} not present in the input subscripts.`);-1===i.indexOf(t)&&i.push(t)}for(let e=0;e<r.length;++e){const t=r[e];-1===i.indexOf(t)&&","!==t&&i.push(t)}const l=new Array(o.length);for(let e=0;e<a;++e){if(new Set(o[e].split("")).size!==o[e].length)throw new Error(`Found duplicate axes in input component ${o[e]}. Support for duplicate axes in input is not implemented yet.`);l[e]=[];for(let t=0;t<o[e].length;++t)l[e].push(i.indexOf(o[e][t]))}const c=i.length,h=[];for(let e=s.length;e<c;++e)h.push(e);return{allDims:i,summedDims:h,idDims:l}},getEinsumPermutation:function(e,t){let n=new Array(e);n.fill(-1);for(let e=0;e<t.length;++e)n[t[e]]=e;const r=[];for(let t=0;t<e;++t)-1===n[t]&&r.push(t);return n=n.filter((e=>-1!==e)),{permutationIndices:n,expandDims:r}},checkEinsumDimSizes:function(e,t,n){const r=new Array(e);for(let e=0;e<n.length;++e){const s=n[e].shape;for(let n=0;n<t[e].length;++n)void 0===r[t[e][n]]?r[t[e][n]]=s[n]:u(r[t[e][n]]===s[n],(()=>`Expected dimension ${r[t[e][n]]} at axis ${n} of input shaped ${JSON.stringify(s)}, but got dimension ${s[n]}`))}},getEinsumComputePath:function(e,t){const n=e,r=[];let s=0;0===e.length&&n.push(-1),s=e.length+1;for(let e=0;e<s;++e)r.push([]);const o=[];for(let e=0;e<n.length;++e){const s=bh(t,n[e]);for(const t of s)-1===o.indexOf(t)&&(r[e].push(t),o.push(t))}return{path:n,steps:r}},isIdentityPermutation:function(e){return e.every(((e,t)=>e===t))},prepareSplitSize:function(e,t,n=0){let r=[];if("number"==typeof t)u(e.shape[n]%t==0,(()=>"Number of splits must evenly divide the axis.")),r=new Array(t).fill(e.shape[n]/t);else{u(t.reduce(((e,t)=>(-1===t&&(e+=1),e)),0)<=1,(()=>"There should be only one negative value in split array."));const s=t.indexOf(-1);if(-1!==s){const r=t.reduce(((e,t)=>t>0?e+t:e));t[s]=e.shape[n]-r}u(e.shape[n]===t.reduce(((e,t)=>e+t)),(()=>"The sum of sizes must match the size of the axis dimension.")),r=t}return r},getSparseFillEmptyRowsIndicesDenseShapeMismatch:function(e){return`Received SparseTensor with denseShape[0] = 0 but\n  indices.shape[0] = ${e}`},getSparseFillEmptyRowsNegativeIndexErrorMessage:function(e,t){return`indices(${e}, 0) is invalid: ${t} < 0`},getSparseFillEmptyRowsOutOfRangeIndexErrorMessage:function(e,t,n){return`indices(${e}, 0) is invalid: ${t} >= ${n}`},getSparseReshapeMultipleNegativeOneOutputDimErrorMessage:function(e,t){return`only one output dimension may be -1, not both ${e} and ${t}`},getSparseReshapeNegativeOutputDimErrorMessage:function(e,t){return`size ${e} must be non-negative, not ${t}`},getSparseReshapeEmptyTensorZeroOutputDimErrorMessage:function(){return"reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero"},getSparseReshapeInputOutputMultipleErrorMessage:function(e,t){return`Input to reshape is a SparseTensor with ${p(e)}\n  dense values, but the requested shape requires a multiple of ${p(t)}. inputShape=${e} outputShape= ${t}`},getSparseReshapeInputOutputMismatchErrorMessage:function(e,t){return`Input to reshape is a tensor with ${p(e)} dense values, but the requested shape has ${p(t)}. inputShape=${e} outputShape=${t}`},getSparseSegmentReductionNegativeSegmentIdsErrorMessage:function(){return"segment ids must be >= 0"},getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage:function(){return"segment ids are not increasing"},getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage:function(e,t){return`Segment id ${e} out of range [0, ${t}), possibly because segmentIds input is not sorted.`},getSparseSegmentReductionIndicesOutOfRangeErrorMessage:function(e,t,n){return`Bad: indices[${e}] == ${t} out of range [0, ${n})`}},wh={__proto__:null,nonMaxSuppressionV3Impl:fc,nonMaxSuppressionV4Impl:gc,nonMaxSuppressionV5Impl:mc,whereImpl:Bu};e.Abs="Abs",e.Acos=V,e.Acosh=H,e.AdadeltaOptimizer=oh,e.AdagradOptimizer=ah,e.AdamOptimizer=ih,e.AdamaxOptimizer=lh,e.Add=j,e.AddN=J,e.All="All",e.Any="Any",e.ArgMax=Z,e.ArgMin=Y,e.Asin=X,e.Asinh=Q,e.Atan=ee,e.Atan2=ne,e.Atanh=te,e.AvgPool=re,e.AvgPool3D=se,e.AvgPool3DGrad="AvgPool3DGrad",e.AvgPoolGrad="AvgPoolGrad",e.BatchMatMul=oe,e.BatchToSpaceND=ae,e.Bincount=ie,e.BroadcastArgs=le,e.BroadcastTo="BroadcastTo",e.Cast=ue,e.Ceil=ce,e.ClipByValue=he,e.Complex=de,e.ComplexAbs=pe,e.Concat=fe,e.Conv2D=ge,e.Conv2DBackpropFilter=me,e.Conv2DBackpropInput=be,e.Conv3D=ye,e.Conv3DBackpropFilterV2="Conv3DBackpropFilterV2",e.Conv3DBackpropInputV2=we,e.Cos="Cos",e.Cosh=ke,e.CropAndResize=xe,e.Cumsum=ve,e.DataStorage=class{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}},e.DenseBincount=Ee,e.DepthToSpace=Se,e.DepthwiseConv2dNative=$e,e.DepthwiseConv2dNativeBackpropFilter=Ae,e.DepthwiseConv2dNativeBackpropInput=Ie,e.Diag=_e,e.Dilation2D=Ne,e.Dilation2DBackpropFilter="Dilation2DBackpropFilter",e.Dilation2DBackpropInput="Dilation2DBackpropInput",e.Einsum=Te,e.Elu="Elu",e.EluGrad="EluGrad",e.Environment=z,e.Equal=De,e.Erf="Erf",e.Exp="Exp",e.ExpandDims=Re,e.Expm1=Be,e.FFT="FFT",e.Fill=Fe,e.FlipLeftRight=Ce,e.Floor=Pe,e.FloorDiv=Oe,e.FromPixels=pn,e.FusedBatchNorm=Le,e.FusedConv2D=mn,e.FusedDepthwiseConv2D=bn,e.GatherNd=qe,e.GatherV2=ze,e.Greater=Ke,e.GreaterEqual=We,e.IFFT=Ue,e.Identity=Ge,e.Imag=Ve,e.IsFinite=He,e.IsInf=je,e.IsNan=Je,e.KernelBackend=s,e.LRN="LRN",e.LRNGrad="LRNGrad",e.LeakyRelu=Ze,e.Less=Ye,e.LessEqual=Xe,e.LinSpace=Qe,e.Log="Log",e.Log1p=et,e.LogSoftmax="LogSoftmax",e.LogicalAnd=tt,e.LogicalNot=nt,e.LogicalOr=rt,e.Max="Max",e.MaxPool=ot,e.MaxPool3D=at,e.MaxPool3DGrad="MaxPool3DGrad",e.MaxPoolGrad="MaxPoolGrad",e.MaxPoolWithArgmax=it,e.Maximum=st,e.Mean=lt,e.Min="Min",e.Minimum=ut,e.MirrorPad=ct,e.Mod="Mod",e.MomentumOptimizer=ch,e.Multinomial=ht,e.Multiply=dt,e.Neg="Neg",e.NonMaxSuppressionV3=ft,e.NonMaxSuppressionV4=gt,e.NonMaxSuppressionV5=mt,e.NotEqual=pt,e.OP_SCOPE_SUFFIX=es,e.OneHot=yt,e.OnesLike=bt,e.Optimizer=sh,e.OptimizerConstructors=dh,e.Pack=wt,e.PadV2=kt,e.Pool="Pool",e.Pow="Pow",e.Prelu=vt,e.Prod=xt,e.RMSPropOptimizer=hh,e.Range=Et,e.Real=St,e.RealDiv=Me,e.Reciprocal=$t,e.Relu=At,e.Relu6=Mt,e.Reshape=It,e.ResizeBilinear=Nt,e.ResizeBilinearGrad="ResizeBilinearGrad",e.ResizeNearestNeighbor=_t,e.ResizeNearestNeighborGrad="ResizeNearestNeighborGrad",e.Reverse=Tt,e.RotateWithOffset=fn,e.Round=Dt,e.Rsqrt=Rt,e.SGDOptimizer=uh,e.ScatterNd=Bt,e.Select=Ft,e.Selu=Ct,e.Sigmoid=zt,e.Sign=Lt,e.Sin="Sin",e.Sinh=Ot,e.Slice=Pt,e.Softmax=Ut,e.Softplus=qt,e.SpaceToBatchND=Wt,e.SparseFillEmptyRows=Vt,e.SparseReshape=Ht,e.SparseSegmentMean=jt,e.SparseSegmentSum=Jt,e.SparseToDense=Zt,e.SplitV=Gt,e.Sqrt=Kt,e.Square="Square",e.SquaredDifference=Yt,e.Step=dn,e.StridedSlice=Xt,e.StringNGrams=Qt,e.StringSplit=en,e.StringToHashBucketFast=tn,e.Sub="Sub",e.Sum="Sum",e.Tan="Tan",e.Tanh=nn,e.Tensor=$r,e.TensorBuffer=xr,e.Tile=rn,e.TopK=sn,e.Transform=on,e.Transpose=an,e.Unique=ln,e.Unpack=un,e.UnsortedSegmentSum=cn,e.Variable=Ar,e.ZerosLike=hn,e._FusedMatMul=gn,e.abs=ea,e.acos=ta,e.acosh=na,e.add=Zo,e.addN=ra,e.all=sa,e.any=oa,e.argMax=aa,e.argMin=ia,e.asin=la,e.asinh=ua,e.atan=ca,e.atan2=ha,e.atanh=da,e.avgPool=Aa,e.avgPool3d=Ia,e.backend=function(){return Wr.backend},e.backend_util=yh,e.basicLSTMCell=Da,e.batchNorm=Ba,e.batchNorm2d=Fa,e.batchNorm3d=Ca,e.batchNorm4d=Pa,e.batchToSpaceND=Ra,e.bincount=Oa,e.booleanMaskAsync=Cu,e.broadcastArgs=La,e.broadcastTo=za,e.broadcast_util=bo,e.browser=xo,e.buffer=Vs,e.cast=Hs,e.ceil=qa,e.clipByValue=Ka,e.clone=js,e.complex=ns,e.concat=_a,e.concat1d=Wa,e.concat2d=Ga,e.concat3d=Ua,e.concat4d=Va,e.conv1d=ja,e.conv2d=Ha,e.conv2dTranspose=Za,e.conv3d=Ya,e.conv3dTranspose=Qa,e.copyRegisteredKernels=function(e,t){En(e).forEach((e=>{Sn(Object.assign({},e,{backendName:t}))}))},e.cos=ei,e.cosh=ti,e.cosineWindow=Uu,e.cumsum=ni,e.customGrad=Pi,e.denseBincount=ri,e.deprecationWarn=function(e){K().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")},e.depthToSpace=si,e.depthwiseConv2d=oi,e.device_util=Hr,e.diag=ai,e.dilation2d=ii,e.disableDeprecationWarnings=function(){K().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")},e.dispose=jo,e.disposeVariables=function(){Wr.disposeVariables()},e.div=Xo,e.divNoNan=hi,e.dot=di,e.dropout=Wu,e.einsum=pi,e.elu=fi,e.enableDebugMode=function(){K().set("DEBUG",!0)},e.enableProdMode=function(){K().set("PROD",!0)},e.enclosingPowerOfTwo=Gu,e.engine=function(){return Wr},e.env=K,e.equal=li,e.erf=gi,e.exp=mi,e.expandDims=bi,e.expm1=yi,e.eye=ki,e.fft=gu,e.fill=vi,e.findBackend=function(e){return Wr.findBackend(e)},e.findBackendFactory=function(e){return Wr.findBackendFactory(e)},e.floor=xi,e.floorDiv=Yo,e.fused=tc,e.gather=Ei,e.gatherND=Ku,e.gather_util=So,e.getBackend=function(){return Wr.backendName},e.getGradient=xn,e.getKernel=vn,e.getKernelsForBackend=En,e.grad=function(e){return u(M(e),(()=>"The f passed in grad(f) must be a function")),(t,n)=>{const r=Xr(t,"x","tf.grad","string_or_numeric"),s=null!=n?Xr(n,"dy","tf.grad"):null;return Wr.tidy((()=>{const{value:t,grads:n}=Wr.gradients((()=>e(r)),[r],s);return null!=s&&c(t.shape,s.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),Oi(n),n[0]}))}},e.grads=function(e){return u(M(e),(()=>"The f passed in grads(f) must be a function")),(t,n)=>{u(Array.isArray(t),(()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s"));const r=Qr(t,"args","tf.grads","string_or_numeric"),s=null!=n?Xr(n,"dy","tf.grads"):null;return Wr.tidy((()=>{const{value:t,grads:n}=Wr.gradients((()=>e(...r)),r,s);return null!=s&&c(t.shape,s.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),Oi(n),n}))}},e.greater=Si,e.greaterEqual=$i,e.ifft=mu,e.imag=Ai,e.image=Qc,e.inTopKAsync=Vu,e.io=lo,e.irfft=bu,e.isFinite=Ii,e.isInf=_i,e.isNaN=Ni,e.keep=Jo,e.kernel_impls=wh,e.leakyRelu=Mi,e.less=Ti,e.lessEqual=Di,e.linalg=eh,e.linspace=function(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const r={start:e,stop:t,num:n};return Wr.runKernel(Qe,{},r)},e.localResponseNormalization=Ri,e.log=Bi,e.log1p=Fi,e.logSigmoid=qi,e.logSoftmax=Ui,e.logSumExp=Ji,e.logicalAnd=Zi,e.logicalNot=Yi,e.logicalOr=Xi,e.logicalXor=Qi,e.losses=th,e.matMul=uo,e.math=po,e.max=Ki,e.maxPool=el,e.maxPool3d=tl,e.maxPoolWithArgmax=nl,e.maximum=rl,e.mean=sl,e.memory=function(){return Wr.memory()},e.meshgrid=function(e,t,{indexing:n="xy"}={}){if("xy"!==n&&"ij"!==n)throw new TypeError(`${n} is not a valid third argument to meshgrid`);if(void 0===e)return[];let r=Xr(e,"x","meshgrid",e instanceof $r?e.dtype:"float32");if(void 0===t)return[r];let s=Xr(t,"y","meshgrid",t instanceof $r?t.dtype:"float32");const o=p(r.shape),a=p(s.shape);return"xy"===n?(r=$a(r,[1,-1]),s=$a(s,[-1,1]),[uo(al([a,1],r.dtype),r),uo(s,al([1,o],s.dtype))]):(r=$a(r,[-1,1]),s=$a(s,[1,-1]),[uo(r,al([1,a],r.dtype)),uo(al([o,1],s.dtype),s)])},e.min=il,e.minimum=ll,e.mirrorPad=ul,e.mod=cl,e.moments=dl,e.movingAverage=Lu,e.mul=Qo,e.multiRNNCell=pl,e.multinomial=fl,e.neg=Li,e.nextFrame=function(){return new Promise((e=>fh((()=>e()))))},e.norm=Ou,e.notEqual=gl,e.oneHot=co,e.ones=al,e.onesLike=ml,e.op=ts,e.outerProduct=bl,e.pad=yl,e.pad1d=wl,e.pad2d=kl,e.pad3d=vl,e.pad4d=xl,e.pool=Sl,e.pow=$l,e.prelu=Al,e.print=Js,e.prod=Il,e.profile=function(e){return Wr.profile(e)},e.rand=_l,e.randomGamma=Kl,e.randomNormal=Wl,e.randomUniform=Gl,e.range=Ul,e.ready=function(){return Wr.ready()},e.real=Vl,e.reciprocal=Hl,e.registerBackend=function(e,t,n=1){return Wr.registerBackend(e,t,n)},e.registerGradient=function(e){const{kernelName:t}=e;kn.has(t)&&K().getBool("DEBUG")&&yn(`Overriding the gradient for '${t}'`),kn.set(t,e)},e.registerKernel=Sn,e.relu=jl,e.relu6=Jl,e.removeBackend=function(e){Wr.removeBackend(e)},e.reshape=$a,e.reverse=Zl,e.reverse1d=Yl,e.reverse2d=Xl,e.reverse3d=Ql,e.reverse4d=eu,e.rfft=wu,e.round=tu,e.rsqrt=nu,e.scalar=ru,e.scatterND=zu,e.scatter_util=_o,e.selu=su,e.separableConv2d=ou,e.serialization=Ko,e.setBackend=function(e){return Wr.setBackend(e)},e.setPlatform=function(e,t){K().setPlatform(e,t)},e.setdiff1dAsync=au,e.sigmoid=Na,e.sign=iu,e.signal=Xc,e.sin=lu,e.sinh=uu,e.slice=Ma,e.slice1d=cu,e.slice2d=hu,e.slice3d=du,e.slice4d=pu,e.slice_util=Oo,e.softmax=fu,e.softplus=zi,e.spaceToBatchND=El,e.sparse=nh,e.sparseToDense=qu,e.spectral=Yc,e.split=yu,e.sqrt=ku,e.square=hl,e.squaredDifference=vu,e.squeeze=xu,e.stack=Eu,e.step=Su,e.stridedSlice=$u,e.string=rh,e.sub=Wi,e.sum=Gi,e.sumOutType=function(e){return Rr(e,"int32")},e.tan=Au,e.tanh=Ta,e.tensor=ss,e.tensor1d=Iu,e.tensor2d=_u,e.tensor3d=yo,e.tensor4d=function(e,t,n){if(h(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const r=Jr(e,n);if(4!==r.length&&1!==r.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return rs(e,t,r,n)},e.tensor5d=function(e,t,n){if(h(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const r=Jr(e,n);if(5!==r.length&&1!==r.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return rs(e,t,r,n)},e.tensor6d=function(e,t,n){if(h(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const r=Jr(e,n);if(6!==r.length&&1!==r.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return rs(e,t=t||r,r,n)},e.tensor_util=Or,e.test_util=Vo,e.tidy=Ho,e.tile=wi,e.time=function(e){return Wr.time(e)},e.topk=Nu,e.train=ph,e.transpose=ho,e.truncatedNormal=Mu,e.unique=Tu,e.unregisterGradient=function(e){if(!kn.has(e))throw new Error(`The gradient '${e}' for backend is not registered`);kn.delete(e)},e.unregisterKernel=function(e,t){const n=$n(e,t);if(!wn.has(n))throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);wn.delete(n)},e.unsortedSegmentSum=Du,e.unstack=Ru,e.upcastType=Rr,e.util=pr,e.valueAndGrad=function(e){return u(M(e),(()=>"The f passed in valueAndGrad(f) must be a function")),(t,n)=>{u(t instanceof $r,(()=>"The x passed in valueAndGrad(f)(x) must be a tensor")),u(null==n||n instanceof $r,(()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor"));const{grads:r,value:s}=Wr.gradients((()=>e(t)),[t],n);return Oi(r),{grad:r[0],value:s}}},e.valueAndGrads=function(e){return u(M(e),(()=>"The f passed in valueAndGrads(f) must be a function")),(t,n)=>{u(Array.isArray(t)&&t.every((e=>e instanceof $r)),(()=>"The args passed in valueAndGrads(f)(args) must be array of tensors")),u(null==n||n instanceof $r,(()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor"));const r=Wr.gradients((()=>e(...t)),t,n);return null!=n&&c(r.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),Oi(r.grads),r}},e.variable=function(e,t=!0,n,r){return Wr.makeVariable(e,t,n,r)},e.variableGrads=Ci,e.version_core="3.13.0",e.where=ui,e.whereAsync=Fu,e.zeros=ol,e.zerosLike=ci,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-core.es2017.min.js.map
