"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true,
});
exports.indexPageMiddleware = exports.createDevServerMiddleware = void 0;
const debug = require("debug")("ReactNative:CommunityCliPlugin");
const noopNextHandle = (req, res, next) => {
  next();
};
const unusedStubWSServer = {};
const unusedMiddlewareStub = {};
const communityMiddlewareFallback = {
  createDevServerMiddleware: (params) => ({
    middleware: unusedMiddlewareStub,
    websocketEndpoints: {},
    messageSocketEndpoint: {
      server: unusedStubWSServer,
      broadcast: (method, _params) => {},
    },
    eventsSocketEndpoint: {
      server: unusedStubWSServer,
      reportEvent: (event) => {},
    },
  }),
  indexPageMiddleware: noopNextHandle,
};
try {
  const communityCliPath = require.resolve("@react-native-community/cli");
  const communityCliServerApiPath = require.resolve(
    "@react-native-community/cli-server-api",
    {
      paths: [communityCliPath],
    }
  );
  const communityCliServerApi = require(communityCliServerApiPath);
  communityMiddlewareFallback.createDevServerMiddleware =
    communityCliServerApi.createDevServerMiddleware;
  communityMiddlewareFallback.indexPageMiddleware =
    communityCliServerApi.indexPageMiddleware;
} catch {
  debug(`⚠️ Unable to find @react-native-community/cli-server-api
Starting the server without the community middleware.`);
}
const createDevServerMiddleware = (exports.createDevServerMiddleware =
  communityMiddlewareFallback.createDevServerMiddleware);
const indexPageMiddleware = (exports.indexPageMiddleware =
  communityMiddlewareFallback.indexPageMiddleware);
