import type { AddScopesParams, SignInParams, ConfigureParams, HasPlayServicesParams, User } from './types';
declare class GoogleSignin {
    configPromise?: Promise<void>;
    constructor();
    signIn(options?: SignInParams): Promise<User>;
    hasPlayServices(options?: HasPlayServicesParams): Promise<boolean>;
    configure(options?: ConfigureParams): void;
    addScopes(options: AddScopesParams): Promise<User | null>;
    signInSilently(): Promise<User>;
    signOut(): Promise<null>;
    revokeAccess(): Promise<null>;
    isSignedIn(): Promise<boolean>;
    getCurrentUser(): Promise<User | null>;
    clearCachedAccessToken(tokenString: string): Promise<null>;
    getTokens(): Promise<{
        idToken: string;
        accessToken: string;
    }>;
}
export declare const GoogleSigninSingleton: GoogleSignin;
export declare const statusCodes: {
    readonly SIGN_IN_CANCELLED: string;
    readonly IN_PROGRESS: string;
    readonly PLAY_SERVICES_NOT_AVAILABLE: string;
    readonly SIGN_IN_REQUIRED: string;
};
export {};
//# sourceMappingURL=GoogleSignin.d.ts.map