"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GoogleSigninButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _RNGoogleSiginButton = require("./RNGoogleSiginButton");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const RNGoogleSignin = _reactNative.NativeModules.RNGoogleSignin;
const GoogleSigninButton = _ref => {
  let {
    onPress,
    style,
    ...rest
  } = _ref;
  (0, _react.useEffect)(() => {
    if (_reactNative.Platform.OS === 'ios') {
      return;
    }
    const clickListener = _reactNative.DeviceEventEmitter.addListener('RNGoogleSigninButtonClicked', () => {
      onPress === null || onPress === void 0 ? void 0 : onPress();
    });
    return () => {
      clickListener.remove();
    };
  }, [onPress]);
  const recommendedSize = (() => {
    switch (rest.size) {
      case RNGoogleSignin.BUTTON_SIZE_ICON:
        return styles.iconSize;
      case RNGoogleSignin.BUTTON_SIZE_WIDE:
        return styles.wideSize;
      default:
        return styles.standardSize;
    }
  })();

  // @ts-ignore style prop incompatible
  return /*#__PURE__*/_react.default.createElement(_RNGoogleSiginButton.RNGoogleSigninButton, _extends({}, rest, {
    onPress: onPress,
    style: [recommendedSize, style]
  }));
};
exports.GoogleSigninButton = GoogleSigninButton;
GoogleSigninButton.Size = {
  Icon: RNGoogleSignin.BUTTON_SIZE_ICON,
  Standard: RNGoogleSignin.BUTTON_SIZE_STANDARD,
  Wide: RNGoogleSignin.BUTTON_SIZE_WIDE
};
GoogleSigninButton.Color = {
  Dark: RNGoogleSignin.BUTTON_COLOR_DARK,
  Light: RNGoogleSignin.BUTTON_COLOR_LIGHT
};

// sizes according to https://developers.google.com/identity/sign-in/ios/reference/Classes/GIDSignInButton
const styles = _reactNative.StyleSheet.create({
  iconSize: {
    width: 48,
    height: 48
  },
  standardSize: {
    width: 230,
    height: 48
  },
  wideSize: {
    width: 312,
    height: 48
  }
});
//# sourceMappingURL=GoogleSigninButton.js.map