import type { CsvSettings } from './formats/csv/CsvSettings';
/**
 * Warning message for the generated sections and files files
 *
 * @private within the repository
 */
export declare const GENERATOR_WARNING = "\u26A0\uFE0F WARNING: This code has been generated so that any manual changes will be overwritten";
/**
 * Claim for the Promptbook
 *
 * TODO: [🗽] Unite branding and make single place for it
 *
 * @public exported from `@promptbook/core`
 */
export declare const CLAIM = "Supercharge LLM models with Promptbook";
/**
 * Warning message for the generated sections and files files
 *
 * @private within the repository
 */
export declare const GENERATOR_WARNING_BY_PROMPTBOOK_CLI = "\u26A0\uFE0F WARNING: This code has been generated by `@promptbook/cli` so that any manual changes will be overwritten";
/**
 * The maximum number of iterations for a loops
 *
 * @private within the repository - too low-level in comparison with other `MAX_...`
 */
export declare const LOOP_LIMIT = 1000;
/**
 * The maximum number of iterations for a loops which adds characters one by one
 *
 * @private within the repository - too low-level in comparison with other `MAX_...`
 */
export declare const CHARACTER_LOOP_LIMIT = 100000;
/**
 * Timeout for the connections in milliseconds
 *
 * @private within the repository - too low-level in comparison with other `MAX_...`
 */
export declare const CONNECTION_TIMEOUT_MS: number;
/**
 * How many times to retry the connections
 *
 * @private within the repository - too low-level in comparison with other `MAX_...`
 */
export declare const CONNECTION_RETRIES_LIMIT = 5;
/**
 * Short time interval to prevent race conditions in milliseconds
 *
 * @private within the repository - too low-level in comparison with other `MAX_...`
 */
export declare const IMMEDIATE_TIME = 10;
/**
 * The maximum number of (LLM) tasks running in parallel
 *
 * @public exported from `@promptbook/core`
 */
export declare const MAX_PARALLEL_COUNT = 5;
/**
 * The maximum number of attempts to execute LLM task before giving up
 *
 * @public exported from `@promptbook/core`
 */
export declare const MAX_EXECUTION_ATTEMPTS = 3;
/**
 * The maximum length of the (generated) filename
 *
 * @public exported from `@promptbook/core`
 */
export declare const MAX_FILENAME_LENGTH = 30;
/**
 * @@@
 * TODO: [🐝][main] !!! Use
 *
 * @public exported from `@promptbook/core`
 */
export declare const MAX_KNOWLEDGE_SOURCES_SCRAPING_DEPTH = 3;
/**
 * @@@
 * TODO: [🐝][main] !!! Use
 *
 * @public exported from `@promptbook/core`
 */
export declare const MAX_KNOWLEDGE_SOURCES_SCRAPING_TOTAL = 200;
/**
 * Where to store the cache of executions for promptbook CLI
 *
 * @public exported from `@promptbook/core`
 */
export declare const EXECUTIONS_CACHE_DIRNAME = "/.promptbook/executions-cache";
/**
 * The name of the builded pipeline collection made by CLI `ptbk make` and for lookup in `createCollectionFromDirectory`
 *
 * @public exported from `@promptbook/core`
 */
export declare const PIPELINE_COLLECTION_BASE_FILENAME = "index";
/**
 * Nonce which is used for replacing things in strings
 *
 * @private within the repository
 */
export declare const REPLACING_NONCE = "u$k42k%!V2zo34w7Fu#@QUHYPW";
/**
 * The names of the parameters that are reserved for special purposes
 *
 * @public exported from `@promptbook/core`
 */
export declare const RESERVED_PARAMETER_NAMES: readonly ["content", "context", "knowledge", "samples", "modelName", "currentDate"];
/**
 * @@@
 *
 * @private within the repository
 */
export declare const RESERVED_PARAMETER_MISSING_VALUE: string;
/**
 * @@@
 *
 * @private within the repository
 */
export declare const RESERVED_PARAMETER_RESTRICTED: string;
/**
 * The thresholds for the relative time in the `moment` NPM package.
 *
 * @see https://momentjscom.readthedocs.io/en/latest/moment/07-customization/13-relative-time-threshold/
 * @private within the repository - too low-level in comparison with other constants
 */
export declare const MOMENT_ARG_THRESHOLDS: {
    readonly ss: 3;
};
/**
 * @@@
 *
 * @public exported from `@promptbook/core`
 */
export declare const DEFAULT_REMOTE_URL = "https://api.pavolhejny.com/";
/**
 * @@@
 *
 * @public exported from `@promptbook/core`
 */
export declare const DEFAULT_REMOTE_URL_PATH = "/promptbook/socket.io";
/**
 * @@@
 *
 * @public exported from `@promptbook/core`
 */
export declare const DEFAULT_CSV_SETTINGS: CsvSettings;
/**
 * @@@
 *
 * @public exported from `@promptbook/core`
 */
export declare const IS_VERBOSE = false;
/**
 * @@@
 *
 * @private within the repository
 */
export declare const IS_PIPELINE_LOGIC_VALIDATED: boolean;
/**
 * @@@
 *
 * @private within the repository
 */
export declare const IS_COST_PREVENTED: boolean;
/**
 * TODO: [🧠][🧜‍♂️] Maybe join remoteUrl and path into single value
 */
